/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.containers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.InventoryAction;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import dev.beecube31.crazyae2.client.gui.implementations.GuiManaTerminal;
import dev.beecube31.crazyae2.common.containers.base.CrazyAEBaseContainer;
import dev.beecube31.crazyae2.common.containers.guisync.GuiSync;
import dev.beecube31.crazyae2.core.api.storage.IManaStorageChannel;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.tileentity.TileEntity;

public class ContainerManaTerminal
extends CrazyAEBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEItemStack> {
    private final IConfigManager clientCM;
    private final IMEMonitor<IAEItemStack> monitor;
    private final IItemList<IAEItemStack> items = ((IManaStorageChannel)Api.INSTANCE.storage().getStorageChannel(IManaStorageChannel.class)).createList();
    @GuiSync(value=99)
    public boolean hasPower = false;
    private final ITerminalHost terminal;
    private IConfigManager serverCM;
    private IConfigManagerHost gui;
    private IGridNode networkNode;

    public ContainerManaTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable instanceof TileEntity ? (TileEntity)monitorable : null, monitorable instanceof IPart ? (IPart)monitorable : null, null);
        this.terminal = monitorable;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        if (Platform.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            this.monitor = monitorable.getInventory(AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class));
            if (this.monitor != null) {
                Object node;
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setCellInventory((IMEInventoryHandler<IAEItemStack>)this.monitor);
                if (monitorable instanceof IPortableCell) {
                    this.setPowerSource((IEnergySource)monitorable);
                    if (monitorable instanceof WirelessTerminalGuiObject) {
                        this.networkNode = ((WirelessTerminalGuiObject)monitorable).getActionableNode();
                    }
                } else if (monitorable instanceof IMEChest) {
                    this.setPowerSource((IEnergySource)monitorable);
                } else if ((monitorable instanceof IGridHost || monitorable instanceof IActionHost) && (node = monitorable instanceof IGridHost ? ((IGridHost)monitorable).getGridNode(AEPartLocation.INTERNAL) : (monitorable instanceof IActionHost ? ((IActionHost)monitorable).getActionableNode() : null)) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    }
                }
            } else {
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        this.bindPlayerInventory(ip, 0, 140);
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public void postUpdate(List<IAEItemStack> list) {
        for (IAEItemStack is : list) {
            this.items.add((IAEStack)is);
        }
        ((GuiManaTerminal)this.gui).postUpdate(list);
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource actionSource) {
        for (IAEItemStack is : change) {
            if (is == null) continue;
            this.items.add((IAEStack)is);
        }
    }

    public void onListUpdate() {
        for (IContainerListener c : this.field_75149_d) {
            this.queueInventory(c);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.queueInventory(listener);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    private void queueInventory(IContainerListener c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                IItemList monitorCache = this.monitor.getStorageList();
                for (IAEItemStack send : monitorCache) {
                    try {
                        piu.appendItem(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance().sendTo((AppEngPacket)piu, (EntityPlayerMP)c);
                        piu = new PacketMEInventoryUpdate();
                        piu.appendItem(send);
                    }
                }
                NetworkHandler.instance().sendTo((AppEngPacket)piu, (EntityPlayerMP)c);
            }
            catch (IOException e) {
                AELog.debug((Throwable)e);
            }
        }
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.monitor != this.terminal.getInventory(AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class))) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (IContainerListener crafter : this.field_75149_d) {
                    if (!(crafter instanceof EntityPlayerMP)) continue;
                    try {
                        NetworkHandler.instance().sendTo((AppEngPacket)new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException e) {
                        AELog.debug((Throwable)e);
                    }
                }
            }
            if (!this.items.isEmpty()) {
                try {
                    IItemList monitorCache = this.monitor.getStorageList();
                    PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                    for (IAEItemStack is : this.items) {
                        IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                        if (send == null) {
                            is.setStackSize(0L);
                            piu.appendItem(is);
                            continue;
                        }
                        piu.appendItem(send);
                    }
                    if (!piu.isEmpty()) {
                        this.items.resetStatus();
                        for (Object c : this.field_75149_d) {
                            if (!(c instanceof EntityPlayer)) continue;
                            NetworkHandler.instance().sendTo((AppEngPacket)piu, (EntityPlayerMP)c);
                        }
                    }
                }
                catch (IOException e) {
                    AELog.debug((Throwable)e);
                }
            }
            this.updatePowerStatus();
            super.func_75142_b();
        }
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }
}

