/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.containers;

import appeng.api.config.SecurityPermissions;
import dev.beecube31.crazyae2.client.gui.CrazyAESlot;
import dev.beecube31.crazyae2.common.containers.base.CrazyAEBaseContainer;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.tile.crafting.TileQuantumCPU;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerQuantumCPU
extends CrazyAEBaseContainer {
    public static final int SLOTS_PER_PAGE = 64;
    private final TileQuantumCPU quantumCPU;
    private int currentPage = 0;
    private final List<Slot> patternSlotsOnPage = new ArrayList<Slot>();

    public ContainerQuantumCPU(InventoryPlayer ip, TileQuantumCPU te) {
        super(ip, te);
        this.quantumCPU = te;
        if (this.quantumCPU != null && this.quantumCPU.getInventoryByName("patterns") != null) {
            this.setCurrentPage(0);
        }
        this.setupConfig();
        this.bindPlayerInventory(ip, 0, 174);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        if (this.quantumCPU == null || this.quantumCPU.getInventoryByName("patterns") == null) {
            return 1;
        }
        return (int)Math.ceil((double)this.quantumCPU.getInventoryByName("patterns").getSlots() / 64.0);
    }

    public void setCurrentPage(int newPage) {
        if (this.quantumCPU == null) {
            return;
        }
        int totalPages = this.getTotalPages();
        if (newPage < 0) {
            newPage = 0;
        }
        if (newPage >= totalPages) {
            newPage = totalPages - 1;
        }
        if (this.currentPage == newPage && !this.patternSlotsOnPage.isEmpty()) {
            return;
        }
        this.currentPage = newPage;
        this.updatePatternSlots();
    }

    private void updatePatternSlots() {
        if (this.quantumCPU == null || this.quantumCPU.getInventoryByName("patterns") == null) {
            return;
        }
        for (Slot slot : this.patternSlotsOnPage) {
            this.field_75151_b.remove(slot);
        }
        this.patternSlotsOnPage.clear();
        IItemHandler patternsHandler = this.quantumCPU.getInventoryByName("patterns");
        int startIndex = this.currentPage * 64;
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                int slotIndexInFullInv = startIndex + (x + y * 8);
                if (slotIndexInFullInv >= patternsHandler.getSlots()) continue;
                CrazyAESlot patternSlot = new RestrictedSlot(RestrictedSlot.PlaceableItemType.ENCODED_CRAFTING_PATTERN, patternsHandler, slotIndexInFullInv, 17 + x * 18, 15 + y * 18, this.getInventoryPlayer()).setStackLimit(1);
                this.func_75146_a(patternSlot);
                this.patternSlotsOnPage.add(patternSlot);
            }
        }
    }

    protected void setupConfig() {
        if (this.quantumCPU != null) {
            this.updatePatternSlots();
        }
    }

    @Override
    @NotNull
    public ItemStack func_184996_a(int slotID, int dragType, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        return super.func_184996_a(slotID, dragType, clickTypeIn, player);
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        super.func_75142_b();
    }
}

