/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.containers.base;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.PlayerSource;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import dev.beecube31.crazyae2.client.gui.CrazyAEMESlot;
import dev.beecube31.crazyae2.client.gui.CrazyAESlot;
import dev.beecube31.crazyae2.client.gui.SlotPlayerHotBar;
import dev.beecube31.crazyae2.client.gui.SlotPlayerInv;
import dev.beecube31.crazyae2.common.containers.base.ContainerOpenContext;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.containers.base.slot.SlotCraftingTerm;
import dev.beecube31.crazyae2.common.containers.base.slot.SlotDisabled;
import dev.beecube31.crazyae2.common.containers.base.slot.SlotFake;
import dev.beecube31.crazyae2.common.containers.base.slot.SlotInaccessible;
import dev.beecube31.crazyae2.common.containers.guisync.GuiSync;
import dev.beecube31.crazyae2.common.containers.guisync.SyncData;
import dev.beecube31.crazyae2.common.networking.network.NetworkHandler;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketInventoryAction;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketTargetItemStack;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketValueConfig;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class CrazyAEBaseContainer
extends Container {
    private final InventoryPlayer invPlayer;
    private final IActionSource mySrc;
    private final HashSet<Integer> locked = new HashSet();
    private final TileEntity tileEntity;
    private final IPart part;
    protected final IGuiItemObject obj;
    private final HashMap<Integer, SyncData> syncData = new HashMap();
    private boolean isContainerValid = true;
    private String customName;
    private ContainerOpenContext openContext;
    private IMEInventoryHandler<IAEItemStack> cellInv;
    private IEnergySource powerSrc;
    private boolean sentCustomName;
    private int ticksSinceCheck = 900;
    private IAEItemStack clientRequestedTargetItem = null;

    public CrazyAEBaseContainer(InventoryPlayer ip, TileEntity myTile, IPart myPart) {
        this(ip, myTile, myPart, null);
    }

    public CrazyAEBaseContainer(InventoryPlayer ip, TileEntity myTile, IPart myPart, IGuiItemObject gio) {
        this.invPlayer = ip;
        this.tileEntity = myTile;
        this.part = myPart;
        this.obj = gio;
        this.mySrc = new PlayerSource(ip.field_70458_d, this.getActionHost());
        this.prepareSync();
    }

    protected IActionHost getActionHost() {
        if (this.obj instanceof IActionHost) {
            return (IActionHost)this.obj;
        }
        if (this.tileEntity instanceof IActionHost) {
            return (IActionHost)this.tileEntity;
        }
        if (this.part instanceof IActionHost) {
            return (IActionHost)this.part;
        }
        return null;
    }

    private void prepareSync() {
        for (Field f : ((Object)((Object)this)).getClass().getFields()) {
            if (!f.isAnnotationPresent(GuiSync.class)) continue;
            GuiSync annotation = f.getAnnotation(GuiSync.class);
            if (this.syncData.containsKey(annotation.value())) {
                CrazyAE.logger().warn("Channel already in use: {} for {}", (Object)annotation.value(), (Object)f.getName());
                continue;
            }
            this.syncData.put(annotation.value(), new SyncData(this, f, annotation));
        }
    }

    public CrazyAEBaseContainer(InventoryPlayer ip, Object anchor) {
        this.invPlayer = ip;
        this.tileEntity = anchor instanceof TileEntity ? (TileEntity)anchor : null;
        this.part = anchor instanceof IPart ? (IPart)anchor : null;
        IGuiItemObject iGuiItemObject = this.obj = anchor instanceof IGuiItemObject ? (IGuiItemObject)anchor : null;
        if (this.tileEntity == null && this.part == null && this.obj == null) {
            throw new IllegalArgumentException("Must have a valid anchor, instead " + anchor + " in " + ip);
        }
        this.mySrc = new PlayerSource(ip.field_70458_d, this.getActionHost());
        this.prepareSync();
    }

    public IAEItemStack getTargetStack() {
        return this.clientRequestedTargetItem;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetItem == null) {
                return;
            }
            if (stack != null && stack.isSameType(this.clientRequestedTargetItem)) {
                return;
            }
            NetworkHandler.instance().sendToServer(new PacketTargetItemStack((AEItemStack)stack));
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    public IActionSource getActionSource() {
        return this.mySrc;
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (Platform.isClient()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 10) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidContainer(this.isValidContainer() && this.hasAccess(security, requirePower));
    }

    protected boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        IGridNode gn;
        IActionHost host = this.getActionHost();
        if (host != null && (gn = host.getActionableNode()) != null) {
            IEnergyGrid eg;
            IGrid g = gn.getGrid();
            if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                return false;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            return sg.hasPermission(this.getInventoryPlayer().field_70458_d, perm);
        }
        return false;
    }

    public void lockPlayerInventorySlot(int idx) {
        this.locked.add(idx);
    }

    public Object getTarget() {
        if (this.tileEntity != null) {
            return this.tileEntity;
        }
        if (this.part != null) {
            return this.part;
        }
        return this.obj;
    }

    public InventoryPlayer getPlayerInv() {
        return this.getInventoryPlayer();
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public final void updateFullProgressBar(int idx, long value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
            return;
        }
        this.func_75137_b(idx, (int)value);
    }

    public void stringSync(int idx, String value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int offsetX, int offsetY) {
        int i;
        PlayerInvWrapper ih = new PlayerInvWrapper(inventoryPlayer);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.locked.contains(j + i * 9 + 9)) {
                    this.func_75146_a(new SlotDisabled((IItemHandler)ih, j + i * 9 + 9, 8 + j * 18 + offsetX, offsetY + i * 18));
                    continue;
                }
                this.func_75146_a(new SlotPlayerInv((IItemHandler)ih, j + i * 9 + 9, 8 + j * 18 + offsetX, offsetY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (this.locked.contains(i)) {
                this.func_75146_a(new SlotDisabled((IItemHandler)ih, i, 8 + i * 18 + offsetX, 58 + offsetY));
                continue;
            }
            this.func_75146_a(new SlotPlayerHotBar((IItemHandler)ih, i, 8 + i * 18 + offsetX, 58 + offsetY));
        }
    }

    protected Slot func_75146_a(Slot newSlot) {
        if (newSlot instanceof CrazyAESlot) {
            CrazyAESlot s = (CrazyAESlot)newSlot;
            s.setContainer(this);
            return super.func_75146_a(newSlot);
        }
        throw new IllegalArgumentException("Trying to add [" + newSlot + "] in [" + ((Object)((Object)this)).getClass() + "] to CrazyAE Container instead of CrazyAESlot.");
    }

    public void func_75142_b() {
        this.sendCustomName();
        if (Platform.isServer()) {
            if (this.tileEntity != null && this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v()) != this.tileEntity) {
                this.setValidContainer(false);
            }
            for (IContainerListener listener : this.field_75149_d) {
                for (SyncData sd : this.syncData.values()) {
                    sd.tick(listener);
                }
            }
        }
        super.func_75142_b();
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return ItemStack.field_190927_a;
        }
        CrazyAESlot clickSlot = (CrazyAESlot)this.field_75151_b.get(idx);
        if (clickSlot instanceof SlotDisabled || clickSlot instanceof SlotInaccessible) {
            return ItemStack.field_190927_a;
        }
        if (clickSlot != null && clickSlot.func_75216_d()) {
            CrazyAESlot cs;
            ItemStack tis = clickSlot.func_75211_c();
            if (tis.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            IItemDefinition expansionCard = AEApi.instance().definitions().materials().cardPatternExpansion();
            ArrayList<CrazyAESlot> selectedSlots = new ArrayList<CrazyAESlot>();
            if (clickSlot.isPlayerSide()) {
                if (!(tis = this.transferStackToContainer(tis)).func_190926_b()) {
                    for (Object e : this.field_75151_b) {
                        cs = (CrazyAESlot)e;
                        if (cs.isPlayerSide() || cs instanceof SlotFake || !cs.func_75214_a(tis)) continue;
                        selectedSlots.add(cs);
                    }
                }
            } else {
                tis = tis.func_77946_l();
                for (Object e : this.field_75151_b) {
                    cs = (CrazyAESlot)e;
                    if (!cs.isPlayerSide() || cs instanceof SlotFake || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot.isPlayerSide() && !tis.func_190926_b()) {
                for (Object e : this.field_75151_b) {
                    cs = (CrazyAESlot)e;
                    ItemStack destination = cs.func_75211_c();
                    if (cs.isPlayerSide() || !(cs instanceof SlotFake)) continue;
                    if (Platform.itemComparisons().isSameItem(destination, tis)) break;
                    if (!destination.func_190926_b()) continue;
                    cs.func_75215_d(tis.func_77946_l());
                    this.updateSlot(cs);
                    break;
                }
            }
            if (!tis.func_190926_b()) {
                for (Slot slot : selectedSlots) {
                    RestrictedSlot rs;
                    RestrictedSlot.PlaceableItemType it;
                    if (slot instanceof SlotDisabled || slot instanceof CrazyAEMESlot || !slot.func_75214_a(tis) || !slot.func_75216_d()) continue;
                    ItemStack t = slot.func_75211_c().func_77946_l();
                    if (!Platform.itemComparisons().isSameItem(tis, t)) continue;
                    if (slot instanceof RestrictedSlot && ((it = (rs = (RestrictedSlot)slot).getPlaceableItemType()) == RestrictedSlot.PlaceableItemType.ELVENTRADE_ENCODED_PATTERN || it == RestrictedSlot.PlaceableItemType.MANAPOOL_ENCODED_PATTERN || it == RestrictedSlot.PlaceableItemType.PETAL_ENCODED_PATTERN || it == RestrictedSlot.PlaceableItemType.RUNEALTAR_ENCODED_PATTERN || it == RestrictedSlot.PlaceableItemType.PUREDAISY_ENCODED_PATTERN || it == RestrictedSlot.PlaceableItemType.TERAPLATE_ENCODED_PATTERN || it == RestrictedSlot.PlaceableItemType.BREWERY_ENCODED_PATTERN)) {
                        return ItemStack.field_190927_a;
                    }
                    int maxSize = Math.min(tis.func_77976_d(), slot.func_75219_a());
                    int placeAble = maxSize - t.func_190916_E();
                    if (tis.func_190916_E() < placeAble) {
                        placeAble = tis.func_190916_E();
                    }
                    t.func_190920_e(t.func_190916_E() + placeAble);
                    tis.func_190920_e(tis.func_190916_E() - placeAble);
                    slot.func_75215_d(t);
                    if (tis.func_190916_E() <= 0) {
                        clickSlot.func_75215_d(ItemStack.field_190927_a);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return ItemStack.field_190927_a;
                    }
                    this.updateSlot(slot);
                }
                for (Slot slot : selectedSlots) {
                    RestrictedSlot rs;
                    RestrictedSlot.PlaceableItemType it;
                    if (slot instanceof SlotDisabled || slot instanceof CrazyAEMESlot || !slot.func_75214_a(tis) || slot.func_75216_d()) continue;
                    int maxSize = Math.min(tis.func_77976_d(), slot.func_75219_a());
                    ItemStack tmp = tis.func_77946_l();
                    if (tmp.func_190916_E() > maxSize) {
                        tmp.func_190920_e(maxSize);
                    }
                    tis.func_190920_e(tis.func_190916_E() - tmp.func_190916_E());
                    slot.func_75215_d(tmp);
                    if (tis.func_190916_E() <= 0) {
                        clickSlot.func_75215_d(ItemStack.field_190927_a);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return ItemStack.field_190927_a;
                    }
                    this.updateSlot(slot);
                    if (!(slot instanceof RestrictedSlot) || (it = (rs = (RestrictedSlot)slot).getPlaceableItemType()) != RestrictedSlot.PlaceableItemType.ELVENTRADE_ENCODED_PATTERN && it != RestrictedSlot.PlaceableItemType.MANAPOOL_ENCODED_PATTERN && it != RestrictedSlot.PlaceableItemType.PETAL_ENCODED_PATTERN && it != RestrictedSlot.PlaceableItemType.RUNEALTAR_ENCODED_PATTERN && it != RestrictedSlot.PlaceableItemType.PUREDAISY_ENCODED_PATTERN) continue;
                    break;
                }
            }
            clickSlot.func_75215_d(!tis.func_190926_b() ? tis : ItemStack.field_190927_a);
        }
        this.updateSlot(clickSlot);
        return ItemStack.field_190927_a;
    }

    public final void func_75137_b(int idx, int value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.isValidContainer()) {
            if (this.tileEntity instanceof IInventory) {
                return ((IInventory)this.tileEntity).func_70300_a(entityplayer);
            }
            return true;
        }
        return false;
    }

    public boolean func_94531_b(Slot s) {
        return ((CrazyAESlot)s).isDraggable();
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        SlotFake f;
        if (slot >= 0 && slot < this.field_75151_b.size()) {
            Slot s = this.func_75139_a(slot);
            if (s instanceof SlotCraftingTerm) {
                switch (action) {
                    case CRAFT_SHIFT: 
                    case CRAFT_ITEM: 
                    case CRAFT_STACK: {
                        ((SlotCraftingTerm)s).doClick(action, (EntityPlayer)player);
                        this.updateHeld(player);
                    }
                }
            }
            ItemStack hand = player.field_71071_by.func_70445_o();
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hand.func_190926_b()) {
                        s.func_75215_d(ItemStack.field_190927_a);
                        break;
                    }
                    s.func_75215_d(hand.func_77946_l());
                    break;
                }
                case PLACE_SINGLE: {
                    ItemStack is;
                    if (!hand.func_190926_b()) {
                        is = hand.func_77946_l();
                        is.func_190920_e(1);
                        s.func_75215_d(is);
                        break;
                    }
                    is = s.func_75211_c().func_77946_l();
                    if (is.func_190916_E() < is.func_77976_d() * 8) {
                        is.func_190917_f(1);
                    }
                    s.func_75215_d(is);
                    break;
                }
                case PICKUP_SINGLE: {
                    if (!hand.func_190926_b()) break;
                    ItemStack is = s.func_75211_c().func_77946_l();
                    if (is.func_190916_E() > 1) {
                        is.func_190918_g(1);
                    }
                    s.func_75215_d(is);
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    ItemStack is = s.func_75211_c();
                    if (!is.func_190926_b()) {
                        if (hand.func_190926_b()) {
                            is.func_190920_e(Math.max(1, is.func_190916_E() - 1));
                        } else if (hand.func_77969_a(is)) {
                            is.func_190920_e(Math.min(is.func_77976_d(), is.func_190916_E() + 1));
                        } else {
                            is = hand.func_77946_l();
                            is.func_190920_e(1);
                        }
                        s.func_75215_d(is);
                        break;
                    }
                    if (hand.func_190926_b()) break;
                    is = hand.func_77946_l();
                    is.func_190920_e(1);
                    s.func_75215_d(is);
                    break;
                }
                case HALVE: {
                    if (s.func_75211_c().func_190916_E() <= 1) break;
                    ItemStack halved = s.func_75211_c().func_77946_l();
                    halved.func_190920_e(s.func_75211_c().func_190916_E() / 2);
                    s.func_75215_d(halved);
                    break;
                }
                case DOUBLE: {
                    ItemStack doubled = s.func_75211_c().func_77946_l();
                    if (s.func_75211_c().func_190916_E() * 2 <= 0) break;
                    doubled.func_190920_e(Math.min(s.func_75219_a(), s.func_75211_c().func_190916_E() * 2));
                    s.func_75215_d(doubled);
                    break;
                }
            }
            if (action == InventoryAction.MOVE_REGION) {
                ArrayList<Slot> from = new ArrayList<Slot>();
                for (Slot j : this.field_75151_b) {
                    if (j == null || j.getClass() != s.getClass() || j instanceof SlotCraftingTerm) continue;
                    from.add(j);
                }
                for (Slot fr : from) {
                    this.func_82846_b((EntityPlayer)player, fr.field_75222_d);
                }
            }
            return;
        }
        IAEItemStack slotItem = this.clientRequestedTargetItem;
        Slot s = this.func_75139_a(slot);
        if (!(s instanceof SlotFake) || s instanceof SlotFake && !(f = (SlotFake)s).isOneStack()) {
            switch (action) {
                case SHIFT_CLICK: {
                    if (this.getPowerSource() == null || this.getCellInventory() == null) {
                        return;
                    }
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    ItemStack myItem = ais.createItemStack();
                    ais.setStackSize((long)myItem.func_77976_d());
                    InventoryAdaptor adp = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    myItem.func_190920_e((int)ais.getStackSize());
                    myItem = adp.simulateAdd(myItem);
                    if (!myItem.func_190926_b()) {
                        ais.setStackSize(ais.getStackSize() - (long)myItem.func_190916_E());
                    }
                    if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource())) == null) break;
                    adp.addItems(ais.createItemStack());
                    break;
                }
                case ROLL_DOWN: {
                    if (this.getPowerSource() == null || this.getCellInventory() == null) {
                        return;
                    }
                    boolean releaseQty = true;
                    ItemStack isg = player.field_71071_by.func_70445_o();
                    if (isg.func_190926_b()) break;
                    IAEItemStack ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)isg);
                    ais.setStackSize(1L);
                    IAEItemStack extracted = ais.copy();
                    ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                    if (ais != null) break;
                    AdaptorItemHandler ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
                    ItemStack fail = ia.removeItems(1, extracted.getDefinition(), null);
                    if (fail.func_190926_b()) {
                        this.getCellInventory().extractItems((IAEStack)extracted, Actionable.MODULATE, this.getActionSource());
                    }
                    this.updateHeld(player);
                    break;
                }
                case PICKUP_SINGLE: 
                case ROLL_UP: {
                    if (this.getPowerSource() == null || this.getCellInventory() == null) {
                        return;
                    }
                    if (slotItem == null) break;
                    int liftQty = 1;
                    ItemStack item = player.field_71071_by.func_70445_o();
                    if (!item.func_190926_b()) {
                        if (item.func_190916_E() >= item.func_77976_d()) {
                            liftQty = 0;
                        }
                        if (!Platform.itemComparisons().isSameItem(slotItem.getDefinition(), item)) {
                            liftQty = 0;
                        }
                    }
                    if (liftQty <= 0) break;
                    IAEItemStack ais = slotItem.copy();
                    ais.setStackSize(1L);
                    ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                    if (ais == null) break;
                    AdaptorItemHandler ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
                    ItemStack fail = ia.addItems(ais.createItemStack());
                    if (!fail.func_190926_b()) {
                        this.getCellInventory().injectItems((IAEStack)ais, Actionable.MODULATE, this.getActionSource());
                    }
                    this.updateHeld(player);
                    break;
                }
                case PICKUP_OR_SET_DOWN: {
                    if (this.getPowerSource() == null || this.getCellInventory() == null) {
                        return;
                    }
                    if (player.field_71071_by.func_70445_o().func_190926_b()) {
                        if (slotItem == null) break;
                        IAEItemStack ais = slotItem.copy();
                        ais.setStackSize((long)ais.getDefinition().func_77976_d());
                        ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                        if (ais != null) {
                            player.field_71071_by.func_70437_b(ais.createItemStack());
                        } else {
                            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                        }
                        this.updateHeld(player);
                        break;
                    }
                    IAEItemStack ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)player.field_71071_by.func_70445_o());
                    ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                    if (ais != null) {
                        player.field_71071_by.func_70437_b(ais.createItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    }
                    this.updateHeld(player);
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (this.getPowerSource() == null || this.getCellInventory() == null) {
                        return;
                    }
                    if (player.field_71071_by.func_70445_o().func_190926_b()) {
                        if (slotItem == null) break;
                        IAEItemStack ais = slotItem.copy();
                        long maxSize = ais.getDefinition().func_77976_d();
                        ais.setStackSize(maxSize);
                        ais = (IAEItemStack)this.getCellInventory().extractItems((IAEStack)ais, Actionable.SIMULATE, this.getActionSource());
                        if (ais != null) {
                            long stackSize = Math.min(maxSize, ais.getStackSize());
                            ais.setStackSize(stackSize + 1L >> 1);
                            ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                        }
                        if (ais != null) {
                            player.field_71071_by.func_70437_b(ais.createItemStack());
                        } else {
                            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                        }
                        this.updateHeld(player);
                        break;
                    }
                    IAEItemStack ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)player.field_71071_by.func_70445_o());
                    ais.setStackSize(1L);
                    ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                    if (ais != null) break;
                    ItemStack is = player.field_71071_by.func_70445_o();
                    is.func_190920_e(is.func_190916_E() - 1);
                    if (is.func_190916_E() <= 0) {
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    }
                    this.updateHeld(player);
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.field_71075_bZ.field_75098_d || slotItem == null) break;
                    ItemStack is = slotItem.createItemStack();
                    is.func_190920_e(is.func_77976_d());
                    player.field_71071_by.func_70437_b(is);
                    this.updateHeld(player);
                    break;
                }
                case MOVE_REGION: {
                    if (this.getPowerSource() == null || this.getCellInventory() == null) {
                        return;
                    }
                    if (slotItem == null) break;
                    int playerInv = 36;
                    for (int slotNum = 0; slotNum < 36; ++slotNum) {
                        IAEItemStack ais = slotItem.copy();
                        ItemStack myItem = ais.createItemStack();
                        ais.setStackSize((long)myItem.func_77976_d());
                        InventoryAdaptor adp = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                        myItem.func_190920_e((int)ais.getStackSize());
                        myItem = adp.simulateAdd(myItem);
                        if (!myItem.func_190926_b()) {
                            ais.setStackSize(ais.getStackSize() - (long)myItem.func_190916_E());
                        }
                        if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource())) == null) {
                            return;
                        }
                        adp.addItems(ais.createItemStack());
                    }
                    break;
                }
            }
        }
    }

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                NetworkHandler.instance().sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.fromItemStack((ItemStack)p.field_71071_by.func_70445_o())), p);
            }
            catch (IOException e) {
                CrazyAE.logger().debug((Object)e);
            }
        }
    }

    protected ItemStack transferStackToContainer(ItemStack input) {
        return this.shiftStoreItem(input);
    }

    private ItemStack shiftStoreItem(ItemStack input) {
        if (this.getPowerSource() == null || this.getCellInventory() == null) {
            return input;
        }
        IAEItemStack ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)Objects.requireNonNull((IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)input)), (IActionSource)this.getActionSource());
        if (ais == null) {
            return ItemStack.field_190927_a;
        }
        return ais.createItemStack();
    }

    private void updateSlot(Slot clickSlot) {
        this.func_75142_b();
    }

    private void sendCustomName() {
        if (!this.sentCustomName) {
            this.sentCustomName = true;
            if (Platform.isServer()) {
                ICustomNameObject name = null;
                if (this.part instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.part;
                }
                if (this.tileEntity instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.tileEntity;
                }
                if (this.obj instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.obj;
                }
                if (this instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this;
                }
                if (name != null) {
                    if (name.hasCustomInventoryName()) {
                        this.setCustomName(name.getCustomInventoryName());
                    }
                    if (this.getCustomName() != null) {
                        try {
                            NetworkHandler.instance().sendTo(new PacketValueConfig("CustomName", this.getCustomName()), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
                        }
                        catch (IOException e) {
                            CrazyAE.logger().debug((Object)e);
                        }
                    }
                }
            }
        }
    }

    public void swapSlotContents(int slotA, int slotB) {
        ItemStack testB;
        Slot a = this.func_75139_a(slotA);
        Slot b = this.func_75139_a(slotB);
        ItemStack isA = a.func_75211_c();
        ItemStack isB = b.func_75211_c();
        if (isA.func_190926_b() && isB.func_190926_b()) {
            return;
        }
        if (!isA.func_190926_b() && !a.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (!isB.func_190926_b() && !b.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (!isB.func_190926_b() && !a.func_75214_a(isB)) {
            return;
        }
        if (!isA.func_190926_b() && !b.func_75214_a(isA)) {
            return;
        }
        ItemStack testA = isB.func_190926_b() ? ItemStack.field_190927_a : isB.func_77946_l();
        ItemStack itemStack = testB = isA.func_190926_b() ? ItemStack.field_190927_a : isA.func_77946_l();
        if (!testA.func_190926_b() && testA.func_190916_E() > a.func_75219_a()) {
            if (!testB.func_190926_b()) {
                return;
            }
            int totalA = testA.func_190916_E();
            testA.func_190920_e(a.func_75219_a());
            testB = testA.func_77946_l();
            testB.func_190920_e(totalA - testA.func_190916_E());
        }
        if (!testB.func_190926_b() && testB.func_190916_E() > b.func_75219_a()) {
            if (!testA.func_190926_b()) {
                return;
            }
            int totalB = testB.func_190916_E();
            testB.func_190920_e(b.func_75219_a());
            testA = testB.func_77946_l();
            testA.func_190920_e(totalB - testA.func_190916_E());
        }
        a.func_75215_d(testA);
        b.func_75215_d(testB);
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int dragType, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        Slot slot;
        if (slotId >= 0 && clickTypeIn == ClickType.PICKUP && (slot = this.func_75139_a(slotId)) instanceof CrazyAESlot) {
            CrazyAESlot crazyAESlot = (CrazyAESlot)slot;
            ItemStack slotStack = slot.func_75211_c();
            ItemStack draggedStack = this.invPlayer.func_70445_o();
            if (!draggedStack.func_190926_b()) {
                if (crazyAESlot.func_75214_a(draggedStack) && slotStack.func_77973_b() == draggedStack.func_77973_b() && slotStack.func_77960_j() == draggedStack.func_77960_j() && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)draggedStack)) {
                    int maxSize = Math.min(crazyAESlot.func_75219_a(), draggedStack.func_77976_d());
                    int maxInsertable = Math.min(draggedStack.func_190916_E(), Math.max(0, maxSize - crazyAESlot.func_75211_c().func_190916_E()));
                    if (maxInsertable != 0) {
                        int toInsert = Math.min(maxInsertable, dragType == 0 ? maxInsertable : 1);
                        draggedStack.func_190918_g(toInsert);
                        slotStack.func_190917_f(toInsert);
                        slot.func_75215_d(slot.func_75211_c());
                        return ItemStack.field_190927_a;
                    }
                }
            } else if ((dragType == 0 || dragType == 1) && slot.func_82869_a(player) && !slotStack.func_190926_b()) {
                ItemStack result = slotStack.func_77946_l();
                int toTake = Math.min(slotStack.func_190916_E(), slotStack.func_77976_d());
                this.invPlayer.func_70437_b(slot.func_75209_a(dragType == 0 ? toTake : (toTake + 1) / 2));
                slot.func_75215_d(slot.func_75211_c());
                return result;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
    }

    public void onSlotChange(Slot s) {
    }

    public boolean isValidForSlot(Slot s, ItemStack i) {
        return true;
    }

    public IMEInventoryHandler<IAEItemStack> getCellInventory() {
        return this.cellInv;
    }

    public void setCellInventory(IMEInventoryHandler<IAEItemStack> cellInv) {
        this.cellInv = cellInv;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.invPlayer;
    }

    public boolean isValidContainer() {
        return this.isContainerValid;
    }

    public void setValidContainer(boolean isContainerValid) {
        this.isContainerValid = isContainerValid;
    }

    public ContainerOpenContext getOpenContext() {
        return this.openContext;
    }

    public void setOpenContext(ContainerOpenContext openContext) {
        this.openContext = openContext;
    }

    public IEnergySource getPowerSource() {
        return this.powerSrc;
    }

    public void setPowerSource(IEnergySource powerSrc) {
        this.powerSrc = powerSrc;
    }
}

