/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.containers.base.slot;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.block.crafting.ItemCraftingStorage;
import appeng.items.misc.ItemEncodedPattern;
import appeng.util.Platform;
import appeng.util.inv.filter.IAEItemFilter;
import dev.beecube31.crazyae2.client.gui.CrazyAESlot;
import dev.beecube31.crazyae2.client.gui.sprites.StateSprite;
import dev.beecube31.crazyae2.common.containers.base.slot.filter.IBotaniaCustomPatternFilter;
import dev.beecube31.crazyae2.common.interfaces.ICrazyAEUpgradeModule;
import dev.beecube31.crazyae2.common.items.CrazyAEUpgradeModule;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.CrazyAESidedHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class RestrictedSlot
extends CrazyAESlot {
    private final PlaceableItemType which;
    private boolean allowEdit = true;

    public RestrictedSlot(PlaceableItemType valid, IItemHandler i, int slotIndex, int x, int y, InventoryPlayer playerInv) {
        super(i, slotIndex, x, y);
        this.which = valid;
        this.setIIcon(valid.IIcon);
    }

    public PlaceableItemType getPlaceableItemType() {
        return this.which;
    }

    public boolean isValid(ItemStack is, World theWorld) {
        return true;
    }

    @Override
    public boolean func_75214_a(@NotNull ItemStack i) {
        if (!this.getContainer().isValidForSlot(this, i)) {
            return false;
        }
        if (i.func_190926_b()) {
            return false;
        }
        if (i.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        if (!super.func_75214_a(i)) {
            return false;
        }
        if (!this.isAllowEdit()) {
            return false;
        }
        return this.which.associatedFilter.allowInsert(null, -1, i);
    }

    @Override
    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
        return this.isAllowEdit();
    }

    @Override
    public ItemStack getDisplayStack() {
        return super.func_75211_c();
    }

    private boolean isAllowEdit() {
        return this.allowEdit;
    }

    public static enum PlaceableItemType {
        NONE(StateSprite.TRASH_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return true;
            }
        }),
        STORAGE_CELLS(StateSprite.STORAGE_CELLS_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return AEApi.instance().registries().cell().isCellHandled(stack);
            }
        }),
        ENCODED_PATTERN(StateSprite.PATTERNS_SLOT_OLD, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof ItemEncodedPattern;
            }
        }),
        ENCODED_CRAFTING_PATTERN(StateSprite.PATTERNS_SLOT_OLD, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                ItemEncodedPattern iep;
                Item item = stack.func_77973_b();
                return item instanceof ItemEncodedPattern && (iep = (ItemEncodedPattern)item).getPatternForItem(stack, null).isCraftable();
            }
        }),
        TRASH(StateSprite.TRASH_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return false;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return true;
            }
        }),
        CONDENSER_INPUT(StateSprite.TRASH_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return false;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return !AEApi.instance().registries().cell().isCellHandled(stack) && (!(stack.func_77973_b() instanceof IStorageComponent) || !((IStorageComponent)stack.func_77973_b()).isStorageComponent(stack));
            }
        }),
        STORAGE_COMPONENT(StateSprite.STORAGE_COMPONENTS_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof IStorageComponent && ((IStorageComponent)stack.func_77973_b()).isStorageComponent(stack);
            }
        }),
        CRAFTING_ACCELERATORS(StateSprite.CRAFTING_ACCELERATOR_128X, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return Utils.getAcceleratorsCountOf(stack) > 0;
            }
        }),
        CRAFTING_STORAGES(StateSprite.CRAFTING_STORAGE_128X, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof ItemCraftingStorage;
            }
        }),
        CRAFTING_UNITS(StateSprite.CRAFTING_BLOCKS_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof ItemCraftingStorage || Utils.getAcceleratorsCountOf(stack) > 0;
            }
        }),
        CERTUS_QUARTZ_CRYSTALS(StateSprite.CERTUS_QUARTZ, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return AEApi.instance().definitions().materials().certusQuartzCrystal().isSameAs(stack);
            }
        }),
        CHARGED_CERTUS_QUARTZ_CRYSTALS(StateSprite.CHARGED_CERTUS_QUARTZ, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return AEApi.instance().definitions().materials().certusQuartzCrystalCharged().isSameAs(stack);
            }
        }),
        AE_UPGRADES(StateSprite.AE_UPGRADE_CARDS_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof IUpgradeModule && ((IUpgradeModule)stack.func_77973_b()).getType(stack) != null;
            }
        }),
        CRAZYAE_UPGRADES(StateSprite.CRAZYAE_UPGRADE_CARDS_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof ICrazyAEUpgradeModule;
            }
        }),
        UPGRADES(StateSprite.CRAZYAE_UPGRADE_CARDS_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof IUpgradeModule && ((IUpgradeModule)stack.func_77973_b()).getType(stack) != null || stack.func_77973_b() instanceof CrazyAEUpgradeModule;
            }
        }),
        ENERGY_STACKS(StateSprite.ENERGY, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                for (IItemDefinition h : CrazyAESidedHandler.availableEnergyTypes) {
                    if (!h.isSameAs(stack)) continue;
                    return true;
                }
                return false;
            }
        }),
        ELVENTRADE_BLANK_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().materials().elventradeBlankPattern().isSameAs(stack);
            }
        }),
        MANAPOOL_BLANK_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().materials().manapoolBlankPattern().isSameAs(stack);
            }
        }),
        RUNEALTAR_BLANK_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().materials().runealtarBlankPattern().isSameAs(stack);
            }
        }),
        TERAPLATE_BLANK_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().materials().teraplateBlankPattern().isSameAs(stack);
            }
        }),
        BREWERY_BLANK_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().materials().breweryBlankPattern().isSameAs(stack);
            }
        }),
        PUREDAISY_BLANK_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().materials().puredaisyBlankPattern().isSameAs(stack);
            }
        }),
        PETAL_BLANK_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().materials().petalBlankPattern().isSameAs(stack);
            }
        }),
        ELVENTRADE_ENCODED_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().items().elventradeEncodedPattern().isSameAs(stack);
            }
        }),
        MANAPOOL_ENCODED_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().items().manapoolEncodedPattern().isSameAs(stack);
            }
        }),
        RUNEALTAR_ENCODED_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().items().runealtarEncodedPattern().isSameAs(stack);
            }
        }),
        PUREDAISY_ENCODED_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().items().puredaisyEncodedPattern().isSameAs(stack);
            }
        }),
        TERAPLATE_ENCODED_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().items().teraplateEncodedPattern().isSameAs(stack);
            }
        }),
        BREWERY_ENCODED_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().items().breweryEncodedPattern().isSameAs(stack);
            }
        }),
        PETAL_ENCODED_PATTERN(StateSprite.PATTERNS_SLOT_NEW, new IBotaniaCustomPatternFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return CrazyAE.definitions().items().petalEncodedPattern().isSameAs(stack);
            }
        }),
        INSCRIBER_PLATE(StateSprite.INSCRIBER_TOP_BOTTOM_INGREDIENT_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                if (stack.func_190926_b()) {
                    return false;
                }
                if (AEApi.instance().definitions().materials().namePress().isSameAs(stack)) {
                    return true;
                }
                for (ItemStack optional : AEApi.instance().registries().inscriber().getOptionals()) {
                    if (!Platform.itemComparisons().isSameItem(stack, optional)) continue;
                    return true;
                }
                return false;
            }
        }),
        INSCRIBER_INPUT(StateSprite.INGOT_SLOT, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                return true;
            }

            public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                return !stack.func_190926_b() && slot != 1;
            }
        });

        public final StateSprite IIcon;
        public final IAEItemFilter associatedFilter;

        private PlaceableItemType(StateSprite o, IAEItemFilter associatedFilter) {
            this.IIcon = o;
            this.associatedFilter = associatedFilter;
        }

        public IAEItemFilter outputLockedFilter() {
            final IAEItemFilter filter = this.associatedFilter;
            return new IAEItemFilter(){

                public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                    return false;
                }

                public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                    return filter.allowInsert(inv, slot, stack);
                }
            };
        }

        public IAEItemFilter inputLockedFilter() {
            final IAEItemFilter filter = this.associatedFilter;
            return new IAEItemFilter(){

                public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                    return filter.allowExtract(inv, slot, amount);
                }

                public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                    return false;
                }
            };
        }
    }
}

