/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.duality;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.DimensionalCoord;
import appeng.capabilities.Capabilities;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.NonBlockingItems;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MachineSource;
import appeng.parts.misc.PartInterface;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.networking.TileCableBus;
import appeng.util.ConfigManager;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.BlockingInventoryAdaptor;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftCallback;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftingProviderHelper;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyInterfaceHost;
import dev.beecube31.crazyae2.common.interfaces.mixin.inv.IMixinAdaptorItemHandler;
import dev.beecube31.crazyae2.common.networking.events.MEInterfaceHostStateUpdateEv;
import dev.beecube31.crazyae2.common.util.Longium;
import dev.beecube31.crazyae2.common.util.ModsChecker;
import dev.beecube31.crazyae2.common.util.NBTUtils;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.cache.impl.CrazyAutocraftingSystem;
import dev.beecube31.crazyae2.core.config.CrazyAEAutoCraftingSystemConfig;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;

public class QuantumInterfaceDuality
extends DualityInterface
implements ICrazyInterfaceHost {
    public static final int NUMBER_OF_PATTERN_SLOTS = 72;
    public static final int MAX_PATTERN_EXECUTIONS_TO_PUSH_PER_AC_TICK = CrazyAEAutoCraftingSystemConfig.maxPatternPushExecutionsPerActiveCraftTick;
    private final IAEItemStack[] requireWork;
    private final List<PendingCraft> pendingCrafts = new ArrayList<PendingCraft>();
    private final Map<String, ActiveInterfaceCraft> activeCrafts = new HashMap<String, ActiveInterfaceCraft>();
    private final AENetworkProxy proxy;
    protected final IInterfaceHost iHost;
    private List<ICraftingPatternDetails> craftingList = null;
    private final ConfigManager cm;
    private EnumMap<EnumFacing, List<IAEItemStack>> waitingToSendFacing = new EnumMap(EnumFacing.class);
    private final Map<String, List<String>> pendingToActiveCraftKeysMap = new HashMap<String, List<String>>();
    private final IActionSource mySource;
    private static Method cachedSameGridMethod;
    private static Class<?> cachedSameGridMethodClass;

    public QuantumInterfaceDuality(AENetworkProxy networkProxy, IInterfaceHost ih) {
        super(networkProxy, ih);
        ObfuscationReflectionHelper.setPrivateValue(DualityInterface.class, (Object)this, (Object)new AppEngInternalInventory((IAEAppEngInventory)this, 72, 1), (String)"patterns");
        this.proxy = networkProxy;
        this.iHost = ih;
        this.craftingList = (List)ObfuscationReflectionHelper.getPrivateValue(DualityInterface.class, (Object)this, (String)"craftingList");
        this.cm = (ConfigManager)ObfuscationReflectionHelper.getPrivateValue(DualityInterface.class, (Object)this, (String)"cm");
        this.requireWork = (IAEItemStack[])ObfuscationReflectionHelper.getPrivateValue(DualityInterface.class, (Object)this, (String)"requireWork");
        this.mySource = new MachineSource((IActionHost)this.iHost);
    }

    @Override
    public boolean isBusy() {
        if (this.activeCrafts.size() >= CrazyAEAutoCraftingSystemConfig.maxCraftingTasksSizePerQuantumInterface) {
            return true;
        }
        return this.waitingToSendFacing != null && !this.waitingToSendFacing.isEmpty();
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.getInventoryByName("patterns")) {
            if (!removed.func_190926_b() || !added.func_190926_b()) {
                this.updateCraftingList();
                this.iHost.saveChanges();
            }
            return;
        }
        if (inv == this.getInventoryByName("storage")) {
            IItemHandler storageInv = this.getInventoryByName("storage");
            ItemStack stackInSlot = storageInv.getStackInSlot(slot);
            if (stackInSlot.func_190926_b()) {
                if (this.requireWork[slot] != null) {
                    this.requireWork[slot] = null;
                }
                return;
            }
            AEItemStack aeStack = AEItemStack.fromItemStack((ItemStack)stackInSlot);
            if (aeStack == null || aeStack.getStackSize() <= 0L) {
                return;
            }
            long totalConsumedFromSlot = 0L;
            boolean changed = false;
            ArrayList<String> activeCraftKeys = new ArrayList<String>();
            ArrayList<PendingCraft> pendingCraftList = new ArrayList<PendingCraft>();
            for (Map.Entry<String, ActiveInterfaceCraft> entry : this.activeCrafts.entrySet()) {
                long actualTakenFromSharedLogicStack;
                ICraftingPatternDetails details;
                if (aeStack.getStackSize() <= 0L) break;
                String activeCraftKey = entry.getKey();
                ActiveInterfaceCraft activeCraft = entry.getValue();
                if (activeCraft == null) continue;
                if (activeCraft.pendingCraft == null) {
                    if (!activeCraftKeys.contains(activeCraftKey)) {
                        activeCraftKeys.add(activeCraftKey);
                    }
                    changed = true;
                    continue;
                }
                PendingCraft currentPendingCraft = activeCraft.pendingCraft;
                if (activeCraft.currentMicroBatchSize == 0L || activeCraft.currentMicroBatchTotalOutputsExpected.isEmpty() && currentPendingCraft.patternDetails != null && currentPendingCraft.patternDetails.getCondensedOutputs().length == 0 || !currentPendingCraft.resolveEnvironment(this.iHost.getTileEntity().func_145831_w()) || (details = currentPendingCraft.patternDetails) == null) continue;
                Longium consumedNowFromLogicStack = new Longium();
                boolean microBatchCompletedNow = activeCraft.recordReceivedAndComplete((IAEItemStack)aeStack, consumedNowFromLogicStack);
                if (consumedNowFromLogicStack.get() > 0L && (actualTakenFromSharedLogicStack = Math.min(aeStack.getStackSize(), consumedNowFromLogicStack.get())) > 0L) {
                    aeStack.decStackSize(actualTakenFromSharedLogicStack);
                    totalConsumedFromSlot += actualTakenFromSharedLogicStack;
                }
                if (!microBatchCompletedNow) continue;
                changed = true;
                long completedPatternExecs = activeCraft.finalizeMicrobatch();
                if (completedPatternExecs <= 0L && activeCraft.currentMicroBatchSize > 0L || completedPatternExecs <= 0L) continue;
                activeCraft.reportedToCpuTotalPatterns += completedPatternExecs;
                currentPendingCraft.updateReportedByAC(completedPatternExecs);
                ICrazyCraftHost iCrazyCraftHost = currentPendingCraft.requesterHost;
                if (iCrazyCraftHost instanceof ICrazyCraftCallback) {
                    ICrazyCraftCallback callbackHost = (ICrazyCraftCallback)((Object)iCrazyCraftHost);
                    callbackHost.onCraftBatchCompletedCallback(details, completedPatternExecs);
                }
                if (currentPendingCraft.reportedToCpu < currentPendingCraft.originalBatchSize) continue;
                List<String> keysForThisPC = this.pendingToActiveCraftKeysMap.get(currentPendingCraft.uuid);
                if (keysForThisPC != null && !keysForThisPC.isEmpty()) {
                    for (String keyOfAcInPc : keysForThisPC) {
                        if (activeCraftKeys.contains(keyOfAcInPc)) continue;
                        activeCraftKeys.add(keyOfAcInPc);
                    }
                }
                if (pendingCraftList.contains(currentPendingCraft)) continue;
                pendingCraftList.add(currentPendingCraft);
            }
            if (!activeCraftKeys.isEmpty()) {
                for (String key : activeCraftKeys) {
                    this.removeActiveCraftInternal(key);
                }
            }
            if (!pendingCraftList.isEmpty()) {
                for (PendingCraft pc : pendingCraftList) {
                    this.pendingCrafts.removeIf(p -> p.uuid.equals(pc.uuid));
                    this.pendingToActiveCraftKeysMap.remove(pc.uuid);
                }
            }
            if (totalConsumedFromSlot > 0L) {
                storageInv.extractItem(slot, (int)totalConsumedFromSlot, false);
                changed = true;
            }
            ItemStack finalStackInSlot = storageInv.getStackInSlot(slot);
            IAEItemStack requireWork = this.requireWork[slot];
            if (!finalStackInSlot.func_190926_b()) {
                boolean pushedSomething = this.pushContainedItemsToMe(slot);
                if (pushedSomething) {
                    changed = true;
                }
            } else if (requireWork != null) {
                this.requireWork[slot] = null;
                changed = true;
            }
            if (!(requireWork == this.requireWork[slot] || requireWork != null && this.requireWork[slot] != null && requireWork.equals(this.requireWork[slot]))) {
                changed = true;
            }
            if (changed) {
                this.iHost.saveChanges();
            }
        }
    }

    private void addActiveCraftInternal(ActiveInterfaceCraft active) {
        String pcId = active.pendingCraft.uuid;
        String acKey = pcId + ":" + active.targetSide.func_176610_l();
        this.activeCrafts.put(acKey, active);
        this.pendingToActiveCraftKeysMap.computeIfAbsent(pcId, k -> new ArrayList()).add(acKey);
        active.pendingCraft.pushedToMachines += active.pushedToMachineTotalPatterns;
        active.pendingCraft.reportedToCpu += active.reportedToCpuTotalPatterns;
    }

    private void removeActiveCraftInternal(String acKey) {
        ActiveInterfaceCraft acToRemove = this.activeCrafts.remove(acKey);
        if (acToRemove != null && acToRemove.pendingCraft != null) {
            String pcId = acToRemove.pendingCraft.uuid;
            List<String> keysInMap = this.pendingToActiveCraftKeysMap.get(pcId);
            if (keysInMap != null) {
                keysInMap.remove(acKey);
                if (keysInMap.isEmpty()) {
                    this.pendingToActiveCraftKeysMap.remove(pcId);
                }
            }
            acToRemove.pendingCraft.pushedToMachines -= acToRemove.pushedToMachineTotalPatterns;
            acToRemove.pendingCraft.reportedToCpu -= acToRemove.reportedToCpuTotalPatterns;
            acToRemove.pendingCraft.pushedToMachines = Math.max(0L, acToRemove.pendingCraft.pushedToMachines);
            acToRemove.pendingCraft.reportedToCpu = Math.max(0L, acToRemove.pendingCraft.reportedToCpu);
        }
    }

    private boolean pushContainedItemsToMe(int slot) {
        IItemHandler inv = this.getInventoryByName("storage");
        ItemStack stored = inv.getStackInSlot(slot);
        boolean changed = false;
        if (!stored.func_190926_b()) {
            try {
                AEItemStack work = AEItemStack.fromItemStack((ItemStack)stored);
                IMEMonitor storage = ((IStorageGrid)this.proxy.getGrid().getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IAEItemStack overflow = (IAEItemStack)storage.injectItems((IAEStack)work, Actionable.SIMULATE, this.mySource);
                if (overflow == null || overflow.getStackSize() == 0L) {
                    storage.injectItems((IAEStack)work, Actionable.MODULATE, this.mySource);
                    if (this.requireWork[slot] != null) {
                        changed = true;
                    }
                    this.requireWork[slot] = null;
                    inv.extractItem(slot, stored.func_190916_E(), false);
                    changed = true;
                } else if (overflow.getStackSize() < work.getStackSize()) {
                    long amountToInject = work.getStackSize() - overflow.getStackSize();
                    IAEItemStack toInject = work.copy();
                    toInject.setStackSize(amountToInject);
                    storage.injectItems((IAEStack)toInject, Actionable.MODULATE, this.mySource);
                    inv.extractItem(slot, (int)amountToInject, false);
                    IAEItemStack newRequireWork = work.copy();
                    newRequireWork.setStackSize(overflow.getStackSize());
                    if (this.requireWork[slot] == null || !this.requireWork[slot].equals(newRequireWork)) {
                        changed = true;
                    }
                    this.requireWork[slot] = newRequireWork;
                    changed = true;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return changed;
    }

    private void updateCraftingList() {
        Object[] accountedFor = new Boolean[this.getInventoryByName("patterns").getSlots()];
        Arrays.fill(accountedFor, (Object)false);
        if (!this.proxy.isReady()) {
            return;
        }
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.getInventoryByName("patterns").getStackInSlot(x);
                    if (!Platform.itemComparisons().isSameItem(details.getPattern(), is)) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (((Boolean)accountedFor[x]).booleanValue()) continue;
            this.addToCraftingList(this.getInventoryByName("patterns").getStackInSlot(x));
        }
        try {
            this.proxy.getGrid().postEvent((MENetworkEvent)new MEInterfaceHostStateUpdateEv(this.proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void onReady() {
        if (Platform.isServer()) {
            this.updateCraftingList();
            if (!this.activeCrafts.isEmpty()) {
                TileEntity tile = this.iHost.getTileEntity();
                World world = tile.func_145831_w();
                for (ActiveInterfaceCraft ac : this.activeCrafts.values()) {
                    if (ac.inventoryAdaptor != null) continue;
                    TileEntity neighborTE = world.func_175625_s(tile.func_174877_v().func_177972_a(ac.targetSide));
                    ac.tryRestoreAdaptor(neighborTE, ac.targetSide.func_176734_d());
                }
            }
        }
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is.func_190926_b()) {
            return;
        }
        Item item = is.func_77973_b();
        if (item instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)item).getPatternForItem(is, this.iHost.getTileEntity().func_145831_w())) != null) {
            if (this.craftingList == null) {
                this.craftingList = new ArrayList<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    private boolean isBlocking() {
        return this.cm.getSetting(Settings.BLOCK) == YesNo.YES;
    }

    private void addToSendListFacing(IAEItemStack is, EnumFacing f) {
        if (this.waitingToSendFacing == null) {
            this.waitingToSendFacing = new EnumMap(EnumFacing.class);
        }
        this.waitingToSendFacing.computeIfAbsent(f, k -> new ArrayList());
        this.waitingToSendFacing.get(f).add(is);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void pushItemsOut(EnumFacing s) {
        itemsToPush = this.waitingToSendFacing.get(s);
        if (itemsToPush == null || itemsToPush.isEmpty()) {
            return;
        }
        tile = this.iHost.getTileEntity();
        w = tile.func_145831_w();
        te = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
        if (te == null) {
            return;
        }
        consolidatedMap = new HashMap<IAEItemStack, Long>();
        for (IAEItemStack currentStack : itemsToPush) {
            if (currentStack == null || currentStack.getStackSize() <= 0L) continue;
            keyStack = currentStack.copy();
            keyStack.setStackSize(1L);
            consolidatedMap.merge(keyStack, currentStack.getStackSize(), (BiFunction<Long, Long, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(long long ), (Ljava/lang/Long;Ljava/lang/Long;)Ljava/lang/Long;)());
        }
        itemsToPush.clear();
        for (Map.Entry entry : consolidatedMap.entrySet()) {
            consolidatedStack = (IAEItemStack)entry.getKey();
            consolidatedStack.setStackSize(((Long)entry.getValue()).longValue());
            itemsToPush.add(consolidatedStack);
        }
        if (itemsToPush.isEmpty()) {
            this.waitingToSendFacing.remove(s);
            return;
        }
        if (te instanceof IInterfaceHost || te instanceof TileCableBus && ((TileCableBus)te).getPart(s.func_176734_d()) instanceof PartInterface) {
            try {
                if (te instanceof IInterfaceHost) {
                    targetTE = (IInterfaceHost)te;
                    targetClass = te.getClass();
                } else {
                    part = ((TileCableBus)te).getPart(s.func_176734_d());
                    targetTE = (IInterfaceHost)part;
                    targetClass = part.getClass();
                }
                if (QuantumInterfaceDuality.cachedSameGridMethod != null && QuantumInterfaceDuality.cachedSameGridMethodClass == targetClass) {
                    m = QuantumInterfaceDuality.cachedSameGridMethod;
                } else {
                    m = targetClass.getDeclaredMethod("sameGrid", new Class[]{IGrid.class});
                    m.setAccessible(true);
                    QuantumInterfaceDuality.cachedSameGridMethod = m;
                    QuantumInterfaceDuality.cachedSameGridMethodClass = targetClass;
                }
                if (!((Boolean)m.invoke((Object)targetTE, new Object[]{this.proxy.getGrid()})).booleanValue() || (mon = (IStorageMonitorableAccessor)te.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, s.func_176734_d())) == null || (sm = mon.getInventory(this.mySource)) == null || (inv = sm.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class))) == null) ** GOTO lbl77
                i = itemsToPush.iterator();
                while (i.hasNext()) {
                    whatToSend = i.next();
                    result = (IAEItemStack)inv.injectItems((IAEStack)whatToSend, Actionable.MODULATE, this.mySource);
                    if (result != null && result.getStackSize() > 0L) {
                        whatToSend.setStackSize(result.getStackSize());
                        continue;
                    }
                    i.remove();
                }
            }
            catch (GridAccessException | IllegalAccessException | NoSuchMethodException | InvocationTargetException targetTE) {}
        } else {
            ad = InventoryAdaptor.getAdaptor((TileEntity)te, (EnumFacing)s.func_176734_d());
            if (ad == null) {
                return;
            }
            i = itemsToPush.iterator();
            while (i.hasNext()) {
                whatToSend = i.next();
                if (whatToSend == null || whatToSend.getStackSize() <= 0L) {
                    i.remove();
                    continue;
                }
                mcStack = whatToSend.createItemStack();
                result = ad.addItems(mcStack);
                if (!result.func_190926_b()) {
                    whatToSend.setStackSize((long)result.func_190916_E());
                    continue;
                }
                i.remove();
            }
        }
lbl77:
        // 4 sources

        if (itemsToPush.isEmpty()) {
            this.waitingToSendFacing.remove(s);
        }
    }

    private void onPushPatternSuccess() {
        this.resetCraftingLock();
        LockCraftingMode lockMode = (LockCraftingMode)this.cm.getSetting(Settings.UNLOCK);
        switch (lockMode) {
            case LOCK_UNTIL_PULSE: 
            case LOCK_UNTIL_RESULT: {
                this.saveChanges();
            }
        }
    }

    @Override
    public void cancelCraftingForPattern(ICraftingPatternDetails detailsToCancel, ICrazyCraftHost requestingCpu) {
        if (detailsToCancel == null || requestingCpu == null) {
            return;
        }
        DimensionalCoord cpuCoord = this.getRequesterCoord(requestingCpu);
        if (cpuCoord == null) {
            return;
        }
        ItemStack pattern = detailsToCancel.getPattern();
        if (pattern == null || pattern.func_190926_b()) {
            return;
        }
        boolean changed = false;
        Iterator<Map.Entry<String, ActiveInterfaceCraft>> activeIterator = this.activeCrafts.entrySet().iterator();
        while (activeIterator.hasNext()) {
            List<String> keysInMap;
            Map.Entry<String, ActiveInterfaceCraft> entry = activeIterator.next();
            ActiveInterfaceCraft active = entry.getValue();
            PendingCraft pending = active.pendingCraft;
            if (pending == null || !pending.resolveEnvironment(this.iHost.getTileEntity().func_145831_w()) || pending.patternDetails == null) continue;
            ItemStack currentPatternStack = pending.patternDetails.getPattern();
            if (!Platform.itemComparisons().isSameItem(currentPatternStack, pattern) || pending.requester == null || !pending.requester.equals((Object)cpuCoord)) continue;
            String acKey = entry.getKey();
            activeIterator.remove();
            if (pending.uuid != null && (keysInMap = this.pendingToActiveCraftKeysMap.get(pending.uuid)) != null) {
                keysInMap.remove(acKey);
                if (keysInMap.isEmpty()) {
                    this.pendingToActiveCraftKeysMap.remove(pending.uuid);
                }
            }
            pending.pushedToMachines -= active.pushedToMachineTotalPatterns;
            pending.reportedToCpu -= active.reportedToCpuTotalPatterns;
            pending.pushedToMachines = Math.max(0L, pending.pushedToMachines);
            pending.reportedToCpu = Math.max(0L, pending.reportedToCpu);
            changed = true;
        }
        Iterator<PendingCraft> pendingIterator = this.pendingCrafts.iterator();
        while (pendingIterator.hasNext()) {
            PendingCraft pending = pendingIterator.next();
            if (pending.resolveEnvironment(this.iHost.getTileEntity().func_145831_w()) && pending.patternDetails != null) {
                boolean shouldRemovePending;
                ItemStack currentPatternStack = pending.patternDetails.getPattern();
                boolean bl = shouldRemovePending = Platform.itemComparisons().isSameItem(currentPatternStack, pattern) && pending.requester != null && pending.requester.equals((Object)cpuCoord);
                if (!this.pendingToActiveCraftKeysMap.containsKey(pending.uuid) && this.activeCrafts.values().stream().noneMatch(ac -> ac.pendingCraft == pending)) {
                    shouldRemovePending = true;
                }
                if (!shouldRemovePending) continue;
                pendingIterator.remove();
                this.pendingToActiveCraftKeysMap.remove(pending.uuid);
                changed = true;
                continue;
            }
            if (pending.patternDetails != null || pending.patternStack.func_190926_b() || !Platform.itemComparisons().isSameItem(pending.patternStack, pattern) || pending.requester == null || !pending.requester.equals((Object)cpuCoord)) continue;
            pendingIterator.remove();
            this.pendingToActiveCraftKeysMap.remove(pending.uuid);
            changed = true;
        }
        if (changed) {
            this.iHost.saveChanges();
        }
    }

    @Override
    public long estimatePushableBatchSize(ICraftingPatternDetails details, long desiredBatchSize, ICrazyCraftHost requestingCpu, World world) {
        if (details == null || desiredBatchSize <= 0L || world == null) {
            return 0L;
        }
        TileEntity tile = this.getHost().getTile();
        if (tile == null) {
            return 0L;
        }
        long maxPushableBatch = 0L;
        int facesAvailable = 0;
        EnumSet facesToCheck = this.iHost.getTargets();
        for (EnumFacing s : facesToCheck) {
            InventoryAdaptor ad;
            TileEntity te = world.func_175625_s(tile.func_174877_v().func_177972_a(s));
            if (te == null) continue;
            if (te instanceof IInterfaceHost || te instanceof TileCableBus && ((TileCableBus)te).getPart(s.func_176734_d()) instanceof PartInterface) {
                try {
                    IPart part;
                    IGridNode otherNode = null;
                    if (te instanceof IInterfaceHost) {
                        otherNode = ((IInterfaceHost)te).getActionableNode();
                    } else if (te instanceof TileCableBus && (part = ((TileCableBus)te).getPart(s.func_176734_d())) instanceof IInterfaceHost) {
                        otherNode = ((IInterfaceHost)part).getActionableNode();
                    }
                    if (otherNode != null && this.proxy.getGrid() != null && otherNode.getGrid() == this.proxy.getGrid()) {
                        continue;
                    }
                }
                catch (GridAccessException otherNode) {
                    // empty catch block
                }
            }
            if ((ad = InventoryAdaptor.getAdaptor((TileEntity)te, (EnumFacing)s.func_176734_d())) == null) continue;
            if (!(ad instanceof IMixinAdaptorItemHandler)) {
                long currentBatch = 0L;
                boolean canPushOneUnit = true;
                IAEItemStack[] iAEItemStackArray = details.getCondensedInputs();
                int n = iAEItemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    IAEItemStack inputTemplate = iAEItemStackArray[i];
                    if (inputTemplate == null || inputTemplate.getStackSize() <= 0L) continue;
                    ItemStack mcStack = inputTemplate.createItemStack();
                    if (mcStack.func_190926_b()) {
                        canPushOneUnit = false;
                        break;
                    }
                    ItemStack remainder = ad.simulateAdd(mcStack);
                    if (remainder.func_190926_b()) continue;
                    canPushOneUnit = false;
                    break;
                }
                if (canPushOneUnit) {
                    currentBatch = 1L;
                }
                maxPushableBatch = Math.max(maxPushableBatch, currentBatch);
                ++facesAvailable;
                continue;
            }
            IMixinAdaptorItemHandler mixinAdaptor = (IMixinAdaptorItemHandler)ad;
            long currentMaxBatchForFace = desiredBatchSize;
            for (IAEItemStack inputTemplate : details.getCondensedInputs()) {
                if (inputTemplate == null || inputTemplate.getStackSize() <= 0L) continue;
                ItemStack templateStack = inputTemplate.createItemStack();
                if (templateStack.func_190926_b()) {
                    currentMaxBatchForFace = 0L;
                    break;
                }
                long canAcceptForItemType = mixinAdaptor.crazyae$estimateInsertableAmount(templateStack);
                long itemsPerPatternExecution = inputTemplate.getStackSize();
                if (itemsPerPatternExecution <= 0L) {
                    currentMaxBatchForFace = 0L;
                    break;
                }
                long numPatternExecutionsPossibleForItem = canAcceptForItemType / itemsPerPatternExecution;
                if ((currentMaxBatchForFace = Math.min(currentMaxBatchForFace, numPatternExecutionsPossibleForItem)) == 0L) break;
            }
            maxPushableBatch = Math.max(maxPushableBatch, currentMaxBatchForFace);
            ++facesAvailable;
        }
        return maxPushableBatch * (long)facesAvailable;
    }

    @Override
    public boolean pushDetails(ICraftingPatternDetails details, long requestedBatchSize, ICrazyCraftHost who) {
        TileEntity tile = this.getHost().getTile();
        if (tile == null) {
            return false;
        }
        World w = tile.func_145831_w();
        DimensionalCoord requesterCoord = this.getRequesterCoord(who);
        if (requesterCoord == null) {
            return false;
        }
        if (this.getCraftingLockedReason() != LockCraftingMode.NONE) {
            return false;
        }
        if (requestedBatchSize <= 0L) {
            return false;
        }
        boolean successfullyPushed = false;
        PendingCraft pendingCraft = null;
        EnumSet facesToCheck = this.iHost.getTargets();
        for (EnumFacing s : facesToCheck) {
            IMixinAdaptorItemHandler mixinAdaptor;
            InventoryAdaptor ad;
            TileEntity te = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
            if (te == null) continue;
            if (te instanceof IInterfaceHost || te instanceof TileCableBus && ((TileCableBus)te).getPart(s.func_176734_d()) instanceof PartInterface) {
                try {
                    IPart part;
                    IGridNode otherNode = null;
                    if (te instanceof IInterfaceHost) {
                        otherNode = ((IInterfaceHost)te).getActionableNode();
                    } else if (te instanceof TileCableBus && (part = ((TileCableBus)te).getPart(s.func_176734_d())) instanceof IInterfaceHost) {
                        otherNode = ((IInterfaceHost)part).getActionableNode();
                    }
                    if (otherNode != null && otherNode.getGrid() == this.proxy.getGrid()) {
                        continue;
                    }
                }
                catch (GridAccessException otherNode) {
                    // empty catch block
                }
            }
            if ((ad = InventoryAdaptor.getAdaptor((TileEntity)te, (EnumFacing)s.func_176734_d())) == null || ad instanceof IMixinAdaptorItemHandler && (mixinAdaptor = (IMixinAdaptorItemHandler)ad).crazyae$isInventoryFull() || this.isBlocking() && this.checkBlocking(w, tile.func_174877_v().func_177972_a(s), te, ad, s)) continue;
            if (pendingCraft == null) {
                Map<IAEItemStack, Long> expectedOutputsTotal = QuantumInterfaceDuality.calculateExpectedOutputs(details, requestedBatchSize);
                if (expectedOutputsTotal == null) {
                    return false;
                }
                pendingCraft = new PendingCraft(requesterCoord, details.getPattern(), details, requestedBatchSize, expectedOutputsTotal);
            }
            ActiveInterfaceCraft active = new ActiveInterfaceCraft(pendingCraft, s, ad);
            this.addActiveCraftInternal(active);
            boolean foundPending = false;
            for (PendingCraft pc : this.pendingCrafts) {
                if (!pc.uuid.equals(pendingCraft.uuid)) continue;
                foundPending = true;
                break;
            }
            if (!foundPending) {
                this.pendingCrafts.add(pendingCraft);
            }
            successfullyPushed = true;
        }
        if (successfullyPushed) {
            this.iHost.saveChanges();
            if (who instanceof ICrazyCraftCallback) {
                ICrazyCraftCallback c = (ICrazyCraftCallback)((Object)who);
                c.onCraftSentCallback(details, requestedBatchSize);
            }
            this.onPushPatternSuccess();
            return true;
        }
        return false;
    }

    private DimensionalCoord getRequesterCoord(ICrazyCraftHost who) {
        IGridNode node;
        if (who instanceof TileEntity) {
            return new DimensionalCoord((TileEntity)who);
        }
        if (who instanceof IGridNode && (node = (IGridNode)who).getMachine() instanceof TileEntity) {
            return new DimensionalCoord((TileEntity)node.getMachine());
        }
        return null;
    }

    private static Map<IAEItemStack, Long> calculateExpectedOutputs(ICraftingPatternDetails details, long batchSize) {
        HashMap<IAEItemStack, Long> expectedOutputs = new HashMap<IAEItemStack, Long>();
        for (IAEItemStack outputTemplate : details.getCondensedOutputs()) {
            if (outputTemplate == null || outputTemplate.getStackSize() <= 0L) continue;
            long totalExpected = Utils.multiplySafely(outputTemplate.getStackSize(), batchSize);
            if (totalExpected > 0L) {
                IAEItemStack keyStack = outputTemplate.copy();
                keyStack.setStackSize(1L);
                expectedOutputs.put(keyStack, expectedOutputs.getOrDefault(keyStack, 0L) + totalExpected);
                continue;
            }
            if (totalExpected >= 0L) continue;
            return null;
        }
        return expectedOutputs;
    }

    private boolean checkBlocking(World w, BlockPos targetPos, TileEntity te, InventoryAdaptor ad, EnumFacing s) {
        if (ModsChecker.AA_LOADED && te instanceof IPhantomTile) {
            IPhantomTile phantomTE = (IPhantomTile)te;
            if (phantomTE.hasBoundPosition()) {
                TileEntity phantom = w.func_175625_s(phantomTE.getBoundPosition());
                if (NonBlockingItems.INSTANCE.getMap().containsKey(w.func_180495_p(phantomTE.getBoundPosition()).func_177230_c().getRegistryName().func_110624_b())) {
                    return this.isCustomInvBlocking(phantom, s);
                }
            }
        } else if (NonBlockingItems.INSTANCE.getMap().containsKey(w.func_180495_p(targetPos).func_177230_c().getRegistryName().func_110624_b())) {
            return this.isCustomInvBlocking(te, s);
        }
        return this.invIsBlocked(ad);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagList pendingList = new NBTTagList();
        for (PendingCraft craft : this.pendingCrafts) {
            pendingList.func_74742_a((NBTBase)craft.writeToNBT());
        }
        data.func_74782_a("pendingCrafts", (NBTBase)pendingList);
        NBTTagList activeCraftsNBTList = new NBTTagList();
        for (ActiveInterfaceCraft ac : this.activeCrafts.values()) {
            activeCraftsNBTList.func_74742_a((NBTBase)ac.writeToNBT());
        }
        data.func_74782_a("activeCraftsData", (NBTBase)activeCraftsNBTList);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pendingCrafts.clear();
        NBTTagList pendingList = data.func_150295_c("pendingCrafts", 10);
        for (int i = 0; i < pendingList.func_74745_c(); ++i) {
            NBTTagCompound craftTag = pendingList.func_150305_b(i);
            PendingCraft craft = PendingCraft.readFromNBT(craftTag);
            if (craft == null) continue;
            this.pendingCrafts.add(craft);
        }
        for (PendingCraft pc : this.pendingCrafts) {
            pc.pushedToMachines = 0L;
            pc.reportedToCpu = 0L;
        }
        this.activeCrafts.clear();
        this.pendingToActiveCraftKeysMap.clear();
        NBTTagList activeCraftsNBTList = data.func_150295_c("activeCraftsData", 10);
        World worldForACLoad = this.iHost != null && this.iHost.getTileEntity() != null ? this.iHost.getTileEntity().func_145831_w() : null;
        for (int i = 0; i < activeCraftsNBTList.func_74745_c(); ++i) {
            NBTTagCompound acTag = activeCraftsNBTList.func_150305_b(i);
            ActiveInterfaceCraft ac = ActiveInterfaceCraft.readFromNBT(acTag, this.pendingCrafts, worldForACLoad);
            if (ac == null || ac.pendingCraft == null) continue;
            this.addActiveCraftInternal(ac);
        }
    }

    private boolean isCustomInvBlocking(TileEntity te, EnumFacing s) {
        BlockingInventoryAdaptor blockingInventoryAdaptor = BlockingInventoryAdaptor.getAdaptor((TileEntity)te, (EnumFacing)s.func_176734_d());
        return QuantumInterfaceDuality.invIsCustomBlocking(blockingInventoryAdaptor);
    }

    private static boolean invIsCustomBlocking(BlockingInventoryAdaptor inv) {
        return inv.containsBlockingItems();
    }

    private boolean invIsBlocked(InventoryAdaptor inv) {
        return inv.containsItems();
    }

    /*
     * WARNING - void declaration
     */
    private long tryPushNextMicroBatch(ActiveInterfaceCraft active, long maxUnitsAmt) {
        if (maxUnitsAmt <= 0L) {
            return 0L;
        }
        if (active.inventoryAdaptor == null) {
            return 0L;
        }
        World currentHostWorld = this.getTile().func_145831_w();
        if (!active.pendingCraft.resolveEnvironment(currentHostWorld)) {
            return 0L;
        }
        ICraftingPatternDetails details = active.pendingCraft.patternDetails;
        if (details == null) {
            return 0L;
        }
        IAEItemStack[] condensedInputs = details.getCondensedInputs();
        if (condensedInputs == null || condensedInputs.length == 0) {
            return maxUnitsAmt;
        }
        long maxUnitsToPush = maxUnitsAmt;
        InventoryAdaptor inventoryAdaptor = active.inventoryAdaptor;
        if (inventoryAdaptor instanceof IMixinAdaptorItemHandler) {
            void var14_19;
            IMixinAdaptorItemHandler mixinAdaptor = (IMixinAdaptorItemHandler)inventoryAdaptor;
            long estimatedUnits = Long.MAX_VALUE;
            IAEItemStack[] iAEItemStackArray = condensedInputs;
            int n = iAEItemStackArray.length;
            boolean bl = false;
            while (var14_19 < n) {
                IAEItemStack inputTemplate = iAEItemStackArray[var14_19];
                if (inputTemplate != null && inputTemplate.getStackSize() > 0L) {
                    ItemStack templateStack = inputTemplate.createItemStack();
                    long canAccept = mixinAdaptor.crazyae$estimateInsertableAmount(templateStack);
                    long itemsPerPatternExecution = inputTemplate.getStackSize();
                    if (itemsPerPatternExecution <= 0L) {
                        estimatedUnits = 0L;
                        break;
                    }
                    long patternExecsAmt = canAccept / itemsPerPatternExecution;
                    if ((estimatedUnits = Math.min(estimatedUnits, patternExecsAmt)) == 0L) break;
                }
                ++var14_19;
            }
            maxUnitsToPush = Math.min(maxUnitsAmt, estimatedUnits);
        }
        if (maxUnitsToPush == 0L) {
            return 0L;
        }
        HashMap<IAEItemStack, ItemStack> templateToMcStackCache = new HashMap<IAEItemStack, ItemStack>();
        for (IAEItemStack inputTemplate : condensedInputs) {
            if (inputTemplate == null || inputTemplate.getStackSize() <= 0L) continue;
            ItemStack itemStack = inputTemplate.createItemStack();
            if (itemStack.func_190926_b()) {
                return 0L;
            }
            templateToMcStackCache.put(inputTemplate, itemStack);
        }
        long actualPushUnitsAmt = 0L;
        if (maxUnitsToPush > 0L) {
            boolean canPushFirstUnit = true;
            for (IAEItemStack inputTemplate : condensedInputs) {
                ItemStack mcStackToSimulate;
                ItemStack remainder;
                if (inputTemplate == null || inputTemplate.getStackSize() <= 0L || (remainder = active.inventoryAdaptor.simulateAdd(mcStackToSimulate = (ItemStack)templateToMcStackCache.get(inputTemplate))).func_190926_b()) continue;
                canPushFirstUnit = false;
                break;
            }
            if (canPushFirstUnit) {
                actualPushUnitsAmt = maxUnitsToPush;
            }
        }
        if (actualPushUnitsAmt > 0L) {
            HashMap<IAEItemStack, Long> itemsSent = new HashMap<IAEItemStack, Long>();
            for (IAEItemStack inputTemplate : condensedInputs) {
                if (inputTemplate == null || inputTemplate.getStackSize() <= 0L) continue;
                IAEItemStack key = inputTemplate.copy();
                key.setStackSize(1L);
                itemsSent.merge(key, Utils.multiplySafely(inputTemplate.getStackSize(), actualPushUnitsAmt), Long::sum);
            }
            if (!itemsSent.isEmpty()) {
                for (Map.Entry entry : itemsSent.entrySet()) {
                    IAEItemStack itemToSend = (IAEItemStack)entry.getKey();
                    itemToSend.setStackSize(((Long)entry.getValue()).longValue());
                    this.addToSendListFacing(itemToSend, active.targetSide);
                }
            }
        }
        return actualPushUnitsAmt;
    }

    private static List<IAEItemStack> calculateExpectedOutputsForMicroBatch(ICraftingPatternDetails details, long microBatchPatternExecutions) {
        ArrayList<IAEItemStack> expected = new ArrayList<IAEItemStack>();
        if (details == null || microBatchPatternExecutions <= 0L) {
            return expected;
        }
        for (IAEItemStack outputTemplate : details.getCondensedOutputs()) {
            long totalAmount;
            if (outputTemplate == null || outputTemplate.getStackSize() <= 0L || (totalAmount = Utils.multiplySafely(outputTemplate.getStackSize(), microBatchPatternExecutions)) <= 0L) continue;
            IAEItemStack batchOutput = outputTemplate.copy();
            batchOutput.setStackSize(totalAmount);
            expected.add(batchOutput);
        }
        expected.addAll(Utils.getContainerItemsFromInputs(details, microBatchPatternExecutions));
        return expected;
    }

    @Override
    public void tickInterfaceHost(IGrid grid, CrazyAutocraftingSystem cache) {
        boolean changedThisTick = false;
        TileEntity hostTileEntity = this.iHost.getTileEntity();
        World hostWorld = hostTileEntity.func_145831_w();
        IItemHandler storageInv = this.getInventoryByName("storage");
        for (int i = 0; i < storageInv.getSlots(); ++i) {
            ItemStack is = storageInv.getStackInSlot(i);
            if (is.func_190926_b()) continue;
            this.pushContainedItemsToMe(i);
        }
        ArrayList<String> activeCraftKeysToRemove = new ArrayList<String>();
        ArrayList<PendingCraft> pendingCraftsToRemove = new ArrayList<PendingCraft>();
        for (Map.Entry<String, ActiveInterfaceCraft> entry2 : this.activeCrafts.entrySet()) {
            long pushed;
            long patternsLeftForAC;
            long totalCurrentlyPushed;
            long globallyRemaining;
            String activeCraftKey = entry2.getKey();
            ActiveInterfaceCraft active = entry2.getValue();
            if (active == null) continue;
            if (active.pendingCraft == null) {
                if (activeCraftKeysToRemove.contains(activeCraftKey)) continue;
                activeCraftKeysToRemove.add(activeCraftKey);
                continue;
            }
            if (active.inventoryAdaptor == null) {
                TileEntity neighborTE = hostWorld.func_175625_s(hostTileEntity.func_174877_v().func_177972_a(active.targetSide));
                active.tryRestoreAdaptor(neighborTE, active.targetSide.func_176734_d());
                if (active.inventoryAdaptor == null) continue;
            }
            if (!active.pendingCraft.resolveEnvironment(hostWorld)) continue;
            PendingCraft currentPendingCraft = active.pendingCraft;
            if (currentPendingCraft.patternDetails == null || (globallyRemaining = currentPendingCraft.originalBatchSize - (totalCurrentlyPushed = currentPendingCraft.pushedToMachines)) <= 0L || !active.canPushNextMicroBatch || (patternsLeftForAC = currentPendingCraft.originalBatchSize - active.pushedToMachineTotalPatterns) <= 0L) continue;
            long attemptsForAC = Math.min(globallyRemaining, (long)MAX_PATTERN_EXECUTIONS_TO_PUSH_PER_AC_TICK);
            if ((attemptsForAC = Math.min(attemptsForAC, patternsLeftForAC)) <= 0L || (pushed = this.tryPushNextMicroBatch(active, attemptsForAC)) <= 0L) continue;
            active.startNewMicroBatch(pushed, currentPendingCraft.patternDetails);
            currentPendingCraft.updatePushedByAC(pushed);
            changedThisTick = true;
            if (!active.isMicroBatchTrulyComplete()) continue;
            long completedSize = active.finalizeMicrobatch();
            if (completedSize <= 0L && active.currentMicroBatchTotalOutputsExpected.isEmpty()) {
                completedSize = pushed;
            }
            if (completedSize <= 0L) continue;
            active.reportedToCpuTotalPatterns += completedSize;
            currentPendingCraft.updateReportedByAC(completedSize);
            ICrazyCraftHost iCrazyCraftHost = currentPendingCraft.requesterHost;
            if (iCrazyCraftHost instanceof ICrazyCraftCallback) {
                ICrazyCraftCallback callbackHost = (ICrazyCraftCallback)((Object)iCrazyCraftHost);
                callbackHost.onCraftBatchCompletedCallback(currentPendingCraft.patternDetails, completedSize);
            }
            if (currentPendingCraft.reportedToCpu < currentPendingCraft.originalBatchSize) continue;
            List<String> keysForThisPC = this.pendingToActiveCraftKeysMap.get(currentPendingCraft.uuid);
            if (keysForThisPC != null && !keysForThisPC.isEmpty()) {
                for (String keyOfAcInPc : keysForThisPC) {
                    if (activeCraftKeysToRemove.contains(keyOfAcInPc)) continue;
                    activeCraftKeysToRemove.add(keyOfAcInPc);
                }
            }
            if (pendingCraftsToRemove.contains(currentPendingCraft)) continue;
            pendingCraftsToRemove.add(currentPendingCraft);
        }
        if (!activeCraftKeysToRemove.isEmpty()) {
            for (String key : activeCraftKeysToRemove) {
                this.removeActiveCraftInternal(key);
            }
            changedThisTick = true;
        }
        if (!pendingCraftsToRemove.isEmpty()) {
            for (PendingCraft pc : pendingCraftsToRemove) {
                this.pendingCrafts.removeIf(p -> p.uuid.equals(pc.uuid));
                this.pendingToActiveCraftKeysMap.remove(pc.uuid);
            }
        }
        if (this.waitingToSendFacing != null && !this.waitingToSendFacing.isEmpty()) {
            boolean itemsPushed = false;
            EnumSet<EnumFacing> faces = EnumSet.noneOf(EnumFacing.class);
            if (this.waitingToSendFacing != null) {
                faces.addAll(this.waitingToSendFacing.keySet());
            }
            for (EnumFacing face : faces) {
                List<IAEItemStack> itemsList = this.waitingToSendFacing.get(face);
                if (itemsList != null && !itemsList.isEmpty()) {
                    long beforePush = 0L;
                    for (IAEItemStack stack : itemsList) {
                        if (stack == null) continue;
                        beforePush += stack.getStackSize();
                    }
                    this.pushItemsOut(face);
                    List<IAEItemStack> itemsListAfterPush = this.waitingToSendFacing.get(face);
                    if (itemsListAfterPush == null || itemsListAfterPush.isEmpty()) {
                        itemsPushed = true;
                        continue;
                    }
                    long countAfterPush = 0L;
                    for (IAEItemStack stack : itemsListAfterPush) {
                        if (stack == null) continue;
                        countAfterPush += stack.getStackSize();
                    }
                    if (countAfterPush >= beforePush) continue;
                    itemsPushed = true;
                    continue;
                }
                if (this.waitingToSendFacing == null) continue;
                this.waitingToSendFacing.remove(face);
            }
            if (itemsPushed) {
                changedThisTick = true;
            }
        }
        if (this.waitingToSendFacing != null) {
            this.waitingToSendFacing.entrySet().removeIf(entry -> entry.getValue() == null || ((List)entry.getValue()).isEmpty());
        }
        if (changedThisTick) {
            this.iHost.saveChanges();
        }
    }

    @Override
    public boolean canAcceptPattern(ICraftingPatternDetails details) {
        return this.craftingList.contains(details);
    }

    @Override
    public IGridNode getNode() {
        return this.proxy.getNode();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        try {
            this.proxy.getGrid().postEvent((MENetworkEvent)new MEInterfaceHostStateUpdateEv(this.proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void provideCrafting(ICrazyCraftingProviderHelper var1) {
        if (this.proxy.isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                details.setPriority(this.getPriority());
                var1.addCraftingOption(this, details);
            }
        }
    }

    private static class ActiveInterfaceCraft {
        final PendingCraft pendingCraft;
        final EnumFacing targetSide;
        InventoryAdaptor inventoryAdaptor;
        long pushedToMachineTotalPatterns;
        long reportedToCpuTotalPatterns;
        boolean canPushNextMicroBatch;
        long currentMicroBatchSize;
        Map<IAEItemStack, Long> currentMicroBatchTotalOutputsExpected;
        Map<IAEItemStack, Long> currentMicroBatchTotalOutputsReceived;

        ActiveInterfaceCraft(PendingCraft pending, EnumFacing side, InventoryAdaptor adaptor) {
            this.pendingCraft = pending;
            this.targetSide = side;
            this.inventoryAdaptor = adaptor;
            this.pushedToMachineTotalPatterns = 0L;
            this.reportedToCpuTotalPatterns = 0L;
            this.canPushNextMicroBatch = true;
            this.currentMicroBatchSize = 0L;
            this.currentMicroBatchTotalOutputsExpected = new HashMap<IAEItemStack, Long>();
            this.currentMicroBatchTotalOutputsReceived = new HashMap<IAEItemStack, Long>();
        }

        public void tryRestoreAdaptor(TileEntity neighbor, EnumFacing oppositeSide) {
            if (this.inventoryAdaptor == null && neighbor != null) {
                this.inventoryAdaptor = InventoryAdaptor.getAdaptor((TileEntity)neighbor, (EnumFacing)oppositeSide);
            }
        }

        void startNewMicroBatch(long pushedPatternExecs, ICraftingPatternDetails details) {
            this.pushedToMachineTotalPatterns += pushedPatternExecs;
            this.currentMicroBatchSize = pushedPatternExecs;
            this.currentMicroBatchTotalOutputsReceived.clear();
            this.currentMicroBatchTotalOutputsExpected.clear();
            List outputsForThisBatch = QuantumInterfaceDuality.calculateExpectedOutputsForMicroBatch(details, pushedPatternExecs);
            for (IAEItemStack output : outputsForThisBatch) {
                if (output == null || output.getStackSize() <= 0L) continue;
                IAEItemStack key = output.copy();
                key.setStackSize(1L);
                this.currentMicroBatchTotalOutputsExpected.merge(key, output.getStackSize(), Long::sum);
            }
            this.canPushNextMicroBatch = false;
        }

        boolean recordReceivedAndComplete(IAEItemStack newItemFromSlot, Longium consumedFromNewItem) {
            consumedFromNewItem.set(0L);
            if (this.currentMicroBatchSize == 0L) {
                return false;
            }
            if (this.currentMicroBatchTotalOutputsExpected.isEmpty()) {
                if (this.pendingCraft.patternDetails != null && this.pendingCraft.patternDetails.getCondensedOutputs().length == 0) {
                    return this.isMicroBatchTrulyComplete();
                }
                return false;
            }
            IAEItemStack keyItem = newItemFromSlot.copy();
            keyItem.setStackSize(1L);
            Long totalExpectedForType = this.currentMicroBatchTotalOutputsExpected.get(keyItem);
            if (totalExpectedForType != null) {
                long alreadyReceived = this.currentMicroBatchTotalOutputsReceived.getOrDefault(keyItem, 0L);
                long neededMore = totalExpectedForType - alreadyReceived;
                if (neededMore > 0L) {
                    long canTake = Math.min(newItemFromSlot.getStackSize(), neededMore);
                    this.currentMicroBatchTotalOutputsReceived.merge(keyItem, canTake, Long::sum);
                    consumedFromNewItem.set(canTake);
                }
            }
            return this.isMicroBatchTrulyComplete();
        }

        boolean isMicroBatchTrulyComplete() {
            if (this.currentMicroBatchSize == 0L) {
                return false;
            }
            if (this.currentMicroBatchTotalOutputsExpected.isEmpty()) {
                return this.pendingCraft.patternDetails != null && this.pendingCraft.patternDetails.getCondensedOutputs().length == 0;
            }
            for (Map.Entry<IAEItemStack, Long> entry : this.currentMicroBatchTotalOutputsExpected.entrySet()) {
                if (this.currentMicroBatchTotalOutputsReceived.getOrDefault(entry.getKey(), 0L) >= entry.getValue()) continue;
                return false;
            }
            return true;
        }

        long finalizeMicrobatch() {
            long size = this.currentMicroBatchSize;
            this.currentMicroBatchSize = 0L;
            this.canPushNextMicroBatch = true;
            return size;
        }

        NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.pendingCraft == null || this.pendingCraft.uuid == null) {
                return new NBTTagCompound();
            }
            tag.func_74778_a("pendingId", this.pendingCraft.uuid);
            tag.func_74778_a("side", this.targetSide.func_176610_l());
            tag.func_74772_a("pushedTotal", this.pushedToMachineTotalPatterns);
            tag.func_74772_a("reportedTotal", this.reportedToCpuTotalPatterns);
            tag.func_74757_a("canPushNext", this.canPushNextMicroBatch);
            tag.func_74772_a("microBatchSize", this.currentMicroBatchSize);
            NBTTagList expectedList = new NBTTagList();
            if (this.currentMicroBatchTotalOutputsExpected != null) {
                for (Map.Entry<IAEItemStack, Long> entry : this.currentMicroBatchTotalOutputsExpected.entrySet()) {
                    NBTTagCompound eTag = new NBTTagCompound();
                    NBTTagCompound key = new NBTTagCompound();
                    entry.getKey().writeToNBT(key);
                    eTag.func_74782_a("key", (NBTBase)key);
                    eTag.func_74772_a("val", entry.getValue().longValue());
                    expectedList.func_74742_a((NBTBase)eTag);
                }
            }
            tag.func_74782_a("microExpected", (NBTBase)expectedList);
            NBTTagList receivedList = new NBTTagList();
            if (this.currentMicroBatchTotalOutputsReceived != null) {
                for (Map.Entry<IAEItemStack, Long> entry : this.currentMicroBatchTotalOutputsReceived.entrySet()) {
                    NBTTagCompound rTag = new NBTTagCompound();
                    NBTTagCompound key = new NBTTagCompound();
                    entry.getKey().writeToNBT(key);
                    rTag.func_74782_a("key", (NBTBase)key);
                    rTag.func_74772_a("val", entry.getValue().longValue());
                    receivedList.func_74742_a((NBTBase)rTag);
                }
            }
            tag.func_74782_a("microReceived", (NBTBase)receivedList);
            return tag;
        }

        static ActiveInterfaceCraft readFromNBT(NBTTagCompound tag, List<PendingCraft> allPendingCrafts, World world) {
            String pendingId = tag.func_74779_i("pendingId");
            PendingCraft foundPending = null;
            for (PendingCraft pc : allPendingCrafts) {
                if (!pc.uuid.equals(pendingId)) continue;
                foundPending = pc;
                break;
            }
            if (foundPending == null) {
                return null;
            }
            EnumFacing side = EnumFacing.func_176739_a((String)tag.func_74779_i("side"));
            if (side == null) {
                return null;
            }
            ActiveInterfaceCraft ac = new ActiveInterfaceCraft(foundPending, side, null);
            ac.pushedToMachineTotalPatterns = tag.func_74763_f("pushedTotal");
            ac.reportedToCpuTotalPatterns = tag.func_74763_f("reportedTotal");
            ac.canPushNextMicroBatch = tag.func_74767_n("canPushNext");
            ac.currentMicroBatchSize = tag.func_74763_f("microBatchSize");
            ac.currentMicroBatchTotalOutputsExpected = new HashMap<IAEItemStack, Long>();
            NBTTagList expectedList = tag.func_150295_c("microExpected", 10);
            for (int i = 0; i < expectedList.func_74745_c(); ++i) {
                NBTTagCompound eTag = expectedList.func_150305_b(i);
                IAEItemStack key = AEItemStack.fromNBT((NBTTagCompound)eTag.func_74775_l("key"));
                if (key == null) continue;
                ac.currentMicroBatchTotalOutputsExpected.put(key, eTag.func_74763_f("val"));
            }
            ac.currentMicroBatchTotalOutputsReceived = new HashMap<IAEItemStack, Long>();
            NBTTagList receivedList = tag.func_150295_c("microReceived", 10);
            for (int i = 0; i < receivedList.func_74745_c(); ++i) {
                NBTTagCompound rTag = receivedList.func_150305_b(i);
                IAEItemStack key = AEItemStack.fromNBT((NBTTagCompound)rTag.func_74775_l("key"));
                if (key == null) continue;
                ac.currentMicroBatchTotalOutputsReceived.put(key, rTag.func_74763_f("val"));
            }
            return ac;
        }
    }

    private static class PendingCraft {
        final DimensionalCoord requester;
        final ItemStack patternStack;
        ICraftingPatternDetails patternDetails;
        final long originalBatchSize;
        final Map<IAEItemStack, Long> totalExpectedOutputs;
        final String uuid;
        ICrazyCraftHost requesterHost = null;
        long pushedToMachines = 0L;
        long reportedToCpu = 0L;

        PendingCraft(DimensionalCoord requesterCoord, ItemStack patternStack, ICraftingPatternDetails details, long batchSize, Map<IAEItemStack, Long> expectedOutputs) {
            this.requester = requesterCoord;
            this.patternStack = patternStack;
            this.patternDetails = details;
            this.originalBatchSize = batchSize;
            this.totalExpectedOutputs = new HashMap<IAEItemStack, Long>(expectedOutputs);
            this.uuid = UUID.randomUUID().toString().substring(0, 8);
        }

        PendingCraft(DimensionalCoord requesterCoord, ItemStack patternStack, long batchSize, String uniqueId) {
            this.requester = requesterCoord;
            this.patternStack = patternStack;
            this.originalBatchSize = batchSize;
            this.uuid = uniqueId;
            this.patternDetails = null;
            this.totalExpectedOutputs = new HashMap<IAEItemStack, Long>();
        }

        public void updatePushedByAC(long deltaPushed) {
            this.pushedToMachines += deltaPushed;
        }

        public void updateReportedByAC(long deltaReported) {
            this.reportedToCpu += deltaReported;
        }

        boolean resolveEnvironment(World world) {
            Item te;
            if (world == null) {
                return false;
            }
            if (this.requesterHost == null && this.requester != null) {
                World worldForCoord = this.requester.getWorld();
                if (worldForCoord == null) {
                    worldForCoord = world;
                }
                if ((te = worldForCoord.func_175625_s(this.requester.getPos())) instanceof ICrazyCraftHost) {
                    this.requesterHost = (ICrazyCraftHost)te;
                } else {
                    return false;
                }
            }
            if (this.patternDetails == null && !this.patternStack.func_190926_b() && (te = this.patternStack.func_77973_b()) instanceof ICraftingPatternItem) {
                Map calculatedExpected;
                ICraftingPatternItem cpi = (ICraftingPatternItem)te;
                this.patternDetails = cpi.getPatternForItem(this.patternStack, world);
                if (this.patternDetails != null && this.totalExpectedOutputs.isEmpty() && (calculatedExpected = QuantumInterfaceDuality.calculateExpectedOutputs(this.patternDetails, this.originalBatchSize)) != null) {
                    this.totalExpectedOutputs.putAll(calculatedExpected);
                }
                if (this.patternDetails == null) {
                    return false;
                }
            }
            return this.requesterHost != null && this.patternDetails != null;
        }

        NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.requester != null) {
                tag.func_74782_a("reqCoord", (NBTBase)NBTUtils.writeDimensionalCoord(this.requester));
            }
            if (!this.patternStack.func_190926_b()) {
                tag.func_74782_a("pattern", (NBTBase)this.patternStack.func_77955_b(new NBTTagCompound()));
            }
            tag.func_74772_a("origBatch", this.originalBatchSize);
            tag.func_74778_a("uid", this.uuid);
            return tag;
        }

        static PendingCraft readFromNBT(NBTTagCompound tag) {
            try {
                DimensionalCoord coord = NBTUtils.readDimensionalCoord(tag.func_74775_l("reqCoord"));
                ItemStack stack = new ItemStack(tag.func_74775_l("pattern"));
                long batchSize = tag.func_74763_f("origBatch");
                String uid = tag.func_74779_i("uid");
                if (coord == null || stack.func_190926_b() || batchSize <= 0L) {
                    return null;
                }
                return new PendingCraft(coord, stack, batchSize, uid);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

