/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.items;

import appeng.api.AEApi;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.core.features.ActivityState;
import appeng.core.features.ItemStackSrc;
import appeng.items.AEBaseItem;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.registration.definitions.Parts;
import dev.beecube31.crazyae2.common.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrazyAEBaseItemPart
extends AEBaseItem
implements IPartItem {
    private static final int INITIAL_REGISTERED_CAPACITY = Parts.PartType.values().length;
    private static final Comparator<Map.Entry<Integer, PartTypeWithVariant>> REGISTERED_COMPARATOR = new RegisteredComparator();
    public static CrazyAEBaseItemPart instance;
    private final Map<Integer, PartTypeWithVariant> registered = new HashMap<Integer, PartTypeWithVariant>(INITIAL_REGISTERED_CAPACITY);

    public CrazyAEBaseItemPart() {
        this.func_77627_a(true);
        instance = this;
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack itemStack) {
        Parts.PartType type = this.getTypeByStack(itemStack);
        if (type == null) {
            return "item.crazyae.invalid";
        }
        return type.getUnlocalizedName().toLowerCase();
    }

    @Nullable
    public Parts.PartType getTypeByStack(@NotNull ItemStack is) {
        PartTypeWithVariant pt = this.registered.get(is.func_77952_i());
        if (pt != null) {
            return pt.part;
        }
        return null;
    }

    protected void getCheckedSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> itemStacks) {
        ArrayList<Map.Entry<Integer, PartTypeWithVariant>> types = new ArrayList<Map.Entry<Integer, PartTypeWithVariant>>(this.registered.entrySet());
        types.sort(REGISTERED_COMPARATOR);
        for (Map.Entry entry : types) {
            itemStacks.add((Object)new ItemStack((Item)this, 1, ((Integer)entry.getKey()).intValue()));
        }
    }

    @Nullable
    public IPart createPartFromItemStack(ItemStack is) {
        Parts.PartType type = this.getTypeByStack(is);
        if (type == null) {
            return null;
        }
        Class<? extends IPart> part = type.getPart();
        if (part == null) {
            return null;
        }
        try {
            if (type.getConstructor() == null) {
                type.setConstructor(part.getConstructor(ItemStack.class));
            }
            return type.getConstructor().newInstance(is);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public String func_77653_i(@NotNull ItemStack is) {
        Parts.PartType pt = this.getTypeByStack(is);
        if (pt != null && pt.getExtraName() != null) {
            return super.func_77653_i(is) + " - " + pt.getExtraName().getLocal();
        }
        return super.func_77653_i(is);
    }

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World w, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing side, float hitX, float hitY, float hitZ) {
        return AEApi.instance().partHelper().placeBus(player.func_184586_b(hand), pos, side, player, hand, w);
    }

    @Nonnull
    public final ItemStackSrc createPart(Parts.PartType mat) {
        Preconditions.checkNotNull((Object)mat);
        return this.createPart(mat, 0);
    }

    public ItemStackSrc createPart(Parts.PartType partType, int varID) {
        assert (partType != null);
        assert (varID >= 0);
        for (PartTypeWithVariant p : this.registered.values()) {
            if (p.part != partType || p.variant != varID) continue;
            throw new IllegalStateException("Cannot create the same material twice...");
        }
        boolean enabled = partType.isEnabled();
        int partDamage = partType.getBaseDamage() + varID;
        ActivityState state = ActivityState.from((boolean)enabled);
        ItemStackSrc output = new ItemStackSrc((Item)this, partDamage, state);
        PartTypeWithVariant pti = new PartTypeWithVariant(partType, varID);
        this.processMetaOverlap(enabled, partDamage, partType, pti);
        return output;
    }

    private void processMetaOverlap(boolean enabled, int partDamage, Parts.PartType mat, PartTypeWithVariant pti) {
        assert (partDamage >= 0);
        assert (mat != null);
        assert (pti != null);
        PartTypeWithVariant registeredPartType = this.registered.get(partDamage);
        if (registeredPartType != null) {
            throw new IllegalStateException("Meta Overlap detected with type " + mat + " and damage " + partDamage + ". Found " + registeredPartType + " there already.");
        }
        if (enabled) {
            this.registered.put(partDamage, pti);
        }
    }

    public int variantOf(int itemDamage) {
        PartTypeWithVariant registeredPartType = this.registered.get(itemDamage);
        if (registeredPartType != null) {
            return registeredPartType.variant;
        }
        return 0;
    }

    protected void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        super.addCheckedInformation(stack, world, lines, advancedTooltips);
        Utils.addReqChannelTooltip(lines);
        Parts.PartType pt = this.getTypeByStack(stack);
        if (pt != null) {
            pt.addCheckedInformation(stack, world, lines, advancedTooltips);
        }
    }

    static final class PartTypeWithVariant {
        private final Parts.PartType part;
        private final int variant;

        PartTypeWithVariant(Parts.PartType part, int variant) {
            assert (part != null);
            assert (variant >= 0);
            this.part = part;
            this.variant = variant;
        }

        public String toString() {
            return "PartTypeWithVariant{part=" + this.part + ", variant=" + this.variant + '}';
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.part != null ? this.part.hashCode() : 0);
            result = 31 * result + this.variant;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((PartTypeWithVariant)arg0).part, this.part)) {
                return false;
            }
            return ((PartTypeWithVariant)arg0).variant == this.variant;
            {
            }
        }

        public Parts.PartType part() {
            return this.part;
        }

        public int variant() {
            return this.variant;
        }
    }

    private static final class RegisteredComparator
    implements Comparator<Map.Entry<Integer, PartTypeWithVariant>> {
        private RegisteredComparator() {
        }

        @Override
        public int compare(Map.Entry<Integer, PartTypeWithVariant> o1, Map.Entry<Integer, PartTypeWithVariant> o2) {
            String string2;
            String string1 = o1.getValue().part.name();
            int comparedString = string1.compareTo(string2 = o2.getValue().part.name());
            if (comparedString == 0) {
                return Integer.compare(o1.getKey(), o2.getKey());
            }
            return comparedString;
        }
    }
}

