/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.items;

import appeng.core.features.IStackSrc;
import appeng.items.AEBaseItem;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.registration.definitions.Materials;
import dev.beecube31.crazyae2.core.CrazyAE;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.jetbrains.annotations.NotNull;

public class CrazyAEResource
extends AEBaseItem {
    public static CrazyAEResource instance;
    private final Int2ObjectOpenHashMap<Materials.MaterialType> dmgToMaterial = new Int2ObjectOpenHashMap();

    public CrazyAEResource() {
        this.func_77627_a(true);
        instance = this;
    }

    @NotNull
    public String func_77667_c(ItemStack itemStack) {
        Optional<Materials.MaterialType> material = CrazyAE.definitions().materials().getById(itemStack.func_77952_i());
        if (material.isPresent()) {
            return material.get().getTranslationKey();
        }
        return "item.crazyae.invalid";
    }

    protected void getCheckedSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> itemStacks) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (Materials.MaterialType material : Materials.MaterialType.getCachedValues().values()) {
            if (!material.isRegistered()) continue;
            itemStacks.add((Object)new ItemStack((Item)this, 1, material.ordinal()));
        }
    }

    public IStackSrc createMaterial(Materials.MaterialType materialType) {
        Preconditions.checkState((!materialType.isRegistered() ? 1 : 0) != 0, (Object)"Cannot create the same material twice.");
        boolean enabled = materialType.isEnabled();
        materialType.setStackSrc(new Materials.MaterialStackSrc(materialType, enabled));
        if (enabled) {
            materialType.setItemInstance((Item)this);
            materialType.markReady();
            int newMaterialNum = materialType.getDamageValue();
            if (this.dmgToMaterial.get(newMaterialNum) == null) {
                this.dmgToMaterial.put(newMaterialNum, (Object)materialType);
            } else {
                throw new IllegalStateException("Meta Overlap detected.");
            }
        }
        return materialType.getStackSrc();
    }

    @Nullable
    public Materials.MaterialType getTypeByStack(ItemStack is) {
        return (Materials.MaterialType)this.dmgToMaterial.get(is.func_77952_i());
    }
}

