/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.items;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.block.AEBaseItemBlock;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import dev.beecube31.crazyae2.client.gui.sprites.Sprite;
import dev.beecube31.crazyae2.common.interfaces.IDenseEnergyCell;
import dev.beecube31.crazyae2.common.util.Utils;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemEnergyCells
extends AEBaseItemBlock
implements IAEItemPowerStorage {
    private final double maxAEPower = this.setMaxAEPower();

    public ItemEnergyCells(Block id) {
        super(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        NBTTagCompound tag = stack.func_77978_p();
        double internalCurrentPower = 0.0;
        if (this.maxAEPower > 0.0) {
            if (tag != null) {
                internalCurrentPower = tag.func_74769_h("internalCurrentPower");
            }
            double percent = internalCurrentPower / this.maxAEPower;
            boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            lines.add(Utils.writeSpriteFlag(Sprite.ENERGY) + GuiText.StoredEnergy.getLocal() + ':' + MessageFormat.format(" {0,number,#} ", internalCurrentPower) + Platform.gui_localize((String)PowerUnits.AE.unlocalizedName) + " -" + MessageFormat.format(shift ? " {0,number,#.#####%}" : " {0,number,#.##%}", percent));
        }
    }

    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double internalMaxPower = this.getAEMaxPower(is);
        double required = internalMaxPower - internalCurrentPower;
        double overflow = Math.max(0.0, amount - required);
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(required, amount);
            double newPowerStored = internalCurrentPower + toAdd;
            this.setInternal(is, newPowerStored);
        }
        return overflow;
    }

    public double extractAEPower(ItemStack is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double fulfillable = Math.min(amount, internalCurrentPower);
        if (mode == Actionable.MODULATE) {
            double newPowerStored = internalCurrentPower - fulfillable;
            this.setInternal(is, newPowerStored);
        }
        return fulfillable;
    }

    public double getAEMaxPower(ItemStack is) {
        return this.maxAEPower;
    }

    public double setMaxAEPower() {
        return ((IDenseEnergyCell)Block.func_149634_a((Item)this)).getMaxPower();
    }

    public double getAECurrentPower(ItemStack is) {
        return this.getInternal(is);
    }

    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    private double getInternal(ItemStack is) {
        NBTTagCompound nbt = Platform.openNbtData((ItemStack)is);
        return nbt.func_74769_h("internalCurrentPower");
    }

    private void setInternal(ItemStack is, double amt) {
        NBTTagCompound nbt = Platform.openNbtData((ItemStack)is);
        nbt.func_74780_a("internalCurrentPower", amt);
    }
}

