/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.items.cells;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.MissingDefinitionException;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.items.AEBaseItem;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.registration.definitions.Materials;
import java.util.List;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCell<T extends IAEStack<T>>
extends AEBaseItem
implements IStorageCell<T>,
IItemGroup {
    protected final Materials.MaterialType component;
    protected final int capacity;
    protected final double idleDrain;
    protected final int bytesPerType;

    public BaseCell(Materials.MaterialType whichCell, int bytes) {
        this(whichCell, bytes, 1, 16.0);
    }

    public BaseCell(Materials.MaterialType whichCell, int bytes, int bytesPerType) {
        this(whichCell, bytes, bytesPerType, 16.0);
    }

    public BaseCell(Materials.MaterialType whichCell, int bytes, double idleDrain) {
        this(whichCell, bytes, 1, idleDrain);
    }

    public BaseCell(Materials.MaterialType whichCell, int bytes, int bytesPerType, double idleDrain) {
        this.func_77625_d(1);
        this.component = whichCell;
        this.capacity = bytes;
        this.idleDrain = idleDrain;
        this.bytesPerType = bytesPerType;
    }

    public abstract int getTotalTypes(@NotNull ItemStack var1);

    public abstract boolean isBlackListed(@NotNull ItemStack var1, @NotNull T var2);

    public abstract String getUnlocalizedGroupName(Set<ItemStack> var1, ItemStack var2);

    public abstract boolean isEditable(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        AEApi.instance().client().addCellInformation(AEApi.instance().registries().cell().getCellInventory(stack, null, this.getChannel()), lines);
    }

    public int getBytes(@NotNull ItemStack cellItem) {
        return this.capacity;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(@NotNull ItemStack i) {
        return true;
    }

    public abstract IItemHandler getUpgradesInventory(ItemStack var1);

    public abstract IItemHandler getConfigInventory(ItemStack var1);

    public FuzzyMode getFuzzyMode(ItemStack is) {
        try {
            return FuzzyMode.valueOf((String)Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode"));
        }
        catch (Throwable var4) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        this.disassembleDrive(player.func_184586_b(hand), player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    protected boolean disassembleDrive(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer playerInventory = player.field_71071_by;
            ICellInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(stack, null, this.getChannel());
            if (inv != null && playerInventory.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                IItemList list = inv.getAvailableItems(this.getChannel().createList());
                if (list.isEmpty()) {
                    playerInventory.func_70299_a(playerInventory.field_70461_c, ItemStack.field_190927_a);
                    ItemStack extraB = ia.addItems(this.component.stack(1));
                    if (!extraB.func_190926_b()) {
                        player.func_71019_a(extraB, false);
                    }
                    IItemHandler upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.getSlots(); ++upgradeIndex) {
                        ItemStack upgradeStack = upgradesInventory.getStackInSlot(upgradeIndex);
                        ItemStack leftStack = ia.addItems(upgradeStack);
                        if (leftStack.func_190926_b() || !(upgradeStack.func_77973_b() instanceof IUpgradeModule)) continue;
                        player.func_71019_a(upgradeStack, false);
                    }
                    this.dropEmptyStorageCellCase(ia, player);
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected void dropEmptyStorageCellCase(InventoryAdaptor ia, EntityPlayer player) {
        AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).ifPresent(is -> {
            ItemStack extraA = ia.addItems(is);
            if (!extraA.func_190926_b()) {
                player.func_71019_a(extraA, false);
            }
        });
    }

    @NotNull
    public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        return this.disassembleDrive(player.func_184586_b(hand), player) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    @NotNull
    public ItemStack getContainerItem(@NotNull ItemStack itemStack) {
        return (ItemStack)AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).orElseThrow(() -> new MissingDefinitionException("Tried to use empty storage cells while basic storage cells are defined."));
    }

    public boolean hasContainerItem(@NotNull ItemStack stack) {
        return AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_DISASSEMBLY_CRAFTING);
    }

    public int getBytesPerType(@NotNull ItemStack itemStack) {
        return this.bytesPerType;
    }

    public double getIdleDrain() {
        return this.idleDrain;
    }
}

