/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.items.cells.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEPartLocation;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.contents.PortableCellViewer;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.Platform;
import dev.beecube31.crazyae2.client.gui.sprites.Sprite;
import dev.beecube31.crazyae2.common.i18n.CrazyAETooltip;
import dev.beecube31.crazyae2.common.util.Utils;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class DensePortableCell
extends AEBasePoweredItem
implements IStorageCell<IAEItemStack>,
IGuiItem,
IItemGroup {
    protected final int capacity;
    protected final double idleDrain;
    protected final int bytesPerType;
    private static final int durabilityColor = new Color(28671).getRGB();

    public DensePortableCell(double batteryCapacity, int bytes, int bytesPerType, double idleDrain) {
        super(batteryCapacity);
        this.capacity = bytes;
        this.bytesPerType = bytesPerType;
        this.idleDrain = idleDrain;
    }

    public int getRGBDurabilityForDisplay(@NotNull ItemStack stack) {
        return durabilityColor;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World w, EntityPlayer player, @NotNull EnumHand hand) {
        ItemStack item;
        NBTTagCompound itemNBT;
        if (player.func_70093_af() && (itemNBT = (item = player.func_184586_b(hand)).func_77978_p()) != null) {
            boolean isEnabled = itemNBT.func_74767_n("autoPickup");
            itemNBT.func_74757_a("autoPickup", !isEnabled);
            player.func_146105_b((ITextComponent)new TextComponentString(CrazyAETooltip.AUTO_PICKUP.getLocalWithSpaceAtEnd() + this.getAutoPickupState(!isEnabled)), true);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        Platform.openGUI((EntityPlayer)player, null, (AEPartLocation)AEPartLocation.INTERNAL, (GuiBridge)GuiBridge.GUI_PORTABLE_CELL);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        super.addCheckedInformation(stack, world, lines, advancedTooltips);
        ICellInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(stack, null, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        NBTTagCompound nbt = stack.func_77978_p();
        boolean isAutoPickupEnabled = nbt != null && nbt.func_74767_n("autoPickup");
        Sprite spritePickup = isAutoPickupEnabled ? Sprite.YES : Sprite.NO;
        lines.add(Utils.writeSpriteFlag(spritePickup) + CrazyAETooltip.AUTO_PICKUP.getLocalWithSpaceAtEnd() + this.getAutoPickupState(isAutoPickupEnabled));
        lines.add(Utils.writeSpriteFlag(Sprite.INFO) + CrazyAETooltip.AUTO_PICKUP_HOW_TO_ENABLE.getLocal());
        lines.add(Utils.writeSpriteFlag(Sprite.INFO) + CrazyAETooltip.AUTO_PICKUP_TIP.getLocal());
        AEApi.instance().client().addCellInformation(cdi, lines);
    }

    public int getBytes(@NotNull ItemStack cellItem) {
        return this.capacity;
    }

    public int getBytesPerType(@NotNull ItemStack cellItem) {
        return this.bytesPerType;
    }

    public int getTotalTypes(@NotNull ItemStack cellItem) {
        return 63;
    }

    public boolean isBlackListed(@NotNull ItemStack cellItem, @NotNull IAEItemStack requestedAddition) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(@NotNull ItemStack i) {
        return true;
    }

    public double getIdleDrain() {
        return this.idleDrain;
    }

    @NotNull
    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    public IGuiItemObject getGuiObject(ItemStack is, World w, BlockPos pos) {
        return new PortableCellViewer(is, pos.func_177958_n());
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    private String getAutoPickupState(boolean isEnabled) {
        return isEnabled ? CrazyAETooltip.ENABLED_LOWERCASE.getLocal() : CrazyAETooltip.DISABLED_LOWERCASE.getLocal();
    }
}

