/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.items.patterns;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.helpers.InvalidPatternHelper;
import appeng.util.Platform;
import appeng.util.item.ItemStackHashStrategy;
import dev.beecube31.crazyae2.common.items.patterns.ItemCustomEncodedPatternBase;
import dev.beecube31.crazyae2.common.util.patterns.crafting.BreweryCraftingPatternDetails;
import dev.beecube31.crazyae2.core.CrazyAE;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BreweryEncodedPattern
extends ItemCustomEncodedPatternBase
implements ICraftingPatternItem {
    private static final ItemStackHashStrategy hashStrategy = ItemStackHashStrategy.comparingAllButCount();
    protected static final Map<ItemStack, ItemStack> SIMPLE_CACHE = new Object2ObjectOpenCustomHashMap((Hash.Strategy)hashStrategy);

    public ICraftingPatternDetails getPatternForItem(ItemStack is, World w) {
        try {
            return new BreweryCraftingPatternDetails(is);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public ItemStack getOutput(ItemStack item) {
        ItemStack out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        World w = AppEng.proxy.getWorld();
        if (w == null) {
            return ItemStack.field_190927_a;
        }
        ICraftingPatternDetails details = this.getPatternForItem(item, w);
        out = details != null ? details.getOutputs()[0].createItemStack() : ItemStack.field_190927_a;
        SIMPLE_CACHE.put(item, out);
        return out;
    }

    @Override
    protected boolean clearPattern(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            SIMPLE_CACHE.remove(stack);
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer inv = player.field_71071_by;
            ItemStack is = CrazyAE.definitions().materials().breweryBlankPattern().maybeStack(stack.func_190916_E()).orElse(ItemStack.field_190927_a);
            if (!is.func_190926_b()) {
                for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                    if (inv.func_70301_a(s) != stack) continue;
                    inv.func_70299_a(s, is);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        ICraftingPatternDetails details = this.getPatternForItem(stack, world);
        if (details == null) {
            if (!stack.func_77942_o()) {
                return;
            }
            stack.func_151001_c(TextFormatting.RED + GuiText.InvalidPattern.getLocal());
            InvalidPatternHelper invalid = new InvalidPatternHelper(stack);
            String label = (invalid.isCraftable() ? GuiText.Crafts.getLocal() : GuiText.Creates.getLocal()) + ": ";
            String and = ' ' + GuiText.And.getLocal() + ' ';
            String with = GuiText.With.getLocal() + ": ";
            boolean first = true;
            for (InvalidPatternHelper.PatternIngredient output : invalid.getOutputs()) {
                lines.add((first ? label : and) + output.getFormattedToolTip());
                first = false;
            }
            first = true;
            for (InvalidPatternHelper.PatternIngredient input : invalid.getInputs()) {
                lines.add((first ? with : and) + input.getFormattedToolTip());
                first = false;
            }
            if (invalid.isCraftable()) {
                String substitutionLabel = GuiText.Substitute.getLocal() + " ";
                String canSubstitute = invalid.canSubstitute() ? GuiText.Yes.getLocal() : GuiText.No.getLocal();
                lines.add(substitutionLabel + canSubstitute);
            }
            return;
        }
        if (stack.func_82837_s()) {
            stack.func_190919_e("display");
        }
        IAEItemStack[] in = details.getCondensedInputs();
        IAEItemStack[] out = details.getCondensedOutputs();
        String label = GuiText.Crafts.getLocal() + ": ";
        String and = ' ' + GuiText.And.getLocal() + ' ';
        String with = GuiText.With.getLocal() + ": ";
        boolean first = true;
        for (IAEItemStack anOut : out) {
            if (anOut == null) continue;
            lines.add((first ? label : and) + anOut.getStackSize() + ' ' + Platform.getItemDisplayName((Object)anOut));
            first = false;
        }
        first = true;
        for (IAEItemStack anIn : in) {
            if (anIn == null) continue;
            lines.add((first ? with : and) + anIn.getStackSize() + ' ' + Platform.getItemDisplayName((Object)anIn));
            first = false;
        }
    }
}

