/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.networking;

import appeng.core.sync.network.INetworkInfo;
import dev.beecube31.crazyae2.common.networking.CrazyAEPacketCallState;
import dev.beecube31.crazyae2.common.networking.CrazyAEPacketHandler;
import dev.beecube31.crazyae2.common.networking.network.NetworkHandler;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public abstract class CrazyAEPacket
implements Packet {
    private PacketBuffer p;
    private CrazyAEPacketCallState caller;

    public void serverPacketData(INetworkInfo manager, CrazyAEPacket packet, EntityPlayer player) {
        throw new UnsupportedOperationException("Packet ( " + this.getPacketID() + " does not implement a server side handler.");
    }

    public final int getPacketID() {
        return CrazyAEPacketHandler.PacketTypes.getID(this.getClass()).ordinal();
    }

    public void clientPacketData(INetworkInfo network, CrazyAEPacket packet, EntityPlayer player) {
        throw new UnsupportedOperationException("Packet ( " + this.getPacketID() + " does not implement a client side handler.");
    }

    protected void configureWrite(ByteBuf data) {
        data.capacity(data.readableBytes());
        this.p = new PacketBuffer(data);
    }

    public FMLProxyPacket getProxy() {
        if (this.p.array().length > 0x200000) {
            throw new IllegalArgumentException();
        }
        return new FMLProxyPacket(this.p, NetworkHandler.instance().getChannel());
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        throw new RuntimeException("Not Implemented");
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        throw new RuntimeException("Not Implemented");
    }

    public ByteArrayInputStream getPacketByteArray(ByteBuf stream, int readerIndex, int readableBytes) {
        ByteArrayInputStream bytes;
        if (stream.hasArray()) {
            bytes = new ByteArrayInputStream(stream.array(), readerIndex, readableBytes);
        } else {
            byte[] data = new byte[stream.capacity()];
            stream.getBytes(readerIndex, data, 0, readableBytes);
            bytes = new ByteArrayInputStream(data);
        }
        return bytes;
    }

    public ByteArrayInputStream getPacketByteArray(ByteBuf stream) {
        return this.getPacketByteArray(stream, 0, stream.readableBytes());
    }

    public void setCallParam(CrazyAEPacketCallState call) {
        this.caller = call;
    }

    public void func_148833_a(INetHandler handler) {
        this.caller.call(this);
    }
}

