/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.networking;

import dev.beecube31.crazyae2.common.networking.CrazyAEPacket;
import dev.beecube31.crazyae2.common.networking.packets.PacketLongCraftRequest;
import dev.beecube31.crazyae2.common.networking.packets.PacketSwitchGuis;
import dev.beecube31.crazyae2.common.networking.packets.PacketToggleGuiObject;
import dev.beecube31.crazyae2.common.networking.packets.PacketUptadeTextField;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketConfigButton;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketInventoryAction;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketProgressBar;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketSwapSlots;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketTargetItemStack;
import dev.beecube31.crazyae2.common.networking.packets.orig.PacketValueConfig;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class CrazyAEPacketHandler {
    private static final Map<Class<? extends CrazyAEPacket>, PacketTypes> REVERSE_LOOKUP = new HashMap<Class<? extends CrazyAEPacket>, PacketTypes>();

    public static enum PacketTypes {
        PACKET_CHANGE_PRIORITY(PacketUptadeTextField.class),
        PACKET_SWITCH_GUIS(PacketSwitchGuis.class),
        PACKET_TOGGLE_GUI_OBJECT(PacketToggleGuiObject.class),
        PACKET_LONG_CRAFT_REQUEST(PacketLongCraftRequest.class),
        PACKET_CONFIG_BUTTON(PacketConfigButton.class),
        PACKET_INVENTORY_ACTION(PacketInventoryAction.class),
        PACKET_VALUE_CONFIG(PacketValueConfig.class),
        PACKET_TARGET_IS(PacketTargetItemStack.class),
        PACKET_SWAP_SLOTS(PacketSwapSlots.class),
        PACKET_PROGRESS_BAR(PacketProgressBar.class);

        private final Class<? extends CrazyAEPacket> packetClass;
        private final Constructor<? extends CrazyAEPacket> packetConstructor;

        private PacketTypes(Class<? extends CrazyAEPacket> c) {
            this.packetClass = c;
            Constructor<? extends CrazyAEPacket> x = null;
            try {
                x = this.packetClass.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            this.packetConstructor = x;
            REVERSE_LOOKUP.put(this.packetClass, this);
            if (this.packetConstructor == null) {
                throw new IllegalStateException("Invalid Packet Class " + c + ", must be constructable on DataInputStream");
            }
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        static PacketTypes getID(Class<? extends CrazyAEPacket> c) {
            return (PacketTypes)((Object)REVERSE_LOOKUP.get(c));
        }

        public CrazyAEPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.packetConstructor.newInstance(in);
        }
    }
}

