/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.networking;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.ItemStackHelper;
import appeng.items.storage.ItemViewCell;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperInvItemHandler;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import dev.beecube31.crazyae2.common.containers.ContainerMechanicalBotaniaTileBase;
import dev.beecube31.crazyae2.common.networking.CrazyAEPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;

public class PacketJeiRecipeTransfer
extends CrazyAEPacket {
    private List<ItemStack[]> recipe;
    private List<ItemStack> output;
    static ItemStack[] emptyArray = new ItemStack[]{ItemStack.field_190927_a};

    public PacketJeiRecipeTransfer(ByteBuf stream) throws IOException {
        ByteArrayInputStream bytes = this.getPacketByteArray(stream);
        bytes.skip(stream.readerIndex());
        NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)bytes);
        this.recipe = new ArrayList<ItemStack[]>();
        for (int x = 0; x < comp.func_150296_c().size(); ++x) {
            if (!comp.func_74764_b("#" + x)) continue;
            NBTTagList list = comp.func_150295_c("#" + x, 10);
            if (list.func_74745_c() > 0) {
                this.recipe.add(new ItemStack[list.func_74745_c()]);
                for (int y = 0; y < list.func_74745_c(); ++y) {
                    this.recipe.get((int)x)[y] = ItemStackHelper.stackFromNBT((NBTTagCompound)list.func_150305_b(y));
                }
                continue;
            }
            this.recipe.add(emptyArray);
        }
        if (comp.func_74764_b("outputs")) {
            NBTTagList outputList = comp.func_150295_c("outputs", 10);
            this.output = new ArrayList<ItemStack>();
            for (int z = 0; z < outputList.func_74745_c(); ++z) {
                this.output.add(ItemStackHelper.stackFromNBT((NBTTagCompound)outputList.func_150305_b(z)));
            }
        }
    }

    public PacketJeiRecipeTransfer(NBTTagCompound recipe) throws IOException {
        ByteBuf data = Unpooled.buffer();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bytes);
        data.writeInt(this.getPacketID());
        CompressedStreamTools.func_74799_a((NBTTagCompound)recipe, (OutputStream)outputStream);
        data.writeBytes(bytes.toByteArray());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, CrazyAEPacket packet, EntityPlayer player) {
        EntityPlayerMP pmp = (EntityPlayerMP)player;
        Container con = pmp.field_71070_bA;
        if (!(con instanceof IContainerCraftingPacket)) {
            return;
        }
        IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
        IGridNode node = cct.getNetworkNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
        IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IItemHandler craftMatrix = cct.getInventoryByName("input");
        IItemHandler playerInventory = cct.getInventoryByName("player");
        if (this.recipe != null) {
            IMEMonitor storage = inv.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IPartitionList filter = ItemViewCell.createFilter((ItemStack[])cct.getViewCells());
            for (int x = 0; x < craftMatrix.getSlots(); ++x) {
                Object out;
                ItemStack currentItem = craftMatrix.getStackInSlot(x);
                if (x >= this.recipe.size()) {
                    currentItem = ItemStack.field_190927_a;
                }
                if (!currentItem.func_190926_b()) {
                    ItemStack newItem = this.canUseInSlot(x, currentItem);
                    if (!cct.useRealItems() && this.recipe.get(x) != null && this.recipe.get(x).length > 0) {
                        currentItem.func_190920_e(this.recipe.get(x)[0].func_190916_E());
                    }
                    if (newItem != currentItem && security.hasPermission(player, SecurityPermissions.INJECT)) {
                        AEItemStack in = AEItemStack.fromItemStack((ItemStack)currentItem);
                        out = cct.useRealItems() ? (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)storage, (IAEStack)in, (IActionSource)cct.getActionSource()) : null;
                        currentItem = out != null ? out.createItemStack() : ItemStack.field_190927_a;
                    }
                }
                if (currentItem.func_190926_b() && this.recipe.size() > x && this.recipe.get(x) != null) {
                    for (int y = 0; y < this.recipe.get(x).length && currentItem.func_190926_b(); ++y) {
                        AEItemStack request = AEItemStack.fromItemStack((ItemStack)this.recipe.get(x)[y]);
                        if (request == null) continue;
                        if ((filter == null || filter.isListed((IAEStack)request)) && security.hasPermission(player, SecurityPermissions.EXTRACT)) {
                            request.setStackSize(1L);
                            if (cct.useRealItems()) {
                                out = (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)storage, (IAEStack)request, (IActionSource)cct.getActionSource());
                                if (out == null && (request.getItem().func_77645_m() || Platform.isGTDamageableItem((Item)request.getItem()))) {
                                    IAEItemStack is;
                                    Collection outList = inv.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).getStorageList().findFuzzy((IAEStack)request, FuzzyMode.IGNORE_ALL);
                                    Iterator iterator = outList.iterator();
                                    while (iterator.hasNext() && ((is = (IAEItemStack)iterator.next()).getStackSize() == 0L || Platform.isGTDamageableItem((Item)request.getItem()) && is.getDefinition().func_77960_j() != request.getDefinition().func_77960_j() || (out = (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)storage, (IAEStack)((IAEItemStack)is.copy().setStackSize(1L)), (IActionSource)cct.getActionSource())) == null)) {
                                    }
                                }
                            } else {
                                out = !crafting.getCraftingFor((IAEItemStack)request, null, 0, null).isEmpty() ? request : (IAEItemStack)storage.extractItems((IAEStack)request, Actionable.SIMULATE, cct.getActionSource());
                            }
                            if (out != null) {
                                if (!cct.useRealItems()) {
                                    out.setStackSize((long)this.recipe.get(x)[y].func_190916_E());
                                }
                                currentItem = out.createItemStack();
                            }
                        }
                        if (!currentItem.func_190926_b()) continue;
                        AdaptorItemHandler ad = new AdaptorItemHandler(playerInventory);
                        currentItem = cct.useRealItems() ? ad.removeSimilarItems(1, this.recipe.get(x)[y], FuzzyMode.IGNORE_ALL, null) : ad.simulateSimilarRemove(this.recipe.get(x)[y].func_190916_E(), this.recipe.get(x)[y], FuzzyMode.IGNORE_ALL, null);
                    }
                    if (!cct.useRealItems() && currentItem.func_190926_b() && this.recipe.size() > x && this.recipe.get(x) != null) {
                        currentItem = this.recipe.get(x)[0].func_77946_l();
                    }
                }
                ItemHandlerUtil.setStackInSlot((IItemHandler)craftMatrix, (int)x, (ItemStack)currentItem);
            }
            con.func_75130_a((IInventory)new WrapperInvItemHandler(craftMatrix));
            if (this.output != null && con instanceof ContainerMechanicalBotaniaTileBase) {
                int i;
                IItemHandler outputSlots = cct.getInventoryByName("output");
                for (i = 0; i < outputSlots.getSlots(); ++i) {
                    ItemHandlerUtil.setStackInSlot((IItemHandler)outputSlots, (int)i, (ItemStack)ItemStack.field_190927_a);
                }
                for (i = 0; i < this.output.size() && i < outputSlots.getSlots(); ++i) {
                    if (this.output.get(i) == null || this.output.get(i) == ItemStack.field_190927_a) continue;
                    ItemHandlerUtil.setStackInSlot((IItemHandler)outputSlots, (int)i, (ItemStack)this.output.get(i));
                }
            }
        }
    }

    private ItemStack canUseInSlot(int slot, ItemStack is) {
        if (this.recipe.get(slot) != null) {
            for (ItemStack option : this.recipe.get(slot)) {
                if (!ItemStack.func_77989_b((ItemStack)is, (ItemStack)option)) continue;
                return is;
            }
        }
        return ItemStack.field_190927_a;
    }
}

