/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.networking.network;

import dev.beecube31.crazyae2.common.networking.CrazyAEPacket;
import dev.beecube31.crazyae2.common.networking.network.CrazyAEClientPacketHandler;
import dev.beecube31.crazyae2.common.networking.network.CrazyAEServerPacketHandler;
import dev.beecube31.crazyae2.common.networking.network.IPacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class NetworkHandler {
    public static NetworkHandler instance;
    private final FMLEventChannel ec;
    private final String myChannelName;
    private final IPacketHandler clientHandler;
    private final IPacketHandler serveHandler;

    public NetworkHandler(String channelName) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.myChannelName = channelName;
        this.ec = NetworkRegistry.INSTANCE.newEventDrivenChannel(this.myChannelName);
        this.ec.register((Object)this);
        this.clientHandler = this.createClientSide();
        this.serveHandler = this.createServerSide();
    }

    public static void init(String channelName) {
        instance = new NetworkHandler(channelName);
    }

    public static NetworkHandler instance() {
        return instance;
    }

    private IPacketHandler createClientSide() {
        try {
            return new CrazyAEClientPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private IPacketHandler createServerSide() {
        try {
            return new CrazyAEServerPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.getPacket().handler();
        if (this.serveHandler != null) {
            try {
                this.serveHandler.onPacketData(null, ev.getHandler(), ev.getPacket(), (EntityPlayer)srv.field_147369_b);
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        if (this.clientHandler != null) {
            try {
                this.clientHandler.onPacketData(null, ev.getHandler(), ev.getPacket(), null);
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
        }
    }

    public String getChannel() {
        return this.myChannelName;
    }

    public void sendToAll(CrazyAEPacket message) {
        this.ec.sendToAll(message.getProxy());
    }

    public void sendTo(CrazyAEPacket message, EntityPlayerMP player) {
        this.ec.sendTo(message.getProxy(), player);
    }

    public void sendToAllAround(CrazyAEPacket message, NetworkRegistry.TargetPoint point) {
        this.ec.sendToAllAround(message.getProxy(), point);
    }

    public void sendToDimension(CrazyAEPacket message, int dimensionId) {
        this.ec.sendToDimension(message.getProxy(), dimensionId);
    }

    public void sendToServer(CrazyAEPacket message) {
        this.ec.sendToServer(message.getProxy());
    }
}

