/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.networking.packets;

import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import dev.beecube31.crazyae2.common.containers.base.ContainerOpenContext;
import dev.beecube31.crazyae2.common.containers.base.CrazyAEBaseContainer;
import dev.beecube31.crazyae2.common.networking.CrazyAEPacket;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public class PacketSwitchGuis
extends CrazyAEPacket {
    private final Object newGui;

    public PacketSwitchGuis(ByteBuf stream) {
        this.newGui = CrazyAEGuiBridge.values()[stream.readInt()];
    }

    public PacketSwitchGuis(Object newGui) {
        this.newGui = newGui;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        if (newGui instanceof GuiBridge) {
            GuiBridge aeGui = (GuiBridge)newGui;
            data.writeInt(aeGui.ordinal());
        } else if (newGui instanceof CrazyAEGuiBridge) {
            CrazyAEGuiBridge crazyAeGui = (CrazyAEGuiBridge)((Object)newGui);
            data.writeInt(crazyAeGui.ordinal());
        } else {
            throw new IllegalArgumentException("Gui must be located in GuiBridge or CrazyAEGuiBridge : " + newGui);
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, CrazyAEPacket packet, EntityPlayer player) {
        CrazyAEBaseContainer bc;
        ContainerOpenContext context;
        Container c = player.field_71070_bA;
        if (c instanceof CrazyAEBaseContainer && (context = (bc = (CrazyAEBaseContainer)c).getOpenContext()) != null) {
            TileEntity te = context.getTile();
            CrazyAEGuiHandler.openGUI(player, te, bc.getOpenContext().getSide(), this.newGui);
        }
    }
}

