/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.networking.packets;

import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.security.IActionHost;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.sync.network.INetworkInfo;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartEncoder;
import dev.beecube31.crazyae2.common.containers.ContainerMechanicalBotaniaTileBase;
import dev.beecube31.crazyae2.common.containers.ContainerQuantumCPU;
import dev.beecube31.crazyae2.common.networking.CrazyAEPacket;
import dev.beecube31.crazyae2.common.tile.crafting.TileImprovedMAC;
import dev.beecube31.crazyae2.common.tile.crafting.TileQuantumCPU;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.mixins.features.patternterm.fastplace.AccessorContainerPatternEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PacketToggleGuiObject
extends CrazyAEPacket {
    private final String Name;
    private final String Value;

    public PacketToggleGuiObject(ByteBuf stream) throws IOException {
        DataInputStream dis = new DataInputStream(this.getPacketByteArray(stream, stream.readerIndex(), stream.readableBytes()));
        this.Name = dis.readUTF();
        this.Value = dis.readUTF();
    }

    public PacketToggleGuiObject(String name) throws IOException {
        this.Name = name;
        this.Value = "";
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeUTF(name);
        dos.writeUTF("");
        data.writeBytes(bos.toByteArray());
        this.configureWrite(data);
    }

    public PacketToggleGuiObject(String name, String value) throws IOException {
        this.Name = name;
        this.Value = value;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeUTF(name);
        dos.writeUTF(value);
        data.writeBytes(bos.toByteArray());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, CrazyAEPacket packet, EntityPlayer player) {
        Container c = player.field_71070_bA;
        if (this.Name.startsWith("CRAZYAE.GUI")) {
            block10 : switch (this.Name) {
                case "CRAZYAE.GUI.QCPU.page.change": {
                    if (!(c instanceof ContainerQuantumCPU)) break;
                    ContainerQuantumCPU e = (ContainerQuantumCPU)c;
                    e.setCurrentPage(Integer.parseInt(this.Value));
                    break;
                }
                case "CRAZYAE.GUI.encodeBtn.pressed": {
                    ContainerMechanicalBotaniaTileBase e;
                    if (!(c instanceof ContainerMechanicalBotaniaTileBase) || !(e = (ContainerMechanicalBotaniaTileBase)c).validateRecipe()) break;
                    e.encodePattern();
                    break;
                }
                case "CRAZYAE.GUI.patternTerm.clearnbt": {
                    if (!(c instanceof ContainerPatternTerm)) break;
                    ContainerPatternTerm t = (ContainerPatternTerm)c;
                    NBTTagCompound encodedValue = new NBTTagCompound();
                    NBTTagList tagIn = new NBTTagList();
                    NBTTagList tagOut = new NBTTagList();
                    for (int i = 0; i < ((AccessorContainerPatternEncoder)t).getCrafting().getSlots(); ++i) {
                        tagIn.func_74742_a((NBTBase)Utils.createItemTag(((AccessorContainerPatternEncoder)t).getCrafting().getStackInSlot(i), true));
                    }
                    tagOut.func_74742_a((NBTBase)Utils.createItemTag(((AccessorContainerPatternEncoder)t).getCOut().getStackInSlot(0), true));
                    encodedValue.func_74782_a("in", (NBTBase)tagIn);
                    encodedValue.func_74782_a("out", (NBTBase)tagOut);
                    encodedValue.func_74757_a("crafting", true);
                    encodedValue.func_74757_a("substitute", t.substitute);
                    ((AccessorContainerPatternEncoder)t).getPatternSlotOUT().func_75211_c().func_77982_d(encodedValue);
                    break;
                }
                case "CRAZYAE.GUI.encoder.syncRecipe": {
                    if (!(c instanceof ContainerMechanicalBotaniaTileBase)) break;
                    ContainerMechanicalBotaniaTileBase e = (ContainerMechanicalBotaniaTileBase)c;
                    e.syncClientOnFirstLoad();
                    break;
                }
                case "CRAZYAE.GUI.patternTerm.fastPlace": {
                    if (!(c instanceof ContainerPatternTerm)) break;
                    ContainerPatternTerm t = (ContainerPatternTerm)c;
                    SlotRestrictedInput patternSlotOUT = ((AccessorContainerPatternEncoder)t).getPatternSlotOUT();
                    ItemStack patternStack = patternSlotOUT.func_75211_c();
                    if (patternStack.func_190926_b()) {
                        return;
                    }
                    try {
                        IMachineSet availableTiles;
                        AbstractPartEncoder part = t.getPart();
                        IGuiItemObject itemObject = ((AccessorContainerPatternEncoder)t).getIGuiItemObject();
                        if (part != null) {
                            availableTiles = part.getProxy().getGrid().getMachines(TileImprovedMAC.class);
                        } else if (itemObject instanceof IActionHost) {
                            IActionHost wirelessTerm = (IActionHost)itemObject;
                            availableTiles = wirelessTerm.getActionableNode().getGrid().getMachines(TileImprovedMAC.class);
                        } else {
                            return;
                        }
                        for (IGridNode channelNode : availableTiles) {
                            TileImprovedMAC te = (TileImprovedMAC)channelNode.getMachine();
                            if (!te.acceptPatternFromTerm(patternStack)) continue;
                            patternStack.func_190918_g(1);
                        }
                    }
                    catch (GridAccessException e) {
                        CrazyAE.logger().error((Object)e);
                    }
                    break;
                }
                case "CRAZYAE.GUI.patternTerm.fastPlaceQCpu": {
                    if (!(c instanceof ContainerPatternTerm)) break;
                    ContainerPatternTerm t = (ContainerPatternTerm)c;
                    SlotRestrictedInput patternSlotOUT = ((AccessorContainerPatternEncoder)t).getPatternSlotOUT();
                    ItemStack patternStack = patternSlotOUT.func_75211_c();
                    if (patternStack.func_190926_b()) {
                        return;
                    }
                    try {
                        IMachineSet availableTiles;
                        AbstractPartEncoder part = t.getPart();
                        IGuiItemObject itemObject = ((AccessorContainerPatternEncoder)t).getIGuiItemObject();
                        if (part != null) {
                            availableTiles = part.getProxy().getGrid().getMachines(TileQuantumCPU.class);
                        } else if (itemObject instanceof IActionHost) {
                            IActionHost wirelessTerm = (IActionHost)itemObject;
                            availableTiles = wirelessTerm.getActionableNode().getGrid().getMachines(TileQuantumCPU.class);
                        } else {
                            return;
                        }
                        for (IGridNode channelNode : availableTiles) {
                            TileQuantumCPU te = (TileQuantumCPU)channelNode.getMachine();
                            if (!te.acceptPatternFromTerm(patternStack)) continue;
                            patternStack.func_190918_g(1);
                            break block10;
                        }
                        break;
                    }
                    catch (GridAccessException e) {
                        CrazyAE.logger().error((Object)e);
                    }
                }
            }
        }
    }
}

