/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.networking.packets.orig;

import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.containers.base.CrazyAEBaseContainer;
import dev.beecube31.crazyae2.common.networking.CrazyAEPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;

public final class PacketConfigButton
extends CrazyAEPacket {
    private final Settings option;
    private final boolean rotationDirection;

    public PacketConfigButton(ByteBuf stream) {
        this.option = Settings.values()[stream.readInt()];
        this.rotationDirection = stream.readBoolean();
    }

    public PacketConfigButton(Settings option, boolean rotationDirection) {
        this.option = option;
        this.rotationDirection = rotationDirection;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(option.ordinal());
        data.writeBoolean(rotationDirection);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, CrazyAEPacket packet, EntityPlayer player) {
        CrazyAEBaseContainer baseContainer;
        EntityPlayerMP sender = (EntityPlayerMP)player;
        Container container = sender.field_71070_bA;
        if (container instanceof CrazyAEBaseContainer && (baseContainer = (CrazyAEBaseContainer)container).getTarget() instanceof IConfigurableObject) {
            IConfigManager cm = ((IConfigurableObject)baseContainer.getTarget()).getConfigManager();
            Enum newState = Platform.rotateEnum((Enum)cm.getSetting(this.option), (boolean)this.rotationDirection, (EnumSet)this.option.getPossibleValues());
            cm.putSetting(this.option, newState);
        }
    }
}

