/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import dev.beecube31.crazyae2.common.interfaces.upgrades.IUpgradesInfoProvider;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.ItemStack;

public abstract class CrazyAEBasePartState
extends AEBasePart
implements IPowerChannelState,
IUpgradesInfoProvider {
    protected static final int POWERED_FLAG = 1;
    private int clientFlags = 0;

    public CrazyAEBasePartState(ItemStack is) {
        super(is);
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.getHost().markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    @MENetworkEventSubscribe
    public void bootingRender(MENetworkBootingStatusChange bs) {
        this.getHost().markForUpdate();
    }

    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.setClientFlags(0);
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.setClientFlags(this.getClientFlags() | 1);
            }
            this.setClientFlags(this.populateFlags(this.getClientFlags()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.getClientFlags()));
    }

    protected int populateFlags(int cf) {
        return cf;
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean eh = super.readFromStream(data);
        int old = this.getClientFlags();
        this.setClientFlags(data.readByte());
        return eh || old != this.getClientFlags();
    }

    public boolean isPowered() {
        return (this.getClientFlags() & 1) == 1;
    }

    public boolean isActive() {
        return this.isPowered();
    }

    public int getClientFlags() {
        return this.clientFlags;
    }

    private void setClientFlags(int clientFlags) {
        this.clientFlags = clientFlags;
    }
}

