/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;

public abstract class CrazyAEAbstractPartTerminal
extends AbstractPartDisplay
implements ITerminalHost,
IConfigManagerHost,
IViewCellStorage,
IAEAppEngInventory {
    private final IConfigManager cm = new ConfigManager((IConfigManagerHost)this);
    private final AppEngInternalInventory viewCell = new AppEngInternalInventory((IAEAppEngInventory)this, 5);

    public CrazyAEAbstractPartTerminal(ItemStack is) {
        super(is);
        this.cm.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.viewCell) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.cm.readFromNBT(data);
        this.viewCell.readFromNBT(data, "viewCell");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.cm.writeToNBT(data);
        this.viewCell.writeToNBT(data, "viewCell");
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!super.onPartActivate(player, hand, pos) && Platform.isServer()) {
            CrazyAEGuiHandler.openGUI(player, this.getHost().getTile(), this.getSide(), (Object)this.getGui(player));
        }
        return true;
    }

    public CrazyAEGuiBridge getGui(EntityPlayer player) {
        return CrazyAEGuiBridge.STUB;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        try {
            return this.getProxy().getStorage().getInventory(channel);
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public IItemHandler getViewCellStorage() {
        return this.viewCell;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.getHost().markForSave();
    }
}

