/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.GridFlags;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.GridAccessException;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IAEAppEngInventory;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEPartUpgradeable;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import dev.beecube31.crazyae2.core.api.storage.energy.IEnergyStorageChannel;
import dev.beecube31.crazyae2.core.config.CrazyAEConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public abstract class CrazyAEPartSharedBus
extends CrazyAEPartUpgradeable
implements IGridTickable {
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory((IAEAppEngInventory)this, 9);
    private boolean lastRedstone = false;

    public CrazyAEPartSharedBus(ItemStack is) {
        super(is);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    @Override
    public void upgradesChanged() {
        this.updateState();
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.getConfig().readFromNBT(extra, "config");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.getConfig().writeToNBT(extra, "config");
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.getConfig();
        }
        return super.getInventoryByName(name);
    }

    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        this.updateState();
        if (this.lastRedstone != this.getHost().hasRedstone(this.getSide())) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doBusWork();
            }
        }
    }

    protected InventoryAdaptor getHandler() {
        TileEntity self = this.getHost().getTile();
        TileEntity target = this.getTileEntity(self, self.func_174877_v().func_177972_a(this.getSide().getFacing()));
        return InventoryAdaptor.getAdaptor((TileEntity)target, (EnumFacing)this.getSide().getFacing().func_176734_d());
    }

    protected TileEntity getVictim() {
        TileEntity self = this.getHost().getTile();
        return this.getTileEntity(self, self.func_174877_v().func_177972_a(this.getSide().getFacing()));
    }

    protected IMEMonitor<IAEItemStack> getEnergyInv() {
        try {
            return this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class));
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    protected IMEMonitor<IAEItemStack> getItemsInv() {
        try {
            return this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    private TileEntity getTileEntity(TileEntity self, BlockPos pos) {
        World w = self.func_145831_w();
        if (w.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) != null) {
            return w.func_175625_s(pos);
        }
        return null;
    }

    protected int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 4, this.getConfig().getSlots());
    }

    protected int calculateItemsToSend() {
        int items = 256;
        switch (this.getInstalledUpgrades(Upgrades.UpgradeType.STACKS)) {
            case 1: {
                items += 768;
                break;
            }
            case 2: {
                items += 1536;
                break;
            }
            case 3: {
                items += 3072;
                break;
            }
            case 4: {
                items += 4096;
            }
        }
        if (this.getInstalledUpgrades(Upgrades.UpgradeType.ADVANCED_SPEED) > 0) {
            items += 4096;
        }
        return items;
    }

    protected int calculateEnergyToSend() {
        int energy = 32;
        switch (this.getInstalledUpgrades(Upgrades.UpgradeType.STACKS)) {
            case 1: {
                energy = 2048;
                break;
            }
            case 2: {
                energy = 131072;
                break;
            }
            case 3: {
                energy = 0x800000;
                break;
            }
            case 4: {
                energy = Integer.MAX_VALUE;
            }
        }
        if (this.getInstalledUpgrades(Upgrades.UpgradeType.ADVANCED_SPEED) > 0) {
            energy += 32768;
        }
        return energy;
    }

    protected long calculateEFEnergyToSend() {
        int energy = 32;
        switch (this.getInstalledUpgrades(Upgrades.UpgradeType.STACKS)) {
            case 1: {
                energy = 2048;
                break;
            }
            case 2: {
                energy = 32768;
                break;
            }
            case 3: {
                energy = 524288;
                break;
            }
            case 4: {
                energy = 0x2000000;
            }
        }
        if (this.getInstalledUpgrades(Upgrades.UpgradeType.ADVANCED_SPEED) > 0) {
            energy += 32768;
        }
        return CrazyAEConfig.disableTierSystemForEnergyBuses ? Long.MAX_VALUE : (long)energy;
    }

    protected int calculateManaIterations() {
        int mana = 1;
        switch (this.getInstalledUpgrades(Upgrades.UpgradeType.STACKS)) {
            case 1: {
                ++mana;
                break;
            }
            case 2: {
                mana += 2;
                break;
            }
            case 3: {
                mana += 4;
                break;
            }
            case 4: {
                mana += 6;
            }
        }
        if (this.getInstalledUpgrades(Upgrades.UpgradeType.ADVANCED_SPEED) > 0) {
            ++mana;
        }
        return mana;
    }

    protected int calculateManaToSend() {
        int mana = 256;
        switch (this.getInstalledUpgrades(Upgrades.UpgradeType.STACKS)) {
            case 1: {
                mana += 16384;
                break;
            }
            case 2: {
                mana += 131072;
                break;
            }
            case 3: {
                mana += 524288;
                break;
            }
            case 4: {
                mana += 0x200000;
            }
        }
        if (this.getInstalledUpgrades(Upgrades.UpgradeType.ADVANCED_SPEED) > 0) {
            mana += 131072;
        }
        return mana;
    }

    protected boolean canDoBusWork() {
        TileEntity self = this.getHost().getTile();
        BlockPos selfPos = self.func_174877_v().func_177972_a(this.getSide().getFacing());
        int xCoordinate = selfPos.func_177958_n();
        int zCoordinate = selfPos.func_177952_p();
        World world = self.func_145831_w();
        return world != null && world.func_72863_F().func_186026_b(xCoordinate >> 4, zCoordinate >> 4) != null;
    }

    private void updateState() {
        try {
            if (!this.isSleeping()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected abstract TickRateModulation doBusWork();

    AppEngInternalAEInventory getConfig() {
        return this.config;
    }
}

