/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.util.IConfigManager;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import dev.beecube31.crazyae2.common.parts.CrazyAEBasePartState;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEStackUpgradeInv;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public abstract class CrazyAEPartUpgradeable
extends CrazyAEBasePartState
implements IAEAppEngInventory,
IConfigManagerHost {
    private final IConfigManager manager;
    protected final CrazyAEStackUpgradeInv upgrades = new CrazyAEStackUpgradeInv(this.getItemStack(), this, this.getUpgradeSlots());

    public CrazyAEPartUpgradeable(ItemStack is) {
        super(is);
        this.manager = new ConfigManager((IConfigManagerHost)this);
    }

    protected int getUpgradeSlots() {
        return 4;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.upgrades) {
            this.upgradesChanged();
        }
    }

    public void upgradesChanged() {
    }

    protected boolean isSleeping() {
        if (this.getInstalledUpgrades(Upgrades.REDSTONE) > 0) {
            switch (this.getRSMode()) {
                case IGNORE: {
                    return false;
                }
                case HIGH_SIGNAL: {
                    if (!this.getHost().hasRedstone(this.getSide())) break;
                    return false;
                }
                case LOW_SIGNAL: {
                    if (this.getHost().hasRedstone(this.getSide())) break;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    public int getInstalledUpgrades(Upgrades.UpgradeType u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    public boolean canConnectRedstone() {
        return this.upgrades.getMaxInstalled(Upgrades.REDSTONE) > 0;
    }

    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.manager.readFromNBT(extra);
        this.upgrades.readFromNBT(extra, "upgrades");
    }

    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.manager.writeToNBT(extra);
        this.upgrades.writeToNBT(extra, "upgrades");
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        Iterator iterator = this.upgrades.iterator();
        while (iterator.hasNext()) {
            ItemStack is = (ItemStack)iterator.next();
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    public IConfigManager getConfigManager() {
        return this.manager;
    }

    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    public RedstoneMode getRSMode() {
        return null;
    }
}

