/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import dev.beecube31.crazyae2.common.items.CrazyAEUpgradeModule;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public abstract class CrazyAEUpgradeInventory
extends AppEngInternalInventory
implements IAEAppEngInventory {
    private final IAEAppEngInventory parent;
    private boolean cached = false;
    private boolean cachedCrazyAE = false;
    private int stacks = 0;
    private int improvedSpeed = 0;
    private int advancedSpeed = 0;
    private int fuzzyUpgrades = 0;
    private int speedUpgrades = 0;
    private int redstoneUpgrades = 0;
    private int capacityUpgrades = 0;
    private int inverterUpgrades = 0;
    private int craftingUpgrades = 0;
    private int patternExpansionUpgrades = 0;
    private int magnetUpgrades = 0;
    private int quantumUpgrades = 0;

    public CrazyAEUpgradeInventory(IAEAppEngInventory parent, int s) {
        super(null, s, 1);
        this.setTileEntity(this);
        this.parent = parent;
        this.setFilter(new UpgradeInvFilter());
    }

    protected boolean eventsEnabled() {
        return true;
    }

    public int getInstalledUpgrades(Upgrades u) {
        int n;
        if (!this.cached) {
            this.updateUpgradeInfo();
        }
        switch (u) {
            case CAPACITY: {
                n = this.capacityUpgrades;
                break;
            }
            case FUZZY: {
                n = this.fuzzyUpgrades;
                break;
            }
            case REDSTONE: {
                n = this.redstoneUpgrades;
                break;
            }
            case SPEED: {
                n = this.speedUpgrades;
                break;
            }
            case INVERTER: {
                n = this.inverterUpgrades;
                break;
            }
            case CRAFTING: {
                n = this.craftingUpgrades;
                break;
            }
            case PATTERN_EXPANSION: {
                n = this.patternExpansionUpgrades;
                break;
            }
            case MAGNET: {
                n = this.magnetUpgrades;
                break;
            }
            case QUANTUM_LINK: {
                n = this.quantumUpgrades;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public int getInstalledUpgrades(Upgrades.UpgradeType u) {
        int n;
        if (!this.cachedCrazyAE) {
            this.updateCrazyAEUpgradesInfo();
        }
        switch (u) {
            case STACKS: {
                n = this.stacks;
                break;
            }
            case ADVANCED_SPEED: {
                n = this.advancedSpeed;
                break;
            }
            case IMPROVED_SPEED: {
                n = this.improvedSpeed;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public abstract int getMaxInstalled(Upgrades var1);

    public abstract int getMaxInstalled(Upgrades.UpgradeType var1);

    private void updateUpgradeInfo() {
        this.cached = true;
        this.quantumUpgrades = 0;
        this.magnetUpgrades = 0;
        this.craftingUpgrades = 0;
        this.fuzzyUpgrades = 0;
        this.redstoneUpgrades = 0;
        this.speedUpgrades = 0;
        this.capacityUpgrades = 0;
        this.inverterUpgrades = 0;
        this.patternExpansionUpgrades = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ItemStack is = (ItemStack)iterator.next();
            if (is == null || is.func_77973_b() == Items.field_190931_a || !(is.func_77973_b() instanceof IUpgradeModule)) continue;
            Upgrades myUpgrade = ((IUpgradeModule)is.func_77973_b()).getType(is);
            switch (myUpgrade) {
                case CAPACITY: {
                    ++this.capacityUpgrades;
                    break;
                }
                case FUZZY: {
                    ++this.fuzzyUpgrades;
                    break;
                }
                case REDSTONE: {
                    ++this.redstoneUpgrades;
                    break;
                }
                case SPEED: {
                    ++this.speedUpgrades;
                    break;
                }
                case INVERTER: {
                    ++this.inverterUpgrades;
                    break;
                }
                case CRAFTING: {
                    ++this.craftingUpgrades;
                    break;
                }
                case PATTERN_EXPANSION: {
                    ++this.patternExpansionUpgrades;
                    break;
                }
                case MAGNET: {
                    ++this.magnetUpgrades;
                    break;
                }
                case QUANTUM_LINK: {
                    ++this.quantumUpgrades;
                }
            }
        }
        this.capacityUpgrades = Math.min(this.capacityUpgrades, this.getMaxInstalled(Upgrades.CAPACITY));
        this.fuzzyUpgrades = Math.min(this.fuzzyUpgrades, this.getMaxInstalled(Upgrades.FUZZY));
        this.redstoneUpgrades = Math.min(this.redstoneUpgrades, this.getMaxInstalled(Upgrades.REDSTONE));
        this.speedUpgrades = Math.min(this.speedUpgrades, this.getMaxInstalled(Upgrades.SPEED));
        this.inverterUpgrades = Math.min(this.inverterUpgrades, this.getMaxInstalled(Upgrades.INVERTER));
        this.craftingUpgrades = Math.min(this.craftingUpgrades, this.getMaxInstalled(Upgrades.CRAFTING));
        this.patternExpansionUpgrades = Math.min(this.patternExpansionUpgrades, this.getMaxInstalled(Upgrades.PATTERN_EXPANSION));
        this.magnetUpgrades = Math.min(this.magnetUpgrades, this.getMaxInstalled(Upgrades.MAGNET));
        this.quantumUpgrades = Math.min(this.quantumUpgrades, this.getMaxInstalled(Upgrades.QUANTUM_LINK));
    }

    private void updateCrazyAEUpgradesInfo() {
        this.cachedCrazyAE = true;
        this.advancedSpeed = 0;
        this.improvedSpeed = 0;
        this.stacks = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ItemStack is = (ItemStack)iterator.next();
            if (is == null || is.func_77973_b() == Items.field_190931_a || !(is.func_77973_b() instanceof CrazyAEUpgradeModule)) continue;
            Upgrades.UpgradeType myUpgrade = ((CrazyAEUpgradeModule)is.func_77973_b()).getType(is);
            switch (myUpgrade) {
                case STACKS: {
                    ++this.stacks;
                    break;
                }
                case IMPROVED_SPEED: {
                    ++this.improvedSpeed;
                    break;
                }
                case ADVANCED_SPEED: {
                    ++this.advancedSpeed;
                    break;
                }
            }
        }
        this.stacks = Math.min(this.stacks, this.getMaxInstalled(Upgrades.UpgradeType.STACKS));
        this.improvedSpeed = Math.min(this.improvedSpeed, this.getMaxInstalled(Upgrades.UpgradeType.IMPROVED_SPEED));
        this.advancedSpeed = Math.min(this.advancedSpeed, this.getMaxInstalled(Upgrades.UpgradeType.ADVANCED_SPEED));
    }

    public void readFromNBT(NBTTagCompound target) {
        super.readFromNBT(target);
        this.updateUpgradeInfo();
    }

    public void saveChanges() {
        if (this.parent != null) {
            this.parent.saveChanges();
        }
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.cached = false;
        this.cachedCrazyAE = false;
        if (this.parent != null && Platform.isServer()) {
            this.parent.onChangeInventory(inv, slot, mc, removedStack, newStack);
        }
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    private class UpgradeInvFilter
    implements IAEItemFilter {
        private UpgradeInvFilter() {
        }

        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(IItemHandler inv, int slot, ItemStack itemstack) {
            Upgrades.UpgradeType cu;
            Upgrades u;
            if (itemstack.func_190926_b()) {
                return false;
            }
            Item it = itemstack.func_77973_b();
            if (it instanceof IUpgradeModule && (u = ((IUpgradeModule)it).getType(itemstack)) != null) {
                return CrazyAEUpgradeInventory.this.getInstalledUpgrades(u) < CrazyAEUpgradeInventory.this.getMaxInstalled(u);
            }
            if (it instanceof CrazyAEUpgradeModule && (cu = ((CrazyAEUpgradeModule)it).getType(itemstack)) != null) {
                return CrazyAEUpgradeInventory.this.getInstalledUpgrades(cu) < CrazyAEUpgradeInventory.this.getMaxInstalled(cu);
            }
            return false;
        }
    }
}

