/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.tile.inventory.AppEngCellInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import dev.beecube31.crazyae2.common.interfaces.gui.IPriHostGuiOverrider;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEPartSharedBus;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import dev.beecube31.crazyae2.common.util.DrivePartWatcher;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class PartDrive
extends CrazyAEPartSharedBus
implements IChestOrDrive,
IPriorityHost,
IPriHostGuiOverrider {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("crazyae", "part/drive_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/drive_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/drive_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/drive_has_channel")});
    private final IActionSource mySrc;
    private final AppEngCellInventory inv = new AppEngCellInventory((IAEAppEngInventory)this, 10);
    private final ICellHandler[] handlersBySlot = new ICellHandler[10];
    private final DrivePartWatcher<IAEItemStack>[] invBySlot = new DrivePartWatcher[10];
    private boolean isCached = false;
    private final Map<IStorageChannel<? extends IAEStack<?>>, List<IMEInventoryHandler>> inventoryHandlers;
    private int priority = 0;
    private boolean wasActive = false;
    private int cellState = 0;
    private boolean powered;
    private int blinking;

    public PartDrive(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.inv.setFilter((IAEItemFilter)new CellValidInventoryFilter());
        this.inventoryHandlers = new IdentityHashMap();
        this.mySrc = new MachineSource((IActionHost)this);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        int newState = 0;
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x) << 3 * x;
        }
        data.writeInt(newState);
        data.writeBoolean(this.getProxy().isActive());
        data.writeInt(this.blinking);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        int oldCellState = this.cellState;
        boolean oldPowered = this.powered;
        int oldBlinking = this.blinking;
        this.cellState = data.readInt();
        this.powered = data.readBoolean();
        this.blinking = data.readInt();
        return oldCellState != this.cellState || oldPowered != this.powered || oldBlinking != this.blinking || c;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isCached = false;
        this.priority = data.func_74762_e("priority");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
    }

    public int getCellCount() {
        return 10;
    }

    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.cellState >> slot * 3 & 7;
        }
        DrivePartWatcher<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return 0;
        }
        return handler.getStatus();
    }

    @Override
    public boolean isPowered() {
        if (Platform.isClient()) {
            return this.powered;
        }
        return this.getProxy().isActive();
    }

    public boolean isCellBlinking(int slot) {
        return (this.blinking & 1 << slot) == 1;
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
            this.recalculateDisplay();
        }
        try {
            if (this.getProxy().isActive()) {
                IStorageGrid gs = this.getProxy().getStorage();
                Platform.postChanges((IStorageGrid)gs, (ItemStack)removed, (ItemStack)added, (IActionSource)this.mySrc);
            }
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    private void recalculateDisplay() {
        boolean currentActive = this.getProxy().isActive();
        int oldCellState = this.cellState;
        boolean oldPowered = this.powered;
        this.powered = currentActive;
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.cellState |= this.getCellStatus(x) << 3 * x;
        }
        if (oldCellState != this.cellState || oldPowered != this.powered) {
            this.markForUpdate();
        }
    }

    private void markForUpdate() {
        this.getHost().getTile().func_145831_w().func_184138_a(this.getHost().getTile().func_174877_v(), this.getHost().getTile().func_145831_w().func_180495_p(this.getHost().getTile().func_174877_v()), this.getHost().getTile().func_145831_w().func_180495_p(this.getHost().getTile().func_174877_v()), 3);
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    private void updateState() {
        if (!this.isCached) {
            Collection storageChannels = AEApi.instance().storage().storageChannels();
            storageChannels.forEach(channel -> this.inventoryHandlers.put((IStorageChannel<IAEStack<?>>)channel, new ArrayList(10)));
            double power = 2.0;
            block0: for (int x = 0; x < this.inv.getSlots(); ++x) {
                ItemStack is = this.inv.getStackInSlot(x);
                this.invBySlot[x] = null;
                this.handlersBySlot[x] = null;
                if (is.func_190926_b()) continue;
                this.handlersBySlot[x] = AEApi.instance().registries().cell().getHandler(is);
                if (this.handlersBySlot[x] == null) continue;
                for (IStorageChannel channel2 : storageChannels) {
                    ICellInventoryHandler cell = this.handlersBySlot[x].getCellInventory(is, (ISaveProvider)this, channel2);
                    if (cell == null) continue;
                    this.inv.setHandler(x, cell);
                    power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                    DrivePartWatcher ih = new DrivePartWatcher(cell, is, this.handlersBySlot[x], this);
                    ih.setPriority(this.priority);
                    this.invBySlot[x] = ih;
                    this.inventoryHandlers.get(channel2).add((IMEInventoryHandler)ih);
                    continue block0;
                }
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
    }

    @Override
    protected TickRateModulation doBusWork() {
        return TickRateModulation.SAME;
    }

    public void addToWorld() {
        super.addToWorld();
        this.updateState();
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        this.updateState();
        return this.inventoryHandlers.get(channel);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.saveChanges();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void saveChanges(ICellInventory<?> cellInventory) {
        this.getHost().getTile().func_145831_w().func_175646_b(this.getHost().getTile().func_174877_v(), null);
    }

    public void blinkCell(int slot) {
        this.blinking |= 1 << slot;
        this.recalculateDisplay();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            CrazyAEGuiHandler.openGUI(player, this.getHost().getTile(), this.getSide(), (Object)this.getOverrideGui());
        }
        return true;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("cells")) {
            return this.inv;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public RedstoneMode getRSMode() {
        return RedstoneMode.IGNORE;
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    @NotNull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public IItemDefinition getBlock() {
        return null;
    }

    public boolean canBeRotated() {
        return false;
    }

    public EnumFacing getForward() {
        return EnumFacing.func_176741_a((Random)new Random());
    }

    public EnumFacing getUp() {
        return EnumFacing.func_176741_a((Random)new Random());
    }

    public void setOrientation(EnumFacing enumFacing, EnumFacing enumFacing1) {
    }

    @Override
    public CrazyAEGuiBridge getOverrideGui() {
        return CrazyAEGuiBridge.GUI_DRIVE_PART;
    }

    public ItemStack getItemStackRepresentation() {
        return AEApi.instance().definitions().blocks().drive().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    public GuiBridge getGuiBridge() {
        return GuiBridge.GUI_DRIVE;
    }

    private class CellValidInventoryFilter
    implements IAEItemFilter {
        private CellValidInventoryFilter() {
        }

        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return !stack.func_190926_b() && AEApi.instance().registries().cell().isCellHandled(stack);
        }
    }
}

