/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.inv.InvOperation;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.denfop.api.sytem.EnergyType;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.tiles.transport.tiles.TileEntityCable;
import com.denfop.tiles.transport.tiles.TileEntityQCable;
import com.denfop.tiles.transport.tiles.TileEntitySCable;
import com.denfop.tiles.transport.tiles.TileEntityUniversalCable;
import dev.beecube31.crazyae2.common.compat.IUCompat;
import dev.beecube31.crazyae2.common.components.ComponentEFEnergySource;
import dev.beecube31.crazyae2.common.components.ComponentEUEnergySource;
import dev.beecube31.crazyae2.common.components.ComponentMoreEnergySource;
import dev.beecube31.crazyae2.common.components.ComponentRFEnergySource;
import dev.beecube31.crazyae2.common.enums.EnergyBusType;
import dev.beecube31.crazyae2.common.interfaces.IEnergyBus;
import dev.beecube31.crazyae2.common.interfaces.IPartActivationOverrider;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEPartSharedBus;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import dev.beecube31.crazyae2.common.util.AEUtils;
import dev.beecube31.crazyae2.common.util.ModsChecker;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.api.storage.energy.IEnergyStorageChannel;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class PartEnergyExportBus
extends CrazyAEPartSharedBus
implements IEnergyBus,
IEnergyStorage,
IPartActivationOverrider {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("crazyae", "part/energy_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/energy_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/energy_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/energy_bus_has_channel")});
    private final IActionSource source;
    private long itemsToSend = 32L;
    private IItemDefinition currentEnergy = null;
    private Object energyComponent = null;
    private boolean worked;
    private long maxConfigEnergy = 0L;
    private ComponentRFEnergySource rfDelegate;
    private ComponentEUEnergySource euDelegate;
    private ComponentEFEnergySource energyDelegate;
    private ComponentMoreEnergySource solariumDelegate;
    private ComponentMoreEnergySource quantumDelegate;

    public PartEnergyExportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.source = new MachineSource((IActionHost)this);
    }

    public ComponentRFEnergySource getRfDelegate() {
        return this.rfDelegate;
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound, EntityPlayer player) {
        IItemHandler inv;
        if (compound != null) {
            IConfigManager cm = this.getConfigManager();
            if (cm != null) {
                cm.readFromNBT(compound);
            }
            if (compound.func_74764_b("EnergyConfig")) {
                this.maxConfigEnergy = compound.func_74763_f("EnergyConfig");
            }
        }
        if ((inv = this.getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            AppEngInternalAEInventory target = (AppEngInternalAEInventory)inv;
            AppEngInternalAEInventory tmp = new AppEngInternalAEInventory(null, target.getSlots());
            tmp.readFromNBT(compound, "config");
            for (int x = 0; x < tmp.getSlots(); ++x) {
                target.setStackInSlot(x, tmp.getStackInSlot(x));
            }
        }
    }

    private boolean useMemoryCard(EntityPlayer player) {
        Item item;
        ItemStack memCardIS = player.field_71071_by.func_70448_g();
        if (!memCardIS.func_190926_b() && this.useStandardMemoryCard() && (item = memCardIS.func_77973_b()) instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)item;
            ItemStack is = this.getItemStack(PartItemStack.NETWORK);
            String name = is.func_77977_a();
            if (player.func_70093_af()) {
                NBTTagCompound data = this.downloadSettings(SettingsFrom.MEMORY_CARD);
                if (data != null) {
                    this.setMemoryCardContents(memCardIS, name, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                    player.func_145747_a((ITextComponent)new TextComponentString("SAVED1"));
                }
            } else {
                String storedName = memoryCard.getSettingsName(memCardIS);
                NBTTagCompound data = memoryCard.getData(memCardIS);
                if (name.equals(storedName)) {
                    this.uploadSettings(SettingsFrom.MEMORY_CARD, data, player);
                    player.func_145747_a((ITextComponent)new TextComponentString("SAVED2"));
                } else {
                    memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                    player.func_145747_a((ITextComponent)new TextComponentString("INVALID_MACHINE1"));
                }
            }
            return true;
        }
        return false;
    }

    public void setMemoryCardContents(ItemStack is, String settingsName, NBTTagCompound data) {
        NBTTagCompound c = Platform.openNbtData((ItemStack)is);
        c.func_74778_a("Config", settingsName);
        c.func_74782_a("Data", (NBTBase)data);
        c.func_74772_a("EnergyConfig", this.maxConfigEnergy);
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.maxConfigEnergy = extra.func_74763_f("energyConfig");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        extra.func_74772_a("energyConfig", this.maxConfigEnergy);
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.upgrades) {
            this.updateMaxConfigEnergy();
        }
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    public void addToWorld() {
        super.addToWorld();
        if (Platform.isServer()) {
            this.rfDelegate = ModsChecker.RFLUX_LOADED ? new ComponentRFEnergySource(this) : null;
            this.euDelegate = ModsChecker.IC2_LOADED ? new ComponentEUEnergySource(this) : null;
            this.energyDelegate = ModsChecker.IU_LOADED ? new ComponentEFEnergySource(this) : null;
            this.solariumDelegate = ModsChecker.IU_LOADED ? new ComponentMoreEnergySource(CrazyAE.definitions().items().SEEnergyAsAeStack(), this) : null;
            ComponentMoreEnergySource componentMoreEnergySource = this.quantumDelegate = ModsChecker.IU_LOADED ? new ComponentMoreEnergySource(CrazyAE.definitions().items().QEEnergyAsAeStack(), this) : null;
            if (this.euDelegate != null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.euDelegate));
            }
            if (this.energyDelegate != null) {
                IUCompat.addEFTileToWorld(this.getTile().func_145831_w(), this.energyDelegate);
            }
            if (this.solariumDelegate != null) {
                IUCompat.addMultiTileToWorld(this.getTile().func_145831_w(), EnergyType.SOLARIUM, this.solariumDelegate);
            }
            if (this.quantumDelegate != null) {
                IUCompat.addMultiTileToWorld(this.getTile().func_145831_w(), EnergyType.QUANTUM, this.quantumDelegate);
            }
        }
    }

    public void removeFromWorld() {
        super.removeFromWorld();
        if (Platform.isServer()) {
            if (this.euDelegate != null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this.euDelegate));
            }
            if (this.energyDelegate != null) {
                IUCompat.removeEFTileFromWorld(this.getTile().func_145831_w(), this.energyDelegate);
            }
            if (this.solariumDelegate != null) {
                IUCompat.removeMultiTileFromWorld(this.getTile().func_145831_w(), EnergyType.SOLARIUM, this.solariumDelegate);
            }
            if (this.quantumDelegate != null) {
                IUCompat.removeMultiTileFromWorld(this.getTile().func_145831_w(), EnergyType.QUANTUM, this.quantumDelegate);
            }
        }
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!this.useMemoryCard(player) && Platform.isServer()) {
            CrazyAEGuiHandler.openGUI(player, this.getHost().getTile(), this.getSide(), (Object)CrazyAEGuiBridge.ENERGY_BUS);
        }
        return true;
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        return new TickingRequest(1, 10, this.isSleeping(), false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.energyComponent = null;
        this.currentEnergy = null;
        this.itemsToSend = -1L;
        this.worked = false;
        this.itemsToSend = Math.min(this.calculateEFEnergyToSend(), this.maxConfigEnergy == 0L ? Long.MAX_VALUE : this.maxConfigEnergy);
        TileEntity te = this.getVictim();
        if (ModsChecker.IU_LOADED && Utils.isIUBlock(te)) {
            if (this.itemsToSend <= 0L || !Utils.findEnergyComponents(te).isEmpty()) return TickRateModulation.SLEEP;
            try {
                IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class));
                while (this.itemsToSend > 0L) {
                    if (!this.exportStuff(te, (IMEMonitor<IAEItemStack>)inv)) continue;
                    return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
                }
                return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            }
            catch (GridAccessException inv) {}
            return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
        }
        if (te instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)te;
            if (!storage.canReceive()) return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            int received = storage.receiveEnergy((int)this.availableEnergy(CrazyAE.definitions().items().FEEnergyAsAeStack()), false);
            IAEItemStack ais = AEUtils.extractFromME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), received), this.source, Actionable.MODULATE);
            if (ais == null || ais.getStackSize() != (long)received) return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            this.worked = true;
            return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
        } else if (Loader.isModLoaded((String)"redstoneflux") && te instanceof IEnergyReceiver) {
            IEnergyReceiver r = (IEnergyReceiver)te;
            int received = r.receiveEnergy(this.getSide().getFacing(), (int)this.availableEnergy(CrazyAE.definitions().items().FEEnergyAsAeStack()), false);
            IAEItemStack ais = AEUtils.extractFromME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), received), this.source, Actionable.MODULATE);
            if (ais == null || ais.getStackSize() != (long)received) return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            this.worked = true;
            return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
        } else {
            if (te == null) return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            this.tryExportToFEComponents(te);
        }
        return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private void tryExportToFEComponents(TileEntity te) {
        try {
            for (Field field : te.getClass().getDeclaredFields()) {
                if (!IEnergyStorage.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                IEnergyStorage candidate = (IEnergyStorage)field.get(te);
                if (!candidate.canReceive()) continue;
                int received = candidate.receiveEnergy((int)this.availableEnergy(CrazyAE.definitions().items().FEEnergyAsAeStack()), false);
                IAEItemStack ais = AEUtils.extractFromME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), received), this.source, Actionable.MODULATE);
                if (ais == null || ais.getStackSize() != (long)received) continue;
                this.worked = true;
                break;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private boolean exportStuff(TileEntity tile, IMEMonitor<IAEItemStack> inv) {
        long toSend = this.calculateMaximumAmountToExport(tile, inv);
        if (toSend == 0L) {
            return true;
        }
        IAEItemStack extracted = AEUtils.extractFromME(inv, AEUtils.createAEStackFromDefinition(this.currentEnergy, toSend), this.source, Actionable.MODULATE);
        if (extracted != null && extracted.getStackSize() > 0L) {
            toSend = extracted.getStackSize();
            this.addEnergyToComponent(toSend);
            this.itemsToSend -= toSend;
            this.worked = true;
            return false;
        }
        return true;
    }

    private void extractEnergyFromComponent(double amt) {
        Object object = this.energyComponent;
        if (object instanceof ComponentBaseEnergy) {
            ComponentBaseEnergy energy = (ComponentBaseEnergy)object;
            energy.useEnergy(amt);
        } else {
            object = this.energyComponent;
            if (object instanceof Energy) {
                Energy energy = (Energy)object;
                energy.useEnergy(amt);
            }
        }
    }

    private void addEnergyToComponent(double amt) {
        Object object = this.energyComponent;
        if (object instanceof ComponentBaseEnergy) {
            ComponentBaseEnergy energy = (ComponentBaseEnergy)object;
            energy.addEnergy(amt);
        } else {
            object = this.energyComponent;
            if (object instanceof Energy) {
                Energy energy = (Energy)object;
                energy.addEnergy(amt);
            }
        }
    }

    private long calculateMaximumAmountToExport(TileEntity tile, IMEMonitor<IAEItemStack> inv) {
        long toSend = 0L;
        List<Object> comp = Utils.findEnergyComponents(tile);
        boolean found = false;
        block4: for (Object cmp : comp) {
            if (found) break;
            if (cmp instanceof ComponentBaseEnergy) {
                ComponentBaseEnergy energy = (ComponentBaseEnergy)cmp;
                if (!energy.receivingDisabled && !energy.sinkDirections.isEmpty()) {
                    switch (energy.getType()) {
                        default: {
                            return 0L;
                        }
                        case QUANTUM: {
                            this.currentEnergy = CrazyAE.definitions().items().QEEnergyAsAeStack();
                            toSend = (long)Math.min(energy.getCapacity() - energy.getEnergy(), (double)this.itemsToSend);
                            found = true;
                            this.energyComponent = cmp;
                            continue block4;
                        }
                        case SOLARIUM: 
                    }
                    this.currentEnergy = CrazyAE.definitions().items().SEEnergyAsAeStack();
                    toSend = (long)Math.min(energy.getCapacity() - energy.getEnergy(), (double)this.itemsToSend);
                    found = true;
                    this.energyComponent = cmp;
                    continue;
                }
            }
            if (!(cmp instanceof Energy)) continue;
            Energy energy = (Energy)cmp;
            if (energy.receivingDisabled || energy.sinkDirections.isEmpty()) continue;
            this.currentEnergy = CrazyAE.definitions().items().EFEnergyAsAeStack();
            toSend = (long)Math.min(energy.getCapacity() - energy.getEnergy(), (double)this.itemsToSend);
            found = true;
            this.energyComponent = cmp;
        }
        if (toSend > 0L) {
            IAEItemStack extracted = null;
            if (this.currentEnergy != null) {
                extracted = (IAEItemStack)inv.extractItems((IAEStack)AEUtils.createAEStackFromItemstack(this.currentEnergy.maybeStack(1).orElse(ItemStack.field_190927_a), toSend), Actionable.SIMULATE, this.source);
            }
            return extracted != null ? extracted.getStackSize() : 0L;
        }
        return toSend;
    }

    @Override
    protected boolean isSleeping() {
        return this.getVictim() == null || super.isSleeping();
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @NotNull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().parts().improvedImportBus();
    }

    private IItemDefinition getEnergyDefinitionFromCable() {
        TileEntity te = this.getVictim();
        if (te != null) {
            return te instanceof TileEntitySCable ? CrazyAE.definitions().items().SEEnergyAsAeStack() : (te instanceof TileEntityQCable ? CrazyAE.definitions().items().QEEnergyAsAeStack() : (te instanceof TileEntityCable || te instanceof TileEntityUniversalCable ? CrazyAE.definitions().items().EFEnergyAsAeStack() : null));
        }
        return null;
    }

    public double availableEnergy(IItemDefinition what) {
        IMEMonitor<IAEItemStack> inv = this.getEnergyInv();
        if (what != null && inv != null) {
            IAEItemStack simulate = AEUtils.extractFromME(inv, AEUtils.createAEStackFromDefinition(what, Long.MAX_VALUE), this.source, Actionable.SIMULATE);
            return simulate == null ? 0.0 : (double)Math.min(Math.min(this.calculateEFEnergyToSend(), simulate.getStackSize()), this.maxConfigEnergy == 0L ? Long.MAX_VALUE : this.maxConfigEnergy);
        }
        return 0.0;
    }

    public void extractEnergy(double var1, IItemDefinition what) {
        if (what != null) {
            AEUtils.extractFromME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(what, (long)var1), this.source, Actionable.MODULATE);
        }
    }

    @Override
    public long getMaxConfigEnergy() {
        return this.maxConfigEnergy;
    }

    @Override
    public void setMaxConfigEnergy(long amt) {
        this.maxConfigEnergy = Math.max(Math.min(this.calculateEFEnergyToSend(), amt), 1L);
    }

    public void updateMaxConfigEnergy() {
        if (this.maxConfigEnergy > this.calculateEFEnergyToSend()) {
            this.maxConfigEnergy = Math.max(this.calculateEFEnergyToSend(), 1L);
        }
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return CrazyAE.definitions().parts().energyExportBus().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        IAEItemStack ais = AEUtils.extractFromME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), maxExtract), this.source, simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        return ais == null ? 0 : (int)ais.getStackSize();
    }

    public int getEnergyStored() {
        return this.getMaxEnergyStored();
    }

    public int getMaxEnergyStored() {
        IAEItemStack simulate = AEUtils.extractFromME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), Long.MAX_VALUE), this.source, Actionable.SIMULATE);
        return simulate == null ? 0 : (int)Math.min(Math.min(this.calculateEFEnergyToSend(), simulate.getStackSize()), this.maxConfigEnergy == 0L ? Long.MAX_VALUE : this.maxConfigEnergy);
    }

    @Override
    public EnergyBusType getBusType() {
        return EnergyBusType.EXPORT;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

