/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.inv.InvOperation;
import cofh.redstoneflux.api.IEnergyProvider;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import dev.beecube31.crazyae2.common.compat.IUCompat;
import dev.beecube31.crazyae2.common.components.ComponentEFEnergySink;
import dev.beecube31.crazyae2.common.components.ComponentEUEnergySink;
import dev.beecube31.crazyae2.common.components.ComponentMoreEnergySink;
import dev.beecube31.crazyae2.common.components.ComponentRFEnergySink;
import dev.beecube31.crazyae2.common.enums.EnergyBusType;
import dev.beecube31.crazyae2.common.interfaces.IEnergyBus;
import dev.beecube31.crazyae2.common.interfaces.IPartActivationOverrider;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEPartSharedBus;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import dev.beecube31.crazyae2.common.util.AEUtils;
import dev.beecube31.crazyae2.common.util.ModsChecker;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.api.storage.energy.IEnergyStorageChannel;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class PartEnergyImportBus
extends CrazyAEPartSharedBus
implements IEnergyBus,
IEnergyStorage,
IPartActivationOverrider {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("crazyae", "part/energy_import_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/energy_import_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/energy_import_bus_off")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/energy_import_bus_has_channel")});
    private final IActionSource source;
    private long itemsToSend = 32L;
    private IItemDefinition currentEnergy = null;
    private Object energyComponent = null;
    private boolean worked;
    private long maxConfigEnergy;
    private ComponentRFEnergySink rfDelegate;
    private ComponentEUEnergySink euDelegate;
    private ComponentEFEnergySink energyDelegate;
    private ComponentMoreEnergySink solariumDelegate;
    private ComponentMoreEnergySink quantumDelegate;

    public PartEnergyImportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.source = new MachineSource((IActionHost)this);
    }

    public ComponentRFEnergySink getRfDelegate() {
        return this.rfDelegate;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.upgrades) {
            this.updateMaxConfigEnergy();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.maxConfigEnergy = extra.func_74763_f("energyConfig");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        extra.func_74772_a("energyConfig", this.maxConfigEnergy);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    public void addToWorld() {
        super.addToWorld();
        if (Platform.isServer()) {
            this.rfDelegate = ModsChecker.RFLUX_LOADED ? new ComponentRFEnergySink(this) : null;
            this.euDelegate = ModsChecker.IC2_LOADED ? new ComponentEUEnergySink(this) : null;
            this.energyDelegate = ModsChecker.IU_LOADED ? new ComponentEFEnergySink(this) : null;
            this.solariumDelegate = ModsChecker.IU_LOADED ? new ComponentMoreEnergySink(CrazyAE.definitions().items().SEEnergyAsAeStack(), this) : null;
            ComponentMoreEnergySink componentMoreEnergySink = this.quantumDelegate = ModsChecker.IU_LOADED ? new ComponentMoreEnergySink(CrazyAE.definitions().items().QEEnergyAsAeStack(), this) : null;
            if (this.euDelegate != null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.euDelegate));
            }
            if (this.energyDelegate != null) {
                IUCompat.addEFTileToWorld(this.getTile().func_145831_w(), this.energyDelegate);
            }
            if (this.solariumDelegate != null) {
                IUCompat.addMultiTileToWorld(this.getTile().func_145831_w(), EnergyType.SOLARIUM, this.solariumDelegate);
            }
            if (this.quantumDelegate != null) {
                IUCompat.addMultiTileToWorld(this.getTile().func_145831_w(), EnergyType.QUANTUM, this.quantumDelegate);
            }
        }
    }

    public void removeFromWorld() {
        super.removeFromWorld();
        if (Platform.isServer()) {
            if (this.euDelegate != null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this.euDelegate));
            }
            if (this.energyDelegate != null) {
                IUCompat.removeEFTileFromWorld(this.getTile().func_145831_w(), this.energyDelegate);
            }
            if (this.solariumDelegate != null) {
                IUCompat.removeMultiTileFromWorld(this.getTile().func_145831_w(), EnergyType.SOLARIUM, this.solariumDelegate);
            }
            if (this.quantumDelegate != null) {
                IUCompat.removeMultiTileFromWorld(this.getTile().func_145831_w(), EnergyType.QUANTUM, this.quantumDelegate);
            }
        }
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound, EntityPlayer player) {
        IItemHandler inv;
        if (compound != null) {
            IConfigManager cm = this.getConfigManager();
            if (cm != null) {
                cm.readFromNBT(compound);
            }
            if (compound.func_74764_b("EnergyConfig")) {
                this.maxConfigEnergy = compound.func_74763_f("EnergyConfig");
            }
        }
        if ((inv = this.getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            AppEngInternalAEInventory target = (AppEngInternalAEInventory)inv;
            AppEngInternalAEInventory tmp = new AppEngInternalAEInventory(null, target.getSlots());
            tmp.readFromNBT(compound, "config");
            for (int x = 0; x < tmp.getSlots(); ++x) {
                target.setStackInSlot(x, tmp.getStackInSlot(x));
            }
        }
    }

    private boolean useMemoryCard(EntityPlayer player) {
        Item item;
        ItemStack memCardIS = player.field_71071_by.func_70448_g();
        if (!memCardIS.func_190926_b() && this.useStandardMemoryCard() && (item = memCardIS.func_77973_b()) instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)item;
            ItemStack is = this.getItemStack(PartItemStack.NETWORK);
            String name = is.func_77977_a();
            if (player.func_70093_af()) {
                NBTTagCompound data = this.downloadSettings(SettingsFrom.MEMORY_CARD);
                if (data != null) {
                    this.setMemoryCardContents(memCardIS, name, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                }
            } else {
                String storedName = memoryCard.getSettingsName(memCardIS);
                NBTTagCompound data = memoryCard.getData(memCardIS);
                if (name.equals(storedName)) {
                    this.uploadSettings(SettingsFrom.MEMORY_CARD, data, player);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                } else {
                    memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                }
            }
            return true;
        }
        return false;
    }

    public void setMemoryCardContents(ItemStack is, String settingsName, NBTTagCompound data) {
        NBTTagCompound c = Platform.openNbtData((ItemStack)is);
        c.func_74778_a("Config", settingsName);
        c.func_74782_a("Data", (NBTBase)data);
        c.func_74772_a("EnergyConfig", this.maxConfigEnergy);
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!this.useMemoryCard(player) && Platform.isServer()) {
            CrazyAEGuiHandler.openGUI(player, this.getHost().getTile(), this.getSide(), (Object)CrazyAEGuiBridge.ENERGY_BUS);
        }
        return true;
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        return new TickingRequest(1, 10, this.isSleeping(), false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.energyComponent = null;
        this.currentEnergy = null;
        this.itemsToSend = -1L;
        this.worked = false;
        this.itemsToSend = Math.min(this.calculateEFEnergyToSend(), this.maxConfigEnergy == 0L ? Long.MAX_VALUE : this.maxConfigEnergy);
        TileEntity te = this.getVictim();
        if (ModsChecker.IU_LOADED && Utils.isIUBlock(te)) {
            if (this.itemsToSend <= 0L || !Utils.findEnergyComponents(te).isEmpty()) return TickRateModulation.SLEEP;
            try {
                IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class));
                while (this.itemsToSend > 0L) {
                    if (!this.importStuff(te, (IMEMonitor<IAEItemStack>)inv)) continue;
                    return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
                }
                return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            }
            catch (GridAccessException inv) {}
            return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
        }
        if (te instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)te;
            if (!storage.canExtract()) return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            int extracted = storage.extractEnergy((int)this.availableEnergy(CrazyAE.definitions().items().FEEnergyAsAeStack()), false);
            IAEItemStack ais = AEUtils.injectToME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), extracted), this.source, Actionable.MODULATE);
            if (ais != null) return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            this.worked = true;
            return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
        } else if (ModsChecker.RFLUX_LOADED && te instanceof IEnergyProvider) {
            IEnergyProvider r = (IEnergyProvider)te;
            int extracted = r.extractEnergy(this.getSide().getFacing(), (int)this.availableEnergy(CrazyAE.definitions().items().FEEnergyAsAeStack()), false);
            IAEItemStack ais = AEUtils.injectToME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), extracted), this.source, Actionable.MODULATE);
            if (ais != null) return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            this.worked = true;
            return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
        } else {
            if (te == null) return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            this.tryImportFromFEComponents(te);
        }
        return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private boolean importStuff(TileEntity tile, IMEMonitor<IAEItemStack> inv) {
        long toSend = this.calculateMaximumAmountToImport(tile, inv);
        if (toSend == 0L) {
            return true;
        }
        IAEItemStack failed = AEUtils.injectToME(inv, AEUtils.createAEStackFromDefinition(this.currentEnergy, toSend), this.source, Actionable.MODULATE);
        if (failed != null) {
            if (failed.getStackSize() == toSend) {
                return false;
            }
            this.extractEnergyFromComponent(failed.getStackSize());
            this.itemsToSend -= failed.getStackSize();
            return true;
        }
        this.extractEnergyFromComponent(toSend);
        this.itemsToSend -= toSend;
        this.worked = true;
        return false;
    }

    private void tryImportFromFEComponents(TileEntity te) {
        try {
            for (Field field : te.getClass().getDeclaredFields()) {
                if (!IEnergyStorage.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                IEnergyStorage candidate = (IEnergyStorage)field.get(te);
                if (!candidate.canExtract()) continue;
                int extracted = candidate.extractEnergy((int)this.availableEnergy(CrazyAE.definitions().items().FEEnergyAsAeStack()), false);
                IAEItemStack ais = AEUtils.injectToME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), extracted), this.source, Actionable.MODULATE);
                if (ais != null) continue;
                this.worked = true;
                break;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void extractEnergyFromComponent(double amt) {
        Object object = this.energyComponent;
        if (object instanceof ComponentBaseEnergy) {
            ComponentBaseEnergy energy = (ComponentBaseEnergy)object;
            energy.useEnergy(amt);
        } else {
            object = this.energyComponent;
            if (object instanceof Energy) {
                Energy energy = (Energy)object;
                energy.useEnergy(amt);
            }
        }
    }

    private void addEnergyToComponent(double amt) {
        Object object = this.energyComponent;
        if (object instanceof ComponentBaseEnergy) {
            ComponentBaseEnergy energy = (ComponentBaseEnergy)object;
            energy.addEnergy(amt);
        } else {
            object = this.energyComponent;
            if (object instanceof Energy) {
                Energy energy = (Energy)object;
                energy.addEnergy(amt);
            }
        }
    }

    private long calculateMaximumAmountToImport(TileEntity tile, IMEMonitor<IAEItemStack> inv) {
        long toSend = 0L;
        List<Object> comp = Utils.findEnergyComponents(tile);
        boolean found = false;
        block4: for (Object cmp : comp) {
            if (found) break;
            if (cmp instanceof ComponentBaseEnergy) {
                ComponentBaseEnergy energy = (ComponentBaseEnergy)cmp;
                if (!energy.sendingSidabled && !energy.sourceDirections.isEmpty()) {
                    switch (energy.getType()) {
                        default: {
                            return 0L;
                        }
                        case QUANTUM: {
                            this.currentEnergy = CrazyAE.definitions().items().QEEnergyAsAeStack();
                            toSend = (long)Math.min(energy.getEnergy(), (double)this.itemsToSend);
                            found = true;
                            this.energyComponent = cmp;
                            continue block4;
                        }
                        case SOLARIUM: 
                    }
                    this.currentEnergy = CrazyAE.definitions().items().SEEnergyAsAeStack();
                    toSend = (long)Math.min(energy.getEnergy(), (double)this.itemsToSend);
                    found = true;
                    this.energyComponent = cmp;
                    continue;
                }
            }
            if (!(cmp instanceof Energy)) continue;
            Energy energy = (Energy)cmp;
            if (energy.sendingSidabled || energy.sourceDirections.isEmpty()) continue;
            this.currentEnergy = CrazyAE.definitions().items().EFEnergyAsAeStack();
            toSend = (long)Math.min(energy.getEnergy(), (double)this.itemsToSend);
            found = true;
            this.energyComponent = cmp;
        }
        if (toSend > 0L) {
            IAEItemStack itemAmountNotStorable = null;
            if (this.currentEnergy != null) {
                itemAmountNotStorable = (IAEItemStack)inv.injectItems((IAEStack)AEUtils.createAEStackFromItemstack(this.currentEnergy.maybeStack(1).orElse(ItemStack.field_190927_a), toSend), Actionable.SIMULATE, this.source);
            }
            if (itemAmountNotStorable != null) {
                if (toSend == itemAmountNotStorable.getStackSize()) {
                    return 0L;
                }
                return (int)Math.min(toSend - itemAmountNotStorable.getStackSize(), toSend);
            }
        }
        return toSend;
    }

    @Override
    protected boolean isSleeping() {
        return this.getVictim() == null || super.isSleeping();
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @NotNull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().parts().energyImportBus();
    }

    public double getDemandedEnergy(IItemDefinition what) {
        return this.availableEnergy(what);
    }

    public double availableEnergy(IItemDefinition what) {
        if (what != null) {
            IAEItemStack simulate = AEUtils.injectToME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(what, Long.MAX_VALUE), this.source, Actionable.SIMULATE);
            return simulate != null && simulate.getStackSize() == Long.MAX_VALUE ? 0.0 : (double)Math.min(Math.min(this.calculateEFEnergyToSend(), Long.MAX_VALUE - (simulate == null ? 0L : simulate.getStackSize())), this.maxConfigEnergy == 0L ? Long.MAX_VALUE : this.maxConfigEnergy);
        }
        return 0.0;
    }

    public double receiveEnergy(double var2, IItemDefinition what) {
        IAEItemStack ais = AEUtils.injectToME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(what, (long)var2), this.source, Actionable.MODULATE);
        return ais == null ? 0.0 : (double)ais.getStackSize();
    }

    public void receiveEnergy(IItemDefinition what, double amt) {
        this.receiveEnergy(amt, what);
    }

    @Override
    public long getMaxConfigEnergy() {
        return this.maxConfigEnergy;
    }

    @Override
    public void setMaxConfigEnergy(long amt) {
        this.maxConfigEnergy = Math.max(Math.min(this.calculateEFEnergyToSend(), amt), 1L);
    }

    public void updateMaxConfigEnergy() {
        if (this.maxConfigEnergy > this.calculateEFEnergyToSend()) {
            this.maxConfigEnergy = Math.max(this.calculateEFEnergyToSend(), 1L);
        }
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return CrazyAE.definitions().parts().energyImportBus().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    public EnergyBusType getBusType() {
        return EnergyBusType.IMPORT;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        IAEItemStack ais = AEUtils.injectToME(this.getEnergyInv(), AEUtils.createAEStackFromDefinition(CrazyAE.definitions().items().FEEnergyAsAeStack(), maxReceive), this.source, simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        return ais == null ? maxReceive : (int)ais.getStackSize();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.getMaxEnergyStored();
    }

    public int getMaxEnergyStored() {
        return (int)this.availableEnergy(CrazyAE.definitions().items().FEEnergyAsAeStack());
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean emitsTo(IAcceptor var1, EnumFacing var2) {
        return true;
    }

    public int receiveEnergy(EnumFacing var1, int var2, boolean var3) {
        return this.receiveEnergy(var2, var3);
    }
}

