/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.item.AEItemStack;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEPartSharedBus;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import dev.beecube31.crazyae2.core.CrazyAE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class PartImportBusImp
extends CrazyAEPartSharedBus
implements IInventoryDestination {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("crazyae", "part/import_bus_base_gold");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/import_bus_off_gold")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/import_bus_on_gold")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/import_bus_has_channel_gold")});
    private final IActionSource source;
    private int itemsToSend = 8;
    private boolean worked;

    public PartImportBusImp(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.source = new MachineSource((IActionHost)this);
    }

    public boolean canInsert(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        try {
            IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IAEItemStack out = (IAEItemStack)inv.injectItems((IAEStack)((IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack)), Actionable.SIMULATE, this.source);
            if (out == null) {
                return true;
            }
            return out.getStackSize() != (long)stack.func_190916_E();
        }
        catch (GridAccessException ex) {
            return false;
        }
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            CrazyAEGuiHandler.openGUI(player, this.getHost().getTile(), this.getSide(), (Object)CrazyAEGuiBridge.IMPROVED_BUS);
        }
        return true;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, TickRates.ImportBus.getMax(), this.isSleeping(), false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.itemsToSend = this.calculateItemsToSend();
        this.worked = false;
        InventoryAdaptor myAdaptor = this.getHandler();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        if (myAdaptor != null) {
            try {
                IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IEnergyGrid energy = this.getProxy().getEnergy();
                boolean Configured = false;
                for (int x = 0; x < this.availableSlots(); ++x) {
                    IAEItemStack ais = this.getConfig().getAEStackInSlot(x);
                    if (ais == null || this.itemsToSend <= 0) continue;
                    Configured = true;
                    while (this.itemsToSend > 0 && !this.importStuff(myAdaptor, ais, (IMEMonitor<IAEItemStack>)inv, (IEnergySource)energy, fzMode)) {
                    }
                }
                if (!Configured) {
                    while (this.itemsToSend > 0) {
                        if (!this.importStuff(myAdaptor, null, (IMEMonitor<IAEItemStack>)inv, (IEnergySource)energy, fzMode)) continue;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            return TickRateModulation.SLEEP;
        }
        return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private boolean importStuff(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, IEnergySource energy, FuzzyMode fzMode) {
        int toSend = this.calculateMaximumAmountToImport(myAdaptor, whatToImport, inv, fzMode);
        if (toSend == 0) {
            return true;
        }
        ItemStack newItems = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? myAdaptor.removeSimilarItems(toSend, whatToImport == null ? ItemStack.field_190927_a : whatToImport.getDefinition(), fzMode, (IInventoryDestination)this) : myAdaptor.removeItems(toSend, whatToImport == null ? ItemStack.field_190927_a : whatToImport.getDefinition(), (IInventoryDestination)this);
        if (!newItems.func_190926_b()) {
            IAEItemStack aeStack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)newItems);
            IAEItemStack failed = (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, inv, (IAEStack)aeStack, (IActionSource)this.source);
            if (failed != null) {
                IAEItemStack spill = (IAEItemStack)inv.injectItems((IAEStack)failed, Actionable.MODULATE, this.source);
                if (spill != null) {
                    myAdaptor.addItems(spill.createItemStack());
                }
                return true;
            }
            this.itemsToSend -= newItems.func_190916_E();
        } else {
            return true;
        }
        this.worked = true;
        return false;
    }

    private int calculateMaximumAmountToImport(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, FuzzyMode fzMode) {
        IAEItemStack itemAmountNotStorable;
        ItemStack simResult;
        int toSend = this.itemsToSend;
        ItemStack itemStackToImport = whatToImport == null ? ItemStack.field_190927_a : whatToImport.getDefinition();
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            simResult = myAdaptor.simulateSimilarRemove(toSend, itemStackToImport, fzMode, null);
            itemAmountNotStorable = (IAEItemStack)inv.injectItems((IAEStack)AEItemStack.fromItemStack((ItemStack)simResult), Actionable.SIMULATE, this.source);
        } else {
            simResult = myAdaptor.simulateRemove(toSend, itemStackToImport, null);
            itemAmountNotStorable = (IAEItemStack)inv.injectItems((IAEStack)AEItemStack.fromItemStack((ItemStack)simResult), Actionable.SIMULATE, this.source);
        }
        if (simResult.func_190926_b()) {
            return 0;
        }
        if (itemAmountNotStorable != null) {
            if ((long)simResult.func_190916_E() == itemAmountNotStorable.getStackSize()) {
                return 0;
            }
            return (int)Math.min((long)simResult.func_190916_E() - itemAmountNotStorable.getStackSize(), (long)toSend);
        }
        return toSend;
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().parts().improvedImportBus();
    }
}

