/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import dev.beecube31.crazyae2.common.interfaces.mana.IManaLinkableDevice;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEPartSharedBus;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.api.storage.IManaStorageChannel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.IManaPool;

public class PartManaExportBus
extends CrazyAEPartSharedBus
implements IManaLinkableDevice {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("crazyae", "part/mana/export_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/mana/export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/mana/export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/mana/export_bus_has_channel")});
    private final IActionSource source;
    private int connectionX = Integer.MIN_VALUE;
    private int connectionY = Integer.MIN_VALUE;
    private int connectionZ = Integer.MIN_VALUE;
    private boolean hasConnection;

    public PartManaExportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.source = new MachineSource((IActionHost)this);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        int[] connection;
        super.readFromNBT(extra);
        this.hasConnection = extra.func_74767_n("hasConnection");
        if (extra.func_74764_b("connection") && (connection = extra.func_74759_k("connection")).length > 0) {
            this.connectionX = connection[0];
            this.connectionY = connection[1];
            this.connectionZ = connection[2];
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        extra.func_74757_a("hasConnection", this.hasConnection);
        if (this.hasConnection) {
            int[] poz = new int[]{this.connectionX, this.connectionY, this.connectionZ};
            extra.func_74783_a("connection", poz);
        }
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            CrazyAEGuiHandler.openGUI(player, this.getHost().getTile(), this.getSide(), (Object)CrazyAEGuiBridge.IMPROVED_BUS);
        }
        return true;
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        return new TickingRequest(1, TickRates.ExportBus.getMax(), false, false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        if (this.hasConnection && !this.getTile().func_145831_w().field_72995_K) {
            BlockPos pos = new BlockPos(this.connectionX, this.connectionY, this.connectionZ);
            TileEntity te = this.getTile().func_145831_w().func_175625_s(pos);
            if (!(te instanceof IManaPool)) {
                this.hasConnection = false;
                return TickRateModulation.SLOWER;
            }
            IManaPool poolReceiver = (IManaPool)te;
            if (this.getTile().func_145831_w().func_175667_e(pos)) {
                try {
                    IAEItemStack simulate;
                    IEnergyGrid energyGrid = this.getProxy().getEnergy();
                    IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class));
                    AEItemStack item = AEItemStack.fromItemStack((ItemStack)CrazyAE.definitions().items().manaAsAEStack().maybeStack(Math.min(this.calculateManaToSend(), te.func_189517_E_().func_74762_e("manaCap") - ((IManaPool)te).getCurrentMana())).orElse(ItemStack.field_190927_a));
                    if (item != null && item.getStackSize() > 0L && (simulate = (IAEItemStack)Platform.poweredExtraction((IEnergySource)energyGrid, (IMEInventory)inv, (IAEStack)item, (IActionSource)this.source, (Actionable)Actionable.SIMULATE)) != null && simulate.getStackSize() > 0L) {
                        item.setStackSize(Math.min(item.getStackSize(), simulate.getStackSize()));
                        poolReceiver.recieveMana((int)item.getStackSize());
                        Platform.poweredExtraction((IEnergySource)energyGrid, (IMEInventory)inv, (IAEStack)item, (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                        return TickRateModulation.URGENT;
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    protected boolean isSleeping() {
        return false;
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @NotNull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public void link(int x, int y, int z) {
        this.hasConnection = true;
        this.connectionX = x;
        this.connectionY = y;
        this.connectionZ = z;
    }

    @Override
    public int getLinkedPoolPosX() {
        return this.connectionX;
    }

    @Override
    public int getLinkedPoolPosY() {
        return this.connectionY;
    }

    @Override
    public int getLinkedPoolPosZ() {
        return this.connectionZ;
    }

    @Override
    public boolean hasLinkedPool() {
        return this.hasConnection;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().parts().manaExportBus();
    }
}

