/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.parts.implementations.fluid;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import dev.beecube31.crazyae2.common.parts.implementations.fluid.CrazyAEPartSharedFluidBus;
import dev.beecube31.crazyae2.core.CrazyAE;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PartFluidExportBusImp
extends CrazyAEPartSharedFluidBus {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("crazyae", "part/fluid_export_bus_base_diamond");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/fluid_export_bus_off_diamond")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/fluid_export_bus_on_diamond")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("crazyae", "part/fluid_export_bus_has_channel_diamond")});
    private final IActionSource source;

    public PartFluidExportBusImp(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
        this.source = new MachineSource((IActionHost)this);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, TickRates.FluidExportBus.getMax(), false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    @Override
    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        TileEntity te = this.getConnectedTE();
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d())) {
            try {
                IFluidHandler fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d());
                IMEMonitor inv = this.getProxy().getStorage().getInventory((IStorageChannel)this.getChannel());
                if (fh != null) {
                    for (int i = 0; i < this.getConfig().getSlots(); ++i) {
                        int wasInserted;
                        IAEFluidStack fluid = this.getConfig().getFluidInSlot(i);
                        if (fluid == null) continue;
                        IAEFluidStack toExtract = fluid.copy();
                        toExtract.setStackSize((long)this.calculateFluidsToSend());
                        IAEFluidStack out = (IAEFluidStack)inv.extractItems((IAEStack)toExtract, Actionable.SIMULATE, this.source);
                        if (out == null || (wasInserted = fh.fill(out.getFluidStack(), true)) <= 0) continue;
                        toExtract.setStackSize((long)wasInserted);
                        inv.extractItems((IAEStack)toExtract, Actionable.MODULATE, this.source);
                        return TickRateModulation.URGENT;
                    }
                    return TickRateModulation.SLOWER;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().parts().improvedExportFluidBus();
    }
}

