/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.recipes.botania;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import quaternary.botaniatweaks.modules.botania.recipe.AgglomerationRecipe;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class RecipeTerraplate {
    public final ImmutableList<ItemStack> recipeStacks;
    public final ImmutableList<String> recipeOreKeys;
    public final ItemStack recipeOutput;
    public final int manaCost;
    final int totalInputs;

    private void verifyInputs(ImmutableList<Object> inputs) {
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("Can't make empty agglomeration recipe");
        }
        for (Object o : inputs) {
            if (o instanceof ItemStack || o instanceof String) continue;
            throw new IllegalArgumentException("illegal recipe input " + o);
        }
    }

    public RecipeTerraplate(ImmutableList<Object> recipeInputs, ItemStack recipeOutput, int manaCost) {
        this.verifyInputs(recipeInputs);
        ImmutableList.Builder stackInputBuilder = new ImmutableList.Builder();
        ImmutableList.Builder keyInputBuilder = new ImmutableList.Builder();
        for (Object o : recipeInputs) {
            if (o instanceof ItemStack) {
                stackInputBuilder.add((Object)((ItemStack)o));
                continue;
            }
            keyInputBuilder.add((Object)((String)o));
        }
        this.recipeStacks = stackInputBuilder.build();
        this.recipeOreKeys = keyInputBuilder.build();
        this.totalInputs = this.recipeStacks.size() + this.recipeOreKeys.size();
        this.recipeOutput = recipeOutput;
        this.manaCost = manaCost;
    }

    public RecipeTerraplate(AgglomerationRecipe s) {
        ImmutableList.Builder stackInputBuilder = new ImmutableList.Builder();
        ImmutableList.Builder keyInputBuilder = new ImmutableList.Builder();
        for (Object o : s.recipeStacks) {
            if (o instanceof ItemStack) {
                stackInputBuilder.add((Object)((ItemStack)o));
                continue;
            }
            keyInputBuilder.add((Object)((String)o));
        }
        this.recipeStacks = stackInputBuilder.build();
        this.recipeOreKeys = keyInputBuilder.build();
        this.totalInputs = this.recipeStacks.size() + this.recipeOreKeys.size();
        this.recipeOutput = s.recipeOutput;
        this.manaCost = s.manaCost;
    }

    public boolean matches(IItemHandler inv) {
        ItemStack stack;
        ArrayList<ItemStack> inputsMissing = new ArrayList<ItemStack>((Collection<ItemStack>)this.recipeStacks);
        for (int i = 0; i < inv.getSlots() && !(stack = inv.getStackInSlot(i)).func_190926_b(); ++i) {
            int stackIndex = -1;
            int oredictIndex = -1;
            for (int j = 0; j < inputsMissing.size(); ++j) {
                Object input = inputsMissing.get(j);
                if (input instanceof String) {
                    boolean found = false;
                    for (ItemStack ostack : OreDictionary.getOres((String)((String)input), (boolean)false)) {
                        if (!OreDictionary.itemMatches((ItemStack)ostack, (ItemStack)stack, (boolean)false)) continue;
                        oredictIndex = j;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!(input instanceof ItemStack) || !this.compareStacks((ItemStack)input, stack)) continue;
                stackIndex = j;
                break;
            }
            if (stackIndex != -1) {
                inputsMissing.remove(stackIndex);
                continue;
            }
            if (oredictIndex != -1) {
                inputsMissing.remove(oredictIndex);
                continue;
            }
            return false;
        }
        return inputsMissing.isEmpty();
    }

    private boolean compareStacks(ItemStack recipe, ItemStack supplied) {
        return recipe.func_77973_b() == supplied.func_77973_b() && recipe.func_77952_i() == supplied.func_77952_i() && ItemNBTHelper.matchTag((NBTBase)recipe.func_77978_p(), (NBTBase)supplied.func_77978_p());
    }

    public boolean itemsMatch(List<ItemStack> userInputs) {
        if (userInputs.isEmpty() || userInputs.size() != this.totalInputs) {
            return false;
        }
        int usedRecipeStackCount = 0;
        int usedOreKeyCount = 0;
        boolean[] usedUserInputs = new boolean[userInputs.size()];
        for (ItemStack recipeStack : this.recipeStacks) {
            for (int i = 0; i < userInputs.size(); ++i) {
                ItemStack userInputStack;
                if (usedUserInputs[i] || !this.compareStacks(recipeStack, userInputStack = userInputs.get(i)) || recipeStack.func_190916_E() != userInputStack.func_190916_E()) continue;
                ++usedRecipeStackCount;
                usedUserInputs[i] = true;
            }
        }
        if (usedRecipeStackCount != this.recipeStacks.size()) {
            return false;
        }
        for (String key : this.recipeOreKeys) {
            NonNullList matchingOres = OreDictionary.getOres((String)key);
            for (ItemStack oreStack : matchingOres) {
                for (int i = 0; i < userInputs.size(); ++i) {
                    ItemStack userInputStack;
                    if (usedUserInputs[i] || !this.compareStacks(oreStack, userInputStack = userInputs.get(i)) || userInputStack.func_190916_E() != 1) continue;
                    ++usedOreKeyCount;
                    usedUserInputs[i] = true;
                }
            }
        }
        return usedOreKeyCount == this.recipeOreKeys.size();
    }

    public ImmutableList<ItemStack> getRecipeStacks() {
        return this.recipeStacks;
    }

    public ImmutableList<String> getRecipeOreKeys() {
        return this.recipeOreKeys;
    }

    public int getManaCost() {
        return this.manaCost;
    }

    public ItemStack getOutput() {
        return this.recipeOutput;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RecipeTerraplate)) {
            return false;
        }
        RecipeTerraplate other = (RecipeTerraplate)obj;
        if (other.manaCost != this.manaCost) {
            return false;
        }
        if (!ItemStack.func_77989_b((ItemStack)other.recipeOutput, (ItemStack)this.recipeOutput)) {
            return false;
        }
        if (!new HashSet<String>((Collection<String>)other.recipeOreKeys).equals(new HashSet<String>((Collection<String>)this.recipeOreKeys))) {
            return false;
        }
        ArrayList<ItemStack> myStackCopy = new ArrayList<ItemStack>((Collection<ItemStack>)this.recipeStacks);
        for (ItemStack otherStack : other.recipeStacks) {
            myStackCopy.removeIf(stack -> ItemStack.func_77989_b((ItemStack)stack, (ItemStack)otherStack));
        }
        return myStackCopy.isEmpty();
    }
}

