/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.recipes.handlers;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import dev.beecube31.crazyae2.common.registration.Registration;
import dev.beecube31.crazyae2.common.registration.definitions.Blocks;
import dev.beecube31.crazyae2.common.registration.definitions.Items;
import dev.beecube31.crazyae2.common.registration.definitions.Materials;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public final class DisassembleRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final ItemStack MISMATCHED_STACK = ItemStack.field_190927_a;
    private final Map<IItemDefinition, IItemDefinition> cellMappings;
    private final Map<IItemDefinition, IItemDefinition> nonCellMappings;

    public DisassembleRecipe() {
        Registration definitions = CrazyAE.definitions();
        Blocks blocks = definitions.blocks();
        Items items = definitions.items();
        Materials mats = definitions.materials();
        this.cellMappings = new HashMap<IItemDefinition, IItemDefinition>(15);
        this.nonCellMappings = new HashMap<IItemDefinition, IItemDefinition>(11);
        this.cellMappings.put(items.storageCell256K(), mats.cellPart256K());
        this.cellMappings.put(items.storageCell1MB(), mats.cellPart1MB());
        this.cellMappings.put(items.storageCell4MB(), mats.cellPart4MB());
        this.cellMappings.put(items.storageCell16MB(), mats.cellPart16MB());
        this.cellMappings.put(items.storageCell64MB(), mats.cellPart64MB());
        this.cellMappings.put(items.storageCell256MB(), mats.cellPart256MB());
        this.cellMappings.put(items.storageCell1GB(), mats.cellPart1GB());
        this.cellMappings.put(items.storageCell2GB(), mats.cellPart2GB());
        this.cellMappings.put(items.fluidStorageCell256K(), mats.cellPart256K());
        this.cellMappings.put(items.fluidStorageCell1MB(), mats.cellPart1MB());
        this.cellMappings.put(items.fluidStorageCell4MB(), mats.cellPart4MB());
        this.cellMappings.put(items.fluidStorageCell16MB(), mats.cellPart16MB());
        this.cellMappings.put(items.fluidStorageCell64MB(), mats.cellPart64MB());
        this.cellMappings.put(items.fluidStorageCell256MB(), mats.cellPart256MB());
        this.cellMappings.put(items.fluidStorageCell1GB(), mats.cellPart1GB());
        this.cellMappings.put(items.fluidStorageCell2GB(), mats.cellPart2GB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage256k(), mats.cellPart256K());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage1mb(), mats.cellPart1MB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage4mb(), mats.cellPart4MB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage16mb(), mats.cellPart16MB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage64mb(), mats.cellPart64MB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage256mb(), mats.cellPart256MB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage1gb(), mats.cellPart1GB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage2gb(), mats.cellPart2GB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage8gb(), mats.cellPart8GB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage32gb(), mats.cellPart32GB());
        this.nonCellMappings.put((IItemDefinition)blocks.craftingStorage128gb(), mats.cellPart128GB());
    }

    private static <T extends IAEStack<T>> IItemList<T> getStorageList(ItemStack stack) {
        IAEStack item = (IAEStack)stack.func_77973_b();
        IStorageChannel channel = item.getChannel();
        ICellInventoryHandler cellInv = AEApi.instance().registries().cell().getCellInventory(stack, null, channel);
        assert (cellInv != null);
        return cellInv.getAvailableItems(channel.createList());
    }

    public boolean func_77569_a(@NotNull InventoryCrafting inv, @NotNull World w) {
        ItemStack output = this.getOutput((IInventory)inv);
        return output != null && !output.func_190926_b();
    }

    private ItemStack getOutput(IInventory inventory) {
        int itemCount = 0;
        ItemStack output = MISMATCHED_STACK;
        for (int slotIndex = 0; slotIndex < inventory.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inventory.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            if (++itemCount > 1) {
                return MISMATCHED_STACK;
            }
            Optional<ItemStack> maybeCellOutput = this.getCellOutput(stackInSlot);
            if (maybeCellOutput.isPresent()) {
                ItemStack storageCellStack = maybeCellOutput.get();
                IItemList storageList = DisassembleRecipe.getStorageList(storageCellStack);
                if (storageList.isEmpty()) {
                    return MISMATCHED_STACK;
                }
                output = storageCellStack;
            }
            output = this.getNonCellOutput(stackInSlot).orElse(output);
        }
        return output;
    }

    @Nonnull
    private Optional<ItemStack> getCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.cellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<ItemStack> getNonCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.nonCellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inv) {
        return this.getOutput((IInventory)inv);
    }

    public boolean func_194133_a(int i, int i1) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }
}

