/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.registration;

import appeng.bootstrap.IModelRegistry;
import appeng.bootstrap.components.IBlockRegistrationComponent;
import appeng.bootstrap.components.IInitComponent;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IModelRegistrationComponent;
import appeng.bootstrap.components.IPostInitComponent;
import appeng.bootstrap.components.IPreInitComponent;
import appeng.bootstrap.components.IRecipeRegistrationComponent;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import dev.beecube31.crazyae2.common.recipes.InscriberRecipesMaker;
import dev.beecube31.crazyae2.common.recipes.ManaPoolRecipesMaker;
import dev.beecube31.crazyae2.common.recipes.botania.RecipeRepo;
import dev.beecube31.crazyae2.common.recipes.handlers.DisassembleRecipe;
import dev.beecube31.crazyae2.common.registration.definitions.Blocks;
import dev.beecube31.crazyae2.common.registration.definitions.Items;
import dev.beecube31.crazyae2.common.registration.definitions.Materials;
import dev.beecube31.crazyae2.common.registration.definitions.Parts;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import dev.beecube31.crazyae2.common.registration.registry.Registry;
import dev.beecube31.crazyae2.integrations.ct.CraftTweakerPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Registration {
    private final Blocks blocks;
    private final Registry registry;
    private final Items items;
    private final Materials materials;
    private final Parts parts;
    private final Upgrades upgrades;

    public Registration() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registry = new Registry();
        this.materials = new Materials(this.registry);
        this.items = new Items(this.registry);
        this.parts = new Parts(this.registry);
        this.upgrades = new Upgrades(this.registry);
        this.blocks = new Blocks(this.registry);
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.registry.getBootstrapComponents(IPreInitComponent.class).forEachRemaining(b -> b.preInitialize(event.getSide()));
    }

    public void init(FMLInitializationEvent event) {
        this.registry.getBootstrapComponents(IInitComponent.class).forEachRemaining(b -> b.initialize(event.getSide()));
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.registry.getBootstrapComponents(IPostInitComponent.class).forEachRemaining(b -> b.postInitialize(event.getSide()));
        InscriberRecipesMaker.init();
        if (Loader.isModLoaded((String)"botania")) {
            ManaPoolRecipesMaker.init();
            if (Loader.isModLoaded((String)"botania_tweaks")) {
                RecipeRepo.copyFromBotaniaTweaks();
            } else {
                RecipeRepo.addDefaultTerrasteelRecipe();
            }
        }
        if (Loader.isModLoaded((String)"crafttweaker")) {
            this.initCraftTweakerPlugin();
        }
    }

    public void initCraftTweakerPlugin() {
        CraftTweakerPlugin.postInit();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        this.registry.getBootstrapComponents(IItemRegistrationComponent.class).forEachRemaining(b -> b.itemRegistration(side, registry));
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_DISASSEMBLY_CRAFTING)) {
            registry.register((IForgeRegistryEntry)((IRecipe)new DisassembleRecipe().setRegistryName("disassemble")));
        }
        this.registry.getBootstrapComponents(IRecipeRegistrationComponent.class).forEachRemaining(b -> b.recipeRegistration(side, registry));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        this.registry.getBootstrapComponents(IBlockRegistrationComponent.class).forEachRemaining(b -> b.blockRegistration(side, registry));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoaderWrapper registry = new ModelLoaderWrapper();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        this.registry.getBootstrapComponents(IModelRegistrationComponent.class).forEachRemaining(b -> b.modelRegistration(side, (IModelRegistry)registry));
    }

    public Blocks blocks() {
        return this.blocks;
    }

    public Items items() {
        return this.items;
    }

    public Materials materials() {
        return this.materials;
    }

    public Parts parts() {
        return this.parts;
    }

    public Upgrades upgrades() {
        return this.upgrades;
    }

    private static class ModelLoaderWrapper
    implements IModelRegistry {
        private ModelLoaderWrapper() {
        }

        public void registerItemVariants(Item item, ResourceLocation ... names) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])names);
        }

        public void setCustomModelResourceLocation(Item item, int metadata, ModelResourceLocation model) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)model);
        }

        public void setCustomMeshDefinition(Item item, ItemMeshDefinition meshDefinition) {
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
        }

        public void setCustomStateMapper(Block block, IStateMapper mapper) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }
}

