/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.registration.definitions;

import appeng.api.AEApi;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartModels;
import appeng.core.features.IStackSrc;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import com.google.common.collect.ImmutableList;
import dev.beecube31.crazyae2.common.features.Features;
import dev.beecube31.crazyae2.common.items.CrazyAEBaseItemPart;
import dev.beecube31.crazyae2.common.parts.implementations.PartEnergyExportBus;
import dev.beecube31.crazyae2.common.parts.implementations.PartEnergyImportBus;
import dev.beecube31.crazyae2.common.parts.implementations.PartEnergyTerminal;
import dev.beecube31.crazyae2.common.parts.implementations.PartExportBusImp;
import dev.beecube31.crazyae2.common.parts.implementations.PartImportBusImp;
import dev.beecube31.crazyae2.common.parts.implementations.PartManaExportBus;
import dev.beecube31.crazyae2.common.parts.implementations.PartManaImportBus;
import dev.beecube31.crazyae2.common.parts.implementations.PartManaTerminal;
import dev.beecube31.crazyae2.common.parts.implementations.PartPatternsInterface;
import dev.beecube31.crazyae2.common.parts.implementations.PartPerfectInterface;
import dev.beecube31.crazyae2.common.parts.implementations.fluid.PartFluidExportBusImp;
import dev.beecube31.crazyae2.common.parts.implementations.fluid.PartFluidImportBusImp;
import dev.beecube31.crazyae2.common.registration.registry.CrazyAEDamagedItemDefinition;
import dev.beecube31.crazyae2.common.registration.registry.Registry;
import dev.beecube31.crazyae2.common.registration.registry.helpers.PartModelsHelper;
import dev.beecube31.crazyae2.common.registration.registry.interfaces.Definitions;
import dev.beecube31.crazyae2.common.registration.registry.interfaces.IDefinition;
import dev.beecube31.crazyae2.common.registration.registry.rendering.CrazyAEItemPartRendering;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class Parts
implements Definitions<CrazyAEDamagedItemDefinition> {
    private final Object2ObjectOpenHashMap<String, CrazyAEDamagedItemDefinition> byId = new Object2ObjectOpenHashMap();
    private final CrazyAEBaseItemPart itemPart = new CrazyAEBaseItemPart();
    private final CrazyAEDamagedItemDefinition improvedImportBus;
    private final CrazyAEDamagedItemDefinition improvedExportBus;
    private final CrazyAEDamagedItemDefinition improvedImportFluidBus;
    private final CrazyAEDamagedItemDefinition improvedExportFluidBus;
    private final CrazyAEDamagedItemDefinition manaImportBus;
    private final CrazyAEDamagedItemDefinition manaExportBus;
    private final CrazyAEDamagedItemDefinition energyImportBus;
    private final CrazyAEDamagedItemDefinition energyExportBus;
    private final CrazyAEDamagedItemDefinition manaTerm;
    private final CrazyAEDamagedItemDefinition energyTerminal;
    private final CrazyAEDamagedItemDefinition partPatternsInterface;
    private final CrazyAEDamagedItemDefinition partPerfectInterface;

    public Parts(Registry registry) {
        registry.item("part", () -> this.itemPart).rendering(new CrazyAEItemPartRendering(this.itemPart)).build();
        IPartModels partModels = AEApi.instance().registries().partModels();
        for (PartType partType : PartType.values()) {
            partModels.registerModels(partType.getModels());
        }
        this.improvedImportBus = this.createPart(this.itemPart, PartType.IMPROVED_IMPORT_BUS);
        this.improvedExportBus = this.createPart(this.itemPart, PartType.IMPROVED_EXPORT_BUS);
        this.improvedImportFluidBus = this.createPart(this.itemPart, PartType.IMPROVED_IMPORT_FLUID_BUS);
        this.improvedExportFluidBus = this.createPart(this.itemPart, PartType.IMPROVED_EXPORT_FLUID_BUS);
        this.manaImportBus = this.createPart(this.itemPart, PartType.MANA_IMPORT_BUS);
        this.manaExportBus = this.createPart(this.itemPart, PartType.MANA_EXPORT_BUS);
        this.manaTerm = this.createPart(this.itemPart, PartType.MANA_TERM);
        this.energyTerminal = this.createPart(this.itemPart, PartType.ENERGY_TERM);
        this.partPatternsInterface = this.createPart(this.itemPart, PartType.PART_PATTERNS_IFACE);
        this.partPerfectInterface = this.createPart(this.itemPart, PartType.PART_PERFECT_IFACE);
        this.energyImportBus = this.createPart(this.itemPart, PartType.ENERGY_IMPORT_BUS);
        this.energyExportBus = this.createPart(this.itemPart, PartType.ENERGY_EXPORT_BUS);
    }

    public CrazyAEDamagedItemDefinition improvedImportBus() {
        return this.improvedImportBus;
    }

    public CrazyAEDamagedItemDefinition improvedExportBus() {
        return this.improvedExportBus;
    }

    public CrazyAEDamagedItemDefinition improvedImportFluidBus() {
        return this.improvedImportFluidBus;
    }

    public CrazyAEDamagedItemDefinition improvedExportFluidBus() {
        return this.improvedExportFluidBus;
    }

    public CrazyAEDamagedItemDefinition manaImportBus() {
        return this.manaImportBus;
    }

    public CrazyAEDamagedItemDefinition manaExportBus() {
        return this.manaExportBus;
    }

    public CrazyAEDamagedItemDefinition energyExportBus() {
        return this.energyExportBus;
    }

    public CrazyAEDamagedItemDefinition energyImportBus() {
        return this.energyImportBus;
    }

    public CrazyAEDamagedItemDefinition manaTerminal() {
        return this.manaTerm;
    }

    public CrazyAEDamagedItemDefinition energyTerminal() {
        return this.energyTerminal;
    }

    public CrazyAEDamagedItemDefinition perfectInterface() {
        return this.partPerfectInterface;
    }

    public CrazyAEDamagedItemDefinition patternsInterface() {
        return this.partPatternsInterface;
    }

    public static Optional<PartType> getById(int itemDamage) {
        return Optional.ofNullable((PartType)PartType.getCachedValues().getOrDefault((Object)itemDamage, null));
    }

    private CrazyAEDamagedItemDefinition createPart(CrazyAEBaseItemPart baseItemPart, PartType partType) {
        CrazyAEDamagedItemDefinition def = new CrazyAEDamagedItemDefinition(partType.getId(), (IStackSrc)baseItemPart.createPart(partType));
        this.byId.put((Object)partType.id, (Object)def);
        return def;
    }

    @Override
    public Optional<CrazyAEDamagedItemDefinition> getById(String id) {
        return Optional.ofNullable((CrazyAEDamagedItemDefinition)this.byId.getOrDefault((Object)id, null));
    }

    public static enum PartType implements IDefinition
    {
        IMPROVED_IMPORT_BUS("improved_import_bus", PartImportBusImp.class, Features.IMPROVED_BUSES),
        IMPROVED_EXPORT_BUS("improved_export_bus", PartExportBusImp.class, Features.IMPROVED_BUSES),
        IMPROVED_IMPORT_FLUID_BUS("improved_import_fluid_bus", PartFluidImportBusImp.class, Features.IMPROVED_BUSES),
        IMPROVED_EXPORT_FLUID_BUS("improved_export_fluid_bus", PartFluidExportBusImp.class, Features.IMPROVED_BUSES),
        MANA_IMPORT_BUS("mana_import_bus", PartManaImportBus.class, Features.MANA_BUSES),
        MANA_EXPORT_BUS("mana_export_bus", PartManaExportBus.class, Features.MANA_BUSES),
        MANA_TERM("mana_terminal", PartManaTerminal.class, Features.MANA_TERM),
        ENERGY_IMPORT_BUS("energy_import_bus", PartEnergyImportBus.class, Features.ENERGY_BUSES),
        ENERGY_EXPORT_BUS("energy_export_bus", PartEnergyExportBus.class, Features.ENERGY_BUSES),
        ENERGY_TERM("energy_terminal", PartEnergyTerminal.class, Features.ENERGY_TERM),
        PART_PERFECT_IFACE("part_perfect_iface", PartPerfectInterface.class, Features.PERFECT_INTERFACE),
        PART_PATTERNS_IFACE("part_patterns_iface", PartPatternsInterface.class, Features.PATTERNS_INTERFACE);

        private static Int2ObjectLinkedOpenHashMap<PartType> cachedValues;
        private final String id;
        private final Class<? extends IPart> clazz;
        private final int baseDamage;
        private final boolean enabled;
        private final Set<ResourceLocation> models;
        private Constructor<? extends IPart> constructor;
        private GuiText extraName;
        private final Features[] features;
        private List<ModelResourceLocation> itemModels;

        private PartType(String id, Class<? extends IPart> clazz, Features ... features) {
            this.id = id;
            this.clazz = clazz;
            this.baseDamage = this.ordinal();
            this.features = (Features[])ArrayUtils.add((Object[])features, (Object)Features.PARTS);
            boolean enabled = false;
            for (Features f : features) {
                if (!f.isEnabled() || f.getRequiredModid() != null && !Loader.isModLoaded((String)f.getRequiredModid())) continue;
                enabled = true;
            }
            this.enabled = enabled;
            if (this.enabled) {
                if (Platform.isClientInstall()) {
                    this.itemModels = this.createItemModels(id);
                }
                this.models = clazz != null ? new HashSet<ResourceLocation>(PartModelsHelper.createModels(clazz)) : Collections.emptySet();
            } else {
                if (Platform.isClientInstall()) {
                    this.itemModels = Collections.emptyList();
                }
                this.models = Collections.emptySet();
            }
        }

        private PartType(String id, Class<? extends IPart> clazz, Features features, GuiText extraName) {
            this(id, clazz, features);
            this.extraName = extraName;
        }

        public static Int2ObjectLinkedOpenHashMap<PartType> getCachedValues() {
            if (cachedValues == null) {
                cachedValues = new Int2ObjectLinkedOpenHashMap();
                Arrays.stream(PartType.values()).forEach(partType -> cachedValues.put(partType.ordinal(), partType));
            }
            return cachedValues;
        }

        @SideOnly(value=Side.CLIENT)
        private static ModelResourceLocation modelFromBaseName(String baseName) {
            return new ModelResourceLocation(new ResourceLocation("crazyae", "part/" + baseName), "inventory");
        }

        @SideOnly(value=Side.CLIENT)
        private List<ModelResourceLocation> createItemModels(String baseName) {
            return ImmutableList.of((Object)PartType.modelFromBaseName(baseName));
        }

        public Features[] getFeature() {
            return this.features;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBaseDamage() {
            return this.baseDamage;
        }

        public Class<? extends IPart> getPart() {
            return this.clazz;
        }

        public String getUnlocalizedName() {
            return "item.crazyae.part." + this.name().toLowerCase();
        }

        public GuiText getExtraName() {
            return this.extraName;
        }

        public Constructor<? extends IPart> getConstructor() {
            return this.constructor;
        }

        public void setConstructor(Constructor<? extends IPart> constructor) {
            this.constructor = constructor;
        }

        @SideOnly(value=Side.CLIENT)
        public List<ModelResourceLocation> getItemModels() {
            return this.itemModels;
        }

        public Set<ResourceLocation> getModels() {
            return this.models;
        }

        public String getId() {
            return this.id;
        }

        public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        }
    }
}

