/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.registration.registry;

import appeng.api.definitions.IItemDefinition;
import appeng.core.features.IStackSrc;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CrazyAEDamagedItemDefinition
implements IItemDefinition {
    private final String identifier;
    private final Optional<IStackSrc> source;

    public CrazyAEDamagedItemDefinition(@Nonnull String identifier, @Nonnull IStackSrc source) {
        this.identifier = (String)Preconditions.checkNotNull((Object)identifier);
        Preconditions.checkNotNull((Object)source);
        this.source = source.isEnabled() ? Optional.of(source) : Optional.empty();
    }

    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    public Optional<Item> maybeItem() {
        return this.source.map(IStackSrc::getItem);
    }

    public Optional<ItemStack> maybeStack(int stackSize) {
        return this.source.map(input -> input.stack(stackSize));
    }

    public boolean isEnabled() {
        return this.source.isPresent();
    }

    public boolean isSameAs(ItemStack comparableStack) {
        if (comparableStack.func_190926_b()) {
            return false;
        }
        return this.isEnabled() && comparableStack.func_77973_b() == this.source.get().getItem() && comparableStack.func_77952_i() == this.source.get().getDamage();
    }
}

