/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.registration.registry.builders;

import appeng.api.definitions.IBlockDefinition;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseItemBlock;
import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.components.IBlockRegistrationComponent;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IPreInitComponent;
import appeng.bootstrap.definitions.TileEntityDefinition;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockDefinition;
import appeng.core.features.BlockStackSrc;
import appeng.core.features.IStackSrc;
import appeng.core.features.TileDefinition;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.features.IFeature;
import dev.beecube31.crazyae2.common.registration.definitions.CreativeTab;
import dev.beecube31.crazyae2.common.registration.registry.Registry;
import dev.beecube31.crazyae2.common.registration.registry.builders.ICrazyAEBlockBuilder;
import dev.beecube31.crazyae2.common.registration.registry.rendering.CrazyAEBlockRendering;
import dev.beecube31.crazyae2.common.registration.registry.rendering.CrazyAEItemRendering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CrazyAEBlockDefinitionBuilder
implements ICrazyAEBlockBuilder {
    private final Registry registry;
    private final String registryName;
    private final Supplier<? extends Block> blockSupplier;
    private final List<BiFunction<Block, Item, IBootstrapComponent>> bootstrapComponents = new ArrayList<BiFunction<Block, Item, IBootstrapComponent>>();
    private final CreativeTabs creativeTab = CreativeTab.instance;
    @Nullable
    private IFeature[] features = null;
    @Nullable
    private AEFeature[] aeFeatures = null;
    private TileEntityDefinition tileEntityDefinition;
    private boolean disableItem = false;
    private Function<Block, ItemBlock> itemFactory;
    private String requiredMod;
    private String bannedMod;
    @SideOnly(value=Side.CLIENT)
    private CrazyAEBlockRendering blockRendering;
    @SideOnly(value=Side.CLIENT)
    private CrazyAEItemRendering itemRendering;
    @SideOnly(value=Side.CLIENT)
    private boolean jeiDescription;

    public CrazyAEBlockDefinitionBuilder(Registry registry, String id, Supplier<? extends Block> blockSupplier) {
        this.registry = registry;
        this.registryName = id;
        this.blockSupplier = blockSupplier;
        if (Platform.isClient()) {
            this.blockRendering = new CrazyAEBlockRendering();
            this.itemRendering = new CrazyAEItemRendering();
        }
    }

    @Override
    public CrazyAEBlockDefinitionBuilder bootstrap(BiFunction<Block, Item, IBootstrapComponent> callback) {
        this.bootstrapComponents.add(callback);
        return this;
    }

    @Override
    public ICrazyAEBlockBuilder features(IFeature ... features) {
        this.features = features;
        return this;
    }

    @Override
    public ICrazyAEBlockBuilder aeFeatures(AEFeature ... features) {
        this.aeFeatures = features;
        return this;
    }

    @Override
    public CrazyAEBlockDefinitionBuilder rendering(BlockRenderingCustomizer callback) {
        if (Platform.isClient()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public ICrazyAEBlockBuilder tileEntity(TileEntityDefinition tileEntityDefinition) {
        this.tileEntityDefinition = tileEntityDefinition;
        return this;
    }

    @Override
    public ICrazyAEBlockBuilder useCustomItemModel() {
        this.rendering(new BlockRenderingCustomizer(){

            @SideOnly(value=Side.CLIENT)
            public void customize(IBlockRendering rendering, IItemRendering itemRendering) {
                ModelResourceLocation model = new ModelResourceLocation(new ResourceLocation("crazyae", CrazyAEBlockDefinitionBuilder.this.registryName), "inventory");
                itemRendering.model(model).variants(new ResourceLocation[]{model});
            }
        });
        return this;
    }

    @Override
    public ICrazyAEBlockBuilder ifModPresent(String modid) {
        this.requiredMod = modid;
        return this;
    }

    @Override
    public ICrazyAEBlockBuilder disableIfModPresent(String modid) {
        this.bannedMod = modid;
        return this;
    }

    @Override
    public ICrazyAEBlockBuilder item(Function<Block, ItemBlock> factory) {
        this.itemFactory = factory;
        return this;
    }

    @Override
    public ICrazyAEBlockBuilder disableItem() {
        this.disableItem = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void customizeForClient(BlockRenderingCustomizer callback) {
        callback.customize((IBlockRendering)this.blockRendering, (IItemRendering)this.itemRendering);
    }

    @Override
    public ICrazyAEBlockBuilder withJEIDescription() {
        if (Platform.isClient()) {
            this.jeiDescription = true;
        }
        return this;
    }

    @Override
    public <T extends IBlockDefinition> T build() {
        if (this.features != null && Arrays.stream(this.features).noneMatch(IFeature::isEnabled) || this.aeFeatures != null && Arrays.stream(this.aeFeatures).noneMatch(AEFeature::isEnabled)) {
            return (T)new TileDefinition(this.registryName, null, null);
        }
        if (this.requiredMod != null) {
            if (Loader.isModLoaded((String)this.requiredMod) && (this.bannedMod == null || !Loader.isModLoaded((String)this.bannedMod))) {
                return this.buildBlock();
            }
            return (T)new TileDefinition(this.registryName, null, null);
        }
        if (this.bannedMod != null) {
            if (Loader.isModLoaded((String)this.bannedMod)) {
                return (T)new TileDefinition(this.registryName, null, null);
            }
            return this.buildBlock();
        }
        return this.buildBlock();
    }

    private <T extends IBlockDefinition> T buildBlock() {
        BlockDefinition definition;
        Block block = this.blockSupplier.get();
        block.setRegistryName("crazyae", this.registryName);
        block.func_149663_c("crazyae." + this.registryName);
        ItemBlock item = this.constructItemFromBlock(block);
        if (item != null) {
            item.setRegistryName("crazyae", this.registryName);
        }
        this.registry.addBootstrapComponent((IBootstrapComponent)((IBlockRegistrationComponent)(side, registry) -> registry.register((IForgeRegistryEntry)block)));
        if (item != null) {
            this.registry.addBootstrapComponent((IBootstrapComponent)((IItemRegistrationComponent)(side, registry) -> registry.register((IForgeRegistryEntry)item)));
        }
        block.func_149647_a(this.creativeTab);
        this.bootstrapComponents.forEach(component -> this.registry.addBootstrapComponent((IBootstrapComponent)component.apply(block, item)));
        if (this.tileEntityDefinition != null && block instanceof AEBaseTileBlock) {
            ((AEBaseTileBlock)block).setTileEntity(this.tileEntityDefinition.getTileEntityClass());
            if (this.tileEntityDefinition.getName() == null) {
                this.tileEntityDefinition.setName(this.registryName);
            }
        }
        if (Platform.isClient()) {
            if (block instanceof AEBaseTileBlock) {
                AEBaseTileBlock tileBlock = (AEBaseTileBlock)block;
                this.blockRendering.apply(this.registry, block, tileBlock.getTileEntityClass());
            } else {
                this.blockRendering.apply(this.registry, block, null);
            }
            if (item != null) {
                this.itemRendering.apply(this.registry, (Item)item);
            }
        }
        if (block instanceof AEBaseTileBlock) {
            this.registry.addBootstrapComponent((IBootstrapComponent)((IPreInitComponent)side -> AEBaseTile.registerTileItem((Class)(this.tileEntityDefinition == null ? ((AEBaseTileBlock)block).getTileEntityClass() : this.tileEntityDefinition.getTileEntityClass()), (IStackSrc)new BlockStackSrc(block, 0, ActivityState.Enabled))));
            if (this.tileEntityDefinition != null) {
                this.registry.tileEntityComponent.addTileEntity(this.tileEntityDefinition);
            }
            definition = new TileDefinition(this.registryName, (AEBaseTileBlock)block, item);
        } else {
            definition = new BlockDefinition(this.registryName, block, item);
        }
        return (T)definition;
    }

    @Nullable
    private ItemBlock constructItemFromBlock(Block block) {
        if (this.disableItem) {
            return null;
        }
        if (this.itemFactory != null) {
            return this.itemFactory.apply(block);
        }
        if (block instanceof AEBaseBlock) {
            return new AEBaseItemBlock(block);
        }
        return new ItemBlock(block);
    }
}

