/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.registration.registry.builders;

import appeng.api.definitions.IItemDefinition;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IPostInitComponent;
import appeng.core.features.ItemDefinition;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.features.Features;
import dev.beecube31.crazyae2.common.features.IFeature;
import dev.beecube31.crazyae2.common.registration.definitions.CreativeTab;
import dev.beecube31.crazyae2.common.registration.registry.Registry;
import dev.beecube31.crazyae2.common.registration.registry.builders.ICrazyAEItemBuilder;
import dev.beecube31.crazyae2.common.registration.registry.rendering.CrazyAEItemRendering;
import dev.beecube31.crazyae2.integrations.jei.JEIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CrazyAEItemDefinitionBuilder
implements ICrazyAEItemBuilder {
    private final Registry registry;
    private final String registryName;
    private final Supplier<Item> itemSupplier;
    private final List<Function<Item, IBootstrapComponent>> boostrapComponents = new ArrayList<Function<Item, IBootstrapComponent>>();
    @Nullable
    private Features[] features = null;
    private Supplier<IBehaviorDispenseItem> dispenserBehaviorSupplier;
    @SideOnly(value=Side.CLIENT)
    private CrazyAEItemRendering itemRendering;
    private CreativeTabs creativeTab = CreativeTab.instance;
    private String requiredMod;
    private String bannedMod;
    private boolean forceDisable = false;
    private boolean hidden;

    public CrazyAEItemDefinitionBuilder(Registry registry, String registryName, Supplier<Item> itemSupplier) {
        this.registry = registry;
        this.registryName = registryName;
        this.itemSupplier = itemSupplier;
        if (Platform.isClient()) {
            this.itemRendering = new CrazyAEItemRendering();
        }
    }

    @Override
    public ICrazyAEItemBuilder bootstrap(Function<Item, IBootstrapComponent> component) {
        this.boostrapComponents.add(component);
        return this;
    }

    @Override
    public ICrazyAEItemBuilder features(Features ... features) {
        this.features = features;
        return this;
    }

    @Override
    public ICrazyAEItemBuilder ifModPresent(String modid) {
        this.requiredMod = modid;
        return this;
    }

    @Override
    public ICrazyAEItemBuilder disableIfModPresent(String modid) {
        this.bannedMod = modid;
        return this;
    }

    @Override
    public ICrazyAEItemBuilder creativeTab(CreativeTabs tab) {
        this.creativeTab = tab;
        return this;
    }

    @Override
    public ICrazyAEItemBuilder rendering(ItemRenderingCustomizer callback) {
        if (Platform.isClient()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public ICrazyAEItemBuilder dispenserBehavior(Supplier<IBehaviorDispenseItem> behavior) {
        this.dispenserBehaviorSupplier = behavior;
        return this;
    }

    @Override
    public ICrazyAEItemBuilder setDisabled() {
        this.forceDisable = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void customizeForClient(ItemRenderingCustomizer callback) {
        callback.customize((IItemRendering)this.itemRendering);
    }

    @Override
    public ICrazyAEItemBuilder hide() {
        this.hidden = true;
        return this;
    }

    @Override
    public ItemDefinition build() {
        if (this.features != null && Arrays.stream(this.features).noneMatch(IFeature::isEnabled) || this.forceDisable) {
            return new ItemDefinition(this.registryName, null);
        }
        if (this.requiredMod != null) {
            if (Loader.isModLoaded((String)this.requiredMod) && (this.bannedMod == null || !Loader.isModLoaded((String)this.bannedMod))) {
                return this.buildItem();
            }
            return new ItemDefinition(this.registryName, null);
        }
        if (this.bannedMod != null) {
            if (Loader.isModLoaded((String)this.bannedMod)) {
                return new ItemDefinition(this.registryName, null);
            }
            return this.buildItem();
        }
        return this.buildItem();
    }

    private ItemDefinition buildItem() {
        Item item = this.itemSupplier.get();
        item.setRegistryName("crazyae", this.registryName);
        ItemDefinition definition = new ItemDefinition(this.registryName, item);
        item.func_77655_b("crazyae." + this.registryName);
        if (!this.hidden) {
            item.func_77637_a(this.creativeTab);
        }
        this.boostrapComponents.forEach(component -> this.registry.addBootstrapComponent((IBootstrapComponent)component.apply(item)));
        if (this.dispenserBehaviorSupplier != null) {
            this.registry.addBootstrapComponent((IBootstrapComponent)((IPostInitComponent)side -> {
                IBehaviorDispenseItem behavior = this.dispenserBehaviorSupplier.get();
                BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)behavior);
            }));
        }
        this.registry.addBootstrapComponent((IBootstrapComponent)((IItemRegistrationComponent)(side, reg) -> reg.register((IForgeRegistryEntry)item)));
        if (Platform.isClient()) {
            if (this.hidden && Platform.isModLoaded((String)"jei")) {
                JEIPlugin.hideItemFromJEI((IItemDefinition)definition);
            }
            this.itemRendering.apply(this.registry, item);
        }
        return definition;
    }
}

