/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.registration.upgrades;

import appeng.api.definitions.IItemDefinition;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UpgradesInfoProvider {
    private static final Multimap<IItemDefinition, Upgrades.UpgradesFeatureSetParser.FeatureEntry> UPGRADES_MAP = ArrayListMultimap.create();

    public static void addUpgradeInfo(@NotNull IItemDefinition block, @NotNull Upgrades.UpgradesFeatureSetParser.FeatureEntry inf) {
        Preconditions.checkNotNull((Object)block, (Object)"Trying to set UpgradeInfo for null block");
        Preconditions.checkNotNull((Object)inf, (Object)"Trying to set null UpgradeInfo for block");
        if (!UPGRADES_MAP.containsEntry((Object)block, (Object)inf)) {
            UPGRADES_MAP.put((Object)block, (Object)inf);
        }
    }

    public static List<Upgrades.UpgradesFeatureSetParser.FeatureEntry> getUpgradeInfo(@NotNull IItemDefinition block) {
        Preconditions.checkNotNull((Object)block, (Object)"Trying to get UpgradeInfo for null block");
        ArrayList<Upgrades.UpgradesFeatureSetParser.FeatureEntry> ret = new ArrayList<Upgrades.UpgradesFeatureSetParser.FeatureEntry>();
        UPGRADES_MAP.forEach((iItemDefinition, featureEntry) -> {
            if (block.equals(iItemDefinition)) {
                ret.add((Upgrades.UpgradesFeatureSetParser.FeatureEntry)featureEntry);
            }
        });
        return ret;
    }

    public static Multimap<IItemDefinition, Upgrades.UpgradesFeatureSetParser.FeatureEntry> getUpgradesMap() {
        return UPGRADES_MAP;
    }
}

