/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.sync;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.exceptions.AppEngException;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.sync.GuiHostType;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.Platform;
import dev.beecube31.crazyae2.client.gui.CrazyAEBaseGui;
import dev.beecube31.crazyae2.common.containers.ContainerBigCrystalCharger;
import dev.beecube31.crazyae2.common.containers.ContainerBotaniaDevicePatternsInv;
import dev.beecube31.crazyae2.common.containers.ContainerBreweryMechanical;
import dev.beecube31.crazyae2.common.containers.ContainerColorizerGui;
import dev.beecube31.crazyae2.common.containers.ContainerColorizerText;
import dev.beecube31.crazyae2.common.containers.ContainerCraftingBlockList;
import dev.beecube31.crazyae2.common.containers.ContainerCraftingUnitsCombiner;
import dev.beecube31.crazyae2.common.containers.ContainerCrazyAEUpgradeable;
import dev.beecube31.crazyae2.common.containers.ContainerDriveImproved;
import dev.beecube31.crazyae2.common.containers.ContainerElventradeMechanical;
import dev.beecube31.crazyae2.common.containers.ContainerEnergyBus;
import dev.beecube31.crazyae2.common.containers.ContainerEnergyBusSettings;
import dev.beecube31.crazyae2.common.containers.ContainerEnergyTerminal;
import dev.beecube31.crazyae2.common.containers.ContainerFastMAC;
import dev.beecube31.crazyae2.common.containers.ContainerIOPortImproved;
import dev.beecube31.crazyae2.common.containers.ContainerImprovedCondenser;
import dev.beecube31.crazyae2.common.containers.ContainerImprovedFluidBuses;
import dev.beecube31.crazyae2.common.containers.ContainerMEPortableCellColorizeable;
import dev.beecube31.crazyae2.common.containers.ContainerManaTerminal;
import dev.beecube31.crazyae2.common.containers.ContainerManapoolMechanical;
import dev.beecube31.crazyae2.common.containers.ContainerPartDrive;
import dev.beecube31.crazyae2.common.containers.ContainerPatternsInterface;
import dev.beecube31.crazyae2.common.containers.ContainerPerfectInterface;
import dev.beecube31.crazyae2.common.containers.ContainerPetalMechanical;
import dev.beecube31.crazyae2.common.containers.ContainerPriority;
import dev.beecube31.crazyae2.common.containers.ContainerPuredaisyMechanical;
import dev.beecube31.crazyae2.common.containers.ContainerQuantumCPU;
import dev.beecube31.crazyae2.common.containers.ContainerQuantumInterface;
import dev.beecube31.crazyae2.common.containers.ContainerRunealtarMechanical;
import dev.beecube31.crazyae2.common.containers.ContainerTeraplateMechanical;
import dev.beecube31.crazyae2.common.containers.ContainerTrashcan;
import dev.beecube31.crazyae2.common.containers.ContainerTrashcanEnergy;
import dev.beecube31.crazyae2.common.containers.ContainerTrashcanFluid;
import dev.beecube31.crazyae2.common.containers.ContainerTrashcanMana;
import dev.beecube31.crazyae2.common.containers.base.CrazyAEBaseContainer;
import dev.beecube31.crazyae2.common.interfaces.ICrazyAEGuiItem;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.common.interfaces.upgrades.IUpgradesInfoProvider;
import dev.beecube31.crazyae2.common.items.ColorizerObj;
import dev.beecube31.crazyae2.common.items.PatternsUSBStickObj;
import dev.beecube31.crazyae2.common.parts.implementations.PartDrive;
import dev.beecube31.crazyae2.common.parts.implementations.fluid.CrazyAEPartSharedFluidBus;
import dev.beecube31.crazyae2.common.tile.botania.TileBotaniaMechanicalMachineBase;
import dev.beecube31.crazyae2.common.tile.botania.TileMechanicalBrewery;
import dev.beecube31.crazyae2.common.tile.botania.TileMechanicalElventrade;
import dev.beecube31.crazyae2.common.tile.botania.TileMechanicalManapool;
import dev.beecube31.crazyae2.common.tile.botania.TileMechanicalPetal;
import dev.beecube31.crazyae2.common.tile.botania.TileMechanicalPuredaisy;
import dev.beecube31.crazyae2.common.tile.botania.TileMechanicalRunealtar;
import dev.beecube31.crazyae2.common.tile.botania.TileMechanicalTerraplate;
import dev.beecube31.crazyae2.common.tile.crafting.TileImprovedMAC;
import dev.beecube31.crazyae2.common.tile.crafting.TileQuantumCPU;
import dev.beecube31.crazyae2.common.tile.misc.TileImprovedCondenser;
import dev.beecube31.crazyae2.common.tile.networking.TileBigCrystalCharger;
import dev.beecube31.crazyae2.common.tile.networking.TileCraftingUnitsCombiner;
import dev.beecube31.crazyae2.common.tile.networking.TileImprovedIOPort;
import dev.beecube31.crazyae2.common.tile.storage.TileImprovedDrive;
import dev.beecube31.crazyae2.common.tile.trashcans.TileTrashcanEnergy;
import dev.beecube31.crazyae2.common.tile.trashcans.TileTrashcanFluids;
import dev.beecube31.crazyae2.common.tile.trashcans.TileTrashcanItems;
import dev.beecube31.crazyae2.common.tile.trashcans.TileTrashcanMana;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum CrazyAEGuiBridge {
    STUB,
    GUI_PRIORITY(IPriorityHost.class, ContainerPriority.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_CRAFTING_BLOCKS_LIST(ICrazyCraftHost.class, ContainerCraftingBlockList.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    IMPROVED_MOLECULAR_ASSEMBLER(TileImprovedMAC.class, ContainerFastMAC.class, GuiHostType.WORLD, null),
    QUANTUM_CPU_HOST(TileQuantumCPU.class, ContainerQuantumCPU.class, GuiHostType.WORLD, null),
    IMPROVED_DRIVE(TileImprovedDrive.class, ContainerDriveImproved.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    IMPROVED_IO_PORT(TileImprovedIOPort.class, ContainerIOPortImproved.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    CRAFTING_UNITS_COMBINER(TileCraftingUnitsCombiner.class, ContainerCraftingUnitsCombiner.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    BIG_CRYSTAL_CHARGER(TileBigCrystalCharger.class, ContainerBigCrystalCharger.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    IMPROVED_BUS(IUpgradesInfoProvider.class, ContainerCrazyAEUpgradeable.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    ENERGY_BUS(IUpgradesInfoProvider.class, ContainerEnergyBus.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    IMPROVED_FLUID_BUSES(CrazyAEPartSharedFluidBus.class, ContainerImprovedFluidBuses.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    IMPROVED_CONDENSER(TileImprovedCondenser.class, ContainerImprovedCondenser.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    PATTERN_INTERFACE(IInterfaceHost.class, ContainerPatternsInterface.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    QUANTUM_INTERFACE(IInterfaceHost.class, ContainerQuantumInterface.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    PERFECT_INTERFACE(IInterfaceHost.class, ContainerPerfectInterface.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_MANA_TERMINAL(ITerminalHost.class, ContainerManaTerminal.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_ENERGY_TERMINAL(ITerminalHost.class, ContainerEnergyTerminal.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_DRIVE_PART(PartDrive.class, ContainerPartDrive.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_ELVENTRADE_MECHANICAL(TileMechanicalElventrade.class, ContainerElventradeMechanical.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_MANAPOOL_MECHANICAL(TileMechanicalManapool.class, ContainerManapoolMechanical.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_PETAL_MECHANICAL(TileMechanicalPetal.class, ContainerPetalMechanical.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_PUREDAISY_MECHANICAL(TileMechanicalPuredaisy.class, ContainerPuredaisyMechanical.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_RUNEALTAR_MECHANICAL(TileMechanicalRunealtar.class, ContainerRunealtarMechanical.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_TERAPLATE_MECHANICAL(TileMechanicalTerraplate.class, ContainerTeraplateMechanical.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_BREWERY_MECHANICAL(TileMechanicalBrewery.class, ContainerBreweryMechanical.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_TRASHCAN_ITEMS(TileTrashcanItems.class, ContainerTrashcan.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_TRASHCAN_FLUID(TileTrashcanFluids.class, ContainerTrashcanFluid.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_TRASHCAN_MANA(TileTrashcanMana.class, ContainerTrashcanMana.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_TRASHCAN_ENERGY(TileTrashcanEnergy.class, ContainerTrashcanEnergy.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_TRASHCAN_EXP(TileTrashcanItems.class, ContainerTrashcan.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_MECHANICAL_DEVICE_PATTERN_INV(TileBotaniaMechanicalMachineBase.class, ContainerBotaniaDevicePatternsInv.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_ENERGY_BUS_SETTINGS(IUpgradesInfoProvider.class, ContainerEnergyBusSettings.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    GUI_DENSE_PORTABLE_CELL(IPortableCell.class, ContainerMEPortableCellColorizeable.class, GuiHostType.ITEM, null),
    GUI_ITEM_COLORIZER_GUI(ColorizerObj.class, ContainerColorizerGui.class, GuiHostType.ITEM, SecurityPermissions.BUILD),
    GUI_ITEM_COLORIZER_TEXT(ColorizerObj.class, ContainerColorizerText.class, GuiHostType.ITEM, SecurityPermissions.BUILD),
    GUI_USB_PATTERNS_STICK(PatternsUSBStickObj.class, ContainerColorizerGui.class, GuiHostType.ITEM, SecurityPermissions.BUILD);

    private static CrazyAEGuiBridge[] cachedValues;
    private final Class<?> clazz;
    private final Class<? extends CrazyAEBaseContainer> containerClass;
    private final GuiHostType hostType;
    private final SecurityPermissions securityPermissions;
    @SideOnly(value=Side.CLIENT)
    private Class<? super CrazyAEBaseGui> clientGuiClass;

    private CrazyAEGuiBridge(Class<?> clazz, Class<? extends CrazyAEBaseContainer> containerClass, GuiHostType hostType, SecurityPermissions securityPermissions) {
        this.hostType = hostType;
        this.securityPermissions = securityPermissions;
        this.clazz = clazz;
        this.containerClass = containerClass;
        this.getGui();
    }

    private CrazyAEGuiBridge() {
        this.clazz = null;
        this.containerClass = null;
        this.hostType = null;
        this.securityPermissions = null;
    }

    private static CrazyAEGuiBridge[] cachedValues() {
        if (cachedValues == null) {
            cachedValues = CrazyAEGuiBridge.values();
            return cachedValues;
        }
        return cachedValues;
    }

    @Nullable
    public static CrazyAEGuiBridge getByID(int id) {
        if (id < 0 || id > CrazyAEGuiBridge.cachedValues().length) {
            return null;
        }
        return cachedValues[id];
    }

    static Object getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z, AEPartLocation side) {
        if (!it.func_190926_b()) {
            Item item = it.func_77973_b();
            if (item instanceof ICrazyAEGuiItem) {
                ICrazyAEGuiItem ngi = (ICrazyAEGuiItem)item;
                return ngi.getGuiObject(it, w, new BlockPos(x, y, z), side);
            }
            IWirelessTermHandler wh = AEApi.instance().registries().wireless().getWirelessTerminalHandler(it);
            if (wh != null) {
                return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
            }
        }
        return null;
    }

    static Object getGuiObject(ItemStack it, World w, BlockPos pos) {
        Item item;
        if (!it.func_190926_b() && (item = it.func_77973_b()) instanceof ICrazyAEGuiItem) {
            ICrazyAEGuiItem ngi = (ICrazyAEGuiItem)item;
            return ngi.getGuiObject(it, w, pos);
        }
        return null;
    }

    public boolean CorrectTileOrPart(Object tE) {
        if (this.clazz == null) {
            throw new IllegalArgumentException("This Gui Cannot use the standard Handler.");
        }
        return this.clazz.isInstance(tE);
    }

    private void getGui() {
        if (Platform.isClientInstall()) {
            CrazyAEBaseGui.class.getName();
            String start = this.containerClass.getName();
            String guiClass = start.replaceFirst("common.containers.Container", "client.gui.implementations.Gui");
            if (start.equals(guiClass)) {
                throw new IllegalStateException("Unable to find gui class: " + start + "/" + guiClass);
            }
            this.clientGuiClass = ReflectionHelper.getClass((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String[])new String[]{guiClass});
        }
    }

    private Constructor<?> findConstructor(Constructor<?>[] constructors, InventoryPlayer inventory, Object tE) {
        for (Constructor<?> con : constructors) {
            Class<?>[] types = con.getParameterTypes();
            if (types.length != 2 || !types[0].isAssignableFrom(inventory.getClass()) || !types[1].isAssignableFrom(tE.getClass())) continue;
            return con;
        }
        return null;
    }

    private String typeName(Object inventory) {
        return inventory == null ? "NULL" : inventory.getClass().getName();
    }

    public Object ConstructContainer(InventoryPlayer inventory, Object tE) {
        try {
            Constructor<?>[] c = this.containerClass.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            Constructor<?> target = this.findConstructor(c, inventory, tE);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + this.containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(tE) + " )");
            }
            return target.newInstance(inventory, tE);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public GuiHostType getHostType() {
        return this.hostType;
    }

    public Object ConstructGui(InventoryPlayer inventory, Object tE) {
        try {
            Constructor<?>[] c = this.clientGuiClass.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            Constructor<?> target = this.findConstructor(c, inventory, tE);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + this.containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(tE) + " )");
            }
            return target.newInstance(inventory, tE);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public boolean hasPermissions(TileEntity te, int x, int y, int z, AEPartLocation side, EntityPlayer player) {
        World w = player.func_130014_f_();
        BlockPos pos = new BlockPos(x, y, z);
        if (Platform.hasPermissions((DimensionalCoord)(te != null ? new DimensionalCoord(te) : new DimensionalCoord(player.field_70170_p, pos)), (EntityPlayer)player)) {
            Object myItem;
            ItemStack it;
            if (this.hostType.isItem() && !(it = player.field_71071_by.func_70448_g()).func_190926_b() && it.func_77973_b() instanceof ICrazyAEGuiItem && this.CorrectTileOrPart(myItem = ((ICrazyAEGuiItem)it.func_77973_b()).getGuiObject(it, w, pos, side))) {
                return true;
            }
            if (!this.hostType.isItem()) {
                TileEntity TE = w.func_175625_s(pos);
                if (TE instanceof IPartHost) {
                    ((IPartHost)TE).getPart(side);
                    IPart part = ((IPartHost)TE).getPart(side);
                    if (this.CorrectTileOrPart(part)) {
                        return this.securityCheck(part, player);
                    }
                } else if (this.CorrectTileOrPart(TE)) {
                    return this.securityCheck(TE, player);
                }
            }
        }
        return false;
    }

    private boolean securityCheck(Object te, EntityPlayer player) {
        if (te instanceof IActionHost && this.securityPermissions != null) {
            IGridNode gn = ((IActionHost)te).getActionableNode();
            IGrid g = gn.getGrid();
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            return sg.hasPermission(player, this.securityPermissions);
        }
        return true;
    }
}

