/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.botania;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.me.GridAccessException;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import dev.beecube31.crazyae2.common.interfaces.device.mechanical.IBotaniaMechanicalDevice;
import dev.beecube31.crazyae2.common.interfaces.upgrades.IUpgradesInfoProvider;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import dev.beecube31.crazyae2.common.tile.base.CrazyAENetworkInvOCTile;
import dev.beecube31.crazyae2.common.util.AEUtils;
import dev.beecube31.crazyae2.common.util.NBTUtils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.api.storage.IManaStorageChannel;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileBotaniaMechanicalMachineBase
extends CrazyAENetworkInvOCTile
implements IBotaniaMechanicalDevice,
IUpgradesInfoProvider,
IConfigManagerHost,
IGridTickable,
ICraftingMedium,
ICraftingProvider {
    protected List<ICraftingPatternDetails> craftingList = null;
    protected List<CraftingTask> queueMap = new ArrayList<CraftingTask>();
    protected CrazyAEInternalInv craftingInputInv;
    protected CrazyAEInternalInv craftingOutputInv;
    protected final CrazyAEInternalInv internalPatternsStorageInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 45);
    protected final CrazyAEInternalInv patternsInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 2);
    protected final CrazyAEInternalInv findSlot = new CrazyAEInternalInv((IAEAppEngInventory)this, 1, 1);
    protected final IConfigManager settings = new ConfigManager((IConfigManagerHost)this);
    protected CrazyAEBlockUpgradeInv upgrades;
    protected boolean isPowered = false;
    protected boolean cached = false;
    protected IActionSource actionSource;
    protected int tasksQueued = 0;
    protected int tasksMaxAmt = 1;
    protected int progressPerTick = 1;
    protected int itemsPerTick = 1;
    protected boolean isRecipeValidated = false;

    public TileBotaniaMechanicalMachineBase() {
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getProxy().setIdlePowerUsage(64.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public boolean canBeRotated() {
        return false;
    }

    protected int getUpgradeSlots() {
        return 5;
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    public int getInstalledCustomUpgrades(Upgrades.UpgradeType u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        NBTUtils.writeQueueMapToNBT(this.queueMap, data, "queueMap");
        data.func_74768_a("tasksAmt", this.tasksQueued);
        this.patternsInv.writeToNBT(data, "patterns");
        this.internalPatternsStorageInv.writeToNBT(data, "patternsInternal");
        this.craftingOutputInv.writeToNBT(data, "output");
        this.craftingInputInv.writeToNBT(data, "input");
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tasksQueued = data.func_74762_e("tasksAmt");
        this.queueMap = NBTUtils.readQueueMapFromNBT(data, "queueMap");
        this.patternsInv.readFromNBT(data, "patterns");
        this.internalPatternsStorageInv.readFromNBT(data, "patternsInternal");
        this.craftingOutputInv.readFromNBT(data, "output");
        this.craftingInputInv.readFromNBT(data, "input");
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    public IItemHandler getInventoryByName(String name) {
        AppEngInternalInventory appEngInternalInventory;
        switch (name) {
            case "upgrades": {
                appEngInternalInventory = this.upgrades;
                break;
            }
            case "input": {
                appEngInternalInventory = this.craftingInputInv;
                break;
            }
            case "output": {
                appEngInternalInventory = this.craftingOutputInv;
                break;
            }
            case "patterns": {
                appEngInternalInventory = this.patternsInv;
                break;
            }
            case "patternsInternal": {
                appEngInternalInventory = this.internalPatternsStorageInv;
                break;
            }
            case "findSlot": {
                appEngInternalInventory = this.findSlot;
                break;
            }
            default: {
                appEngInternalInventory = null;
            }
        }
        return appEngInternalInventory;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getProxy().getNode().isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                craftingTracker.addCraftingOption((ICraftingMedium)this, details);
            }
        }
    }

    protected void updateCraftingList() {
        Object[] accountedFor = new Boolean[this.internalPatternsStorageInv.getSlots()];
        Arrays.fill(accountedFor, (Object)false);
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.internalPatternsStorageInv.getStackInSlot(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (((Boolean)accountedFor[x]).booleanValue()) continue;
            this.addToCraftingList(this.internalPatternsStorageInv.getStackInSlot(x));
        }
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is.func_190926_b()) {
            return;
        }
        Item item = is.func_77973_b();
        if (item instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)item).getPatternForItem(is, this.func_145831_w())) != null) {
            if (this.craftingList == null) {
                this.craftingList = new ArrayList<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    protected void notifyPatternsChanged() {
        try {
            if (this.getProxy().isActive()) {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
                this.cached = true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (Platform.isServer()) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
        }
    }

    public void onReady() {
        super.onReady();
        if (Platform.isServer()) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
            this.checkUpgrades();
        }
    }

    public abstract boolean pushPattern(ICraftingPatternDetails var1, InventoryCrafting var2);

    public boolean isBusy() {
        return this.tasksQueued >= this.tasksMaxAmt;
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        ItemStack is;
        for (int h = 0; h < this.upgrades.getSlots(); ++h) {
            is = this.upgrades.getStackInSlot(h);
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
        Iterator iterator = this.patternsInv.iterator();
        while (iterator.hasNext()) {
            is = (ItemStack)iterator.next();
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
        iterator = this.internalPatternsStorageInv.iterator();
        while (iterator.hasNext()) {
            is = (ItemStack)iterator.next();
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    protected void checkUpgrades() {
        this.itemsPerTick = 0;
        this.tasksMaxAmt = 0;
        this.progressPerTick = 0;
        switch (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.STACKS)) {
            case 1: {
                this.itemsPerTick += 8;
                this.tasksMaxAmt += 8;
                this.progressPerTick += 10;
                break;
            }
            case 2: {
                this.itemsPerTick += 24;
                this.tasksMaxAmt += 24;
                this.progressPerTick += 25;
                break;
            }
            case 3: {
                this.itemsPerTick += 48;
                this.tasksMaxAmt += 48;
                this.progressPerTick += 50;
                break;
            }
            case 4: {
                this.itemsPerTick += 192;
                this.tasksMaxAmt += 192;
                this.progressPerTick += 100;
                break;
            }
            case 5: {
                this.itemsPerTick += 320;
                this.tasksMaxAmt += 320;
                this.progressPerTick += 100;
            }
        }
        switch (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.IMPROVED_SPEED)) {
            case 1: {
                this.progressPerTick += 2;
                break;
            }
            case 2: {
                this.progressPerTick += 5;
                break;
            }
            case 3: {
                this.progressPerTick += 10;
                break;
            }
            case 4: {
                this.progressPerTick += 15;
                break;
            }
            case 5: {
                this.progressPerTick += 20;
            }
        }
        if (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.ADVANCED_SPEED) > 0) {
            this.progressPerTick += 100;
        }
        if (this.progressPerTick > 100) {
            this.progressPerTick = 100;
        }
        if (this.progressPerTick <= 0) {
            this.progressPerTick = 1;
        }
        if (this.itemsPerTick <= 0) {
            this.itemsPerTick = 1;
        }
        if (this.tasksMaxAmt <= 0) {
            this.tasksMaxAmt = 1;
        }
    }

    @Nullable
    protected IAEItemStack pushItemsOut(IAEItemStack is) {
        try {
            IMEMonitor storage = ((IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IAEItemStack overflow = (IAEItemStack)storage.injectItems((IAEStack)is, Actionable.SIMULATE, this.actionSource);
            if (overflow == null) {
                storage.injectItems((IAEStack)is, Actionable.MODULATE, this.actionSource);
                return null;
            }
            return is;
        }
        catch (GridAccessException gridAccessException) {
            return is;
        }
    }

    protected boolean tryUseMana(int amt) {
        try {
            IAEItemStack simulate;
            IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class));
            AEItemStack item = AEItemStack.fromItemStack((ItemStack)CrazyAE.definitions().items().manaAsAEStack().maybeStack(amt).orElse(ItemStack.field_190927_a));
            if (item != null && item.getStackSize() == (long)amt && (simulate = (IAEItemStack)AEUtils.extractFromME(inv, item, this.actionSource, Actionable.SIMULATE)) != null && simulate.getStackSize() == (long)amt) {
                AEUtils.extractFromME(inv, item, this.actionSource, Actionable.MODULATE);
                return true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return false;
    }

    @MENetworkEventSubscribe
    public void onPowerEvent(MENetworkPowerStatusChange p) {
        this.updatePowerState();
        if (Platform.isServer()) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
        }
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode iGridNode) {
        return new TickingRequest(1, 20, false, true);
    }

    @NotNull
    public abstract TickRateModulation tickingRequest(@NotNull IGridNode var1, int var2);

    public abstract void encodePattern();

    public abstract boolean validateRecipe();

    public IConfigManager getConfigManager() {
        return this.settings;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation aePartLocation) {
        return AECableType.COVERED;
    }

    @NotNull
    public IItemHandler getInternalInventory() {
        return this.patternsInv;
    }

    public boolean isRecipeValidated() {
        return this.isRecipeValidated;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (!(inv != this.craftingInputInv || removed.func_190926_b() && added.func_190926_b())) {
            this.validateRecipe();
        }
        if (!(inv != this.internalPatternsStorageInv || removed.func_190926_b() && added.func_190926_b())) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
        }
        if (!(inv != this.upgrades || removed.func_190926_b() && added.func_190926_b())) {
            this.checkUpgrades();
        }
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public static class BreweryCraftingTask
    extends CraftingTask
    implements IManaTask {
        private final int requiredMana;

        public BreweryCraftingTask(IAEItemStack[] taskItems, int progress, int requiredMana) {
            super(taskItems, progress);
            this.requiredMana = requiredMana;
        }

        @Override
        public int getRequiredMana() {
            return this.requiredMana;
        }
    }

    public static class TeraplateCraftingTask
    extends CraftingTask
    implements IManaTask {
        private final int requiredMana;

        public TeraplateCraftingTask(IAEItemStack[] taskItems, int progress, int requiredMana) {
            super(taskItems, progress);
            this.requiredMana = requiredMana;
        }

        @Override
        public int getRequiredMana() {
            return this.requiredMana;
        }
    }

    public static class RuneAltarCraftingTask
    extends CraftingTask
    implements IRuneAltarTask {
        private final int requiredMana;

        public RuneAltarCraftingTask(IAEItemStack[] taskItems, int progress, int requiredMana) {
            super(taskItems, progress);
            this.requiredMana = requiredMana;
        }

        @Override
        public int getRequiredMana() {
            return this.requiredMana;
        }
    }

    public static class PureDaisyCraftingTask
    extends CraftingTask
    implements IPureDaisyTask {
        private final boolean requireOutputBucket;

        public PureDaisyCraftingTask(IAEItemStack[] taskItems, int progress, boolean requireOutputBucket) {
            super(taskItems, progress);
            this.requireOutputBucket = requireOutputBucket;
        }

        @Override
        public boolean requireOutputBucket() {
            return this.requireOutputBucket;
        }
    }

    public static class ManaCraftingTask
    extends CraftingTask
    implements IManaTask {
        private final int requiredMana;

        public ManaCraftingTask(IAEItemStack[] taskItems, int progress, int requiredMana) {
            super(taskItems, progress);
            this.requiredMana = requiredMana;
        }

        @Override
        public int getRequiredMana() {
            return this.requiredMana;
        }
    }

    public static class CraftingTask {
        private IAEItemStack[] taskItems;
        private int progress;

        public CraftingTask(IAEItemStack[] taskItems, int progress) {
            this.taskItems = taskItems;
            this.progress = progress;
        }

        protected void setProgress(int progress) {
            this.progress = progress;
        }

        protected void addProgress(int progress) {
            this.progress += progress;
        }

        protected void setTaskItems(IAEItemStack[] taskItems) {
            this.taskItems = taskItems;
        }

        public IAEItemStack[] getTaskItems() {
            return this.taskItems;
        }

        public int getProgress() {
            return this.progress;
        }
    }

    public static interface IRuneAltarTask
    extends IManaTask {
    }

    public static interface IPureDaisyTask {
        public boolean requireOutputBucket();
    }

    public static interface IManaTask {
        public int getRequiredMana();
    }

    protected static final class DisabledFilter
    implements IAEItemFilter {
        protected DisabledFilter() {
        }

        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return false;
        }

        public boolean allowInsert(IItemHandler inv, int slot, ItemStack itemstack) {
            return false;
        }
    }
}

