/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.botania;

import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.helpers.MachineSource;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.enums.BotaniaMechanicalDeviceType;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.tile.botania.TileBotaniaMechanicalMachineBase;
import dev.beecube31.crazyae2.common.util.NBTUtils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.common.util.patterns.crafting.BreweryCraftingPatternDetails;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeBrew;

public class TileMechanicalBrewery
extends TileBotaniaMechanicalMachineBase {
    protected RecipeBrew currentRecipe;
    protected CrazyAEInternalInv craftingBottleSlot;

    public TileMechanicalBrewery() {
        this.craftingInputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 16, 64);
        this.craftingBottleSlot = new CrazyAEInternalInv((IAEAppEngInventory)this, 1, 64);
        this.craftingOutputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 1, 64);
        this.craftingOutputInv.setFilter(new TileBotaniaMechanicalMachineBase.DisabledFilter());
        this.actionSource = new MachineSource((IActionHost)this);
        Block block = CrazyAE.definitions().blocks().mechanicalBrewery().maybeBlock().orElse(null);
        Preconditions.checkNotNull((Object)block);
        this.upgrades = new CrazyAEBlockUpgradeInv(block, (IAEAppEngInventory)this, this.getUpgradeSlots());
        this.internalPatternsStorageInv.setItemFilter(RestrictedSlot.PlaceableItemType.BREWERY_ENCODED_PATTERN.associatedFilter);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.craftingBottleSlot.writeToNBT(data, "bottleInv");
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.craftingBottleSlot.readFromNBT(data, "bottleInv");
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails iCraftingPatternDetails, InventoryCrafting inventoryCrafting) {
        return this.acceptPattern(iCraftingPatternDetails);
    }

    private boolean acceptPattern(ICraftingPatternDetails iCraftingPatternDetails) {
        if (iCraftingPatternDetails instanceof BreweryCraftingPatternDetails) {
            BreweryCraftingPatternDetails pd = (BreweryCraftingPatternDetails)iCraftingPatternDetails;
            if (this.tasksQueued >= this.tasksMaxAmt) {
                return false;
            }
            ++this.tasksQueued;
            this.queueMap.add(new TileBotaniaMechanicalMachineBase.BreweryCraftingTask(iCraftingPatternDetails.getCondensedOutputs(), 0, pd.getRequiredMana()));
            return true;
        }
        return false;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (!(inv != this.craftingInputInv && inv != this.craftingBottleSlot || removed.func_190926_b() && added.func_190926_b())) {
            this.validateRecipe();
        }
        if (!(inv != this.internalPatternsStorageInv || removed.func_190926_b() && added.func_190926_b())) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
        }
        if (!(inv != this.upgrades || removed.func_190926_b() && added.func_190926_b())) {
            this.checkUpgrades();
        }
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        AppEngInternalInventory appEngInternalInventory;
        switch (name) {
            case "upgrades": {
                appEngInternalInventory = this.upgrades;
                break;
            }
            case "input": {
                appEngInternalInventory = this.craftingInputInv;
                break;
            }
            case "output": {
                appEngInternalInventory = this.craftingOutputInv;
                break;
            }
            case "patterns": {
                appEngInternalInventory = this.patternsInv;
                break;
            }
            case "patternsInternal": {
                appEngInternalInventory = this.internalPatternsStorageInv;
                break;
            }
            case "findSlot": {
                appEngInternalInventory = this.findSlot;
                break;
            }
            case "bottle": {
                appEngInternalInventory = this.craftingBottleSlot;
                break;
            }
            default: {
                appEngInternalInventory = null;
            }
        }
        return appEngInternalInventory;
    }

    @Override
    public boolean validateRecipe() {
        RecipeBrew recipe;
        this.isRecipeValidated = false;
        this.currentRecipe = null;
        for (int i = 0; i < this.craftingOutputInv.getSlots(); ++i) {
            this.craftingOutputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (this.craftingBottleSlot.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        if (!this.craftingInputInv.getStacks().isEmpty() && (recipe = TileMechanicalBrewery.getMatchingRecipe(this.craftingInputInv)) != null) {
            this.isRecipeValidated = true;
            this.currentRecipe = recipe;
            this.craftingOutputInv.setStackInSlot(0, recipe.getOutput(this.craftingBottleSlot.getStackInSlot(0)));
            return true;
        }
        return false;
    }

    @Nullable
    public static RecipeBrew getMatchingRecipe(@Nonnull CrazyAEInternalInv inv) {
        for (RecipeBrew recipe : BotaniaAPI.brewRecipes) {
            if (!TileMechanicalBrewery.compareRecipes(recipe, inv)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean compareRecipes(RecipeBrew recipe, @Nonnull CrazyAEInternalInv inv) {
        return recipe.matches((IItemHandler)inv);
    }

    @Override
    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode iGridNode, int ticksSinceLastCall) {
        if (!this.cached) {
            if (this.getProxy().isActive()) {
                this.notifyPatternsChanged();
            }
            return TickRateModulation.URGENT;
        }
        if (!this.queueMap.isEmpty()) {
            int itemsAmt = this.itemsPerTick;
            for (int j = 0; j < this.queueMap.size() && itemsAmt >= j; ++j) {
                TileBotaniaMechanicalMachineBase.CraftingTask s = (TileBotaniaMechanicalMachineBase.CraftingTask)this.queueMap.get(j);
                IAEItemStack[] ais = s.getTaskItems();
                int progress = s.getProgress();
                if (progress >= 100) {
                    TileBotaniaMechanicalMachineBase.IManaTask manaTask;
                    if (s instanceof TileBotaniaMechanicalMachineBase.IManaTask && !this.tryUseMana((manaTask = (TileBotaniaMechanicalMachineBase.IManaTask)((Object)s)).getRequiredMana())) continue;
                    boolean accepted = true;
                    for (IAEItemStack stack : ais) {
                        IAEItemStack result = this.pushItemsOut(stack);
                        if (result == null) continue;
                        accepted = false;
                        break;
                    }
                    if (!accepted) break;
                    this.queueMap.remove(j);
                    --this.tasksQueued;
                    this.addCompletedOperations();
                    continue;
                }
                s.addProgress(this.progressPerTick);
            }
        }
        return TickRateModulation.URGENT;
    }

    @Override
    public void encodePattern() {
        if (!this.patternsInv.getStackInSlot(0).func_190926_b() && !this.craftingBottleSlot.getStackInSlot(0).func_190926_b() && this.currentRecipe != null) {
            ItemStack s;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            Iterator iterator = this.craftingInputInv.iterator();
            while (iterator.hasNext()) {
                s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                inputs.add(s);
            }
            iterator = this.craftingOutputInv.iterator();
            while (iterator.hasNext()) {
                s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                outputs.add(s);
            }
            CrazyAE.definitions().items().breweryEncodedPattern().maybeStack(1).ifPresent(maybePattern -> {
                ItemStack[] in = (ItemStack[])ArrayUtils.add((Object[])inputs.toArray(new ItemStack[0]), (Object)this.craftingBottleSlot.getStackInSlot(0));
                ItemStack[] out = outputs.toArray(new ItemStack[0]);
                NBTTagCompound encodedValue = new NBTTagCompound();
                NBTTagList tagIn = new NBTTagList();
                NBTTagList tagOut = new NBTTagList();
                for (ItemStack i : in) {
                    tagIn.func_74742_a(NBTUtils.createItemTag(i));
                }
                for (ItemStack i : out) {
                    tagOut.func_74742_a(NBTUtils.createItemTag(i));
                }
                encodedValue.func_74782_a("input", (NBTBase)tagIn);
                encodedValue.func_74782_a("output", (NBTBase)tagOut);
                encodedValue.func_74757_a("crafting", true);
                encodedValue.func_74757_a("substitute", false);
                encodedValue.func_74768_a("reqMana", this.currentRecipe.getManaUsage());
                maybePattern.func_77982_d(encodedValue);
                for (int i = 0; i < this.internalPatternsStorageInv.getSlots(); ++i) {
                    if (!this.internalPatternsStorageInv.getStackInSlot(i).func_190926_b()) continue;
                    this.internalPatternsStorageInv.setStackInSlot(i, (ItemStack)maybePattern);
                    this.patternsInv.extractItem(0, 1, false);
                    break;
                }
                this.cached = false;
                this.updateCraftingList();
            });
        }
    }

    public RecipeBrew getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public BotaniaMechanicalDeviceType getType() {
        return BotaniaMechanicalDeviceType.BREWERY;
    }

    @Override
    public TileBotaniaMechanicalMachineBase getMechanicalTile() {
        return this;
    }

    @Override
    public List<TileBotaniaMechanicalMachineBase.CraftingTask> getQueueMap() {
        return this.queueMap;
    }

    @Override
    public int getTasksQueued() {
        return this.tasksQueued;
    }

    @Override
    public int getTasksMaxAmt() {
        return this.tasksMaxAmt;
    }

    @Override
    public int getProgressPerTick() {
        return this.progressPerTick;
    }

    @Override
    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().mechanicalBrewery();
    }
}

