/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.botania;

import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.helpers.MachineSource;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.enums.BotaniaMechanicalDeviceType;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.tile.botania.TileBotaniaMechanicalMachineBase;
import dev.beecube31.crazyae2.common.util.NBTUtils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeElvenTrade;

public class TileMechanicalElventrade
extends TileBotaniaMechanicalMachineBase {
    public TileMechanicalElventrade() {
        this.craftingInputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 16, 64);
        this.craftingOutputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 16, 64);
        this.craftingOutputInv.setFilter(new TileBotaniaMechanicalMachineBase.DisabledFilter());
        this.actionSource = new MachineSource((IActionHost)this);
        Block block = CrazyAE.definitions().blocks().mechanicalElventrade().maybeBlock().orElse(null);
        Preconditions.checkNotNull((Object)block);
        this.upgrades = new CrazyAEBlockUpgradeInv(block, (IAEAppEngInventory)this, this.getUpgradeSlots());
        this.internalPatternsStorageInv.setItemFilter(RestrictedSlot.PlaceableItemType.ELVENTRADE_ENCODED_PATTERN.associatedFilter);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails iCraftingPatternDetails, InventoryCrafting inventoryCrafting) {
        if (this.tasksQueued >= this.tasksMaxAmt) {
            return false;
        }
        ++this.tasksQueued;
        this.queueMap.add(new TileBotaniaMechanicalMachineBase.CraftingTask(iCraftingPatternDetails.getCondensedOutputs(), 0));
        return true;
    }

    @Override
    public boolean validateRecipe() {
        this.isRecipeValidated = false;
        for (int i = 0; i < this.craftingOutputInv.getSlots(); ++i) {
            this.craftingOutputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        Iterator iterator = this.craftingInputInv.iterator();
        while (iterator.hasNext()) {
            ItemStack s = (ItemStack)iterator.next();
            if (s.func_190926_b()) continue;
            input.add(s);
        }
        RecipeElvenTrade recipe = TileMechanicalElventrade.getMatchingRecipe(input, this.craftingInputInv);
        if (recipe != null) {
            this.isRecipeValidated = true;
            for (int i = 0; i < recipe.getOutputs().size(); ++i) {
                this.craftingOutputInv.setStackInSlot(i, (ItemStack)recipe.getOutputs().get(i));
            }
            return true;
        }
        return false;
    }

    public boolean findRecipe() {
        int i;
        this.isRecipeValidated = false;
        for (i = 0; i < this.craftingOutputInv.getSlots(); ++i) {
            this.craftingOutputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.craftingInputInv.getSlots(); ++i) {
            this.craftingInputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (RecipeElvenTrade recipe : BotaniaAPI.elvenTradeRecipes) {
            for (ItemStack output : recipe.getOutputs()) {
                if (output != this.findSlot.getStackInSlot(0)) continue;
                this.isRecipeValidated = true;
                for (int i2 = 0; i2 < recipe.getOutputs().size(); ++i2) {
                    this.craftingOutputInv.setStackInSlot(i2, (ItemStack)recipe.getOutputs().get(i2));
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static RecipeElvenTrade getMatchingRecipe(@Nonnull List<ItemStack> input, @Nonnull AppEngInternalInventory inv) {
        for (RecipeElvenTrade recipe : BotaniaAPI.elvenTradeRecipes) {
            if (!TileMechanicalElventrade.compareRecipes(recipe, input, inv)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean compareRecipes(RecipeElvenTrade recipe, @Nonnull List<ItemStack> input, @Nonnull AppEngInternalInventory inv) {
        if (recipe.matches(input, false) && input.size() == recipe.getInputs().size()) {
            for (int i = 0; i < inv.getSlots() && i <= recipe.getInputs().size() - 1; ++i) {
                Object e;
                ItemStack invStack = inv.getStackInSlot(i);
                if (!invStack.func_190926_b() && (e = recipe.getInputs().get(i)) instanceof ItemStack) {
                    ItemStack ris = (ItemStack)e;
                    invStack.func_190920_e(ris.func_190916_E());
                    continue;
                }
                if (!(recipe.getInputs().get(i) instanceof String)) continue;
                invStack.func_190920_e(1);
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode iGridNode, int ticksSinceLastCall) {
        if (!this.cached) {
            if (this.getProxy().isActive()) {
                this.notifyPatternsChanged();
            }
            return TickRateModulation.SLOWER;
        }
        if (!this.queueMap.isEmpty()) {
            int itemsAmt = this.itemsPerTick;
            for (int j = 0; j < this.queueMap.size() && itemsAmt >= j; ++j) {
                TileBotaniaMechanicalMachineBase.CraftingTask s = (TileBotaniaMechanicalMachineBase.CraftingTask)this.queueMap.get(j);
                IAEItemStack[] ais = s.getTaskItems();
                int progress = s.getProgress();
                if (progress >= 100) {
                    if (!this.tryUseMana(500)) continue;
                    boolean accepted = true;
                    for (IAEItemStack stack : ais) {
                        IAEItemStack result = this.pushItemsOut(stack);
                        if (result == null) continue;
                        accepted = false;
                        break;
                    }
                    if (!accepted) break;
                    this.queueMap.remove(j);
                    --this.tasksQueued;
                    this.addCompletedOperations();
                    continue;
                }
                s.addProgress(this.progressPerTick);
            }
        }
        return TickRateModulation.URGENT;
    }

    @Override
    public void encodePattern() {
        if (!this.patternsInv.getStackInSlot(0).func_190926_b()) {
            ItemStack s;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            Iterator iterator = this.craftingInputInv.iterator();
            while (iterator.hasNext()) {
                s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                inputs.add(s);
            }
            iterator = this.craftingOutputInv.iterator();
            while (iterator.hasNext()) {
                s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                outputs.add(s);
            }
            CrazyAE.definitions().items().elventradeEncodedPattern().maybeStack(1).ifPresent(maybePattern -> {
                ItemStack[] in = inputs.toArray(new ItemStack[0]);
                ItemStack[] out = outputs.toArray(new ItemStack[0]);
                NBTTagCompound encodedValue = new NBTTagCompound();
                NBTTagList tagIn = new NBTTagList();
                NBTTagList tagOut = new NBTTagList();
                for (ItemStack i : in) {
                    tagIn.func_74742_a(NBTUtils.createItemTag(i));
                }
                for (ItemStack i : out) {
                    tagOut.func_74742_a(NBTUtils.createItemTag(i));
                }
                encodedValue.func_74782_a("input", (NBTBase)tagIn);
                encodedValue.func_74782_a("output", (NBTBase)tagOut);
                encodedValue.func_74757_a("crafting", true);
                encodedValue.func_74757_a("substitute", false);
                maybePattern.func_77982_d(encodedValue);
                for (int i = 0; i < this.internalPatternsStorageInv.getSlots(); ++i) {
                    if (!this.internalPatternsStorageInv.getStackInSlot(i).func_190926_b()) continue;
                    this.internalPatternsStorageInv.setStackInSlot(i, (ItemStack)maybePattern);
                    this.patternsInv.extractItem(0, 1, false);
                    break;
                }
                this.cached = false;
                this.updateCraftingList();
            });
        }
    }

    @Override
    public BotaniaMechanicalDeviceType getType() {
        return BotaniaMechanicalDeviceType.ELVENTRADE;
    }

    @Override
    public TileBotaniaMechanicalMachineBase getMechanicalTile() {
        return this;
    }

    @Override
    public List<TileBotaniaMechanicalMachineBase.CraftingTask> getQueueMap() {
        return this.queueMap;
    }

    @Override
    public int getTasksQueued() {
        return this.tasksQueued;
    }

    @Override
    public int getTasksMaxAmt() {
        return this.tasksMaxAmt;
    }

    @Override
    public int getProgressPerTick() {
        return this.progressPerTick;
    }

    @Override
    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().mechanicalElventrade();
    }
}

