/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.botania;

import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.helpers.MachineSource;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.enums.BotaniaMechanicalDeviceType;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.tile.botania.TileBotaniaMechanicalMachineBase;
import dev.beecube31.crazyae2.common.util.NBTUtils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.common.util.patterns.crafting.ManapoolCraftingPatternDetails;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeManaInfusion;

public class TileMechanicalManapool
extends TileBotaniaMechanicalMachineBase {
    protected RecipeManaInfusion currentRecipe;

    public TileMechanicalManapool() {
        this.craftingInputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 2, 64);
        this.craftingOutputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 1, 64);
        this.craftingOutputInv.setFilter(new TileBotaniaMechanicalMachineBase.DisabledFilter());
        this.actionSource = new MachineSource((IActionHost)this);
        Block block = CrazyAE.definitions().blocks().mechanicalManapool().maybeBlock().orElse(null);
        Preconditions.checkNotNull((Object)block);
        this.upgrades = new CrazyAEBlockUpgradeInv(block, (IAEAppEngInventory)this, this.getUpgradeSlots());
        this.internalPatternsStorageInv.setItemFilter(RestrictedSlot.PlaceableItemType.MANAPOOL_ENCODED_PATTERN.associatedFilter);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails iCraftingPatternDetails, InventoryCrafting inventoryCrafting) {
        if (iCraftingPatternDetails instanceof ManapoolCraftingPatternDetails) {
            ManapoolCraftingPatternDetails pd = (ManapoolCraftingPatternDetails)iCraftingPatternDetails;
            if (this.tasksQueued >= this.tasksMaxAmt) {
                return false;
            }
            ++this.tasksQueued;
            this.queueMap.add(new TileBotaniaMechanicalMachineBase.ManaCraftingTask(iCraftingPatternDetails.getCondensedOutputs(), 0, pd.getRequiredMana()));
            return true;
        }
        return false;
    }

    @Override
    public boolean validateRecipe() {
        this.isRecipeValidated = false;
        this.currentRecipe = null;
        for (int i = 0; i < this.craftingOutputInv.getSlots(); ++i) {
            this.craftingOutputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        Iterator iterator = this.craftingInputInv.iterator();
        while (iterator.hasNext()) {
            ItemStack s = (ItemStack)iterator.next();
            if (s.func_190926_b()) continue;
            input.add(s);
        }
        if (!input.isEmpty()) {
            RecipeManaInfusion recipe;
            if (!this.craftingInputInv.getStackInSlot(1).func_190926_b()) {
                this.craftingInputInv.getStackInSlot(1).func_190920_e(1);
            }
            if ((recipe = TileMechanicalManapool.getMatchingRecipe(this.craftingInputInv)) != null) {
                this.isRecipeValidated = true;
                this.currentRecipe = recipe;
                this.craftingOutputInv.setStackInSlot(0, recipe.getOutput());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static RecipeManaInfusion getMatchingRecipe(@Nonnull AppEngInternalInventory inv) {
        for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
            if (!TileMechanicalManapool.compareRecipes(recipe, inv)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean compareRecipes(RecipeManaInfusion recipe, @Nonnull AppEngInternalInventory inv) {
        if (recipe.matches(inv.getStackInSlot(0)) && TileMechanicalManapool.checkCatalyst(inv.getStackInSlot(1), recipe)) {
            Object object = recipe.getInput();
            if (object instanceof ItemStack) {
                ItemStack s = (ItemStack)object;
                inv.getStackInSlot(0).func_190920_e(s.func_190916_E());
            }
            return true;
        }
        return false;
    }

    private static boolean checkCatalyst(ItemStack is, RecipeManaInfusion recipe) {
        if (recipe.getCatalyst() == null) {
            return true;
        }
        if (is.func_190926_b()) {
            return false;
        }
        if (is.func_190916_E() < 1) {
            return false;
        }
        return Item.func_150898_a((Block)recipe.getCatalyst().func_177230_c()) == is.func_77973_b();
    }

    @Override
    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode iGridNode, int ticksSinceLastCall) {
        if (!this.cached) {
            if (this.getProxy().isActive()) {
                this.notifyPatternsChanged();
            }
            return TickRateModulation.URGENT;
        }
        if (!this.queueMap.isEmpty()) {
            int itemsAmt = this.itemsPerTick;
            for (int j = 0; j < this.queueMap.size() && itemsAmt >= j; ++j) {
                TileBotaniaMechanicalMachineBase.CraftingTask s = (TileBotaniaMechanicalMachineBase.CraftingTask)this.queueMap.get(j);
                IAEItemStack[] ais = s.getTaskItems();
                int progress = s.getProgress();
                if (progress >= 100) {
                    TileBotaniaMechanicalMachineBase.IManaTask manaTask;
                    if (s instanceof TileBotaniaMechanicalMachineBase.IManaTask && !this.tryUseMana((manaTask = (TileBotaniaMechanicalMachineBase.IManaTask)((Object)s)).getRequiredMana())) continue;
                    boolean accepted = true;
                    for (IAEItemStack stack : ais) {
                        IAEItemStack result = this.pushItemsOut(stack);
                        if (result == null) continue;
                        accepted = false;
                        break;
                    }
                    if (!accepted) break;
                    this.queueMap.remove(j);
                    --this.tasksQueued;
                    this.addCompletedOperations();
                    continue;
                }
                s.addProgress(this.progressPerTick);
            }
        }
        return TickRateModulation.URGENT;
    }

    @Override
    public void encodePattern() {
        if (!this.patternsInv.getStackInSlot(0).func_190926_b() && this.currentRecipe != null) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            Iterator iterator = this.craftingOutputInv.iterator();
            while (iterator.hasNext()) {
                ItemStack s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                outputs.add(s);
            }
            CrazyAE.definitions().items().manapoolEncodedPattern().maybeStack(1).ifPresent(maybePattern -> {
                ItemStack[] out = outputs.toArray(new ItemStack[0]);
                NBTTagCompound encodedValue = new NBTTagCompound();
                NBTTagList tagIn = new NBTTagList();
                NBTTagList tagOut = new NBTTagList();
                for (ItemStack i : out) {
                    tagOut.func_74742_a(NBTUtils.createItemTag(i));
                }
                tagIn.func_74742_a(NBTUtils.createItemTag(this.craftingInputInv.getStackInSlot(0)));
                encodedValue.func_74782_a("input", (NBTBase)tagIn);
                encodedValue.func_74782_a("output", (NBTBase)tagOut);
                encodedValue.func_74757_a("crafting", true);
                encodedValue.func_74757_a("substitute", false);
                encodedValue.func_74768_a("reqMana", this.currentRecipe.getManaToConsume());
                maybePattern.func_77982_d(encodedValue);
                for (int i = 0; i < this.internalPatternsStorageInv.getSlots(); ++i) {
                    if (!this.internalPatternsStorageInv.getStackInSlot(i).func_190926_b()) continue;
                    this.internalPatternsStorageInv.setStackInSlot(i, (ItemStack)maybePattern);
                    this.patternsInv.extractItem(0, 1, false);
                    break;
                }
                this.cached = false;
                this.updateCraftingList();
            });
        }
    }

    public RecipeManaInfusion getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public BotaniaMechanicalDeviceType getType() {
        return BotaniaMechanicalDeviceType.MANAPOOL;
    }

    @Override
    public TileBotaniaMechanicalMachineBase getMechanicalTile() {
        return this;
    }

    @Override
    public List<TileBotaniaMechanicalMachineBase.CraftingTask> getQueueMap() {
        return this.queueMap;
    }

    @Override
    public int getTasksQueued() {
        return this.tasksQueued;
    }

    @Override
    public int getTasksMaxAmt() {
        return this.tasksMaxAmt;
    }

    @Override
    public int getProgressPerTick() {
        return this.progressPerTick;
    }

    @Override
    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().mechanicalManapool();
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (!(inv != this.craftingInputInv || removed.func_190926_b() && added.func_190926_b())) {
            this.validateRecipe();
        }
        if (!(inv != this.internalPatternsStorageInv || removed.func_190926_b() && added.func_190926_b())) {
            this.updateCraftingList();
        }
        if (!(inv != this.upgrades || removed.func_190926_b() && added.func_190926_b())) {
            this.checkUpgrades();
        }
    }
}

