/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.botania;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.item.AEItemStack;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.enums.BotaniaMechanicalDeviceType;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.tile.botania.TileBotaniaMechanicalMachineBase;
import dev.beecube31.crazyae2.common.util.ForgeUtils;
import dev.beecube31.crazyae2.common.util.NBTUtils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.common.util.patterns.crafting.PuredaisyCraftingPatternDetails;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePureDaisy;

public class TileMechanicalPuredaisy
extends TileBotaniaMechanicalMachineBase {
    protected boolean reqBucket = false;

    public TileMechanicalPuredaisy() {
        this.craftingInputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 1, 64);
        this.craftingOutputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 1, 64);
        this.craftingOutputInv.setFilter(new TileBotaniaMechanicalMachineBase.DisabledFilter());
        this.actionSource = new MachineSource((IActionHost)this);
        Block block = CrazyAE.definitions().blocks().mechanicalPuredaisy().maybeBlock().orElse(null);
        Preconditions.checkNotNull((Object)block);
        this.upgrades = new CrazyAEBlockUpgradeInv(block, (IAEAppEngInventory)this, this.getUpgradeSlots());
        this.internalPatternsStorageInv.setItemFilter(RestrictedSlot.PlaceableItemType.PUREDAISY_ENCODED_PATTERN.associatedFilter);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails iCraftingPatternDetails, InventoryCrafting inventoryCrafting) {
        if (iCraftingPatternDetails instanceof PuredaisyCraftingPatternDetails) {
            PuredaisyCraftingPatternDetails pd = (PuredaisyCraftingPatternDetails)iCraftingPatternDetails;
            if (this.tasksQueued >= this.tasksMaxAmt) {
                return false;
            }
            ++this.tasksQueued;
            this.queueMap.add(new TileBotaniaMechanicalMachineBase.PureDaisyCraftingTask(iCraftingPatternDetails.getCondensedOutputs(), 0, pd.requireOutputBucket()));
            return true;
        }
        return false;
    }

    @Override
    public boolean validateRecipe() {
        RecipePureDaisy recipe;
        this.isRecipeValidated = false;
        this.reqBucket = false;
        for (int i = 0; i < this.craftingOutputInv.getSlots(); ++i) {
            this.craftingOutputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        ItemStack input = null;
        Iterator iterator = this.craftingInputInv.iterator();
        while (iterator.hasNext()) {
            ItemStack s = (ItemStack)iterator.next();
            if (s.func_190926_b()) continue;
            input = s;
            break;
        }
        if (input != null && (recipe = this.getMatchingRecipe(this.craftingInputInv)) != null) {
            this.isRecipeValidated = true;
            this.craftingOutputInv.setStackInSlot(0, new ItemStack(recipe.getOutputState().func_177230_c()));
            return true;
        }
        return false;
    }

    @Nullable
    public RecipePureDaisy getMatchingRecipe(@Nonnull AppEngInternalInventory inv) {
        for (RecipePureDaisy recipe : BotaniaAPI.pureDaisyRecipes) {
            if (!this.compareRecipes(recipe, inv)) continue;
            return recipe;
        }
        return null;
    }

    private boolean compareRecipes(RecipePureDaisy recipe, @Nonnull AppEngInternalInventory inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            Object input = recipe.getInput();
            if (input instanceof BlockLiquid) {
                boolean matches;
                this.reqBucket = matches = stack.func_77973_b() == Items.field_151131_as || stack.func_77973_b() == Items.field_151129_at;
                return matches;
            }
            if (input instanceof Block) {
                Block block = (Block)input;
                return Item.func_150898_a((Block)block) == stack.func_77973_b() || stack.equals(new ItemStack((Block)input));
            }
            if (input instanceof IBlockState) {
                return stack.equals(new ItemStack(((IBlockState)input).func_177230_c())) && stack.func_77960_j() == ((IBlockState)input).func_177230_c().func_176201_c((IBlockState)input);
            }
            if (!(input instanceof String)) continue;
            return ForgeUtils.isOreDict(stack, (String)input);
        }
        return false;
    }

    private boolean tryOutputBucket() {
        try {
            IMEMonitor storage = ((IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            AEItemStack item = AEItemStack.fromItemStack((ItemStack)new ItemStack(Items.field_151133_ar, 1));
            IAEItemStack overflow = (IAEItemStack)storage.injectItems((IAEStack)item, Actionable.SIMULATE, this.actionSource);
            if (overflow == null) {
                storage.injectItems((IAEStack)item, Actionable.MODULATE, this.actionSource);
                return true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return false;
    }

    @Override
    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode iGridNode, int ticksSinceLastCall) {
        if (!this.cached) {
            if (this.getProxy().isActive()) {
                this.notifyPatternsChanged();
            }
            return TickRateModulation.URGENT;
        }
        if (!this.queueMap.isEmpty()) {
            int itemsAmt = this.itemsPerTick;
            for (int j = 0; j < this.queueMap.size() && itemsAmt >= j; ++j) {
                TileBotaniaMechanicalMachineBase.CraftingTask s = (TileBotaniaMechanicalMachineBase.CraftingTask)this.queueMap.get(j);
                IAEItemStack[] ais = s.getTaskItems();
                int progress = s.getProgress();
                if (progress >= 100) {
                    TileBotaniaMechanicalMachineBase.IPureDaisyTask t;
                    if (s instanceof TileBotaniaMechanicalMachineBase.IPureDaisyTask && (t = (TileBotaniaMechanicalMachineBase.IPureDaisyTask)((Object)s)).requireOutputBucket() && !this.tryOutputBucket()) continue;
                    boolean accepted = true;
                    for (IAEItemStack stack : ais) {
                        IAEItemStack result = this.pushItemsOut(stack);
                        if (result == null) continue;
                        accepted = false;
                        break;
                    }
                    if (!accepted) break;
                    this.queueMap.remove(j);
                    --this.tasksQueued;
                    this.addCompletedOperations();
                    continue;
                }
                s.addProgress(this.progressPerTick);
            }
        }
        return TickRateModulation.URGENT;
    }

    @Override
    public void encodePattern() {
        if (!this.patternsInv.getStackInSlot(0).func_190926_b()) {
            ItemStack s;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            Iterator iterator = this.craftingInputInv.iterator();
            while (iterator.hasNext()) {
                s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                inputs.add(s);
            }
            iterator = this.craftingOutputInv.iterator();
            while (iterator.hasNext()) {
                s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                outputs.add(s);
            }
            CrazyAE.definitions().items().puredaisyEncodedPattern().maybeStack(1).ifPresent(maybePattern -> {
                ItemStack[] in = inputs.toArray(new ItemStack[0]);
                ItemStack[] out = outputs.toArray(new ItemStack[0]);
                NBTTagCompound encodedValue = new NBTTagCompound();
                NBTTagList tagIn = new NBTTagList();
                NBTTagList tagOut = new NBTTagList();
                for (ItemStack i : in) {
                    tagIn.func_74742_a(NBTUtils.createItemTag(i));
                }
                for (ItemStack i : out) {
                    tagOut.func_74742_a(NBTUtils.createItemTag(i));
                }
                encodedValue.func_74782_a("input", (NBTBase)tagIn);
                encodedValue.func_74782_a("output", (NBTBase)tagOut);
                encodedValue.func_74757_a("crafting", true);
                encodedValue.func_74757_a("substitute", false);
                encodedValue.func_74757_a("reqBucket", this.reqBucket);
                maybePattern.func_77982_d(encodedValue);
                for (int i = 0; i < this.internalPatternsStorageInv.getSlots(); ++i) {
                    if (!this.internalPatternsStorageInv.getStackInSlot(i).func_190926_b()) continue;
                    this.internalPatternsStorageInv.setStackInSlot(i, (ItemStack)maybePattern);
                    this.patternsInv.extractItem(0, 1, false);
                    break;
                }
                this.cached = false;
                this.updateCraftingList();
            });
        }
    }

    @Override
    public BotaniaMechanicalDeviceType getType() {
        return BotaniaMechanicalDeviceType.PUREDAISY;
    }

    @Override
    public TileBotaniaMechanicalMachineBase getMechanicalTile() {
        return this;
    }

    @Override
    public List<TileBotaniaMechanicalMachineBase.CraftingTask> getQueueMap() {
        return this.queueMap;
    }

    @Override
    public int getTasksQueued() {
        return this.tasksQueued;
    }

    @Override
    public int getTasksMaxAmt() {
        return this.tasksMaxAmt;
    }

    @Override
    public int getProgressPerTick() {
        return this.progressPerTick;
    }

    @Override
    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().mechanicalPuredaisy();
    }
}

