/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.botania;

import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.ItemStackHelper;
import appeng.me.helpers.MachineSource;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.item.AEItemStack;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.enums.BotaniaMechanicalDeviceType;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.tile.botania.TileBotaniaMechanicalMachineBase;
import dev.beecube31.crazyae2.common.util.ModsChecker;
import dev.beecube31.crazyae2.common.util.NBTUtils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.common.util.patterns.crafting.RunealtarCraftingPatternDetails;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeRuneAltar;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.material.ItemRune;

public class TileMechanicalRunealtar
extends TileBotaniaMechanicalMachineBase {
    protected RecipeRuneAltar currentRecipe;
    protected List<IAEItemStack> outputRunes = new ArrayList<IAEItemStack>();

    public TileMechanicalRunealtar() {
        this.craftingInputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 16, 64);
        this.craftingOutputInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 1, 64);
        this.craftingOutputInv.setFilter(new TileBotaniaMechanicalMachineBase.DisabledFilter());
        this.actionSource = new MachineSource((IActionHost)this);
        Block block = CrazyAE.definitions().blocks().mechanicalRunealtar().maybeBlock().orElse(null);
        Preconditions.checkNotNull((Object)block);
        this.upgrades = new CrazyAEBlockUpgradeInv(block, (IAEAppEngInventory)this, this.getUpgradeSlots());
        this.internalPatternsStorageInv.setItemFilter(RestrictedSlot.PlaceableItemType.RUNEALTAR_ENCODED_PATTERN.associatedFilter);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails iCraftingPatternDetails, InventoryCrafting inventoryCrafting) {
        if (iCraftingPatternDetails instanceof RunealtarCraftingPatternDetails) {
            RunealtarCraftingPatternDetails pd = (RunealtarCraftingPatternDetails)iCraftingPatternDetails;
            if (this.tasksQueued >= this.tasksMaxAmt) {
                return false;
            }
            ++this.tasksQueued;
            this.queueMap.add(new TileBotaniaMechanicalMachineBase.RuneAltarCraftingTask(iCraftingPatternDetails.getCondensedOutputs(), 0, pd.getRequiredMana()));
            for (IAEItemStack ais : iCraftingPatternDetails.getCondensedInputs()) {
                Item item = ais.createItemStack().func_77973_b();
                if (!(item instanceof ItemRune) && !ModsChecker.isItemMoreRune(item)) continue;
                this.outputRunes.add(ais);
            }
            this.pushOutRunes();
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        NBTTagList nbtTagList = new NBTTagList();
        for (IAEItemStack i : this.outputRunes) {
            ItemStack is = i.createItemStack();
            if (is.func_190926_b()) continue;
            NBTTagCompound itemTag = ItemStackHelper.stackToNBT((ItemStack)is);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a("outputRunes", (NBTBase)nbtTagList);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_150297_b("outputRunes", 9)) {
            NBTTagList tagList = data.func_150295_c("outputRunes", 10);
            this.outputRunes.clear();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTags = tagList.func_150305_b(i);
                this.outputRunes.add((IAEItemStack)AEItemStack.fromItemStack((ItemStack)ItemStackHelper.stackFromNBT((NBTTagCompound)itemTags)));
            }
        }
        this.pushOutRunes();
    }

    @Override
    public boolean validateRecipe() {
        RecipeRuneAltar recipe;
        this.isRecipeValidated = false;
        this.currentRecipe = null;
        for (int i = 0; i < this.craftingOutputInv.getSlots(); ++i) {
            this.craftingOutputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        ItemStack input = null;
        Iterator iterator = this.craftingInputInv.iterator();
        while (iterator.hasNext()) {
            ItemStack s = (ItemStack)iterator.next();
            if (s.func_190926_b()) continue;
            input = s;
            break;
        }
        if (input != null && (recipe = TileMechanicalRunealtar.getMatchingRecipe(this.craftingInputInv)) != null) {
            this.isRecipeValidated = true;
            this.currentRecipe = recipe;
            this.craftingOutputInv.setStackInSlot(0, recipe.getOutput());
            return true;
        }
        return false;
    }

    public boolean findRecipe() {
        int i;
        this.isRecipeValidated = false;
        for (i = 0; i < this.craftingOutputInv.getSlots(); ++i) {
            this.craftingOutputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.craftingInputInv.getSlots(); ++i) {
            this.craftingInputInv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes) {
            if (recipe.getOutput() != this.findSlot.getStackInSlot(0)) continue;
            this.isRecipeValidated = true;
            this.craftingOutputInv.setStackInSlot(0, recipe.getOutput());
            return true;
        }
        return false;
    }

    @Nullable
    public static RecipeRuneAltar getMatchingRecipe(@Nonnull AppEngInternalInventory inv) {
        for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes) {
            if (!TileMechanicalRunealtar.compareRecipes(recipe, inv)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean compareRecipes(RecipeRuneAltar recipe, @Nonnull AppEngInternalInventory inv) {
        return recipe.matches((IItemHandler)inv);
    }

    @Override
    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode iGridNode, int ticksSinceLastCall) {
        if (!this.cached) {
            if (this.getProxy().isActive()) {
                this.notifyPatternsChanged();
            }
            return TickRateModulation.URGENT;
        }
        if (!this.queueMap.isEmpty()) {
            int itemsAmt = this.itemsPerTick;
            for (int j = 0; j < this.queueMap.size() && itemsAmt >= j; ++j) {
                TileBotaniaMechanicalMachineBase.CraftingTask s = (TileBotaniaMechanicalMachineBase.CraftingTask)this.queueMap.get(j);
                IAEItemStack[] ais = s.getTaskItems();
                int progress = s.getProgress();
                if (progress >= 100) {
                    boolean accepted = true;
                    for (IAEItemStack stack : ais) {
                        IAEItemStack result = this.pushItemsOut(stack);
                        if (result == null) continue;
                        accepted = false;
                        break;
                    }
                    if (!accepted) break;
                    this.queueMap.remove(j);
                    --this.tasksQueued;
                    this.addCompletedOperations();
                    continue;
                }
                s.addProgress(this.progressPerTick);
            }
        }
        this.pushOutRunes();
        return TickRateModulation.URGENT;
    }

    private void pushOutRunes() {
        if (!this.outputRunes.isEmpty()) {
            this.outputRunes.removeIf(ais -> this.pushItemsOut((IAEItemStack)ais) == null);
        }
    }

    @Override
    public void encodePattern() {
        if (!this.patternsInv.getStackInSlot(0).func_190926_b() && this.currentRecipe != null) {
            ItemStack s;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            Iterator iterator = this.craftingInputInv.iterator();
            while (iterator.hasNext()) {
                s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                inputs.add(s);
            }
            iterator = this.craftingOutputInv.iterator();
            while (iterator.hasNext()) {
                s = (ItemStack)iterator.next();
                if (s.func_190926_b()) continue;
                outputs.add(s);
            }
            CrazyAE.definitions().items().runealtarEncodedPattern().maybeStack(1).ifPresent(maybePattern -> {
                ItemStack[] in = inputs.toArray(new ItemStack[0]);
                ItemStack[] out = outputs.toArray(new ItemStack[0]);
                NBTTagCompound encodedValue = new NBTTagCompound();
                NBTTagList tagIn = new NBTTagList();
                NBTTagList tagOut = new NBTTagList();
                for (ItemStack i : in) {
                    tagIn.func_74742_a(NBTUtils.createItemTag(i));
                }
                for (ItemStack i : out) {
                    tagOut.func_74742_a(NBTUtils.createItemTag(i));
                }
                tagIn.func_74742_a(NBTUtils.createItemTag(new ItemStack(ModBlocks.livingrock)));
                encodedValue.func_74782_a("input", (NBTBase)tagIn);
                encodedValue.func_74782_a("output", (NBTBase)tagOut);
                encodedValue.func_74757_a("crafting", true);
                encodedValue.func_74757_a("substitute", false);
                encodedValue.func_74768_a("reqMana", this.currentRecipe.getManaUsage());
                maybePattern.func_77982_d(encodedValue);
                for (int i = 0; i < this.internalPatternsStorageInv.getSlots(); ++i) {
                    if (!this.internalPatternsStorageInv.getStackInSlot(i).func_190926_b()) continue;
                    this.internalPatternsStorageInv.setStackInSlot(i, (ItemStack)maybePattern);
                    this.patternsInv.extractItem(0, 1, false);
                    break;
                }
                this.cached = false;
                this.updateCraftingList();
            });
        }
    }

    public RecipeRuneAltar getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public BotaniaMechanicalDeviceType getType() {
        return BotaniaMechanicalDeviceType.RUNEALTAR;
    }

    @Override
    public TileBotaniaMechanicalMachineBase getMechanicalTile() {
        return this;
    }

    @Override
    public List<TileBotaniaMechanicalMachineBase.CraftingTask> getQueueMap() {
        return this.queueMap;
    }

    @Override
    public int getTasksQueued() {
        return this.tasksQueued;
    }

    @Override
    public int getTasksMaxAmt() {
        return this.tasksMaxAmt;
    }

    @Override
    public int getProgressPerTick() {
        return this.progressPerTick;
    }

    @Override
    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().mechanicalRunealtar();
    }
}

