/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.helpers.ItemStackHelper;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.containers.base.ContainerNull;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.i18n.CrazyAEGuiText;
import dev.beecube31.crazyae2.common.interfaces.IGridHostMonitorable;
import dev.beecube31.crazyae2.common.interfaces.upgrades.IUpgradesInfoProvider;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import dev.beecube31.crazyae2.common.tile.base.CrazyAENetworkInvOCTile;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.config.CrazyAEConfig;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileImprovedMAC
extends CrazyAENetworkInvOCTile
implements IConfigManagerHost,
IGridTickable,
ICraftingMedium,
ICraftingProvider,
IUpgradesInfoProvider,
IGridHostMonitorable {
    private final int maxQueueSize = CrazyAEConfig.improvedMolecularAssemblerMaxQueueSize;
    private int itemsToSendPerTick = 8;
    private final CrazyAEInternalInv patternsInv;
    private final IConfigManager settings;
    private final CrazyAEBlockUpgradeInv upgrades;
    private boolean isPowered;
    private boolean cached;
    private final IActionSource actionSource;
    private int priority;
    private List<ICraftingPatternDetails> craftingList;
    private final List<IAEItemStack> itemsToSend;
    private final List<InventoryCrafting> activeJobs;

    public TileImprovedMAC() {
        this.patternsInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 45, 1).setItemFilter(RestrictedSlot.PlaceableItemType.ENCODED_CRAFTING_PATTERN.associatedFilter);
        this.isPowered = false;
        this.cached = false;
        this.actionSource = new MachineSource((IActionHost)this);
        this.priority = 1;
        this.craftingList = null;
        this.itemsToSend = new ArrayList<IAEItemStack>();
        this.activeJobs = new ArrayList<InventoryCrafting>();
        Block assembler = CrazyAE.definitions().blocks().improvedMolecularAssembler().maybeBlock().orElse(null);
        Preconditions.checkNotNull((Object)assembler);
        this.settings = new ConfigManager((IConfigManagerHost)this);
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getProxy().setIdlePowerUsage(32.0);
        this.upgrades = new CrazyAEBlockUpgradeInv(assembler, (IAEAppEngInventory)this, this.getUpgradeSlots());
    }

    private int getUpgradeSlots() {
        return 5;
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.isPowered && !this.isBusy()) {
            this.activeJobs.add(table);
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return this.activeJobs.size() >= this.maxQueueSize;
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        NBTTagList nbtTagList = new NBTTagList();
        for (IAEItemStack i : this.itemsToSend) {
            ItemStack is = i.createItemStack();
            if (is.func_190926_b()) continue;
            NBTTagCompound itemTag = ItemStackHelper.stackToNBT((ItemStack)is);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a("itemsToSend", (NBTBase)nbtTagList);
        NBTTagList jobsList = new NBTTagList();
        for (InventoryCrafting job : this.activeJobs) {
            NBTTagCompound jobTag = new NBTTagCompound();
            NBTTagList itemsList = new NBTTagList();
            for (int i = 0; i < job.func_70302_i_(); ++i) {
                ItemStack stack = job.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(itemTag);
                itemsList.func_74742_a((NBTBase)itemTag);
            }
            jobTag.func_74782_a("Items", (NBTBase)itemsList);
            jobsList.func_74742_a((NBTBase)jobTag);
        }
        data.func_74782_a("activeJobs", (NBTBase)jobsList);
        this.patternsInv.writeToNBT(data, "patterns");
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        int i;
        super.func_145839_a(data);
        if (data.func_150297_b("itemsToSend", 9)) {
            NBTTagList tagList = data.func_150295_c("itemsToSend", 10);
            this.itemsToSend.clear();
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTags = tagList.func_150305_b(i);
                this.itemsToSend.add((IAEItemStack)AEItemStack.fromItemStack((ItemStack)ItemStackHelper.stackFromNBT((NBTTagCompound)itemTags)));
            }
        }
        this.activeJobs.clear();
        if (data.func_74764_b("activeJobs")) {
            NBTTagList jobsList = data.func_150295_c("activeJobs", 10);
            for (i = 0; i < jobsList.func_74745_c(); ++i) {
                NBTTagCompound jobTag = jobsList.func_150305_b(i);
                InventoryCrafting job = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
                NBTTagList itemsList = jobTag.func_150295_c("Items", 10);
                for (int j = 0; j < itemsList.func_74745_c(); ++j) {
                    NBTTagCompound itemTag = itemsList.func_150305_b(j);
                    byte slot = itemTag.func_74771_c("Slot");
                    if (slot < 0 || slot >= job.func_70302_i_()) continue;
                    job.func_70299_a((int)slot, new ItemStack(itemTag));
                }
                this.activeJobs.add(job);
            }
        }
        this.patternsInv.readFromNBT(data, "patterns");
        this.priority = data.func_74762_e("priority");
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation dir) {
        return AECableType.COVERED;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IConfigManager getConfigManager() {
        return this.settings;
    }

    public IItemHandler getInventoryByName(String name) {
        AppEngInternalInventory appEngInternalInventory;
        switch (name) {
            case "upgrades": {
                appEngInternalInventory = this.upgrades;
                break;
            }
            case "patterns": {
                appEngInternalInventory = this.patternsInv;
                break;
            }
            default: {
                appEngInternalInventory = null;
            }
        }
        return appEngInternalInventory;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    @NotNull
    public IItemHandler getInternalInventory() {
        return this.patternsInv;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (!(inv != this.patternsInv || removed.func_190926_b() && added.func_190926_b() || !this.getProxy().isActive())) {
            this.cached = false;
            this.updateCraftingList();
            this.notifyPatternsChanged();
        }
        if (!(inv != this.upgrades || removed.func_190926_b() && added.func_190926_b())) {
            this.checkUpgrades();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (Platform.isServer()) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
        }
    }

    public void onReady() {
        super.onReady();
        if (Platform.isServer()) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
            this.checkUpgrades();
        }
    }

    private void checkUpgrades() {
        switch (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.STACKS)) {
            default: {
                this.itemsToSendPerTick = CrazyAEConfig.improvedMolecularAssemblerCraftsPerTickWithoutUpgrades;
                break;
            }
            case 1: {
                this.itemsToSendPerTick = CrazyAEConfig.improvedMolecularAssemblerCraftsPerTickWith1Upgrade;
                break;
            }
            case 2: {
                this.itemsToSendPerTick = CrazyAEConfig.improvedMolecularAssemblerCraftsPerTickWith2Upgrades;
                break;
            }
            case 3: {
                this.itemsToSendPerTick = CrazyAEConfig.improvedMolecularAssemblerCraftsPerTickWith3Upgrades;
                break;
            }
            case 4: {
                this.itemsToSendPerTick = CrazyAEConfig.improvedMolecularAssemblerCraftsPerTickWith4Upgrades;
                break;
            }
            case 5: {
                this.itemsToSendPerTick = CrazyAEConfig.improvedMolecularAssemblerCraftsPerTickWith5Upgrades;
            }
        }
    }

    public boolean acceptPatternFromTerm(ItemStack pattern) {
        for (int i = 0; i < this.patternsInv.getSlots(); ++i) {
            ItemStack is = this.patternsInv.getStackInSlot(i);
            if (!is.func_190926_b()) continue;
            this.patternsInv.setStackInSlot(i, pattern.func_77946_l());
            return true;
        }
        return false;
    }

    private void pushItemsOut() {
        try {
            int remaining = this.itemsToSendPerTick;
            IMEMonitor storage = ((IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            Iterator<IAEItemStack> iterator = this.itemsToSend.iterator();
            while (remaining > 0 && iterator.hasNext()) {
                IAEItemStack iaeItemStack = iterator.next();
                IAEItemStack overflow = (IAEItemStack)storage.injectItems((IAEStack)iaeItemStack, Actionable.SIMULATE, this.actionSource);
                if (overflow == null) {
                    storage.injectItems((IAEStack)iaeItemStack, Actionable.MODULATE, this.actionSource);
                    this.addCompletedOperations(iaeItemStack.getStackSize());
                    iterator.remove();
                } else {
                    if (overflow.getStackSize() == iaeItemStack.getStackSize()) continue;
                    IAEItemStack item = (IAEItemStack)iaeItemStack.setStackSize(iaeItemStack.getStackSize() - overflow.getStackSize());
                    storage.injectItems((IAEStack)item, Actionable.MODULATE, this.actionSource);
                    this.addCompletedOperations(item.getStackSize());
                    iterator.remove();
                    this.itemsToSend.add(item);
                }
                --remaining;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateCraftingList() {
        Object[] accountedFor = new Boolean[this.patternsInv.getSlots()];
        Arrays.fill(accountedFor, (Object)false);
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.patternsInv.getStackInSlot(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (((Boolean)accountedFor[x]).booleanValue()) continue;
            this.addToCraftingList(this.patternsInv.getStackInSlot(x));
        }
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is.func_190926_b()) {
            return;
        }
        Item item = is.func_77973_b();
        if (item instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)item).getPatternForItem(is, this.func_145831_w())) != null) {
            if (this.craftingList == null) {
                this.craftingList = new ArrayList<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        for (int h = 0; h < this.upgrades.getSlots(); ++h) {
            ItemStack itemStack = this.upgrades.getStackInSlot(h);
            if (itemStack.func_190926_b()) continue;
            drops.add(itemStack);
        }
        Iterator<IAEItemStack> iterator = this.patternsInv.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            if (itemStack.func_190926_b()) continue;
            drops.add(itemStack);
        }
        for (IAEItemStack iAEItemStack : this.itemsToSend) {
            drops.add(iAEItemStack.createItemStack());
        }
    }

    public int getInstalledCustomUpgrades(Upgrades.UpgradeType u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    private void notifyPatternsChanged() {
        try {
            if (this.getProxy().isActive()) {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
                this.cached = true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private boolean checkStatus() {
        boolean empty = this.itemsToSend.isEmpty();
        if (empty) {
            try {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return empty && this.cached;
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        return new TickingRequest(1, 10, this.checkStatus(), false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        if (!this.cached) {
            if (this.getProxy().isActive()) {
                this.notifyPatternsChanged();
            }
            return TickRateModulation.URGENT;
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 2L == 0L) {
            this.checkUpgrades();
        }
        if (!this.itemsToSend.isEmpty()) {
            this.pushItemsOut();
        }
        if (!this.activeJobs.isEmpty()) {
            IStorageGrid storage;
            try {
                storage = (IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class);
            }
            catch (GridAccessException e) {
                return TickRateModulation.IDLE;
            }
            int processedThisTick = 0;
            Iterator<InventoryCrafting> iterator = this.activeJobs.iterator();
            while (iterator.hasNext() && processedThisTick < this.itemsToSendPerTick) {
                InventoryCrafting craftingGrid = iterator.next();
                ItemStack result = Platform.findMatchingRecipeOutput((InventoryCrafting)craftingGrid, (World)this.field_145850_b);
                if (result != null && !result.func_190926_b()) {
                    AEItemStack toInject;
                    ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
                    outputs.add(result.func_77946_l());
                    for (int i = 0; i < craftingGrid.func_70302_i_(); ++i) {
                        ItemStack remaining = craftingGrid.func_70301_a(i).func_77973_b().getContainerItem(craftingGrid.func_70301_a(i));
                        if (remaining.func_190926_b()) continue;
                        outputs.add(remaining);
                    }
                    boolean allPushed = true;
                    for (ItemStack outputStack : outputs) {
                        toInject = AEItemStack.fromItemStack((ItemStack)outputStack);
                        IAEItemStack overflow = (IAEItemStack)storage.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).injectItems((IAEStack)toInject, Actionable.SIMULATE, this.actionSource);
                        if (overflow == null || overflow.getStackSize() <= 0L) continue;
                        allPushed = false;
                        break;
                    }
                    if (!allPushed) continue;
                    for (ItemStack outputStack : outputs) {
                        toInject = AEItemStack.fromItemStack((ItemStack)outputStack);
                        storage.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).injectItems((IAEStack)toInject, Actionable.MODULATE, this.actionSource);
                    }
                    processedThisTick += outputs.size();
                    this.addCompletedOperations(1.0);
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        }
        if (this.activeJobs.isEmpty()) {
            return TickRateModulation.SLEEP;
        }
        return TickRateModulation.URGENT;
    }

    @MENetworkEventSubscribe
    public void onPowerEvent(MENetworkPowerStatusChange p) {
        this.updatePowerState();
        if (Platform.isServer()) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
            if (!this.itemsToSend.isEmpty()) {
                this.pushItemsOut();
            }
        }
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getProxy().getNode().isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                details.setPriority(this.priority);
                craftingTracker.addCraftingOption((ICraftingMedium)this, details);
            }
        }
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().improvedMolecularAssembler();
    }

    @Override
    public long getSortValue() {
        return (long)this.func_174877_v().func_177952_p() << 24 ^ (long)this.func_174877_v().func_177958_n() << 8 ^ (long)this.func_174877_v().func_177956_o();
    }

    @Override
    public BlockPos getTEPos() {
        return this.func_174877_v();
    }

    @Override
    public int getDim() {
        return this.func_145831_w().field_73011_w.getDimension();
    }

    @Override
    public IItemHandler getPatternsInv() {
        return this.getInternalInventory();
    }

    @Override
    public String getName() {
        return CrazyAEGuiText.IMPROVED_MAC_GUI.getLocal();
    }
}

