/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.crafting.CraftBranchFailure;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.me.helpers.PlayerSource;
import appeng.tile.crafting.TileCraftingMonitorTile;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.i18n.CrazyAEGuiText;
import dev.beecube31.crazyae2.common.interfaces.IGridHostMonitorable;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftCallback;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftingMethod;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftingProviderHelper;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyInterfaceHost;
import dev.beecube31.crazyae2.common.interfaces.mixin.crafting.IMixinCraftingCPUStatus;
import dev.beecube31.crazyae2.common.networking.events.MECraftHostPatternsChangedEv;
import dev.beecube31.crazyae2.common.networking.events.MECraftHostStateUpdateEv;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import dev.beecube31.crazyae2.core.cache.impl.CrazyAutocraftingSystem;
import dev.beecube31.crazyae2.core.config.CrazyAEAutoCraftingSystemConfig;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftContainer;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingInventory;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingJob;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingLink;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileQuantumCPU
extends CrazyCraftContainer
implements IConfigManagerHost,
ICraftingCPU,
ICrazyCraftHost,
ICrazyCraftingMethod,
ICrazyCraftCallback,
IGridHostMonitorable,
IMixinCraftingCPUStatus,
IGridTickable {
    private final CrazyAEInternalInv patternsInv;
    private final CrazyAEInternalInv accelsInv;
    private final CrazyAEInternalInv storagesInv;
    private final Map<ICraftingPatternDetails, PendingInterfaceTask> pendingInterfaceTasks;
    private final IConfigManager settings;
    private boolean isPowered;
    private boolean cached;
    private final IActionSource actionSource;
    private int priority;
    private Set<ICraftingPatternDetails> craftingList;
    private final List<IAEItemStack> itemsToSend;
    private long accelsCount;
    private double storageCount;
    private long initialTotalItems;
    private long initialTotalExpectedItems;
    private String myOwnName;
    private long millisWhenJobStarted;
    private String jobInitiator;

    public TileQuantumCPU() {
        this.patternsInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 1024, 1).setItemFilter(RestrictedSlot.PlaceableItemType.ENCODED_CRAFTING_PATTERN.associatedFilter);
        this.accelsInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 18, 64).setItemFilter(RestrictedSlot.PlaceableItemType.CRAFTING_ACCELERATORS.associatedFilter);
        this.storagesInv = new CrazyAEInternalInv((IAEAppEngInventory)this, 18, 64).setItemFilter(RestrictedSlot.PlaceableItemType.CRAFTING_STORAGES.associatedFilter);
        this.pendingInterfaceTasks = new ConcurrentHashMap<ICraftingPatternDetails, PendingInterfaceTask>();
        this.isPowered = false;
        this.cached = false;
        this.actionSource = new MachineSource((IActionHost)this);
        this.priority = 1;
        this.craftingList = null;
        this.itemsToSend = new ArrayList<IAEItemStack>();
        this.accelsCount = -1L;
        this.storageCount = -1.0;
        this.initialTotalItems = 0L;
        this.initialTotalExpectedItems = 0L;
        this.myOwnName = "";
        this.millisWhenJobStarted = 0L;
        this.jobInitiator = "";
        this.settings = new ConfigManager((IConfigManagerHost)this);
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getProxy().setIdlePowerUsage(4096.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    @Override
    public boolean isBusy() {
        boolean tasksActive = false;
        if (!this.tasks.isEmpty()) {
            for (CrazyCraftContainer.TaskProgress p : this.tasks.values()) {
                if (p.value <= 0L) continue;
                tasksActive = true;
                break;
            }
        }
        return this.finalOutput != null && this.finalOutput.getStackSize() > 0L || tasksActive || !this.pendingInterfaceTasks.isEmpty() || !this.waitingFor.isEmpty() || !this.itemsToSend.isEmpty();
    }

    public IActionSource getActionSource() {
        return this.actionSource;
    }

    public long getAvailableStorage() {
        return (long)this.getStorageCount();
    }

    public int getCoProcessors() {
        return (int)Math.min(this.getAcceleratorCount(), Integer.MAX_VALUE);
    }

    public long getRemainingItemCount() {
        if (!this.isBusy() && (this.finalOutput == null || this.finalOutput.getStackSize() <= 0L) && this.tasks.isEmpty() && this.pendingInterfaceTasks.isEmpty() && this.waitingFor.isEmpty()) {
            return 0L;
        }
        long remainingItems = 0L;
        for (Map.Entry entry : this.tasks.entrySet()) {
            ICraftingPatternDetails details = (ICraftingPatternDetails)entry.getKey();
            CrazyCraftContainer.TaskProgress progress = (CrazyCraftContainer.TaskProgress)entry.getValue();
            if (progress.value <= 0L) continue;
            IAEItemStack[] iAEItemStackArray = details.getCondensedOutputs();
            int n = iAEItemStackArray.length;
            for (int i = 0; i < n; ++i) {
                IAEItemStack output = iAEItemStackArray[i];
                remainingItems += Utils.multiplySafely(output.getStackSize(), progress.value);
            }
        }
        for (Map.Entry<Object, Object> entry : this.pendingInterfaceTasks.entrySet()) {
            PendingInterfaceTask pendingTask = (PendingInterfaceTask)entry.getValue();
            if (pendingTask.details == null || pendingTask.pendingBatches <= 0L) continue;
            for (IAEItemStack output : pendingTask.details.getCondensedOutputs()) {
                remainingItems += Utils.multiplySafely(output.getStackSize(), pendingTask.pendingBatches);
            }
        }
        return Math.max(0L, remainingItems);
    }

    public long getStartItemCount() {
        return this.initialTotalExpectedItems;
    }

    public IAEItemStack getFinalOutput() {
        if (this.finalOutput != null) {
            return this.finalOutput.copy();
        }
        return null;
    }

    @Override
    public boolean pushDetails(ICraftingPatternDetails details, long crafts) {
        CrazyCraftContainer.TaskProgress i = this.tasks.computeIfAbsent(details, k -> new CrazyCraftContainer.TaskProgress());
        i.value += crafts;
        return true;
    }

    @Override
    public ICraftingLink pushJob(ICraftingJob job, ICraftingRequester requester, IActionSource src) {
        if (!this.waitingFor.isEmpty()) {
            return null;
        }
        if (this.isBusy() || this.getStorageCount() < (double)job.getByteTotal()) {
            return null;
        }
        try {
            IStorageGrid sg = (IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class);
            IMEMonitor storage = sg.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            CrazyCraftingInventory ci = new CrazyCraftingInventory((IMEInventory<IAEItemStack>)storage, true, false, false);
            try {
                this.waitingFor.resetStatus();
                ((CrazyCraftingJob)job).getTree().setJob(ci, this, src);
                if (ci.commit(src)) {
                    PlayerSource playerSource;
                    this.finalOutput = job.getOutput();
                    this.waiting = false;
                    this.isComplete = false;
                    this.requestingPlayerUUID = src instanceof PlayerSource && (playerSource = (PlayerSource)src).player().isPresent() ? ((EntityPlayer)playerSource.player().get()).func_110124_au() : null;
                    this.func_70296_d();
                    this.updateCrafting();
                    String craftID = Utils.generateCraftingID(null);
                    this.myLastLink = new CrazyCraftingLink(Utils.generateLinkData(craftID, requester == null, false), this);
                    this.prepareElapsedTime();
                    this.initialTotalItems = 0L;
                    for (CrazyCraftContainer.TaskProgress taskProgress : this.tasks.values()) {
                        this.initialTotalItems += taskProgress.value;
                    }
                    this.initialTotalExpectedItems = 0L;
                    for (Map.Entry entry : this.tasks.entrySet()) {
                        ICraftingPatternDetails details = (ICraftingPatternDetails)entry.getKey();
                        CrazyCraftContainer.TaskProgress progress = (CrazyCraftContainer.TaskProgress)entry.getValue();
                        for (IAEItemStack output : details.getCondensedOutputs()) {
                            this.initialTotalExpectedItems += Utils.multiplySafely(output.getStackSize(), progress.value);
                        }
                    }
                    if (requester == null) {
                        this.setCraftInfo(src);
                        return this.myLastLink;
                    }
                    CrazyCraftingLink whatLink = new CrazyCraftingLink(Utils.generateLinkData(craftID, false, true), this);
                    this.submitLink(this.myLastLink);
                    this.submitLink(whatLink);
                    IItemList iItemList = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
                    this.getListOfItem((IItemList<IAEItemStack>)iItemList, CraftingItemList.ALL);
                    for (IAEItemStack ge : iItemList) {
                        Utils.postChange(ge, this.actionSource, this.getListeners());
                    }
                    this.setCraftInfo(src);
                    return whatLink;
                }
                this.tasks.clear();
                this.inventory.getItemList().resetStatus();
                this.initialTotalItems = 0L;
            }
            catch (CraftBranchFailure e) {
                this.tasks.clear();
                this.inventory.getItemList().resetStatus();
                this.initialTotalItems = 0L;
            }
            CrazyCraftingLink link = new CrazyCraftingLink(Utils.generateLinkData(Utils.generateCraftingID(job.getOutput()), false, true), this);
            this.submitLink(link);
            IItemList list = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
            this.getListOfItem((IItemList<IAEItemStack>)list, CraftingItemList.ALL);
            for (IAEItemStack ge : list) {
                Utils.postChange(ge, this.actionSource, this.getListeners());
            }
            this.setCraftInfo(src);
            return link;
        }
        catch (GridAccessException gridAccessException) {
            this.initialTotalItems = 0L;
            return null;
        }
    }

    private void setCraftInfo(IActionSource src) {
        String initiator = src.player().isPresent() ? ((EntityPlayer)src.player().get()).func_70005_c_() : (src.machine().isPresent() ? ((IActionHost)src.machine().get()).getActionableNode().getGridBlock().getMachineRepresentation().func_82833_r() : "N/A");
        this.jobInitiator = initiator;
        this.millisWhenJobStarted = System.currentTimeMillis();
    }

    @Override
    protected void completeJob() {
        this.updateCrafting();
        super.completeJob();
        this.initialTotalItems = 0L;
        this.tasks.clear();
        this.initialTotalExpectedItems = 0L;
        this.pendingInterfaceTasks.clear();
        this.jobInitiator = "";
        this.millisWhenJobStarted = 0L;
        this.func_70296_d();
    }

    @Override
    public void cancel(IActionSource src) {
        HashMap<ICraftingPatternDetails, PendingInterfaceTask> tasksToCancelWithInterfaces = new HashMap<ICraftingPatternDetails, PendingInterfaceTask>(this.pendingInterfaceTasks);
        if (!tasksToCancelWithInterfaces.isEmpty()) {
            try {
                IGrid grid = this.getProxy().getGrid();
                if (grid != null) {
                    CrazyAutocraftingSystem cc = (CrazyAutocraftingSystem)grid.getCache(ICrazyAutocraftingSystem.class);
                    for (Map.Entry entry : tasksToCancelWithInterfaces.entrySet()) {
                        Set<ICrazyInterfaceHost> relevantInterfaces;
                        PendingInterfaceTask taskInfo = (PendingInterfaceTask)entry.getValue();
                        if (taskInfo.details == null || taskInfo.pendingBatches <= 0L || (relevantInterfaces = cc.findInterfaceByDetails(taskInfo.details)) == null || relevantInterfaces.isEmpty()) continue;
                        for (ICrazyInterfaceHost interfaceHost : relevantInterfaces) {
                            if (interfaceHost.getNode() == null || !interfaceHost.getNode().isActive()) continue;
                            interfaceHost.cancelCraftingForPattern(taskInfo.details, this);
                        }
                    }
                }
            }
            catch (GridAccessException grid) {
                // empty catch block
            }
        }
        this.pendingInterfaceTasks.clear();
        if (!this.waitingFor.isEmpty()) {
            IItemList toPost = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
            for (IAEItemStack stack : this.waitingFor) {
                if (stack == null || stack.getStackSize() <= 0L) continue;
                IAEItemStack negStack = stack.copy();
                negStack.setStackSize(-stack.getStackSize());
                toPost.add((IAEStack)negStack);
            }
            this.waitingFor.resetStatus();
            if (!toPost.isEmpty()) {
                for (IAEItemStack negStack : toPost) {
                    this.postCraftingStatusChange(negStack);
                    Utils.postChange(negStack, src, this.getListeners());
                }
            }
        }
        super.cancel(src);
        this.initialTotalItems = 0L;
        this.initialTotalExpectedItems = 0L;
        this.jobInitiator = "";
        this.millisWhenJobStarted = 0L;
        if (!this.itemsToSend.isEmpty()) {
            this.pushItemsOut();
        }
        this.isComplete = true;
        this.updateCrafting();
        this.func_70296_d();
    }

    private void updateElapsedTime() {
        long nextStartTime = System.nanoTime();
        this.elapsedTime = this.getElapsedTime() + nextStartTime - this.lastTime;
        this.lastTime = nextStartTime;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    private void checkAndCompleteJob() {
        boolean conditionsMet;
        if (this.isComplete) {
            return;
        }
        boolean allInternalTasksDone = true;
        if (!this.tasks.isEmpty()) {
            allInternalTasksDone = this.tasks.values().stream().allMatch(p -> p.value <= 0L);
        }
        boolean allInterfaceTasksDone = this.pendingInterfaceTasks.isEmpty();
        boolean allItemsReceived = this.waitingFor.isEmpty();
        boolean allItemsSent = this.itemsToSend.isEmpty();
        boolean bl = conditionsMet = allInternalTasksDone && allInterfaceTasksDone && allItemsReceived && allItemsSent;
        if (conditionsMet) {
            this.completeJob();
        }
    }

    @Override
    public void tickCraftHost(IGrid grid, CrazyAutocraftingSystem cache) {
        boolean hasPendingInterfaceTasks;
        if (!this.getProxy().isActive()) {
            return;
        }
        if (!this.itemsToSend.isEmpty() && this.getProxy().isActive()) {
            this.pushItemsOut();
        }
        if (this.myLastLink != null && this.myLastLink.isCanceled()) {
            this.myLastLink = null;
            this.cancel(this.actionSource);
            return;
        }
        if (this.isComplete) {
            if (!this.inventory.getItemList().isEmpty()) {
                this.storeItems(this.actionSource);
            }
            if (!this.itemsToSend.isEmpty()) {
                this.pushItemsOut();
            }
            return;
        }
        this.waiting = false;
        boolean hasInternalTasks = !this.tasks.isEmpty() && this.tasks.values().stream().anyMatch(p -> p.value > 0L);
        boolean bl = hasPendingInterfaceTasks = !this.pendingInterfaceTasks.isEmpty();
        if (!hasInternalTasks && !hasPendingInterfaceTasks && this.waitingFor.isEmpty()) {
            this.checkAndCompleteJob();
            if (this.isComplete) {
                return;
            }
        }
        long startedOps = this.remainingOperations = this.getAcceleratorCount() + 1L - (this.usedOps[0] + this.usedOps[1] + this.usedOps[2]);
        if (this.remainingOperations > 0L && hasInternalTasks) {
            this.updateElapsedTime();
            do {
                this.somethingChanged = false;
                this.executeCrafting(cache);
                boolean bl2 = hasInternalTasks = !this.tasks.isEmpty() && this.tasks.values().stream().anyMatch(p -> p.value > 0L);
            } while (this.somethingChanged && this.remainingOperations > 0L && hasInternalTasks);
        }
        if (!hasInternalTasks && !hasPendingInterfaceTasks && this.waitingFor.isEmpty()) {
            this.checkAndCompleteJob();
            if (this.isComplete) {
                return;
            }
            if (this.remainingOperations <= 0L) {
                this.waiting = true;
            }
        }
        this.usedOps[2] = this.usedOps[1];
        this.usedOps[1] = this.usedOps[0];
        this.usedOps[0] = startedOps - this.remainingOperations;
        if (this.remainingOperations <= 0L && (hasInternalTasks || hasPendingInterfaceTasks)) {
            this.waiting = true;
        } else if (!this.somethingChanged && !hasInternalTasks && !hasPendingInterfaceTasks && this.waitingFor.isEmpty()) {
            this.waiting = true;
        }
        this.checkAndCompleteJob();
    }

    private void executeCrafting(CrazyAutocraftingSystem cc) {
        ICraftingPatternDetails details;
        HashMap<ICraftingPatternDetails, Long> interfaceTasks = new HashMap<ICraftingPatternDetails, Long>();
        Iterator taskIterator = this.tasks.entrySet().iterator();
        while (taskIterator.hasNext()) {
            Map.Entry entry = taskIterator.next();
            ICraftingPatternDetails iCraftingPatternDetails = (ICraftingPatternDetails)entry.getKey();
            CrazyCraftContainer.TaskProgress progress = (CrazyCraftContainer.TaskProgress)entry.getValue();
            if (progress.value <= 0L) {
                taskIterator.remove();
                continue;
            }
            if (iCraftingPatternDetails.isCraftable()) continue;
            interfaceTasks.merge(iCraftingPatternDetails, progress.value, Long::sum);
        }
        if (!interfaceTasks.isEmpty()) {
            for (Map.Entry entry : interfaceTasks.entrySet()) {
                Set<ICrazyInterfaceHost> candidateInterfaces;
                if (this.remainingOperations <= 0L && this.getCoProcessors() > 0 && interfaceTasks.values().stream().anyMatch(v -> v > 0L)) break;
                details = (ICraftingPatternDetails)entry.getKey();
                long totalExecutionsStillNeeded = (Long)entry.getValue();
                CrazyCraftContainer.TaskProgress originalProgress = (CrazyCraftContainer.TaskProgress)this.tasks.get(details);
                if (originalProgress == null || originalProgress.value <= 0L || (totalExecutionsStillNeeded = Math.min(totalExecutionsStillNeeded, originalProgress.value)) <= 0L || (candidateInterfaces = cc.findInterfaceByDetails(details)).isEmpty()) continue;
                ArrayList<ICrazyInterfaceHost> availableInterfaces = new ArrayList<ICrazyInterfaceHost>(candidateInterfaces);
                availableInterfaces.sort(Comparator.comparingInt(host -> ((IPriorityHost)host.getTile()).getPriority()));
                long executionsDelegated = 0L;
                for (ICrazyInterfaceHost currentInterface : availableInterfaces) {
                    List<IAEItemStack> extracted;
                    long estimatedByInterface;
                    long maxPossibleDelegationsConfig = CrazyAEAutoCraftingSystemConfig.maxDelegationSizePerInterface;
                    long maxPossibleDelegations = totalExecutionsStillNeeded - executionsDelegated;
                    long batchSize = Math.min(maxPossibleDelegationsConfig, maxPossibleDelegations);
                    if (this.getCoProcessors() > 0) {
                        batchSize = Math.min(batchSize, this.remainingOperations);
                    } else if (maxPossibleDelegations > 0L) {
                        batchSize = Math.max(1L, batchSize);
                    }
                    if (batchSize <= 0L || (batchSize = Math.min(batchSize, estimatedByInterface = currentInterface.estimatePushableBatchSize(details, batchSize, this, this.field_145850_b))) <= 0L || (extracted = this.extractIngredientsForBatch(details, batchSize)) == null) continue;
                    if (currentInterface.pushDetails(details, batchSize, this)) {
                        this.somethingChanged = true;
                        executionsDelegated += batchSize;
                        PendingInterfaceTask taskState = this.pendingInterfaceTasks.computeIfAbsent(details, k -> new PendingInterfaceTask(details, 0L));
                        taskState.pendingBatches += batchSize;
                        for (IAEItemStack outputTemplate : details.getCondensedOutputs()) {
                            if (outputTemplate == null || outputTemplate.getStackSize() <= 0L) continue;
                            IAEItemStack expectedOutput = outputTemplate.copy();
                            long amountToExpect = Utils.multiplySafely(outputTemplate.getStackSize(), batchSize);
                            if (amountToExpect <= 0L) continue;
                            expectedOutput.setStackSize(amountToExpect);
                            this.waitingFor.add((IAEStack)expectedOutput.copy());
                            this.postCraftingStatusChange(expectedOutput.copy());
                        }
                        List<IAEItemStack> containerItemsFromInterface = this.handleContainerItems(details, batchSize);
                        for (IAEItemStack containerItem : containerItemsFromInterface) {
                            if (containerItem == null || containerItem.getStackSize() <= 0L) continue;
                            this.waitingFor.add((IAEStack)containerItem.copy());
                            this.postCraftingStatusChange(containerItem.copy());
                        }
                        if (this.getCoProcessors() > 0) {
                            this.remainingOperations -= batchSize;
                        }
                        this.func_70296_d();
                        continue;
                    }
                    this.rollbackIngredients(extracted);
                }
                if (executionsDelegated <= 0L) continue;
                originalProgress.value -= executionsDelegated;
                if (originalProgress.value > 0L) continue;
                this.tasks.remove(details);
            }
        }
        Iterator craftableTaskIterator = this.tasks.entrySet().iterator();
        while (craftableTaskIterator.hasNext() && (this.remainingOperations > 0L || this.getCoProcessors() <= 0)) {
            IAEItemStack remainder;
            List<IAEItemStack> extractedItems;
            long actualCraftableNow;
            Map.Entry entry = craftableTaskIterator.next();
            details = (ICraftingPatternDetails)entry.getKey();
            CrazyCraftContainer.TaskProgress progress = (CrazyCraftContainer.TaskProgress)entry.getValue();
            if (progress.value <= 0L) {
                craftableTaskIterator.remove();
                continue;
            }
            if (!details.isCraftable()) continue;
            long maxBatchThisTickForPattern = progress.value;
            if (this.getCoProcessors() > 0) {
                maxBatchThisTickForPattern = Math.min(maxBatchThisTickForPattern, this.remainingOperations);
            } else if (progress.value > 0L) {
                maxBatchThisTickForPattern = Math.min(maxBatchThisTickForPattern, 1L);
            }
            if (maxBatchThisTickForPattern <= 0L || (actualCraftableNow = this.determineActualBatchSize(details, maxBatchThisTickForPattern)) <= 0L || (extractedItems = this.extractIngredientsForBatch(details, actualCraftableNow)) == null) continue;
            List<IAEItemStack> craftedOutputs = this.dispatchBatchJobInternal(details, actualCraftableNow);
            List<IAEItemStack> containerItems = this.handleContainerItems(details, actualCraftableNow);
            this.somethingChanged = true;
            for (IAEItemStack outputItem : craftedOutputs) {
                if (outputItem == null || outputItem.getStackSize() <= 0L || (remainder = this.injectCraftedInternally(outputItem.copy(), Actionable.MODULATE, this.getActionSource())) == null || remainder.getStackSize() <= 0L) continue;
                this.handleRemainder(remainder);
            }
            for (IAEItemStack containerItem : containerItems) {
                if (containerItem == null || containerItem.getStackSize() <= 0L || (remainder = this.injectCraftedInternally(containerItem.copy(), Actionable.MODULATE, this.getActionSource())) == null || remainder.getStackSize() <= 0L) continue;
                this.handleRemainder(remainder);
            }
            this.func_70296_d();
            progress.value -= actualCraftableNow;
            if (this.getCoProcessors() > 0) {
                this.remainingOperations -= actualCraftableNow;
            }
            if (progress.value > 0L) continue;
            craftableTaskIterator.remove();
        }
        this.checkAndCompleteJob();
    }

    private void handleRemainder(IAEItemStack remainder) {
        if (this.finalOutput != null && this.finalOutput.isSameType(remainder)) {
            this.itemsToSend.add(remainder.copy());
        } else {
            boolean merged = false;
            for (IAEItemStack stackInSend : this.itemsToSend) {
                if (!stackInSend.isSameType(remainder)) continue;
                stackInSend.add(remainder);
                merged = true;
                break;
            }
            if (!merged) {
                this.itemsToSend.add(remainder.copy());
            }
        }
    }

    private IAEItemStack injectToMe(IAEItemStack item, Actionable mode, IActionSource source) {
        if (!this.getProxy().isActive() || item == null || item.getStackSize() <= 0L) {
            return item;
        }
        try {
            IGrid grid = this.getProxy().getGrid();
            IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IMEMonitor storage = storageGrid.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            return (IAEItemStack)storage.injectItems((IAEStack)item, mode, source);
        }
        catch (GridAccessException gridAccessException) {
            return item;
        }
    }

    private IAEItemStack injectCraftedInternally(IAEItemStack input, Actionable type, IActionSource src) {
        if (input == null || input.getStackSize() <= 0L) {
            return null;
        }
        if (this.finalOutput != null && this.finalOutput.isSameType(input)) {
            return this.processFinalOutput(input, type);
        }
        IAEItemStack remainder = this.inventory.injectItems(input.copy(), type, src);
        if (remainder == null || remainder.getStackSize() <= 0L) {
            Utils.postChange(input, src, this.getListeners());
        } else {
            long injectedAmount = input.getStackSize() - remainder.getStackSize();
            if (injectedAmount > 0L) {
                IAEItemStack injectedPart = input.copy();
                injectedPart.setStackSize(injectedAmount);
                Utils.postChange(injectedPart, src, this.getListeners());
            }
        }
        return remainder;
    }

    @Override
    public void onCraftSentCallback(ICraftingPatternDetails details, long batchSize) {
    }

    @Override
    public void onCraftBatchCompletedCallback(ICraftingPatternDetails details, long batchSizeCompletedByInterface) {
        if (batchSizeCompletedByInterface <= 0L) {
            return;
        }
        if (this.isComplete) {
            ArrayList<IAEItemStack> allItems = new ArrayList<IAEItemStack>();
            for (IAEItemStack outputTemplate : details.getCondensedOutputs()) {
                IAEItemStack itemToProcess = outputTemplate.copy();
                long amountReturned = Utils.multiplySafely(outputTemplate.getStackSize(), batchSizeCompletedByInterface);
                if (amountReturned <= 0L) continue;
                itemToProcess.setStackSize(amountReturned);
                allItems.add(itemToProcess);
            }
            allItems.addAll(this.handleContainerItems(details, batchSizeCompletedByInterface));
            for (IAEItemStack item : allItems) {
                try {
                    IStorageGrid storageGrid;
                    IMEMonitor networkInv;
                    IAEItemStack remainder;
                    IGrid grid = this.getProxy().getGrid();
                    if (grid == null || (remainder = (IAEItemStack)(networkInv = (storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class))).injectItems((IAEStack)item.copy(), Actionable.MODULATE, this.getActionSource())) == null || remainder.getStackSize() <= 0L) continue;
                    boolean merged = false;
                    for (IAEItemStack stackInSend : this.itemsToSend) {
                        if (!stackInSend.isSameType(remainder)) continue;
                        stackInSend.add(remainder);
                        merged = true;
                        break;
                    }
                    if (merged) continue;
                    this.itemsToSend.add(remainder.copy());
                }
                catch (GridAccessException grid) {}
            }
            this.func_70296_d();
            return;
        }
        PendingInterfaceTask pendingTaskStatus = this.pendingInterfaceTasks.get(details);
        if (pendingTaskStatus != null) {
            pendingTaskStatus.pendingBatches -= batchSizeCompletedByInterface;
            if (pendingTaskStatus.pendingBatches <= 0L) {
                this.pendingInterfaceTasks.remove(details);
            }
        }
        ArrayList<IAEItemStack> allReturnedItems = new ArrayList<IAEItemStack>();
        for (IAEItemStack outputTemplate : details.getCondensedOutputs()) {
            IAEItemStack itemExpected = outputTemplate.copy();
            long amountExpected = Utils.multiplySafely(outputTemplate.getStackSize(), batchSizeCompletedByInterface);
            if (amountExpected <= 0L) continue;
            itemExpected.setStackSize(amountExpected);
            allReturnedItems.add(itemExpected);
        }
        allReturnedItems.addAll(this.handleContainerItems(details, batchSizeCompletedByInterface));
        for (IAEItemStack itemReceived : allReturnedItems) {
            IAEItemStack remainderAfterProcessing;
            if (itemReceived == null || itemReceived.getStackSize() <= 0L) continue;
            long amountToConsume = itemReceived.getStackSize();
            IItemList nextWaitingFor = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
            boolean waitingForChanged = false;
            for (IAEItemStack stackInWaitingFor : this.waitingFor) {
                IAEItemStack stackToKeep = stackInWaitingFor.copy();
                if (amountToConsume > 0L && stackInWaitingFor.isSameType(itemReceived)) {
                    long canTakeFromThisWaitingStack = Math.min(stackInWaitingFor.getStackSize(), amountToConsume);
                    IAEItemStack consumedPortion = stackInWaitingFor.copy();
                    consumedPortion.setStackSize(canTakeFromThisWaitingStack);
                    stackToKeep.decStackSize(canTakeFromThisWaitingStack);
                    amountToConsume -= canTakeFromThisWaitingStack;
                    waitingForChanged = true;
                    this.postCraftingStatusChange((IAEItemStack)consumedPortion.copy().setStackSize(-consumedPortion.getStackSize()));
                }
                if (stackToKeep.getStackSize() > 0L) {
                    nextWaitingFor.add((IAEStack)stackToKeep);
                    continue;
                }
                if (!stackInWaitingFor.isSameType(itemReceived)) continue;
                waitingForChanged = true;
            }
            if (waitingForChanged) {
                this.waitingFor = nextWaitingFor;
            }
            IAEItemStack itemToProcess = itemReceived.copy();
            if (this.finalOutput != null && this.finalOutput.isSameType(itemToProcess)) {
                remainderAfterProcessing = this.processFinalOutput(itemToProcess.copy(), Actionable.MODULATE);
            } else {
                remainderAfterProcessing = this.inventory.injectItems(itemToProcess.copy(), Actionable.MODULATE, this.actionSource);
                if (remainderAfterProcessing == null || remainderAfterProcessing.getStackSize() <= 0L) {
                    Utils.postChange(itemToProcess, this.actionSource, this.getListeners());
                } else {
                    long injectedAmount = itemToProcess.getStackSize() - remainderAfterProcessing.getStackSize();
                    if (injectedAmount > 0L) {
                        IAEItemStack injectedPart = itemToProcess.copy();
                        injectedPart.setStackSize(injectedAmount);
                        Utils.postChange(injectedPart, this.actionSource, this.getListeners());
                    }
                }
            }
            if (remainderAfterProcessing == null || remainderAfterProcessing.getStackSize() <= 0L) continue;
            this.handleRemainder(remainderAfterProcessing);
        }
        this.func_70296_d();
        this.checkAndCompleteJob();
    }

    private void rollbackIngredients(List<IAEItemStack> itemsToRollback) {
        if (itemsToRollback == null || itemsToRollback.isEmpty()) {
            return;
        }
        for (IAEItemStack extractedItem : itemsToRollback) {
            if (extractedItem == null || extractedItem.getStackSize() <= 0L) continue;
            IAEItemStack itemToReturn = extractedItem.copy();
            IAEItemStack remainder = this.inventory.injectItems(itemToReturn, Actionable.MODULATE, this.actionSource);
            if (remainder == null || remainder.getStackSize() <= 0L) {
                Utils.postChange(itemToReturn, this.actionSource, this.getListeners());
                continue;
            }
            long returnedAmount = itemToReturn.getStackSize() - remainder.getStackSize();
            if (returnedAmount <= 0L) continue;
            IAEItemStack partialReturn = itemToReturn.copy();
            partialReturn.setStackSize(returnedAmount);
            Utils.postChange(partialReturn, this.actionSource, this.getListeners());
        }
        this.func_70296_d();
    }

    private long determineActualBatchSize(ICraftingPatternDetails details, long requestedBatchSize) {
        IAEItemStack[] condensedInputs = details.getCondensedInputs();
        long maxBatch = requestedBatchSize;
        HashMap<IAEItemStackMatcher, Long> requiredTotals = new HashMap<IAEItemStackMatcher, Long>();
        boolean canCraftAtLeastOne = true;
        for (IAEItemStack templateInput : condensedInputs) {
            if (templateInput == null || templateInput.getStackSize() == 0L) continue;
            long neededPerCraft = templateInput.getStackSize();
            long totalNeeded = Utils.multiplySafely(neededPerCraft, requestedBatchSize);
            if (totalNeeded <= 0L && requestedBatchSize > 0L) {
                return 0L;
            }
            IAEItemStackMatcher matcher = IAEItemStackMatcher.create(templateInput, details);
            requiredTotals.put(matcher, requiredTotals.getOrDefault(matcher, 0L) + totalNeeded);
        }
        for (Map.Entry entry : requiredTotals.entrySet()) {
            IAEItemStackMatcher matcher = (IAEItemStackMatcher)entry.getKey();
            long neededPerCraft = matcher.template.getStackSize();
            if (neededPerCraft <= 0L) continue;
            long totalAvailable = this.countAvailableItems(matcher);
            if (totalAvailable < neededPerCraft) {
                maxBatch = 0L;
                canCraftAtLeastOne = false;
                break;
            }
            long possibleCraftsWithThisItem = totalAvailable / neededPerCraft;
            maxBatch = Math.min(maxBatch, possibleCraftsWithThisItem);
        }
        if (!canCraftAtLeastOne) {
            return 0L;
        }
        return maxBatch;
    }

    private List<IAEItemStack> extractIngredientsForBatch(ICraftingPatternDetails details, long actualBatchSize) {
        ArrayList<IAEItemStack> extractedItems = new ArrayList<IAEItemStack>();
        IAEItemStack[] inputs = details.getInputs();
        for (int slotIndex = 0; slotIndex < inputs.length; ++slotIndex) {
            boolean itemExtractedForSlot;
            IAEItemStack templateInput = inputs[slotIndex];
            if (templateInput == null || templateInput.getStackSize() == 0L) continue;
            long totalToExtract = Utils.multiplySafely(templateInput.getStackSize(), actualBatchSize);
            if (totalToExtract <= 0L && actualBatchSize > 0L) {
                this.rollbackExtraction(extractedItems);
                return null;
            }
            if (totalToExtract == 0L) continue;
            IAEItemStack request = templateInput.copy();
            request.setStackSize(totalToExtract);
            long remainingToExtract = totalToExtract;
            if (details.isCraftable() && details.canSubstitute()) {
                List substitutes = details.getSubstituteInputs(slotIndex);
                ArrayList<IAEItemStack> potentialSources = new ArrayList<IAEItemStack>();
                potentialSources.add(templateInput);
                potentialSources.addAll(substitutes);
                for (IAEItemStack potentialSource : potentialSources) {
                    if (remainingToExtract > 0L) {
                        IAEItemStack requestPart = potentialSource.copy();
                        requestPart.setStackSize(remainingToExtract);
                        IAEItemStack currentExtracted = this.inventory.extractItems(requestPart, Actionable.MODULATE, this.actionSource);
                        if (currentExtracted == null || currentExtracted.getStackSize() <= 0L) continue;
                        extractedItems.add(currentExtracted.copy());
                        remainingToExtract -= currentExtracted.getStackSize();
                        Utils.postChange(currentExtracted, this.actionSource, this.getListeners());
                        continue;
                    }
                    break;
                }
            } else {
                IAEItemStack extractedBatch = this.inventory.extractItems(request, Actionable.MODULATE, this.actionSource);
                if (extractedBatch != null && extractedBatch.getStackSize() > 0L) {
                    extractedItems.add(extractedBatch.copy());
                    remainingToExtract -= extractedBatch.getStackSize();
                    Utils.postChange(extractedBatch, this.actionSource, this.getListeners());
                }
            }
            boolean bl = itemExtractedForSlot = remainingToExtract <= 0L;
            if (itemExtractedForSlot) continue;
            this.rollbackExtraction(extractedItems);
            return null;
        }
        return extractedItems;
    }

    private void rollbackExtraction(List<IAEItemStack> extractedItems) {
        for (IAEItemStack toReturn : extractedItems) {
            IAEItemStack returned = this.inventory.injectItems(toReturn.copy(), Actionable.MODULATE, this.actionSource);
            if (returned != null && returned.getStackSize() > 0L) continue;
            Utils.postChange(toReturn, this.actionSource, this.getListeners());
        }
    }

    private List<IAEItemStack> handleContainerItems(ICraftingPatternDetails details, long actualBatchSize) {
        IAEItemStack[] inputs;
        ArrayList<IAEItemStack> containerItems = new ArrayList<IAEItemStack>();
        for (IAEItemStack templateInput : inputs = details.getInputs()) {
            long totalContainers;
            long totalUnitsUsed;
            AEItemStack aeContainerStack;
            ItemStack containerStack;
            ItemStack inputStack;
            if (templateInput == null || templateInput.getStackSize() <= 0L || (inputStack = templateInput.createItemStack()).func_190926_b() || (containerStack = Platform.getContainerItem((ItemStack)inputStack.func_77946_l().func_77979_a(1))).func_190926_b() || (aeContainerStack = AEItemStack.fromItemStack((ItemStack)containerStack.func_77946_l())) == null || aeContainerStack.getStackSize() <= 0L || (totalUnitsUsed = Utils.multiplySafely(templateInput.getStackSize(), actualBatchSize)) <= 0L && actualBatchSize > 0L || totalUnitsUsed == 0L || (totalContainers = Utils.multiplySafely(aeContainerStack.getStackSize(), totalUnitsUsed)) <= 0L) continue;
            IAEItemStack finalBatchContainer = aeContainerStack.copy();
            finalBatchContainer.setStackSize(totalContainers);
            boolean merged = false;
            for (IAEItemStack existingContainer : containerItems) {
                if (!existingContainer.isSameType(finalBatchContainer)) continue;
                existingContainer.setStackSize(existingContainer.getStackSize() + finalBatchContainer.getStackSize());
                merged = true;
                break;
            }
            if (merged) continue;
            containerItems.add(finalBatchContainer);
        }
        return containerItems;
    }

    @Override
    public IAEItemStack getItemStack(IAEItemStack what, CraftingItemList storage2) {
        IAEItemStack is;
        switch (storage2) {
            case STORAGE: {
                is = (IAEItemStack)this.inventory.getItemList().findPrecise((IAEStack)what);
                break;
            }
            case ACTIVE: {
                is = (IAEItemStack)this.waitingFor.findPrecise((IAEStack)what);
                break;
            }
            case PENDING: {
                is = what.copy();
                is.setStackSize(0L);
                for (Map.Entry t : this.tasks.entrySet()) {
                    for (IAEItemStack ais : ((ICraftingPatternDetails)t.getKey()).getCondensedOutputs()) {
                        if (!ais.isSameType(is)) continue;
                        is.setStackSize(is.getStackSize() + ais.getStackSize() * ((CrazyCraftContainer.TaskProgress)t.getValue()).value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Operation!!1");
            }
        }
        if (is != null) {
            return is.copy();
        }
        is = what.copy();
        is.setStackSize(0L);
        return is;
    }

    @Override
    public long crazyae$whenJobStarted() {
        return this.millisWhenJobStarted;
    }

    @Override
    public void crazyae$setWhenJobStarted(long when) {
        this.millisWhenJobStarted = when;
    }

    @Override
    public String crazyae$jobInitiator() {
        return this.jobInitiator;
    }

    @Override
    public void crazyae$setJobInitiator(String player) {
        this.jobInitiator = player;
    }

    @Override
    public CrazyCraftingLink getLastLink() {
        return (CrazyCraftingLink)this.myLastLink;
    }

    @Override
    public IGridNode getNode() {
        return this.getProxy().getNode();
    }

    @Override
    public void jobStateChange(ICraftingLink link) {
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack aeStack, Actionable mode) {
        if (aeStack == null || aeStack.getStackSize() <= 0L) {
            return null;
        }
        if (mode == Actionable.SIMULATE) {
            try {
                IGrid grid = this.getProxy().getGrid();
                if (grid == null) {
                    return aeStack.copy();
                }
                IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
                IMEMonitor networkInv = storageGrid.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                return (IAEItemStack)networkInv.injectItems((IAEStack)aeStack.copy(), Actionable.SIMULATE, this.getActionSource());
            }
            catch (GridAccessException e) {
                return aeStack.copy();
            }
        }
        IAEItemStack remainder = aeStack.copy();
        if (this.getProxy().isActive()) {
            try {
                IGrid grid = this.getProxy().getGrid();
                if (grid != null) {
                    IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
                    IMEMonitor networkInv = storageGrid.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                    remainder = (IAEItemStack)networkInv.injectItems((IAEStack)aeStack.copy(), Actionable.MODULATE, this.getActionSource());
                    if (remainder == null || remainder.getStackSize() <= 0L) {
                        this.func_70296_d();
                        return null;
                    }
                    long injectedAmount = aeStack.getStackSize() - remainder.getStackSize();
                    if (injectedAmount > 0L) {
                        this.func_70296_d();
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return remainder;
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        if (input == null || input.getStackSize() <= 0L) {
            return input;
        }
        if (this.isComplete && (this.finalOutput == null || !this.finalOutput.isSameType(input))) {
            if (type == Actionable.MODULATE) {
                IAEItemStack remainder = this.injectToMe(input.copy(), Actionable.MODULATE, src != null ? src : this.actionSource);
                if (remainder != null && remainder.getStackSize() > 0L) {
                    this.handleRemainder(remainder.copy());
                }
                return null;
            }
            return this.injectToMe(input.copy(), Actionable.SIMULATE, src != null ? src : this.actionSource);
        }
        if (type == Actionable.SIMULATE) {
            IAEItemStack remaining = input.copy();
            for (IAEItemStack wfStack : this.waitingFor) {
                if (wfStack == null || wfStack.getStackSize() <= 0L || !wfStack.isSameType(remaining)) continue;
                long canTake = Math.min(remaining.getStackSize(), wfStack.getStackSize());
                remaining.decStackSize(canTake);
                if (remaining.getStackSize() > 0L) continue;
                return null;
            }
            return remaining;
        }
        IAEItemStack currentInput = input.copy();
        IAEItemStack remainderAfterProcessing = null;
        boolean waitingForChanged = false;
        IItemList nextWaitingForList = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
        for (IAEItemStack waitingStack : this.waitingFor) {
            IAEItemStack stackToKeepInNext = waitingStack.copy();
            if (currentInput.getStackSize() > 0L && waitingStack.getStackSize() > 0L && waitingStack.isSameType(currentInput)) {
                IAEItemStack remainderFromProcessing;
                this.waiting = false;
                long canTakeFromWaiting = Math.min(currentInput.getStackSize(), waitingStack.getStackSize());
                IAEItemStack takenFromWaiting = waitingStack.copy();
                takenFromWaiting.setStackSize(canTakeFromWaiting);
                stackToKeepInNext.decStackSize(canTakeFromWaiting);
                currentInput.decStackSize(canTakeFromWaiting);
                waitingForChanged = true;
                this.postCraftingStatusChange((IAEItemStack)takenFromWaiting.copy().setStackSize(-takenFromWaiting.getStackSize()));
                if (this.finalOutput != null && this.finalOutput.isSameType(takenFromWaiting)) {
                    remainderFromProcessing = this.processFinalOutput(takenFromWaiting.copy(), Actionable.MODULATE);
                } else {
                    remainderFromProcessing = this.inventory.injectItems(takenFromWaiting.copy(), Actionable.MODULATE, src);
                    if (remainderFromProcessing == null || remainderFromProcessing.getStackSize() <= 0L) {
                        Utils.postChange(takenFromWaiting, src, this.getListeners());
                    } else {
                        long injectedAmt = takenFromWaiting.getStackSize() - remainderFromProcessing.getStackSize();
                        if (injectedAmt > 0L) {
                            Utils.postChange((IAEItemStack)takenFromWaiting.copy().setStackSize(injectedAmt), src, this.getListeners());
                        }
                    }
                }
                if (remainderFromProcessing != null && remainderFromProcessing.getStackSize() > 0L) {
                    if (remainderAfterProcessing == null) {
                        remainderAfterProcessing = remainderFromProcessing.copy();
                    } else {
                        remainderAfterProcessing.add(remainderFromProcessing);
                    }
                }
            }
            if (stackToKeepInNext.getStackSize() > 0L) {
                nextWaitingForList.add((IAEStack)stackToKeepInNext);
                continue;
            }
            if (!waitingStack.isSameType(currentInput) && (!input.isSameType(waitingStack) || waitingStack.getStackSize() <= 0L)) continue;
            waitingForChanged = true;
        }
        if (waitingForChanged) {
            this.waitingFor = nextWaitingForList;
            this.func_70296_d();
        }
        if (currentInput.getStackSize() > 0L) {
            IAEItemStack remainderFromProcessingUnfulfilled;
            IAEItemStack unfulfilledByWaiting = currentInput.copy();
            if (this.finalOutput != null && this.finalOutput.isSameType(unfulfilledByWaiting)) {
                remainderFromProcessingUnfulfilled = this.processFinalOutput(unfulfilledByWaiting.copy(), Actionable.MODULATE);
            } else {
                remainderFromProcessingUnfulfilled = this.inventory.injectItems(unfulfilledByWaiting.copy(), Actionable.MODULATE, src);
                if (remainderFromProcessingUnfulfilled == null || remainderFromProcessingUnfulfilled.getStackSize() <= 0L) {
                    Utils.postChange(unfulfilledByWaiting, src, this.getListeners());
                } else {
                    long injectedAmt = unfulfilledByWaiting.getStackSize() - remainderFromProcessingUnfulfilled.getStackSize();
                    if (injectedAmt > 0L) {
                        Utils.postChange((IAEItemStack)unfulfilledByWaiting.copy().setStackSize(injectedAmt), src, this.getListeners());
                    }
                }
            }
            if (remainderFromProcessingUnfulfilled != null && remainderFromProcessingUnfulfilled.getStackSize() > 0L) {
                if (remainderAfterProcessing == null) {
                    remainderAfterProcessing = remainderFromProcessingUnfulfilled.copy();
                } else {
                    remainderAfterProcessing.add(remainderFromProcessingUnfulfilled);
                }
            }
        }
        if (remainderAfterProcessing == null || remainderAfterProcessing.getStackSize() <= 0L) {
            this.checkAndCompleteJob();
        }
        if (remainderAfterProcessing != null && remainderAfterProcessing.getStackSize() > 0L) {
            boolean alreadyInItemsToSend = false;
            for (IAEItemStack its : this.itemsToSend) {
                if (!its.isSameType(remainderAfterProcessing)) continue;
                alreadyInItemsToSend = true;
                break;
            }
            if (alreadyInItemsToSend) {
                this.checkAndCompleteJob();
                return null;
            }
        }
        return remainderAfterProcessing;
    }

    @Override
    protected void updateCrafting() {
        IAEItemStack sendToGui = null;
        if (this.finalOutput != null && this.finalOutput.getStackSize() > 0L) {
            sendToGui = this.finalOutput.copy();
        }
        for (TileCraftingMonitorTile t : this.status) {
            t.setJob(sendToGui);
        }
    }

    private IAEItemStack processFinalOutput(IAEItemStack item, Actionable type) {
        IAEItemStack remainingAfterLink = item.copy();
        if (this.myLastLink != null) {
            remainingAfterLink = ((CrazyCraftingLink)this.myLastLink).injectItems(item.copy(), type);
        }
        if (remainingAfterLink != null && remainingAfterLink.getStackSize() > 0L) {
            boolean merged = false;
            for (IAEItemStack stackInSend : this.itemsToSend) {
                if (!stackInSend.isSameType(remainingAfterLink)) continue;
                stackInSend.add(remainingAfterLink);
                merged = true;
                break;
            }
            if (!merged) {
                this.itemsToSend.add(remainingAfterLink.copy());
            }
            this.func_70296_d();
        }
        this.updateCrafting();
        return null;
    }

    private void submitLink(ICraftingLink myLastLink2) {
        try {
            if (this.getProxy().getGrid() != null) {
                CrazyAutocraftingSystem cc = (CrazyAutocraftingSystem)this.getProxy().getGrid().getCache(ICrazyAutocraftingSystem.class);
                cc.addLink((CrazyCraftingLink)myLastLink2);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public IItemHandler getAcceleratorsInv() {
        return this.getInventoryByName("accelerators");
    }

    @Override
    public IItemHandler getStoragesInv() {
        return this.getInventoryByName("storages");
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        NBTTagCompound c;
        super.func_189515_b(data);
        this.patternsInv.writeToNBT(data, "patterns");
        this.accelsInv.writeToNBT(data, "accels");
        this.storagesInv.writeToNBT(data, "storages");
        this.settings.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        data.func_74772_a("initialTotalExpectedItems", this.initialTotalExpectedItems);
        NBTTagList tasksList = new NBTTagList();
        for (Map.Entry entry : this.tasks.entrySet()) {
            ICraftingPatternDetails iCraftingPatternDetails = (ICraftingPatternDetails)entry.getKey();
            CrazyCraftContainer.TaskProgress task = (CrazyCraftContainer.TaskProgress)entry.getValue();
            if (task.value <= 0L) continue;
            NBTTagCompound tag = new NBTTagCompound();
            ItemStack patternStack = iCraftingPatternDetails.getPattern();
            if (patternStack.func_190926_b()) continue;
            tag.func_74782_a("pattern", (NBTBase)patternStack.func_77955_b(new NBTTagCompound()));
            tag.func_74772_a("value", task.value);
            tasksList.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("craftingTasks", (NBTBase)tasksList);
        NBTTagList pendingInterfacesNBT = new NBTTagList();
        for (Map.Entry<ICraftingPatternDetails, PendingInterfaceTask> entry : this.pendingInterfaceTasks.entrySet()) {
            ICraftingPatternDetails patternDetailsAsKey = entry.getKey();
            PendingInterfaceTask task = entry.getValue();
            if (task.pendingBatches <= 0L || patternDetailsAsKey == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            ItemStack patternStackFromDetails = patternDetailsAsKey.getPattern();
            if (patternStackFromDetails.func_190926_b()) continue;
            tag.func_74782_a("patternStack", (NBTBase)patternStackFromDetails.func_77955_b(new NBTTagCompound()));
            tag.func_74772_a("pending", task.pendingBatches);
            pendingInterfacesNBT.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("pendingCPUInterfaces", (NBTBase)pendingInterfacesNBT);
        NBTTagList nBTTagList = new NBTTagList();
        for (Object stack : this.inventory.getItemList()) {
            if (stack == null || stack.getStackSize() <= 0L) continue;
            c = new NBTTagCompound();
            stack.writeToNBT(c);
            nBTTagList.func_74742_a((NBTBase)c);
        }
        data.func_74782_a("craftingInventory", (NBTBase)nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (Object stack : this.waitingFor) {
            if (stack == null || stack.getStackSize() <= 0L) continue;
            NBTTagCompound c2 = new NBTTagCompound();
            stack.writeToNBT(c2);
            nBTTagList2.func_74742_a((NBTBase)c2);
        }
        data.func_74782_a("waitingFor", (NBTBase)nBTTagList2);
        NBTTagList itemsToSendList = new NBTTagList();
        for (IAEItemStack i : this.itemsToSend) {
            if (i == null || i.getStackSize() <= 0L) continue;
            NBTTagCompound c3 = new NBTTagCompound();
            i.writeToNBT(c3);
            itemsToSendList.func_74742_a((NBTBase)c3);
        }
        data.func_74782_a("itemsToSend", (NBTBase)itemsToSendList);
        if (this.finalOutput != null && this.finalOutput.getStackSize() > 0L) {
            c = new NBTTagCompound();
            this.finalOutput.writeToNBT(c);
            data.func_74782_a("finalOutput", (NBTBase)c);
        }
        if (this.myLastLink != null) {
            NBTTagCompound linkNBT = new NBTTagCompound();
            this.myLastLink.writeToNBT(linkNBT);
            data.func_74782_a("myLastLinkData", (NBTBase)linkNBT);
        }
        data.func_74757_a("isComplete", this.isComplete);
        data.func_74772_a("initialTotalItems", this.initialTotalItems);
        if (this.requestingPlayerUUID != null) {
            data.func_74782_a("requestingPlayerUUID", (NBTBase)NBTUtil.func_186862_a((UUID)this.requestingPlayerUUID));
        }
        data.func_74778_a("cpuName", this.myOwnName);
        data.func_74772_a("elapsedTime", this.elapsedTime);
        data.func_74778_a("jobInitiator", this.jobInitiator);
        data.func_74772_a("millisJobStarted", this.millisWhenJobStarted);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        IAEItemStack stack;
        NBTTagCompound itemTags;
        Item details;
        ICraftingPatternItem cpi;
        ItemStack patternStack;
        NBTTagCompound tag;
        int i;
        super.func_145839_a(data);
        this.patternsInv.readFromNBT(data, "patterns");
        this.accelsInv.readFromNBT(data, "accels");
        this.storagesInv.readFromNBT(data, "storages");
        this.settings.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
        this.initialTotalExpectedItems = data.func_74763_f("initialTotalExpectedItems");
        this.tasks.clear();
        if (data.func_150297_b("craftingTasks", 9)) {
            NBTTagList tasksList = data.func_150295_c("craftingTasks", 10);
            for (i = 0; i < tasksList.func_74745_c(); ++i) {
                Item item;
                tag = tasksList.func_150305_b(i);
                patternStack = new ItemStack(tag.func_74775_l("pattern"));
                long taskValue = tag.func_74763_f("value");
                if (patternStack.func_190926_b() || !((item = patternStack.func_77973_b()) instanceof ICraftingPatternItem)) continue;
                cpi = (ICraftingPatternItem)item;
                if (taskValue <= 0L || (details = cpi.getPatternForItem(patternStack, this.func_145831_w())) == null) continue;
                CrazyCraftContainer.TaskProgress progress = new CrazyCraftContainer.TaskProgress();
                progress.value = taskValue;
                this.tasks.put(details, progress);
            }
        }
        this.pendingInterfaceTasks.clear();
        if (data.func_150297_b("pendingCPUInterfaces", 9)) {
            NBTTagList pendingList = data.func_150295_c("pendingCPUInterfaces", 10);
            for (i = 0; i < pendingList.func_74745_c(); ++i) {
                tag = pendingList.func_150305_b(i);
                patternStack = new ItemStack(tag.func_74775_l("patternStack"));
                long pendingBatches = tag.func_74763_f("pending");
                if (patternStack.func_190926_b() || !((details = patternStack.func_77973_b()) instanceof ICraftingPatternItem)) continue;
                cpi = (ICraftingPatternItem)details;
                if (pendingBatches <= 0L || (details = cpi.getPatternForItem(patternStack, this.func_145831_w())) == null) continue;
                this.pendingInterfaceTasks.put((ICraftingPatternDetails)details, new PendingInterfaceTask((ICraftingPatternDetails)details, pendingBatches));
            }
        }
        this.inventory = new CrazyCraftingInventory();
        if (data.func_150297_b("craftingInventory", 9)) {
            NBTTagList inventoryList = data.func_150295_c("craftingInventory", 10);
            for (i = 0; i < inventoryList.func_74745_c(); ++i) {
                itemTags = inventoryList.func_150305_b(i);
                stack = AEItemStack.fromNBT((NBTTagCompound)itemTags);
                if (stack == null || stack.getStackSize() <= 0L) continue;
                this.inventory.injectItems(stack, Actionable.MODULATE, null);
            }
        }
        this.waitingFor = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
        if (data.func_150297_b("waitingFor", 9)) {
            NBTTagList waitingForList = data.func_150295_c("waitingFor", 10);
            for (i = 0; i < waitingForList.func_74745_c(); ++i) {
                itemTags = waitingForList.func_150305_b(i);
                stack = AEItemStack.fromNBT((NBTTagCompound)itemTags);
                if (stack == null || stack.getStackSize() <= 0L) continue;
                this.waitingFor.add((IAEStack)stack);
            }
        }
        this.itemsToSend.clear();
        if (data.func_150297_b("itemsToSend", 9)) {
            NBTTagList tagList = data.func_150295_c("itemsToSend", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                itemTags = tagList.func_150305_b(i);
                stack = AEItemStack.fromNBT((NBTTagCompound)itemTags);
                if (stack == null || stack.getStackSize() <= 0L) continue;
                this.itemsToSend.add(stack);
            }
        }
        if (data.func_150297_b("finalOutput", 10)) {
            this.finalOutput = AEItemStack.fromNBT((NBTTagCompound)data.func_74775_l("finalOutput"));
            if (this.finalOutput != null && this.finalOutput.getStackSize() <= 0L) {
                this.finalOutput = null;
            }
        } else {
            this.finalOutput = null;
        }
        this.myLastLink = data.func_150297_b("myLastLinkData", 8) ? new CrazyCraftingLink(data, this) : null;
        this.isComplete = data.func_74767_n("isComplete");
        this.initialTotalItems = data.func_74763_f("initialTotalItems");
        this.requestingPlayerUUID = data.func_74764_b("requestingPlayerUUID") ? NBTUtil.func_186860_b((NBTTagCompound)data.func_74775_l("requestingPlayerUUID")) : null;
        this.myOwnName = data.func_150297_b("cpuName", 8) ? data.func_74779_i("cpuName") : "";
        this.elapsedTime = data.func_74763_f("elapsedTime");
        this.jobInitiator = data.func_74779_i("jobInitiator");
        this.millisWhenJobStarted = data.func_74763_f("millisJobStarted");
    }

    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation dir) {
        return AECableType.COVERED;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IItemHandler getInventoryByName(String name) {
        CrazyAEInternalInv crazyAEInternalInv;
        switch (name) {
            case "patterns": {
                crazyAEInternalInv = this.patternsInv;
                break;
            }
            case "accelerators": {
                crazyAEInternalInv = this.accelsInv;
                break;
            }
            case "storages": {
                crazyAEInternalInv = this.storagesInv;
                break;
            }
            default: {
                crazyAEInternalInv = null;
            }
        }
        return crazyAEInternalInv;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    @NotNull
    public IItemHandler getInternalInventory() {
        return this.patternsInv;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (!(inv != this.patternsInv || removed.func_190926_b() && added.func_190926_b() || !this.getProxy().isActive())) {
            this.cached = false;
        }
        if (!(inv != this.accelsInv && inv != this.storagesInv || removed.func_190926_b() && added.func_190926_b())) {
            this.cached = false;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (Platform.isServer()) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
        }
    }

    public void onReady() {
        super.onReady();
        if (Platform.isServer()) {
            this.notifyReady();
            this.updateCraftingList();
            this.notifyPatternsChanged();
            if (this.isBusy() && !this.isComplete) {
                this.lastTime = System.nanoTime();
            }
        }
    }

    private void notifyReady() {
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MECraftHostStateUpdateEv(this.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public boolean acceptPatternFromTerm(ItemStack pattern) {
        for (int i = 0; i < this.patternsInv.getSlots(); ++i) {
            ItemStack is = this.patternsInv.getStackInSlot(i);
            if (!is.func_190926_b()) continue;
            this.patternsInv.setStackInSlot(i, pattern.func_77946_l());
            return true;
        }
        return false;
    }

    private void pushItemsOut() {
        if (!this.getProxy().isActive() || this.itemsToSend.isEmpty()) {
            return;
        }
        try {
            IGrid grid = this.getProxy().getGrid();
            if (grid == null) {
                return;
            }
            IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IMEMonitor storage = storageGrid.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            ArrayList<IAEItemStack> toProcess = new ArrayList<IAEItemStack>(this.itemsToSend);
            ArrayList<IAEItemStack> successfullySent = new ArrayList<IAEItemStack>();
            HashMap<IAEItemStack, Long> toUpdateInOriginal = new HashMap<IAEItemStack, Long>();
            for (IAEItemStack iAEItemStack : toProcess) {
                if (iAEItemStack == null || iAEItemStack.getStackSize() <= 0L) {
                    successfullySent.add(iAEItemStack);
                    continue;
                }
                IAEItemStack iAEItemStack2 = iAEItemStack.copy();
                IAEItemStack overflow = (IAEItemStack)storage.injectItems((IAEStack)iAEItemStack2, Actionable.MODULATE, this.actionSource);
                long injectedAmount = iAEItemStack2.getStackSize() - (overflow != null ? overflow.getStackSize() : 0L);
                if (injectedAmount <= 0L) continue;
                if (overflow == null || overflow.getStackSize() <= 0L) {
                    successfullySent.add(iAEItemStack);
                    continue;
                }
                toUpdateInOriginal.put(iAEItemStack, overflow.getStackSize());
            }
            boolean changed = false;
            if (!successfullySent.isEmpty()) {
                this.itemsToSend.removeAll(successfullySent);
                changed = true;
            }
            for (Map.Entry entry : toUpdateInOriginal.entrySet()) {
                IAEItemStack originalItem = (IAEItemStack)entry.getKey();
                long newSize = (Long)entry.getValue();
                int index = this.itemsToSend.indexOf(originalItem);
                if (index == -1) continue;
                this.itemsToSend.get(index).setStackSize(newSize);
                changed = true;
            }
            if (!successfullySent.isEmpty() || !toUpdateInOriginal.isEmpty()) {
                ArrayList<IAEItemStack> arrayList = new ArrayList<IAEItemStack>();
                for (IAEItemStack currentInList : this.itemsToSend) {
                    if (successfullySent.contains(currentInList)) continue;
                    Long updatedSize = (Long)toUpdateInOriginal.get(currentInList);
                    if (updatedSize != null) {
                        currentInList.setStackSize(updatedSize.longValue());
                        if (currentInList.getStackSize() > 0L) {
                            arrayList.add(currentInList);
                        }
                        changed = true;
                        continue;
                    }
                    arrayList.add(currentInList);
                }
                this.itemsToSend.clear();
                this.itemsToSend.addAll(arrayList);
            }
            if (changed) {
                this.func_70296_d();
                this.checkAndCompleteJob();
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateCraftingList() {
        Object[] accountedFor = new Boolean[this.patternsInv.getSlots()];
        Arrays.fill(accountedFor, (Object)false);
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.patternsInv.getStackInSlot(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (((Boolean)accountedFor[x]).booleanValue()) continue;
            this.addToCraftingList(this.patternsInv.getStackInSlot(x));
        }
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is.func_190926_b()) {
            return;
        }
        Item item = is.func_77973_b();
        if (item instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)item).getPatternForItem(is, this.func_145831_w())) != null) {
            if (this.craftingList == null) {
                this.craftingList = new HashSet<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        Iterator<IAEItemStack> iterator = this.patternsInv.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            if (itemStack.func_190926_b()) continue;
            drops.add(itemStack);
        }
        iterator = this.accelsInv.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            if (itemStack.func_190926_b()) continue;
            drops.add(itemStack);
        }
        iterator = this.storagesInv.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            if (itemStack.func_190926_b()) continue;
            drops.add(itemStack);
        }
        for (IAEItemStack iAEItemStack : this.itemsToSend) {
            drops.add(iAEItemStack.createItemStack());
        }
    }

    private void notifyPatternsChanged() {
        try {
            if (this.getProxy().isActive()) {
                IGrid grid = this.getProxy().getGrid();
                if (grid != null) {
                    grid.postEvent((MENetworkEvent)new MECraftHostPatternsChangedEv(this, this.getProxy().getNode()));
                    this.getProxy().getTick().alertDevice(this.getProxy().getNode());
                    this.cached = true;
                } else {
                    this.cached = false;
                }
            } else {
                this.cached = false;
            }
        }
        catch (GridAccessException e) {
            this.cached = false;
        }
    }

    private List<IAEItemStack> dispatchBatchJobInternal(ICraftingPatternDetails details, long batchSize) {
        ArrayList<IAEItemStack> producedOutputs = new ArrayList<IAEItemStack>();
        if (details != null && batchSize > 0L) {
            for (IAEItemStack outputTemplate : details.getCondensedOutputs()) {
                IAEItemStack totalOutput = outputTemplate.copy();
                long newAmount = Utils.multiplySafely(outputTemplate.getStackSize(), batchSize);
                if (newAmount <= 0L) continue;
                totalOutput.setStackSize(newAmount);
                producedOutputs.add(totalOutput);
            }
        }
        return producedOutputs;
    }

    private long countAvailableItems(IAEItemStackMatcher matcher) {
        long totalAvailable;
        block9: {
            IAEItemStack template;
            IItemList availableItems;
            block7: {
                block10: {
                    block8: {
                        totalAvailable = 0L;
                        availableItems = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
                        this.inventory.getAvailableItems((IItemList<IAEItemStack>)availableItems);
                        ICraftingPatternDetails details = matcher.details;
                        template = matcher.template;
                        if (!details.isCraftable() || !details.canSubstitute() || !matcher.useSubstitutes()) break block7;
                        int slotIndex = Utils.findSlotIndex(details, template);
                        if (slotIndex == -1) break block8;
                        List substitutes = details.getSubstituteInputs(slotIndex);
                        ArrayList<IAEItemStack> potentialSources = new ArrayList<IAEItemStack>();
                        potentialSources.add(template);
                        potentialSources.addAll(substitutes);
                        for (IAEItemStack source : potentialSources) {
                            for (IAEItemStack stackInInv : availableItems.findFuzzy((IAEStack)source, FuzzyMode.IGNORE_ALL)) {
                                totalAvailable += stackInInv.getStackSize();
                            }
                        }
                        break block9;
                    }
                    IAEItemStack found = (IAEItemStack)availableItems.findPrecise((IAEStack)template);
                    if (found == null) break block10;
                    totalAvailable = found.getStackSize();
                    break block9;
                }
                if (!template.getDefinition().func_77984_f() && !Platform.isGTDamageableItem((Item)template.getItem())) break block9;
                for (IAEItemStack fuzzyMatch : availableItems.findFuzzy((IAEStack)template, FuzzyMode.IGNORE_ALL)) {
                    totalAvailable += fuzzyMatch.getStackSize();
                }
                break block9;
            }
            IAEItemStack found = (IAEItemStack)availableItems.findPrecise((IAEStack)template);
            if (found != null) {
                totalAvailable = found.getStackSize();
            } else if (template.getDefinition().func_77984_f() || Platform.isGTDamageableItem((Item)template.getItem())) {
                for (IAEItemStack fuzzyMatch : availableItems.findFuzzy((IAEStack)template, FuzzyMode.IGNORE_ALL)) {
                    totalAvailable += fuzzyMatch.getStackSize();
                }
            }
        }
        return totalAvailable;
    }

    @MENetworkEventSubscribe
    public void onPowerEvent(MENetworkPowerStatusChange p) {
        this.updatePowerState();
        if (Platform.isServer()) {
            this.updateCraftingList();
            this.notifyPatternsChanged();
            if (!this.itemsToSend.isEmpty()) {
                this.pushItemsOut();
            }
        }
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    public void provideCrafting(ICrazyCraftingProviderHelper craftingTracker) {
        if (this.getProxy().getNode().isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                details.setPriority(this.priority);
                craftingTracker.addCraftingOption(this, details);
            }
        }
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        if (input instanceof IAEItemStack) {
            IAEItemStack is = (IAEItemStack)this.waitingFor.findPrecise((IAEStack)input);
            return is != null && is.getStackSize() > 0L;
        }
        return false;
    }

    @Override
    public long getSortValue() {
        return (long)this.func_174877_v().func_177952_p() << 24 ^ (long)this.func_174877_v().func_177958_n() << 8 ^ (long)this.func_174877_v().func_177956_o();
    }

    @Override
    public BlockPos getTEPos() {
        return this.func_174877_v();
    }

    @Override
    public int getDim() {
        return this.func_145831_w().field_73011_w.getDimension();
    }

    @Override
    public IItemHandler getPatternsInv() {
        return this.getInternalInventory();
    }

    @Override
    public String getName() {
        return this.hasCustomInventoryName() ? this.getCustomInventoryName() : CrazyAEGuiText.QUANTUM_CPU.getLocal() + this.myOwnName;
    }

    @Override
    public void setCpuName(String name) {
        this.myOwnName = name;
    }

    @Override
    public long getAcceleratorCount() {
        if (this.accelsCount != -1L) {
            return this.accelsCount;
        }
        long ret = 0L;
        Iterator iterator = this.accelsInv.iterator();
        while (iterator.hasNext()) {
            ItemStack is = (ItemStack)iterator.next();
            if (is == null) continue;
            for (int i = 0; i < is.func_190916_E(); ++i) {
                ret += (long)Utils.getAcceleratorsCountOf(is);
            }
        }
        this.accelsCount = ret;
        return this.accelsCount;
    }

    @Override
    public double getStorageCount() {
        if (this.storageCount != -1.0) {
            return this.storageCount;
        }
        double ret = 0.0;
        Iterator iterator = this.storagesInv.iterator();
        while (iterator.hasNext()) {
            ItemStack is = (ItemStack)iterator.next();
            if (is == null) continue;
            for (int i = 0; i < is.func_190916_E(); ++i) {
                ret += (double)Utils.getStorageCountOf(is);
            }
        }
        this.storageCount = ret;
        return this.storageCount;
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> imeMonitorHandlerReceiver, Object o) {
        this.listeners.put(imeMonitorHandlerReceiver, o);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> imeMonitorHandlerReceiver) {
        this.listeners.remove(imeMonitorHandlerReceiver);
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode iGridNode) {
        return new TickingRequest(1, 1, false, false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode iGridNode, int i) {
        if (!this.cached) {
            this.accelsCount = -1L;
            this.storageCount = -1.0;
            if (this.getProxy().isActive()) {
                this.updateCraftingList();
                this.notifyPatternsChanged();
                this.notifyReady();
            }
        }
        return TickRateModulation.URGENT;
    }

    private static class PendingInterfaceTask {
        final ICraftingPatternDetails details;
        long pendingBatches;

        PendingInterfaceTask(ICraftingPatternDetails details, long initialBatches) {
            this.details = details;
            this.pendingBatches = initialBatches;
        }
    }

    private static class IAEItemStackMatcher {
        private final IAEItemStack template;
        private final ICraftingPatternDetails details;
        private final int slotIndex;
        private final boolean useSubstitutes;

        private IAEItemStackMatcher(IAEItemStack template, ICraftingPatternDetails details, int slotIndex, boolean useSubstitutes) {
            this.template = template;
            this.details = details;
            this.slotIndex = slotIndex;
            this.useSubstitutes = useSubstitutes;
        }

        public static IAEItemStackMatcher create(IAEItemStack template, ICraftingPatternDetails details) {
            int slot = -1;
            IAEItemStack[] inputs = details.getInputs();
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] == null || !inputs[i].isSameType(template)) continue;
                slot = i;
                break;
            }
            boolean useEffectiveSubstitutes = details.isCraftable() && details.canSubstitute();
            return new IAEItemStackMatcher(template, details, slot, useEffectiveSubstitutes);
        }

        public boolean useSubstitutes() {
            return this.useSubstitutes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IAEItemStackMatcher that = (IAEItemStackMatcher)o;
            if (this.useSubstitutes && that.useSubstitutes && this.details == that.details && this.slotIndex != -1 && this.slotIndex == that.slotIndex) {
                return true;
            }
            return this.template.isSameType(that.template);
        }

        public int hashCode() {
            if (this.useSubstitutes && this.slotIndex != -1) {
                return Objects.hash(this.details, this.slotIndex);
            }
            return Objects.hash(this.template.getItem(), this.template.getItemDamage());
        }
    }
}

