/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.helpers.ICustomCollision;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.tile.base.CrazyAEOCTile;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileImprovedCrank
extends CrazyAEOCTile
implements ICustomCollision,
ITickable {
    private final int ticksPerRotation = 15;
    private float visibleRotation = 0.0f;
    private int hits = 0;
    private int rotation = 0;

    public void func_73660_a() {
        if (this.rotation > 0) {
            float f = this.getVisibleRotation();
            Objects.requireNonNull(this);
            this.setVisibleRotation(f - 360.0f / 15.0f);
            ICrankable grinder = this.getGrinder();
            if (grinder != null) {
                grinder.applyTurn();
            }
            --this.rotation;
        }
    }

    private ICrankable getGrinder() {
        if (Platform.isClient()) {
            return null;
        }
        EnumFacing grinder = this.getUp().func_176734_d();
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(grinder));
        if (te instanceof ICrankable) {
            return (ICrankable)te;
        }
        return null;
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        this.rotation = data.readInt();
        return c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.rotation);
    }

    public void setOrientation(EnumFacing inForward, EnumFacing inUp) {
        super.setOrientation(inForward, inUp);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_145838_q().func_189540_a(state, this.field_145850_b, this.field_174879_c, state.func_177230_c(), this.field_174879_c);
    }

    public boolean requiresTESR() {
        return true;
    }

    public boolean power() {
        ICrankable g;
        if (Platform.isClient()) {
            return false;
        }
        if (this.rotation <= 0 && (g = this.getGrinder()) != null) {
            if (g.canTurn()) {
                this.rotation += this.ticksPerRotation;
                this.markForUpdate();
                return true;
            }
            ++this.hits;
            if (this.hits > 20) {
                this.field_145850_b.func_175655_b(this.field_174879_c, false);
            }
        }
        return false;
    }

    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, BlockPos pos, Entity thePlayer, boolean b) {
        double xOff = -0.15 * (double)this.getUp().func_82601_c();
        double yOff = -0.15 * (double)this.getUp().func_96559_d();
        double zOff = -0.15 * (double)this.getUp().func_82599_e();
        return Collections.singletonList(new AxisAlignedBB(xOff + 0.15, yOff + 0.15, zOff + 0.15, xOff + 0.85, yOff + 0.85, zOff + 0.85));
    }

    public void addCollidingBlockToList(World w, BlockPos pos, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        double xOff = -0.15 * (double)this.getUp().func_82601_c();
        double yOff = -0.15 * (double)this.getUp().func_96559_d();
        double zOff = -0.15 * (double)this.getUp().func_82599_e();
        out.add(new AxisAlignedBB(xOff + 0.15, yOff + 0.15, zOff + 0.15, xOff + 0.85, yOff + 0.85, zOff + 0.85));
    }

    public float getVisibleRotation() {
        return this.visibleRotation;
    }

    private void setVisibleRotation(float visibleRotation) {
        this.visibleRotation = visibleRotation;
    }
}

