/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.helpers.BaseActionSource;
import appeng.me.storage.ITickingMonitor;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import dev.beecube31.crazyae2.common.tile.misc.TileImprovedCondenser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;

class CondenserItemInventory
implements IMEMonitor<IAEItemStack>,
ITickingMonitor {
    private final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    private final TileImprovedCondenser target;
    private boolean hasChanged = true;
    private final ItemList cachedList = new ItemList();
    private IActionSource actionSource = new BaseActionSource();
    private ItemList changeSet = new ItemList();

    CondenserItemInventory(TileImprovedCondenser te) {
        this.target = te;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, IActionSource src) {
        if (mode == Actionable.MODULATE && input != null) {
            this.target.addPower(input.getStackSize());
        }
        return null;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        AEItemStack ret = null;
        for (int i = 0; i < 4; ++i) {
            ItemStack slotItem = this.target.getOutputSlot().getStackInSlot(i);
            if (slotItem.func_190926_b() || !request.isSameType(slotItem)) continue;
            int count = (int)Math.min(request.getStackSize(), Integer.MAX_VALUE);
            ret = AEItemStack.fromItemStack((ItemStack)this.target.getOutputSlot().extractItem(i, count, mode == Actionable.SIMULATE));
            if (ret != null && ret.getStackSize() <= 0L) break;
        }
        return ret;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        for (int i = 0; i < 4; ++i) {
            ItemStack slotItem = this.target.getOutputSlot().getStackInSlot(i);
            if (slotItem.func_190926_b()) continue;
            out.add((IAEStack)AEItemStack.fromItemStack((ItemStack)slotItem));
        }
        return out;
    }

    public IItemList<IAEItemStack> getStorageList() {
        if (this.hasChanged) {
            this.hasChanged = false;
            this.cachedList.resetStatus();
            return this.getAvailableItems((IItemList<IAEItemStack>)this.cachedList);
        }
        return this.cachedList;
    }

    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEItemStack input) {
        return false;
    }

    public boolean canAccept(IAEItemStack input) {
        return true;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return i == 2;
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    public void updateOutput(ItemStack added, ItemStack removed) {
        this.hasChanged = true;
        if (!added.func_190926_b()) {
            this.changeSet.add((IAEItemStack)AEItemStack.fromItemStack((ItemStack)added));
        }
        if (!removed.func_190926_b()) {
            this.changeSet.add((IAEItemStack)AEItemStack.fromItemStack((ItemStack)removed).setStackSize((long)(-removed.func_190916_E())));
        }
    }

    public TickRateModulation onTick() {
        ItemList currentChanges = this.changeSet;
        if (currentChanges.isEmpty()) {
            return TickRateModulation.IDLE;
        }
        this.changeSet = new ItemList();
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> l = i.next();
            IMEMonitorHandlerReceiver<IAEItemStack> key = l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange((IBaseMonitor)this, (Iterable)currentChanges, this.actionSource);
                continue;
            }
            i.remove();
        }
        return TickRateModulation.URGENT;
    }

    public void setActionSource(IActionSource actionSource) {
        this.actionSource = actionSource;
    }
}

