/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.misc;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import dev.beecube31.crazyae2.common.tile.misc.TileImprovedCondenser;

class CondenserVoidInventory<T extends IAEStack<T>>
implements IMEMonitor<T> {
    private final TileImprovedCondenser target;
    private final IStorageChannel<T> channel;

    CondenserVoidInventory(TileImprovedCondenser te, IStorageChannel<T> channel) {
        this.target = te;
        this.channel = channel;
    }

    public T injectItems(T input, Actionable mode, IActionSource src) {
        if (mode == Actionable.SIMULATE) {
            return null;
        }
        if (input != null) {
            this.target.addPower((double)input.getStackSize() / (double)this.channel.transferFactor());
        }
        return null;
    }

    public T extractItems(T request, Actionable mode, IActionSource src) {
        return null;
    }

    public IItemList<T> getAvailableItems(IItemList<T> out) {
        return out;
    }

    public IItemList<T> getStorageList() {
        return this.channel.createList();
    }

    public IStorageChannel<T> getChannel() {
        return this.channel;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.WRITE;
    }

    public boolean isPrioritized(T input) {
        return false;
    }

    public boolean canAccept(T input) {
        return true;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return i == 2;
    }

    public void addListener(IMEMonitorHandlerReceiver<T> l, Object verificationToken) {
    }

    public void removeListener(IMEMonitorHandlerReceiver<T> l) {
    }
}

