/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.capabilities.Capabilities;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.AEItemFilters;
import dev.beecube31.crazyae2.common.tile.base.CrazyAEInvOCTile;
import dev.beecube31.crazyae2.common.tile.misc.CondenserItemInventory;
import dev.beecube31.crazyae2.common.tile.misc.CondenserVoidInventory;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileImprovedCondenser
extends CrazyAEInvOCTile
implements IConfigManagerHost,
IConfigurableObject {
    public static final int BYTE_MULTIPLIER = 8;
    private final ConfigManager cm = new ConfigManager((IConfigManagerHost)this);
    private final AppEngInternalInventory outputSlot = new AppEngInternalInventory((IAEAppEngInventory)this, 4);
    private final AppEngInternalInventory storageSlot = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final IItemHandler inputSlot = new CondenseItemHandler();
    private final IFluidHandler fluidHandler = new FluidHandler();
    private final MEHandler meHandler = new MEHandler();
    private final IItemHandler externalInv = new WrapperChainedItemHandler(new IItemHandler[]{this.inputSlot, new WrapperFilteredItemHandler((IItemHandler)this.outputSlot, AEItemFilters.EXTRACT_ONLY)});
    private final IItemHandler combinedInv = new WrapperChainedItemHandler(new IItemHandler[]{this.inputSlot, this.outputSlot, this.storageSlot});
    private double storedPower = 0.0;
    private static final IFluidTankProperties[] EMPTY = new IFluidTankProperties[]{new FluidTankProperties(null, 1000, true, false)};

    public TileImprovedCondenser() {
        this.cm.registerSetting(Settings.CONDENSER_OUTPUT, (Enum)CondenserOutput.TRASH);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.cm.writeToNBT(data);
        data.func_74780_a("storedPower", this.getStoredPower());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.cm.readFromNBT(data);
        this.setStoredPower(data.func_74769_h("storedPower"));
    }

    public double getStorage() {
        IStorageComponent sc;
        Item item;
        ItemStack is = this.storageSlot.getStackInSlot(0);
        if (!is.func_190926_b() && (item = is.func_77973_b()) instanceof IStorageComponent && (sc = (IStorageComponent)item).isStorageComponent(is)) {
            return sc.getBytes(is) * 8;
        }
        return 0.0;
    }

    public void addPower(double rawPower) {
        this.setStoredPower(this.getStoredPower() + rawPower);
        this.setStoredPower(Math.max(0.0, Math.min(this.getStorage(), this.getStoredPower())));
        double requiredPower = this.getRequiredPower();
        ItemStack output = this.getOutput();
        while (requiredPower <= this.getStoredPower() && !output.func_190926_b() && requiredPower > 0.0 && this.canAddOutput(output)) {
            this.setStoredPower(this.getStoredPower() - requiredPower);
            this.addOutput(output.func_77946_l());
        }
    }

    private boolean canAddOutput(ItemStack output) {
        boolean can = false;
        for (int i = 0; i < this.outputSlot.getSlots(); ++i) {
            if (this.outputSlot.getStackInSlot(i).func_190916_E() >= 64) continue;
            return true;
        }
        return can;
    }

    private void addOutput(ItemStack output) {
        for (int i = 0; i < this.outputSlot.getSlots(); ++i) {
            if (this.outputSlot.getStackInSlot(i).func_190916_E() >= 64) continue;
            this.outputSlot.insertItem(i, output, false);
            return;
        }
    }

    IItemHandler getOutputSlot() {
        return this.outputSlot;
    }

    private ItemStack getOutput() {
        ItemStack itemStack;
        IMaterials materials = AEApi.instance().definitions().materials();
        switch ((CondenserOutput)this.cm.getSetting(Settings.CONDENSER_OUTPUT)) {
            case MATTER_BALLS: {
                itemStack = materials.matterBall().maybeStack(1).orElse(ItemStack.field_190927_a);
                break;
            }
            case SINGULARITY: {
                itemStack = materials.singularity().maybeStack(1).orElse(ItemStack.field_190927_a);
                break;
            }
            default: {
                itemStack = ItemStack.field_190927_a;
            }
        }
        return itemStack;
    }

    public double getRequiredPower() {
        return ((CondenserOutput)this.cm.getSetting((Settings)Settings.CONDENSER_OUTPUT)).requiredPower;
    }

    public IItemHandler getInternalInventory() {
        return this.combinedInv;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.outputSlot) {
            if (!removed.func_190926_b()) {
                double requiredPower = this.getRequiredPower();
                ItemStack output = this.getOutput();
                while (requiredPower <= this.getStoredPower() && !output.func_190926_b() && requiredPower > 0.0 && this.canAddOutput(output)) {
                    this.setStoredPower(this.getStoredPower() - requiredPower);
                    this.addOutput(output.func_77946_l());
                    removed.func_190918_g(output.func_190916_E());
                }
            }
            this.meHandler.outputChanged(added, removed);
        }
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.addPower(0.0);
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public double getStoredPower() {
        return this.storedPower;
    }

    private void setStoredPower(double storedPower) {
        this.storedPower = storedPower;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.externalInv;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidHandler;
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return (T)this.meHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    private class CondenseItemHandler
    implements IItemHandler {
        private CondenseItemHandler() {
        }

        public int getSlots() {
            return 25;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate && !stack.func_190926_b()) {
                TileImprovedCondenser.this.addPower(stack.func_190916_E());
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return EMPTY;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (doFill) {
                IStorageChannel chan = AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
                TileImprovedCondenser.this.addPower((resource == null ? 0.0 : (double)resource.amount) / (double)chan.transferFactor());
            }
            return resource == null ? 0 : resource.amount;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }

    private class MEHandler
    implements IStorageMonitorableAccessor,
    IStorageMonitorable {
        private final CondenserItemInventory itemInventory;

        private MEHandler() {
            this.itemInventory = new CondenserItemInventory(TileImprovedCondenser.this);
        }

        void outputChanged(ItemStack added, ItemStack removed) {
            this.itemInventory.updateOutput(added, removed);
        }

        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            return this;
        }

        public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
            if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                return this.itemInventory;
            }
            return new CondenserVoidInventory<T>(TileImprovedCondenser.this, channel);
        }
    }
}

